
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 接收.
// POST
export async function connectorActionCreate (params) {
    const {data} = await request(`jaxrs/connector`, params)
    return data.data
}

    
// 获取消息.
// consume: String: 消费者
// count: Integer: 数量
// GET
export async function consumeActionListWithPerson (params) {
    const {data} = await request(`jaxrs/consume/list/${params.consume}/person/${params.person}/count/${params.count}`)
    return data.data
}

    
// 获取消息,当前人员.
// consume: String: 消费者
// count: Integer: 数量
// GET
export async function consumeActionUpdateSingle (params) {
    const {data} = await request(`jaxrs/consume/${params.id}/type/${params.type}`)
    return data.data
}

    
// 获取消息,指定人员.
// consume: String: 消费者
// person: String: 人员
// count: Integer: 数量
// GET
export async function consumeActionListWithCurrentPerson (params) {
    const {data} = await request(`jaxrs/consume/list/${params.consume}/currentperson/count/${params.count}`)
    return data.data
}

    
// 更新消息,将消息标志为已处理.
// type: String: 消费类型
// PUT
export async function consumeActionUpdate (params) {
    const {data} = await request(`jaxrs/consume/type/${params.type}`, params)
    return data.data
}

    
// 更新消息,将消息标志为已处理.
// id: String: 标识
// type: String: 消费类型
// GET
export async function consumeActionList (params) {
    const {data} = await request(`jaxrs/consume/list/${params.consume}/count/${params.count}`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 清空会话的所有消息.
// id: String: 会话ID
// POST
export async function imActionConfig (params) {
    const {data} = await request(`jaxrs/im/manager/config`, params)
    return data.data
}

    
// 更新IM配置.
// GET
export async function imActionDownload (params) {
    const {data} = await request(`jaxrs/im/msg/download/${params.id}`)
    return data.data
}

    
// 会话对象.
// id: String: 会话id
// PUT
export async function imActionConversationRead (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/read`, params)
    return data.data
}

    
// 会话取消置顶.
// id: String: 会话id
// POST
export async function imActionMsgCreate (params) {
    const {data} = await request(`jaxrs/im/msg`, params)
    return data.data
}

    
// 根据业务id查询会话，当前用户在会话中.
// businessId: String: 业务id
// PUT
export async function imActionConversationSetTop (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/top/set`, params)
    return data.data
}

    
// 会话阅读消息.
// id: String: 会话id
// GET
export async function imActionMyConversationList (params) {
    const {data} = await request(`jaxrs/im/conversation/list/my`)
    return data.data
}

    
// 会话置顶.
// id: String: 会话id
// GET
export async function imActionMsgRevoke (params) {
    const {data} = await request(`jaxrs/im/msg/revoke/${params.id}`)
    return data.data
}

    
// 创建会话.
// POST
export async function imActionMsgListByPaging (params) {
    const {data} = await request(`jaxrs/im/msg/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 删除群聊，只有群主可以删除.
// id: String: 会话ID
// GET
export async function imActionGetImConfig (params) {
    const {data} = await request(`jaxrs/im/manager/config`)
    return data.data
}

    
// 删除单聊会话.
// id: String: 会话ID
// GET
export async function imActionConversation (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}`)
    return data.data
}

    
// 获取文件内容,输出头信息
// id: String: 附件标识
// POST
export async function imActionUploadFile (params) {
    const {data} = await request(`jaxrs/im/msg/upload/${params.conversationId}/type/${params.type}`, params)
    return data.data
}

    
// 下载图片设定宽高后的(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度
// GET
export async function imActionDownloadImageWidthHeight (params) {
    const {data} = await request(`jaxrs/im/msg/download/${params.id}/image/width/${params.width}/height/${params.height}`)
    return data.data
}

    
// 获取IM配置.
// GET
export async function imActionConversationFindByBusinessId (params) {
    const {data} = await request(`jaxrs/im/conversation/business/${params.businessId}`)
    return data.data
}

    
// 创建消息，发送消息到某一个会话中.
// PUT
export async function imActionConversationCancelTop (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/top/cancel`, params)
    return data.data
}

    
// 分页查询某个会话的消息列表.
// page: Integer: 分页
// size: Integer: 数量
// DELETE
export async function imActionDeleteGroupConversation (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/group`, params)
    return data.data
}

    
// 撤回消息
// id: String: 消息标识
// DELETE
export async function imActionDeleteSingleConversation (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/single`, params)
    return data.data
}

    
// 我的会话列表.
// DELETE
export async function imActionClearConversationMsg (params) {
    const {data} = await request(`jaxrs/im/conversation/${params.id}/clear/all/msg`, params)
    return data.data
}

    
// 修改会话.
// PUT
export async function imActionUpdate (params) {
    const {data} = await request(`jaxrs/im/conversation`, params)
    return data.data
}

    
// 上传文件.
// conversationId: String: 会话id
// type: String: 文件类型
// POST
export async function imActionCreate (params) {
    const {data} = await request(`jaxrs/im/conversation`, params)
    return data.data
}

    
// 将当前用户指定的主体消息标识为已消费.
// GET
export async function instantActionListNext (params) {
    const {data} = await request(`jaxrs/instant/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 将当前用户所有主体消息全部标识为已消费.
// GET
export async function instantActionListPrev (params) {
    const {data} = await request(`jaxrs/instant/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示所有的主体消息,需要管理员权限或者MessageManager,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentNotConsumedPersonDesc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/not/consumed/count/${params.count}/desc`)
    return data.data
}

    
// 列示所有的主体消息,需要管理员权限或者MessageManager,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentPersonNotConsumedAsc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/not/consumed/count/${params.count}/asc`)
    return data.data
}

    
// 获取当前人员已经消费的主体消息,倒序.
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentPersonConsumedAsc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/consumed/count/${params.count}/asc`)
    return data.data
}

    
// 获取当前人员还未消费的主体消息,倒序.
// count: Integer: 数量
// PUT
export async function instantActionCurrentPersonConsumed (params) {
    const {data} = await request(`jaxrs/instant/currentperson/consumed`, params)
    return data.data
}

    
// 获取当前人员的主体消息,顺序.
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentPersonAsc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/count/${params.count}/asc`)
    return data.data
}

    
// 获取当前人员已经消费的主体消息,顺序.
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentConsumedPersonDesc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/consumed/count/${params.count}/desc`)
    return data.data
}

    
// 获取当前人员的主体消息,倒序.
// count: Integer: 数量
// GET
export async function instantActionCurrentPersonConsumedAll (params) {
    const {data} = await request(`jaxrs/instant/currentperson/consumed/all`)
    return data.data
}

    
// 获取当前人员还未消费的主体消息,顺序.
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentPersonDesc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/count/${params.count}/desc`)
    return data.data
}

    
// 获取当前人员的主体消息,排除IM消息,倒序.
// count: Integer: 数量
// GET
export async function instantActionListWithCurrentPersonWithoutIMDesc (params) {
    const {data} = await request(`jaxrs/instant/list/currentperson/noim/count/${params.count}/desc`)
    return data.data
}

    
// 更新消息,将消息标志为已处理.
// GET
export async function massActionEnableType (params) {
    const {data} = await request(`jaxrs/mass/enable/type`)
    return data.data
}

    
// 删除群发消息.
// id: String: 标识
// GET
export async function massActionListNext (params) {
    const {data} = await request(`jaxrs/mass/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 获取启用的消息类型.
// GET
export async function massActionListPrev (params) {
    const {data} = await request(`jaxrs/mass/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 获取消息.
// id: String: 标识
// GET
export async function massActionGet (params) {
    const {data} = await request(`jaxrs/mass/${params.id}`)
    return data.data
}

    
// 列示群发消息对象,下一页.
// id: String: 标识
// count: Integer: 数量
// DELETE
export async function massActionDelete (params) {
    const {data} = await request(`jaxrs/mass/${params.id}`, params)
    return data.data
}

    
// 列示群发消息对象,上一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function massActionCreate (params) {
    const {data} = await request(`jaxrs/mass`, params)
    return data.data
}

    
// 创建定制消息.
// POST
export async function messageActionCustomCreate (params) {
    const {data} = await request(`jaxrs/message/custom/create`, params)
    return data.data
}

    
// 消息分页查询.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function messageActionListPaging (params) {
    const {data} = await request(`jaxrs/message/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 在线用户数量.
// GET
export async function wsActionCountPerson (params) {
    const {data} = await request(`jaxrs/ws/count/person`)
    return data.data
}

    
// 发送webSocket消息.
// GET
export async function wsActionListPerson (params) {
    const {data} = await request(`jaxrs/ws/list/person`)
    return data.data
}

    
// 列示用户.
// GET
export async function wsActionListPersonCurrentNode (params) {
    const {data} = await request(`jaxrs/ws/list/person/current/node`)
    return data.data
}

    
// 列示当前节点用户.
// POST
export async function wsActionCreate (params) {
    const {data} = await request(`jaxrs/ws`, params)
    return data.data
}

    