
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 删除导入记录.
// recordId: String: 导入记录标识
// GET
export async function importModelActionGetRecord (params) {
    const {data} = await request(`jaxrs/importmodel/record/${params.recordId}`)
    return data.data
}

    
// 删除导入记录mockdeletetoget.
// recordId: String: 导入记录标识
// GET
export async function importModelActionGetWithQuery (params) {
    const {data} = await request(`jaxrs/importmodel/flag/${params.flag}/query/${params.queryFlag}`)
    return data.data
}

    
// 执行数据导入(执行导入是异步过程，请关注记录的状态)
// id: String: 导入模型标识
// GET
export async function importModelActionGetUUID (params) {
    const {data} = await request(`jaxrs/importmodel/uuid`)
    return data.data
}

    
// 获取导入模型.
// id: String: 标识
// GET
export async function importModelActionReExecuteRecord (params) {
    const {data} = await request(`jaxrs/importmodel/execute/record/${params.recordId}`)
    return data.data
}

    
// 获取导入记录.
// recordId: String: 导入记录标识
// GET
export async function importModelActionGetRecordStatus (params) {
    const {data} = await request(`jaxrs/importmodel/record/${params.recordId}/status`)
    return data.data
}

    
// 获取导入记录的执行状态.
// recordId: String: 导入记录标识
// POST
export async function importModelActionRecordListPaging (params) {
    const {data} = await request(`jaxrs/importmodel/list/record/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 生成唯一编码.
// DELETE
export async function importModelActionDeleteRecord (params) {
    const {data} = await request(`jaxrs/importmodel/record/${params.recordId}`, params)
    return data.data
}

    
// 根据查询获取导入模型对象.
// flag: String: 导入模型标识
// queryFlag: String: 查询标识
// GET
export async function importModelActionListWithQuery (params) {
    const {data} = await request(`jaxrs/importmodel/list/query/${params.queryFlag}`)
    return data.data
}

    
// 根据查询列示导入模型对象.
// queryFlag: String: 查询标识
// POST
export async function importModelActionRecordItemListPaging (params) {
    const {data} = await request(`jaxrs/importmodel/list/record/item/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 重新导入失败的记录(执行导入是异步过程，请关注记录的状态).
// recordId: String: 导入记录标识
// GET
export async function importModelActionDeleteRecordMockDeleteToGet (params) {
    const {data} = await request(`jaxrs/importmodel/record/${params.recordId}/mockdeletetoget`)
    return data.data
}

    
// 导入记录明细分页查询.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function importModelActionGet (params) {
    const {data} = await request(`jaxrs/importmodel/${params.id}`)
    return data.data
}

    
// 导入记录分页查询.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function importModelActionExecute (params) {
    const {data} = await request(`jaxrs/importmodel/${params.id}/execute`, params)
    return data.data
}

    
// 相似查找.
// POST
export async function moreLikeThisActionPost (params) {
    const {data} = await request(`jaxrs/morelikethis`, params)
    return data.data
}

    
// 神经网络计算.
// modelFlag: String: 项目标识
// workId: String: 工作标识
// GET
export async function neuralActionListCalculate (params) {
    const {data} = await request(`jaxrs/neural/list/calculate/model/${params.modelFlag}/work/${params.workId}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取指定的Application信息,并在Control段附带其操作权限.
// flag: String: 应用标识
// GET
export async function queryActionListWithPerson (params) {
    const {data} = await request(`jaxrs/query/list`)
    return data.data
}

    
// 获取可见的应用,同时判断应用下有可见的流程.
// GET
export async function queryActionListWithPersonLike (params) {
    const {data} = await request(`jaxrs/query/list/key/${params.key}`)
    return data.data
}

    
// 获取可见的应用,同时判断应用下有可见的流程,并进行流程的名称匹配.
// key: String: 关键字
// GET
export async function queryActionGet (params) {
    const {data} = await request(`jaxrs/query/${params.flag}`)
    return data.data
}

    
// POST方法执行搜索.
// POST
export async function searchActionPost (params) {
    const {data} = await request(`jaxrs/search`, params)
    return data.data
}

    
// 执行统计
// id: String: 视图标识
// GET
export async function statActionGetWithQuery (params) {
    const {data} = await request(`jaxrs/stat/flag/${params.flag}/query/${params.queryFlag}`)
    return data.data
}

    
// 执行统计MockPutToPost
// id: String: 视图标识
// PUT
export async function statActionExecuteWithQuery (params) {
    const {data} = await request(`jaxrs/stat/flag/${params.flag}/query/${params.queryFlag}/execute`, params)
    return data.data
}

    
// 执行指定查询和统计名的统计
// flag: String: 视图标识
// queryFlag: String: 查询标识
// GET
export async function statActionListWithQuery (params) {
    const {data} = await request(`jaxrs/stat/list/query/${params.queryFlag}`)
    return data.data
}

    
// 执行指定查询和统计名的统计MockPutToPost
// flag: String: 视图标识
// queryFlag: String: 查询标识
// POST
export async function statActionExecuteMockPutToPost (params) {
    const {data} = await request(`jaxrs/stat/${params.id}/execute/mockputtopost`, params)
    return data.data
}

    
// 获取统计内容.
// id: String: 标识
// POST
export async function statActionExecuteWithQueryMockPutToPost (params) {
    const {data} = await request(`jaxrs/stat/flag/${params.flag}/query/${params.queryFlag}/execute/mockputtopost`, params)
    return data.data
}

    
// 根据查询获取统计对象.
// flag: String: 统计标识
// queryFlag: String: 查询标识
// GET
export async function statActionGet (params) {
    const {data} = await request(`jaxrs/stat/${params.id}`)
    return data.data
}

    
// 根据查询列示统计对象.
// queryFlag: String: 查询标识
// PUT
export async function statActionExecute (params) {
    const {data} = await request(`jaxrs/stat/${params.id}/execute`, params)
    return data.data
}

    
// V8版本新版本查询语句,取消mode参数,增加自动count,增加自动内置参数判断,替换V2版本.
// flag: String: 标识
// page: Integer: 页码
// size: Integer: 每页数量
// GET
export async function statementActionGetFormat (params) {
    const {data} = await request(`jaxrs/statement/${params.id}/format`)
    return data.data
}

    
// 执行语句V2,可以同时执行查询结果及查询总数.
// flag: String: 标识
// mode: String: 执行模式：data|count|all
// page: Integer: 页码
// size: Integer: 每页数量
// POST
export async function statementActionListWithQuery (params) {
    const {data} = await request(`jaxrs/statement/list/query/${params.queryFlag}`, params)
    return data.data
}

    
// 获取语句内容.
// id: String: 标识
// POST
export async function statementActionExecuteV2 (params) {
    const {data} = await request(`jaxrs/statement/${params.flag}/execute/mode/${params.mode}/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取语句的格式.
// id: String: 标识
// GET
export async function statementActionGet (params) {
    const {data} = await request(`jaxrs/statement/${params.id}`)
    return data.data
}

    
// 根据查询列示语句对象.
// queryFlag: String: 查询标识
// POST
export async function statementActionExecute (params) {
    const {data} = await request(`jaxrs/statement/${params.flag}/execute/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 根据标识获取表.
// flag: String: 标识
// POST
export async function tableActionListRowPaging (params) {
    const {data} = await request(`jaxrs/table/list/table/${params.tableFlag}/row/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示表对象,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function tableActionListPaging (params) {
    const {data} = await request(`jaxrs/table/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 分页列示Table对象.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function tableActionListRowSelect (params) {
    const {data} = await request(`jaxrs/table/list/${params.tableFlag}/row/select`, params)
    return data.data
}

    
// 列示Stat对象,上一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function tableActionRowInsertOne (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/one`, params)
    return data.data
}

    
// 列示表中的行对象,下一页.
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量
// GET
export async function tableActionListNext (params) {
    const {data} = await request(`jaxrs/table/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 分页列示表中的数据
// tableFlag: String: 表标识
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function tableActionListPrev (params) {
    const {data} = await request(`jaxrs/table/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示表中的行对象,上一页.
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量
// GET
export async function tableActionRowCountWhere (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/count/where/${params.where}`)
    return data.data
}

    
// 根据条件获取表中的数据
// tableFlag: String: 表标识
// GET
export async function tableActionRowGet (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/${params.id}`)
    return data.data
}

    
// 通过where 获取表中的数据,格式为jpql语法,o.name='zhangsan'
// tableFlag: String: 表标识
// where: String: where语句
// GET
export async function tableActionListRowSelectWhere (params) {
    const {data} = await request(`jaxrs/table/list/${params.tableFlag}/row/select/where/${params.where}`)
    return data.data
}

    
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
// POST
export async function tableActionRowInsert (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row`, params)
    return data.data
}

    
// 通过where 统计数量
// tableFlag: String: 表标识
// where: String: where语句
// DELETE
export async function tableActionRowDeleteAll (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/delete/all`, params)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionListRowNext (params) {
    const {data} = await request(`jaxrs/table/list/${params.tableFlag}/row/${params.id}/next/${params.count}`)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// GET
export async function tableActionListRowPrev (params) {
    const {data} = await request(`jaxrs/table/list/${params.tableFlag}/row/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 更新指定表中指定行数据MockDeleteToGet.
// tableFlag: String: 表标识
// PUT
export async function tableActionRowUpdate (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/${params.id}`, params)
    return data.data
}

    
// 更新指定表中指定行数据MockDeleteToGet.
// tableFlag: String: 表标识
// id: String: 行标识
// DELETE
export async function tableActionRowDelete (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/${params.id}`, params)
    return data.data
}

    
// 获取表中某一行数据
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`jaxrs/table/reload/dynamic`)
    return data.data
}

    
// 指定表中插入数据.
// tableFlag: String: 表标识
// POST
export async function tableActionRowUpdateMockPutToPost (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 指定表中插入一行数据.
// tableFlag: String: 表标识
// GET
export async function tableActionRowDeleteAllMockDeleteToGet (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/delete/all/mockdeletetoget`)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionRowDeleteMockDeleteToGet (params) {
    const {data} = await request(`jaxrs/table/${params.tableFlag}/row/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 更新指定表中指定行数据 MockPutToPost.
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionGet (params) {
    const {data} = await request(`jaxrs/table/${params.flag}`)
    return data.data
}

    
// 列示执行后的bundle列表
// id: String: 视图标识
// GET
export async function viewActionExcelResult (params) {
    const {data} = await request(`jaxrs/view/excel/result/${params.flag}`)
    return data.data
}

    
// 列示执行后的bundle列表 MockPutToPost
// id: String: 视图标识
// GET
export async function viewActionGetWithQuery (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}`)
    return data.data
}

    
// 列示按查询和视图标识执行后的bundle列表
// flag: String: 视图标识
// queryFlag: String: 查询标识
// PUT
export async function viewActionExcel (params) {
    const {data} = await request(`jaxrs/view/${params.id}/excel`, params)
    return data.data
}

    
// 列示按查询和视图标识执行后的bundle列表 MockPutToPost
// flag: String: 视图标识
// queryFlag: String: 查询标识
// PUT
export async function viewActionExecuteWithQuery (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/execute`, params)
    return data.data
}

    
// 将视图执行结果作为Excel导出
// id: String: 视图标识
// POST
export async function viewActionExcelMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/${params.id}/excel/mockputtopost`, params)
    return data.data
}

    
// 将视图执行结果作为Excel导出 MockPutToPost
// id: String: 视图标识
// PUT
export async function viewActionExcelWithQuery (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/excel`, params)
    return data.data
}

    
// 导出Excel的执行结果.
// flag: String: 对象标识
// PUT
export async function viewActionBundleWithQuery (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/bundle`, params)
    return data.data
}

    
// 将视图执行结果作为Excel导出
// flag: String: 视图标识
// queryFlag: String: 查询标识
// GET
export async function viewActionListWithQuery (params) {
    const {data} = await request(`jaxrs/view/list/query/${params.queryFlag}`)
    return data.data
}

    
// 将视图执行结果作为Excel导出 MockPutToPost
// flag: String: 视图标识
// queryFlag: String: 查询标识
// POST
export async function viewActionBundleWithQueryMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/bundle/mockputtopost`, params)
    return data.data
}

    
// 执行view
// id: String: 视图标识
// POST
export async function viewActionExecuteMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/${params.id}/execute/mockputtopost`, params)
    return data.data
}

    
// 执行view MockPutToPost
// id: String: 视图标识
// POST
export async function viewActionBundleMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/${params.id}/bundle/mockputtopost`, params)
    return data.data
}

    
// 执行view
// flag: String: 视图标识
// queryFlag: String: 查询标识
// POST
export async function viewActionExcelWithQueryMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/excel/mockputtopost`, params)
    return data.data
}

    
// 执行view MockPutToPost
// flag: String: 视图标识
// queryFlag: String: 查询标识
// POST
export async function viewActionExecuteWithQueryMockPutToPost (params) {
    const {data} = await request(`jaxrs/view/flag/${params.flag}/query/${params.queryFlag}/execute/mockputtopost`, params)
    return data.data
}

    
// 获取View内容.
// id: String: 标识
// GET
export async function viewActionGet (params) {
    const {data} = await request(`jaxrs/view/${params.id}`)
    return data.data
}

    
// 根据query获取view对象.
// flag: String: 视图标识
// queryFlag: String: 查询标识
// PUT
export async function viewActionBundle (params) {
    const {data} = await request(`jaxrs/view/${params.id}/bundle`, params)
    return data.data
}

    
// 根据query列示view对象.
// queryFlag: String: 查询标识
// PUT
export async function viewActionExecute (params) {
    const {data} = await request(`jaxrs/view/${params.id}/execute`, params)
    return data.data
}

    