# 使用方法

js 函数中 params 变量需要传一个对象，默认如下形式，下方有介绍
```js
params = {
  pathParameters: {},
  queryParameters: {},
  // 如果 contentType 为 multipart/form-data
  data: new FormData(),
  // 如果 contentType 为 multipart/json，就将 data 写成 json 形式就行，不需要考虑是不是 ins
  data: {}
}
```

# 介绍

`describe.json` 文件中几个 parameters
键值对描述，以及在传参数时，需要以什么样的形式传入

```json
{
  "name": "captchaLogin",
  "className": "com.x.organization.assemble.authentication.jaxrs.authentication.ActionCaptchaLogin",
  "description": "用户登录.credential\u003dxxxx,password\u003dxxxx,使用图片验证码验证.",
  "type": "POST",
  "path": "jaxrs/authentication/captcha",
  "contentType": "application/json",
  "resultContentType": "application/json; charset\u003dUTF-8",
  "useJsonElementParameter": false,
  "useStringParameter": false,
  "pathParameters": [],
  "formParameters": [],
  "queryParameters": [],
  "ins": [],
  "outs": []
}
```

下面主要介绍的是 pathParameters, formParameters, queryParameters, ins
这四个键值对在 url 和 请求中的作用

## pathParameters

这个字段是将 url 中带括号的内容替换成相应的值

```json
{
  "name": "oauthLogin",
  "className": "com.x.organization.assemble.authentication.jaxrs.authentication.ActionOauthLogin",
  "description": "oauth登录认证",
  "type": "GET",
  "path": "jaxrs/authentication/oauth/login/name/{name}/code/{code}/redirecturi/{redirectUri}",
  "contentType": "application/json",
  "resultContentType": "application/json; charset\u003dUTF-8",
  "useJsonElementParameter": false,
  "useStringParameter": false,
  "pathParameters": [
    {
      "name": "name",
      "type": "String",
      "description": "oauthClient名称"
    },
    {
      "name": "code",
      "type": "String",
      "description": "code"
    },
    {
      "name": "redirectUri",
      "type": "String",
      "description": "redirectUri"
    }
  ]
}
```

**jquery样例**

```js
$.ajax({
  type: "GET",
  dataType: "json",
  url:
    "http://localhost:81/x_organization_assemble_authentication/jaxrs/authentication/oauth/login/name/替换参数0/code/替换参数1/redirecturi/替换参数2",
  headers: { "x-debugger": true },
  contentType: "application/json",
  xhrFields: { "withCredentials": true },
  crossDomain: true,
}).always(function (resultJson) {
  alert(JSON.stringify(resultJson, null, 4));
});
```

## formParameters

这个字段是传类型为 multipart/form-data 的参数类型到请求中，而不是 json

```json
{
    "name": "postInfoJira",
    "className": "com.x.organization.assemble.authentication.jaxrs.oauth.ActionInfo",
    "description": "POST方法实现oauth认证info方法,适配jira.",
    "type": "POST",
    "path": "jaxrs/oauth/info/jira",
    "contentType": "multipart/form-data",
    "resultContentType": "application/json; charset\u003dUTF-8",
    "useJsonElementParameter": false,
    "useStringParameter": true,
    "pathParameters": [],
    "formParameters": [
    {
        "name": "access_token",
        "type": "String",
        "description": "访问令牌"
    }
    ],
    "queryParameters": [],
    "ins": [],
    "outs": [
    {
        "name": "text",
        "type": "String",
        "isCollection": false,
        "description": "text"
    },
    {
        "name": "contentType",
        "type": "String",
        "isCollection": false,
        "description": "返回Content_Type"
    }
    ]
},
```

**jquery样例**

```js
var formData = new FormData();
formData.append("access_token", "参数0");
$.ajax({
  type: "POST",
  url:
    "http://localhost:81/x_organization_assemble_authentication/jaxrs/oauth/info/jira",
  headers: { "x-debugger": true },
  contentType: "multipart/form-data",
  processData: false,
  xhrFields: { "withCredentials": true },
  crossDomain: true,
  data: formData,
});
```

## queryParameters

放在 url 后面的变量

```json
{
    "name": "getInfoJira",
    "className": "com.x.organization.assemble.authentication.jaxrs.oauth.ActionInfo",
    "description": "GET方法实现oauth认证info方法,适配jira.",
    "type": "GET",
    "path": "jaxrs/oauth/info/jira",
    "contentType": "multipart/form-data",
    "resultContentType": "application/json; charset\u003dUTF-8",
    "useJsonElementParameter": false,
    "useStringParameter": false,
    "pathParameters": [],
    "formParameters": [],
    "queryParameters": [
    {
        "name": "access_token",
        "type": "String",
        "description": "access_token"
    }
    ],
    "ins": [],
    "outs": [
    {
        "name": "text",
        "type": "String",
        "isCollection": false,
        "description": "text"
    },
    {
        "name": "contentType",
        "type": "String",
        "isCollection": false,
        "description": "返回Content_Type"
    }
    ]
},
```

**jquery样例**

```js
var formData = new FormData();
$.ajax({
  type: "GET",
  url:
    "http://localhost:81/x_organization_assemble_authentication/jaxrs/oauth/info/jira?access_token=替换参数0",
  headers: { "x-debugger": true },
  contentType: "multipart/form-data",
  processData: false,
  xhrFields: { "withCredentials": true },
  crossDomain: true,
  data: formData,
});
```

## ins

作为内容传，当时要将 json 内容通过 JSON.stringify 转成字符串传入

```json
{
  "name": "captchaLogin",
  "className": "com.x.organization.assemble.authentication.jaxrs.authentication.ActionCaptchaLogin",
  "description": "用户登录.credential\u003dxxxx,password\u003dxxxx,使用图片验证码验证.",
  "type": "POST",
  "path": "jaxrs/authentication/captcha",
  "contentType": "application/json",
  "resultContentType": "application/json; charset\u003dUTF-8",
  "useJsonElementParameter": false,
  "useStringParameter": false,
  "pathParameters": [],
  "formParameters": [],
  "queryParameters": [],
  "ins": [
    {
      "name": "credential",
      "type": "String",
      "isCollection": false,
      "description": "用户凭证.",
      "isBaseType": true
    },
    {
      "name": "password",
      "type": "String",
      "isCollection": false,
      "description": "密码.",
      "isBaseType": true
    },
    {
      "name": "captcha",
      "type": "String",
      "isCollection": false,
      "description": "图片认证码编号.",
      "isBaseType": true
    },
    {
      "name": "captchaAnswer",
      "type": "String",
      "isCollection": false,
      "description": "图片认证码.",
      "isBaseType": true
    }
  ],
  "outs": []
}
```

**jquery样例**

```js
var data = {
  "credential": "参数",
  "password": "参数",
  "captcha": "参数",
  "captchaAnswer": "参数",
};

$.ajax({
  type: "POST",
  dataType: "json",
  url:
    "http://localhost:81/x_organization_assemble_authentication/jaxrs/authentication/captcha",
  headers: { "x-debugger": true },
  contentType: "application/json",
  xhrFields: { "withCredentials": true },
  crossDomain: true,
  data: JSON.stringify(data),
}).always(function (resultJson) {
  alert(JSON.stringify(resultJson, null, 4));
});
```
