
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}


// pathParameters
// id: String: 日历信息ID   
// GET : application/json
// 取消关注一个公开的日历信息
export async function calendarActionFollowCalendarCancel (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/follow/${params.pathParameters.id}/cancel`, params.data)
    return data.data
}

   
// ins
// name: String: 日历名称
// type: String: 日历类型
// source: String: 日历来源
// createor: String: 创建者
// PUT : application/json
// 根据条件查询日历信息列表
export async function calendarActionListWithFilter (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 日历信息ID   
// DELETE : application/json
// 根据ID删除日历信息及所有事件
export async function calendarActionDestory (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有公开的日历信息列表
export async function calendarActionListPublicCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/public`, params.data)
    return data.data
}


// pathParameters
// id: String: 日历信息ID   
// GET : application/json
// 关注一个公开的日历信息
export async function calendarActionFollowCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/follow/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取我能访问到的所有日历信息列表
export async function calendarActionListMyCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/my`, params.data)
    return data.data
}

   
// GET : application/json
// 判断当前用户是否对指定的日历有管理员权限
export async function calendarActionIsCalendarManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/ismanager/calendar/${params.pathParameters.accountId}`, params.data)
    return data.data
}

   
// GET : application/json
// 判断当前用户是否有管理员权限
export async function calendarActionIsManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/ismanager`, params.data)
    return data.data
}


// pathParameters
// id: String: 日历信息ID   
// GET : application/json
// 根据ID获取日历信息
export async function calendarActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// name: String: 日历名称
// type: String: 日历类别: PERSON | UNIT
// target: String: 人员标识或者组织标识
// color: String: 显示颜色
// description: String: 备注70个字
// source: String: 信息来源: LEADER | PERSON | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// createor: String: 创建者
// isPublic: Boolean: 是否公开的日历
// manageablePersonList: List<String>: 可管理人员列表
// followers: List<String>: 关注者列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// publishablePersonList: List<String>: 可发布人员列表
// publishableUnitList: List<String>: 可发布组织列表
// publishableGroupList: List<String>: 可发布群组列表
// status: String: 日历状态：OPEN|CLOSE
// POST : application/json
// 新建或者更新日历信息
export async function calendarActionSave (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有系统配置信息列表
export async function calendarSettingActionListAllReportSetting (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/list/all`, params.data)
    return data.data
}


// pathParameters
// code: String: 系统配置信息编码   
// GET : application/json
// 根据Code获取系统配置信息
export async function calendarSettingActionGetWithCode (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/code/${params.pathParameters.code}`, params.data)
    return data.data
}

   
// GET : application/json
// 判断当前用户是否有管理员权限
export async function calendarSettingActionIsManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/ismanager`, params.data)
    return data.data
}


// pathParameters
// id: String: 系统配置信息ID   
// GET : application/json
// 根据ID获取系统配置信息
export async function calendarSettingActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// configCode: String: 配置编码
// configName: String: 配置名称
// configValue: String: 配置内容
// valueType: String: 值类型: select | identity | number | date | text
// selectContent: String: 可选值，和select配合使用，以‘|’号分隔
// isMultiple: Boolean: 是否可以多值
// isLob: Boolean: 是否富文本、长文本
// orderNumber: Integer: 排序号
// description: String: 备注说明
// POST : application/json
// 新建或者更新系统配置信息
export async function calendarSettingActionSave (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// DELETE : application/json
// 根据指定事件ID删除所有的重复日历事件信息
export async function calendar_EventActionDestoryAllEventsWithRepeatMaster (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/all/${params.pathParameters.eventId}`, params.data)
    return data.data
}

   
// ins
// calendarIds: List<String>: 日历账号ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// key: String: 事件标题 或者 备注信息 模糊搜索
// startTime: Date: 查询开始时间
// endTime: Date: 查询结束时间
// createPerson: String: 创建者
// PUT : application/json
// 根据条件查询日历事件信息列表(返回简单列表)
export async function calendar_EventActionListWithFilterSample (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/list/filter/sample`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// ins
// id: String: 数据库主键,自动生成.
// calendarId: String: 日历账号ID
// repeatMasterId: String: 重复日程宿主ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// title: String: 事件标题
// color: String: 显示颜色
// comment: String: 备注信息
// commentId: String: 备注LOB信息
// startTime: Date: 事件开始时间
// startTimeStr: String: 事件开始时间(yyyy-MM-dd HH:mm:ss)
// endTime: Date: 事件结束时间
// endTimeStr: String: 事件结束时间(yyyy-MM-dd HH:mm:ss)
// locationName: String: 地点说明
// longitude: String: 经度
// latitude: String: 纬度
// recurrenceRule: String: 重复日期表达式RecurrenceRule
// recurrenceExc: String: 排除日期表达式RecurrenceExc
// alarm: Boolean: 是否提醒
// alarmTime: Date: 当前事件提醒时间
// alarmAlready: Boolean: 是否已经提醒过了
// valarmTime_config: String: 提醒提配置：天, 时, 分, 秒（负数为提前）
// valarm_mailto: String: 提交Email地址，为空则不邮件提醒
// valarm_Summary: String: 提醒显示标题
// valarm_description: String: 提醒备注信息
// isAllDayEvent: Boolean: 是否为全天事件
// daysOfDuration: Integer: 事件持续天数：0、1或者N天
// isPublic: Boolean: 是否公开的事件
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// bundle: String: 绑定来源数据标识
// createPerson: String: 创建者
// updatePerson: String: 最后更新者
// targetType: String: 参与者类型：PERSON | UNIT | GROUP
// participants: List<String>: 参与者列表
// manageablePersonList: List<String>: 可管理人员列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 更新事件所有的重复日程事件
export async function calendar_EventActionUpdateAllEventsWithRepeatMaster (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/all/${params.pathParameters.eventId}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// calendarIds: List<String>: 日历账号ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// key: String: 事件标题 或者 备注信息 模糊搜索
// startTime: Date: 查询开始时间
// endTime: Date: 查询结束时间
// createPerson: String: 创建者
// PUT : application/json
// 根据条件查询日历事件信息列表
export async function calendar_EventActionListWithFilter (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/list/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// ins
// id: String: 数据库主键,自动生成.
// calendarId: String: 日历账号ID
// repeatMasterId: String: 重复日程宿主ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// title: String: 事件标题
// color: String: 显示颜色
// comment: String: 备注信息
// commentId: String: 备注LOB信息
// startTime: Date: 事件开始时间
// startTimeStr: String: 事件开始时间(yyyy-MM-dd HH:mm:ss)
// endTime: Date: 事件结束时间
// endTimeStr: String: 事件结束时间(yyyy-MM-dd HH:mm:ss)
// locationName: String: 地点说明
// longitude: String: 经度
// latitude: String: 纬度
// recurrenceRule: String: 重复日期表达式RecurrenceRule
// recurrenceExc: String: 排除日期表达式RecurrenceExc
// alarm: Boolean: 是否提醒
// alarmTime: Date: 当前事件提醒时间
// alarmAlready: Boolean: 是否已经提醒过了
// valarmTime_config: String: 提醒提配置：天, 时, 分, 秒（负数为提前）
// valarm_mailto: String: 提交Email地址，为空则不邮件提醒
// valarm_Summary: String: 提醒显示标题
// valarm_description: String: 提醒备注信息
// isAllDayEvent: Boolean: 是否为全天事件
// daysOfDuration: Integer: 事件持续天数：0、1或者N天
// isPublic: Boolean: 是否公开的事件
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// bundle: String: 绑定来源数据标识
// createPerson: String: 创建者
// updatePerson: String: 最后更新者
// targetType: String: 参与者类型：PERSON | UNIT | GROUP
// participants: List<String>: 参与者列表
// manageablePersonList: List<String>: 可管理人员列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 更新重复日程事件中指定事件开始后续所有的日程事件信息
export async function calendar_EventActionUpdateAfterEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/after/${params.pathParameters.eventId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// DELETE : application/json
// 根据事件ID删除指定的日历事件信息
export async function calendar_EventActionDestorySingleEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/single/${params.pathParameters.eventId}`, params.data)
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// ins
// id: String: 数据库主键,自动生成.
// calendarId: String: 日历账号ID
// repeatMasterId: String: 重复日程宿主ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// title: String: 事件标题
// color: String: 显示颜色
// comment: String: 备注信息
// commentId: String: 备注LOB信息
// startTime: Date: 事件开始时间
// startTimeStr: String: 事件开始时间(yyyy-MM-dd HH:mm:ss)
// endTime: Date: 事件结束时间
// endTimeStr: String: 事件结束时间(yyyy-MM-dd HH:mm:ss)
// locationName: String: 地点说明
// longitude: String: 经度
// latitude: String: 纬度
// recurrenceRule: String: 重复日期表达式RecurrenceRule
// recurrenceExc: String: 排除日期表达式RecurrenceExc
// alarm: Boolean: 是否提醒
// alarmTime: Date: 当前事件提醒时间
// alarmAlready: Boolean: 是否已经提醒过了
// valarmTime_config: String: 提醒提配置：天, 时, 分, 秒（负数为提前）
// valarm_mailto: String: 提交Email地址，为空则不邮件提醒
// valarm_Summary: String: 提醒显示标题
// valarm_description: String: 提醒备注信息
// isAllDayEvent: Boolean: 是否为全天事件
// daysOfDuration: Integer: 事件持续天数：0、1或者N天
// isPublic: Boolean: 是否公开的事件
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// bundle: String: 绑定来源数据标识
// createPerson: String: 创建者
// updatePerson: String: 最后更新者
// targetType: String: 参与者类型：PERSON | UNIT | GROUP
// participants: List<String>: 参与者列表
// manageablePersonList: List<String>: 可管理人员列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 根据事件ID更新单个日程事件信息
export async function calendar_EventActionUpdateSingleEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/single/${params.pathParameters.eventId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// eventId: String: 日历事件信息ID   
// ins
// id: String: 数据库主键,自动生成.
// calendarId: String: 日历账号ID
// repeatMasterId: String: 重复日程宿主ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// title: String: 事件标题
// color: String: 显示颜色
// comment: String: 备注信息
// commentId: String: 备注LOB信息
// startTime: Date: 事件开始时间
// startTimeStr: String: 事件开始时间(yyyy-MM-dd HH:mm:ss)
// endTime: Date: 事件结束时间
// endTimeStr: String: 事件结束时间(yyyy-MM-dd HH:mm:ss)
// locationName: String: 地点说明
// longitude: String: 经度
// latitude: String: 纬度
// recurrenceRule: String: 重复日期表达式RecurrenceRule
// recurrenceExc: String: 排除日期表达式RecurrenceExc
// alarm: Boolean: 是否提醒
// alarmTime: Date: 当前事件提醒时间
// alarmAlready: Boolean: 是否已经提醒过了
// valarmTime_config: String: 提醒提配置：天, 时, 分, 秒（负数为提前）
// valarm_mailto: String: 提交Email地址，为空则不邮件提醒
// valarm_Summary: String: 提醒显示标题
// valarm_description: String: 提醒备注信息
// isAllDayEvent: Boolean: 是否为全天事件
// daysOfDuration: Integer: 事件持续天数：0、1或者N天
// isPublic: Boolean: 是否公开的事件
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// bundle: String: 绑定来源数据标识
// createPerson: String: 创建者
// updatePerson: String: 最后更新者
// targetType: String: 参与者类型：PERSON | UNIT | GROUP
// participants: List<String>: 参与者列表
// manageablePersonList: List<String>: 可管理人员列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// DELETE : application/json
// 删除重复日程事件中指定事件开始后续所有的日程事件信息
export async function calendar_EventActionDestoryAfterEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/after/${params.pathParameters.eventId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 日历事件信息ID   
// GET : application/json
// 根据ID获取日历事件信息的RFC内容
export async function calendar_EventActionGetRFC (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/rfc/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 日历事件信息ID   
// GET : application/json
// 根据ID获取日历事件信息
export async function calendar_EventActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// calendarId: String: 日历账号ID
// repeatMasterId: String: 重复日程宿主ID
// eventType: String: 信息类别: CAL_EVENT | TASK_EVENT
// title: String: 事件标题
// color: String: 显示颜色
// comment: String: 备注信息
// commentId: String: 备注LOB信息
// startTime: Date: 事件开始时间
// startTimeStr: String: 事件开始时间(yyyy-MM-dd HH:mm:ss)
// endTime: Date: 事件结束时间
// endTimeStr: String: 事件结束时间(yyyy-MM-dd HH:mm:ss)
// locationName: String: 地点说明
// longitude: String: 经度
// latitude: String: 纬度
// recurrenceRule: String: 重复日期表达式RecurrenceRule
// recurrenceExc: String: 排除日期表达式RecurrenceExc
// alarm: Boolean: 是否提醒
// alarmTime: Date: 当前事件提醒时间
// alarmAlready: Boolean: 是否已经提醒过了
// valarmTime_config: String: 提醒提配置：天, 时, 分, 秒（负数为提前）
// valarm_mailto: String: 提交Email地址，为空则不邮件提醒
// valarm_Summary: String: 提醒显示标题
// valarm_description: String: 提醒备注信息
// isAllDayEvent: Boolean: 是否为全天事件
// daysOfDuration: Integer: 事件持续天数：0、1或者N天
// isPublic: Boolean: 是否公开的事件
// source: String: 信息来源: PERSONAL| LEADER | UNIT | MEETING | BUSINESS_TRIP | HOLIDAY
// bundle: String: 绑定来源数据标识
// createPerson: String: 创建者
// updatePerson: String: 最后更新者
// targetType: String: 参与者类型：PERSON | UNIT | GROUP
// participants: List<String>: 参与者列表
// manageablePersonList: List<String>: 可管理人员列表
// viewablePersonList: List<String>: 可见人员列表
// viewableUnitList: List<String>: 可见组织列表
// viewableGroupList: List<String>: 可见群组列表
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// POST : application/json
// 创建一个新的日历事件信息
export async function calendar_EventActionCreate (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// type: String: 消息类型：meeting_invite | meeting_delete | meeting_accept | meeting_reject
// person: String: 接收者
// title: String: 消息提醒标题
// body: JsonElement: 消息内容
// POST : application/json
// 接收日历消息
export async function calendar_EventMessageActionMessageReceive (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/message`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
