
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// type: String: 类型
// person: String: 人员
// title: String: 标题
// body: JsonElement: 推送内容
// POST : application/json
// 接收.
export async function connectorActionCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/connector`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// consume: String: 消费者
// person: String: 人员
// count: Integer: 数量   
// GET : application/json
// 获取消息,指定人员.
export async function consumeActionListWithPerson (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/consume/list/${params.pathParameters.consume}/person/${params.pathParameters.person}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// type: String: 消费类型   
// GET : application/json
// 更新消息,将消息标志为已处理.
export async function consumeActionUpdateSingle (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/consume/${params.pathParameters.id}/type/${params.pathParameters.type}`, params.data)
    return data.data
}


// pathParameters
// consume: String: 消费者
// count: Integer: 数量   
// GET : application/json
// 获取消息,当前人员.
export async function consumeActionListWithCurrentPerson (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/consume/list/${params.pathParameters.consume}/currentperson/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// type: String: 消费类型   
// ins
// idList: List<String>: 标识
// PUT : application/json
// 更新消息,将消息标志为已处理.
export async function consumeActionUpdate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/consume/type/${params.pathParameters.type}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// consume: String: 消费者
// count: Integer: 数量   
// GET : application/json
// 获取消息.
export async function consumeActionList (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/consume/list/${params.pathParameters.consume}/count/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// ins
// enableClearMsg: Boolean: 是否开启清空聊天记录的功能.
// enableRevokeMsg: Boolean: 是否开启撤回聊天消息的功能.
// POST : application/json
// 更新IM配置.
export async function imActionConfig (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/manager/config`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取文件内容,输出头信息
export async function imActionDownload (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg/download/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话id   
// PUT : application/json
// 会话阅读消息.
export async function imActionConversationRead (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/read`, params.data)
    return data.data
}

   
// POST : application/json
// 创建消息，发送消息到某一个会话中.
export async function imActionMsgCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话id   
// PUT : application/json
// 会话置顶.
export async function imActionConversationSetTop (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/top/set`, params.data)
    return data.data
}

   
// GET : application/json
// 我的会话列表.
export async function imActionMyConversationList (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/list/my`, params.data)
    return data.data
}


// pathParameters
// id: String: 消息标识   
// GET : application/json
// 撤回消息
export async function imActionMsgRevoke (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg/revoke/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// conversationId: String: 会话id
// POST : application/json
// 分页查询某个会话的消息列表.
export async function imActionMsgListByPaging (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取IM配置.
export async function imActionGetImConfig (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/manager/config`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话id   
// GET : application/json
// 会话对象.
export async function imActionConversation (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// conversationId: String: 会话id
// type: String: 文件类型 
// formParameters
// file: File: 上传文件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 上传文件.
export async function imActionUploadFile (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg/upload/${params.pathParameters.conversationId}/type/${params.pathParameters.type}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度   
// GET : application/json
// 下载图片设定宽高后的(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
export async function imActionDownloadImageWidthHeight (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/msg/download/${params.pathParameters.id}/image/width/${params.pathParameters.width}/height/${params.pathParameters.height}`, params.data)
    return data.data
}


// pathParameters
// businessId: String: 业务id   
// GET : application/json
// 根据业务id查询会话，当前用户在会话中.
export async function imActionConversationFindByBusinessId (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/business/${params.pathParameters.businessId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话id   
// PUT : application/json
// 会话取消置顶.
export async function imActionConversationCancelTop (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/top/cancel`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话ID   
// DELETE : application/json
// 删除群聊，只有群主可以删除.
export async function imActionDeleteGroupConversation (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/group`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话ID   
// DELETE : application/json
// 删除单聊会话.
export async function imActionDeleteSingleConversation (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/single`, params.data)
    return data.data
}


// pathParameters
// id: String: 会话ID   
// DELETE : application/json
// 清空会话的所有消息.
export async function imActionClearConversationMsg (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation/${params.pathParameters.id}/clear/all/msg`, params.data)
    return data.data
}

   
// ins
// id: String: id
// title: String: 会话标题
// note: String: 会话公告
// personList: List<String>: 会话对象
// adminPerson: String: 会话管理员
// PUT : application/json
// 修改会话.
export async function imActionUpdate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation`, JSON.stringify(params.data))
    return data.data
}

   
// POST : application/json
// 创建会话.
export async function imActionCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/im/conversation`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示所有的主体消息,需要管理员权限或者MessageManager,下一页.
export async function instantActionListNext (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示所有的主体消息,需要管理员权限或者MessageManager,上一页.
export async function instantActionListPrev (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员还未消费的主体消息,倒序.
export async function instantActionListWithCurrentNotConsumedPersonDesc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/not/consumed/count/${params.pathParameters.count}/desc`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员还未消费的主体消息,顺序.
export async function instantActionListWithCurrentPersonNotConsumedAsc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/not/consumed/count/${params.pathParameters.count}/asc`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员已经消费的主体消息,顺序.
export async function instantActionListWithCurrentPersonConsumedAsc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/consumed/count/${params.pathParameters.count}/asc`, params.data)
    return data.data
}

   
// ins
// idList: List<String>: 标识
// PUT : application/json
// 将当前用户指定的主体消息标识为已消费.
export async function instantActionCurrentPersonConsumed (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/currentperson/consumed`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员的主体消息,顺序.
export async function instantActionListWithCurrentPersonAsc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/count/${params.pathParameters.count}/asc`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员已经消费的主体消息,倒序.
export async function instantActionListWithCurrentConsumedPersonDesc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/consumed/count/${params.pathParameters.count}/desc`, params.data)
    return data.data
}

   
// GET : application/json
// 将当前用户所有主体消息全部标识为已消费.
export async function instantActionCurrentPersonConsumedAll (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/currentperson/consumed/all`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员的主体消息,倒序.
export async function instantActionListWithCurrentPersonDesc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/count/${params.pathParameters.count}/desc`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 获取当前人员的主体消息,排除IM消息,倒序.
export async function instantActionListWithCurrentPersonWithoutIMDesc (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/instant/list/currentperson/noim/count/${params.pathParameters.count}/desc`, params.data)
    return data.data
}

   
// GET : application/json
// 获取启用的消息类型.
export async function massActionEnableType (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass/enable/type`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示群发消息对象,下一页.
export async function massActionListNext (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示群发消息对象,上一页.
export async function massActionListPrev (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取消息.
export async function massActionGet (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除群发消息.
export async function massActionDelete (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// creatorPerson: String: 创建人，可能为空，如果由系统创建。
// body: String: 内容.
// type: String: 消息类型.
// personList: List<String>: 个人对象.
// identityList: List<String>: 身份对象.
// groupList: List<String>: 群组对象.
// unitList: List<String>: 组织对象.
// sendPersonList: List<String>: 发送人员对象.
// POST : application/json
// 更新消息,将消息标志为已处理.
export async function massActionCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/mass`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// type: String: 类型
// person: String: 人员
// title: String: 标题
// body: JsonElement: 推送内容
// POST : application/json
// 创建定制消息.
export async function messageActionCustomCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/message/custom/create`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// person: String: 用户
// type: String: 消息类型.
// consume: String: 消费者
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// POST : application/json
// 消息分页查询.
export async function messageActionListPaging (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/message/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// GET : application/json
// 在线用户数量.
export async function wsActionCountPerson (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/ws/count/person`, params.data)
    return data.data
}

   
// GET : application/json
// 列示用户.
export async function wsActionListPerson (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/ws/list/person`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前节点用户.
export async function wsActionListPersonCurrentNode (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/ws/list/person/current/node`, params.data)
    return data.data
}

   
// ins
// type: String: Ws消息类别.
// person: String: Ws消息接收人.
// title: String: Ws消息标题.
// body: JsonElement: Ws消息内容.
// POST : application/json
// 发送webSocket消息.
export async function wsActionCreate (params) {
    const {data} = await request(`/x_message_assemble_communicate/jaxrs/ws`, JSON.stringify(params.data))
    return data.data
}
