
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// folderId: String: 文件夹ID   
// ins
// mindIds: List<String>: 需要移动的脑图列表
// folderIds: List<String>: 需要移动的文件夹列表
// PUT : application/json
// 将指定的脑图和文件夹移动到指定的文件夹内
export async function mindFolderInfoActionMoveMindAndFolder (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/folder/move/${params.pathParameters.folderId}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 目录名称
// parentId: String: 上级目录Id，默认为‘0’ 
// orderNumber: Integer: 编号，默认为1
// description: String: 备注信息
// creator: String: 自动生成，创建者
// creatorUnit: String: 自动生成，创建者所属组织
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// POST : application/json
// 保存(创建或者更新)一个目录信息
export async function mindFolderInfoActionSaveFolder (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/folder/save`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 文件夹ID   
// DELETE : application/json
// 根据ID强制删除一个目录，包括下级目录以及文件
export async function mindFolderInfoActionFolderDeleteForce (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/folder/${params.pathParameters.id}/force`, params.data)
    return data.data
}

   
// GET : application/json
// 列出用户自己的个人脑图文件夹（所有文件夹，按上下级树型组织信息）
export async function mindFolderInfoActionTreeMyFolder (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/folder/tree/my`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件夹ID   
// DELETE : application/json
// 根据ID删除一个目录，如果目录是非空目录，则无法删除）
export async function mindFolderInfoActionFolderDelete (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/folder/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// ins
// sharePersons: List<String>: 分享目标人员列表
// shareUnits: List<String>: 分享目标组织列表
// shareGroups: List<String>: 分享目标群组列表
// PUT : application/json
// 将指定的脑图分享给其他用户或者组织
export async function mindInfoActionShareMindWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/share/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 脑图名称
// folderId: String: 所属目录ID
// icon: String: 缩略图信息
// description: String: 备注信息
// creator: String: 自动生成，创建者
// creatorUnit: String: 自动生成，创建者所属组织
// shared: Boolean: 自动生成，是否已经分享
// cooperative: Boolean: 自动生成，是否协作模式
// sharePersonList: List<String>: 共享人员
// shareUnitList: List<String>: 共享组织
// shareGroupList: List<String>: 共享群组
// editorList: List<String>: 可编辑人员
// shared_sequence: String: 自动生成，shared列表序号.
// folder_sequence: String: 自动生成，folder列表序号
// creator_sequence: String: 自动生成，creator列表序号.
// creatorUnit_sequence: String: 自动生成，creatorUnit列表序号.
// cooperative_sequence: String: 自动生成，cooperative列表序号.
// fileVersion: Integer: 自动生成，版本号
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// POST : application/json
// 保存(创建或者更新)一个脑图信息
export async function mindInfoActionSaveMind (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/save`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// shareId: String: 脑图分享信息ID   
// PUT : application/json
// 根据分享记录ID取消对脑图的分享
export async function mindInfoActionShareCancelWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/share/${params.pathParameters.shareId}/cancel`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// DELETE : application/json
// 根据脑图文件ID删除脑图信息
export async function mindInfoActionDestoryFromNormal (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/${params.pathParameters.id}/destorymind`, params.data)
    return data.data
}


// pathParameters
// mindId: String: 脑图信息ID
// size: Integer: 最大宽度 
// formParameters
// file: File:   
// POST : multipart/form-data
// 上传或者替换栏目的图标内容，可以指定压缩大小	.
export async function mindInfoActionChangeMindIcon (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/${params.pathParameters.mindId}/icon/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量   
// ins
// key: String: 模糊搜索
// folderId: String: 所属目录
// description: String: 备注信息
// creator: String: 创建者
// creatorUnit: String: 创建者所属组织
// sharePersons: List<String>: 共享者列表
// shareUnits: List<String>: 共享组织列表
// shareGroups: List<String>: 共享角色列表
// shared: Boolean: 是否已经分享
// orderField: String: 排序列：默认为sequence
// orderType: String: 排序方式：DESC|ASC， 默认为DESC
// PUT : application/json
// 列示符合过滤条件的脑图信息内容, 下一页.
export async function mindInfoActionListNextWithFilter (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/filter/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// DELETE : application/json
// 将指定的脑图放入回收站
export async function mindInfoActionRecycleMindWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/recycle/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// recycleId: String: 回收站脑图ID   
// DELETE : application/json
// 从回收站根据信息ID删除脑图信息
export async function mindInfoActionDestoryFromRecycle (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/${params.pathParameters.recycleId}/destoryrecycle`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// GET : application/json
// 根据ID获取脑图信息，包括脑图内容
export async function mindInfoActionViewMindWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/view/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 回收站脑图ID   
// GET : application/json
// 根据ID从回收站还原脑图信息
export async function mindInfoActionRestoreMindWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/restore/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// GET : application/json
// 根据ID获取脑图缩略图
export async function mindInfoActionGetMindIconWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/${params.pathParameters.id}/icon`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// GET : application/json
// 根据脑图ID获取脑图所有的版本信息
export async function mindInfoActionListVersionsWithMindId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/list/${params.pathParameters.id}/version`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图历史版本信息ID   
// GET : application/json
// 根据历史版本信息ID获取脑图信息，包括脑图内容
export async function mindInfoActionViewMindVersionWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/version/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// GET : application/json
// 根据脑图ID获取脑图所有的分享信息
export async function mindInfoActionListShareRecordsWithMindId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/list/${params.pathParameters.id}/shareRecords`, params.data)
    return data.data
}


// pathParameters
// id: String: 脑图ID   
// GET : application/json
// 根据ID获取脑图信息
export async function mindInfoActionGetMindBaseInfoWithId (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量   
// ins
// folderId: String: 指定的目录ID
// key: String: 关键字
// sharePersons: List<String>: 共享者列表
// shareUnits: List<String>: 共享组织列表
// shareGroups: List<String>: 共享角色列表
// orderField: String: 排序列：默认为sequence
// orderType: String: 排序方式：DESC|ASC， 默认为DESC
// PUT : application/json
// 列示符合过滤条件的脑图信息内容, 下一页.
export async function mindInfoActionListMySharedMindNextWithFilter (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/filter/shared/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量   
// ins
// folderId: String: 文件原始目录
// shared: Boolean: 是否已分享
// key: String: 关键字
// orderField: String: 排序列：默认为sequence
// orderType: String: 排序方式：DESC|ASC， 默认为DESC
// PUT : application/json
// 列示符合过滤条件的脑图信息内容, 下一页.
export async function mindInfoActionListMyRecycleNextWithFilter (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/filter/recycle/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量   
// ins
// source: String: 分享者
// key: String: 关键字
// orderField: String: 排序列：默认为sequence
// orderType: String: 排序方式：DESC|ASC， 默认为DESC
// PUT : application/json
// 列示符合过滤条件的脑图信息内容, 下一页.
export async function mindInfoActionListMyRecivedMindNextWithFilter (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/mind/filter/recived/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_mind_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
