

// pathParameters
// token: String: 单点票据
// enterId: String: 企业ID   
// GET : application/json
// 移动办公MOA点单登录.
export async function andFxActionMoaSso (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/andfx/moa/sso/token/${params.pathParameters.token}/enter/${params.pathParameters.enterId}`, params.data)
    return data.data
}

   
// DELETE : application/json
// 用户注销.
export async function authenticationActionLogout (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication`, params.data)
    return data.data
}

   
// ins
// credential: String: 用户标识.
// password: String: 密码.
// POST : application/json
// 用户登录.credential=xxxx,password=xxxx
export async function authenticationActionLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 钉钉oauth登录认证配置
export async function authenticationActionDingdingOauthConfig (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/dingding/config`, params.data)
    return data.data
}

   
// GET : application/json
// 获取公钥publicKey
export async function authenticationActionCaptchaRSAPublicKey (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/captchaRSAPublicKey`, params.data)
    return data.data
}

   
// GET : application/json
// 企业微信oauth登录认证配置
export async function authenticationActionQiyeweixinOauthConfig (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/qywx/config`, params.data)
    return data.data
}

   
// ins
// credential: String: 用户凭证.
// POST : application/json
// 切换当前用户,需要系统管理员权限 MockPutToPost.
export async function authenticationActionSwitchUserMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/switchuser/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 用户注销 MockDeleteToGet.
export async function authenticationActionLogoutMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// credential: String: 用户凭证.
// password: String: 密码.
// captcha: String: 图片认证码编号.
// captchaAnswer: String: 图片认证码.
// POST : application/json
// 用户登录.credential=xxxx,password=xxxx,使用图片验证码验证.
export async function authenticationActionCaptchaLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/captcha`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// credential: String: 用户标识.
// codeAnswer: String: 短信认证码.
// POST : application/json
// 用户登录.credential=xxxx,codeAnswer=xxxx,使用短信验证码登录.
export async function authenticationActionCodeLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/code`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// credential: String: 凭证   
// GET : application/json
// 检查用户名是否存在.
export async function authenticationActionCheckCredential (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/check/credential/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// width: Integer: 图片验证码宽度
// height: Integer: 图片验证码高度   
// GET : application/json
// 获取图片验证码.
export async function authenticationActionCaptcha (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/captcha/width/${params.pathParameters.width}/height/${params.pathParameters.height}`, params.data)
    return data.data
}


// pathParameters
// name: String: oauthClient名称   
// GET : application/json
// oauth登录认证地址
export async function authenticationActionOauth (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/name/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// code: String: code   
// GET : application/json
// 钉钉oauth登录
export async function authenticationActionOauthLoginDingding (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/login/dingding/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// name: String: oauthClient名称
// code: String: code
// redirectUri: String: redirectUri   
// GET : application/json
// oauth账户绑定.
export async function authenticationActionOauthBind (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/bind/name/${params.pathParameters.name}/code/${params.pathParameters.code}/redirecturi/${params.pathParameters.redirectUri}`, params.data)
    return data.data
}


// pathParameters
// code: String: code   
// GET : application/json
// 企业微信oauth登录
export async function authenticationActionOauthLoginQywx (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/login/qywx/code/${params.pathParameters.code}`, params.data)
    return data.data
}

   
// GET : application/json
// 安全注销用户,该用户所有session全部过期.
export async function authenticationActionSafeLogout (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/safe/logout`, params.data)
    return data.data
}


// pathParameters
// name: String: oauthClient名称
// code: String: code
// redirectUri: String: redirectUri   
// GET : application/json
// oauth登录认证
export async function authenticationActionOauthLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/login/name/${params.pathParameters.name}/code/${params.pathParameters.code}/redirecturi/${params.pathParameters.redirectUri}`, params.data)
    return data.data
}

   
// ins
// credential: String: 用户凭证.
// PUT : application/json
// 切换当前用户,需要系统管理员权限.
export async function authenticationActionSwitchUser (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/switchuser`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// meta: String: 认证序列号   
// GET : application/json
// 通过二维码进行登录.
export async function authenticationActionBindLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/bind/meta/${params.pathParameters.meta}`, params.data)
    return data.data
}

   
// GET : application/json
// oauth登录认证地址
export async function authenticationActionOauthList (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/oauth/list`, params.data)
    return data.data
}


// pathParameters
// meta: String: 认证序列号   
// POST : application/json
// 二维码用户录入.
export async function authenticationActionBindMeta (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/bind/meta/${params.pathParameters.meta}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前可用的登录模式.
export async function authenticationActionMode (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/mode`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前用户,如果是未登录用户返回anonymous
export async function authenticationActionWho (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication`, params.data)
    return data.data
}


// pathParameters
// credential: String: 凭证   
// GET : application/json
// 获取短信验证码.
export async function authenticationActionCode (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/code/credential/${params.pathParameters.credential}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取登录二维码.
export async function authenticationActionBind (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/authentication/bind`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有绑定对象.
export async function bindActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/bind/list`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// code: String: 登录code   
// GET : application/json
// 钉钉点单登录.
export async function dingdingActionGetLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/dingding/code/${params.pathParameters.code}`, params.data)
    return data.data
}

   
// ins
// url: String: 签名地址
// POST : application/json
// 钉钉获取jsticket等信息.
export async function dingdingActionInfo (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/dingding/info`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// code: String: 码   
// GET : application/json
// 绑定微信公众号openid到当前登录用户.
export async function mPweixinActionBindWithCode (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/mpweixin/bind/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// code: String: 码   
// GET : application/json
// 微信公众号code登录.
export async function mPweixinActionLoginWithCode (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/mpweixin/login/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// person: String: 人员   
// POST : application/json
// 测试发送模版消息
export async function mPweixinActionTestSendMessage (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/mpweixin/menu/test/send/to/${params.pathParameters.person}`, params.data)
    return data.data
}

  
// queryParameters
// access_token: String: access_token
// contentType: String: response CONTENT_TYPE 设置 默认为text/plain; charset=UTF-8 
// GET : application/json
// GET方法实现oauth认证info方法.
export async function oauthActionGetInfo (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/info?access_token=${params.queryParameters.access_token }&contentType=${params.queryParameters.contentType }`, params.data)
    return data.data
}

  
// queryParameters
// code: String: code
// grant_type: String: grant_type
// contentType: String: response CONTENT_TYPE 设置 默认为text/plain; charset=UTF-8 
// GET : application/json
// GET方法实现oauth认证token方法
export async function oauthActionGetToken (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/token?code=${params.queryParameters.code }&grant_type=${params.queryParameters.grant_type }&contentType=${params.queryParameters.contentType }`, params.data)
    return data.data
}

 
// formParameters
// code: String: 码
// contentType: String: response CONTENT_TYPE 设置 默认为text/plain; charset=UTF-8
// grant_type: String: 授权类型  
// POST : multipart/form-data
// POST方法实现oauth认证token方法
export async function oauthActionPostToken (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/token`, params.data)
    return data.data
}

 
// formParameters
// code: String: 码
// grant_type: String: 授权类型  
// POST : multipart/form-data
// POST方法实现oauth认证token方法,适配jira.
export async function oauthActionPostTokenJira (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/token/jira`, params.data)
    return data.data
}

  
// queryParameters
// access_token: String: access_token 
// GET : multipart/form-data
// GET方法实现oauth认证info方法,适配jira.
export async function oauthActionGetInfoJira (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/info/jira?access_token=${params.queryParameters.access_token }`, params.data)
    return data.data
}

 
// formParameters
// access_token: String: access_token
// contentType: String: response CONTENT_TYPE 设置 默认为text/plain; charset=UTF-8  
// POST : multipart/form-data
// POST方法实现oauth认证info方法.
export async function oauthActionPostInfo (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/info`, params.data)
    return data.data
}

 
// formParameters
// access_token: String: 访问令牌  
// POST : multipart/form-data
// POST方法实现oauth认证info方法,适配jira.
export async function oauthActionPostInfoJira (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/info/jira`, params.data)
    return data.data
}

  
// queryParameters
// response_type: String: 表示授权类型，必选项，此处的值固定为code
// client_id: String: 表示客户端的ID
// redirect_uri: String: 表示重定向URI
// scope: String: 表示申请的权限范围
// state: String: 表示客户端的当前状态，可以指定任意值，认证服务器会原封不动地返回这个值 
// GET : application/json
// GET方法实现oauth认证auth方法
export async function oauthActionAuth (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/oauth/auth?response_type=${params.queryParameters.response_type }&client_id=${params.queryParameters.client_id }&redirect_uri=${params.queryParameters.redirect_uri }&scope=${params.queryParameters.scope }&state=${params.queryParameters.state }`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// code: String: 码   
// GET : application/json
// 企业微信获取用户详细信息.
export async function qiyeweixinActionUpdatePersonInfoFromQywx (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/qiyeweixin/update/person/detail/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// code: String: 码   
// GET : application/json
// 企业微信点单登录.
export async function qiyeweixinActionGetLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/qiyeweixin/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// client: String: 标识
// key: String: 口令
// credential: String: 凭证   
// GET : application/json
// GET方法,进行3DES加密,用于不方便进行加密的场景.
export async function ssoActionGetEncrypt (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/sso/encrypt/client/${params.pathParameters.client}/key/${params.pathParameters.key}/credential/${params.pathParameters.credential}`, params.data)
    return data.data
}

   
// ins
// token: String: 令牌
// client: String: 客户标识
// POST : application/json
// POST方法,使用token进行Sso登陆。格式加密后的credential#1970年毫秒数
export async function ssoActionPostLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/sso`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// client: String: 标识
// token: String: 令牌   
// GET : application/json
// GET方法,使用token进行Sso登陆。格式加密后的credential#1970年毫秒数
export async function ssoActionGetLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/sso/client/${params.pathParameters.client}/token/${params.pathParameters.token}`, params.data)
    return data.data
}

   
// ins
// client: String: 客户标识
// credential: String: 用户标识
// key: String: 加密密钥
// POST : application/json
// POST方法,进行3DES加密,用于不方便进行加密的场景.
export async function ssoActionPostEncrypt (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/sso/encrypt`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}


// pathParameters
// code: String: 登录code   
// GET : application/json
// WeLink单点登录.
export async function weLinkActionGetLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/welink/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// code: String: 登录code   
// GET : application/json
// 钉钉点单登录.
export async function zhengwuDingdingActionGetLogin (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/zhengwudingding/code/${params.pathParameters.code}`, params.data)
    return data.data
}

   
// ins
// url: String: 签名地址
// POST : application/json
// 钉钉获取jsticket等信息.
export async function zhengwuDingdingActionInfo (params) {
    const {data} = await request(`/x_organization_assemble_authentication/jaxrs/zhengwudingding/info`, JSON.stringify(params.data))
    return data.data
}
