
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// person: String: 用户
// name: String: 定义名称   
// PUT : application/json
// 管理员更新指定用户指定名称的Custom数据.
export async function customActionManagerUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.pathParameters.person}/name/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户
// name: String: 名称   
// GET : application/json
// 获取指定用户的Custom数据.
export async function customActionManagerGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.pathParameters.person}/name/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// POST : application/json
// 更新指定名称的Custom数据(Mock put to post).
export async function customActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.pathParameters.name}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户
// name: String: 定义名称   
// POST : application/json
// 管理员更新指定用户指定名称的Custom数据(Mock put to post).
export async function customActionManagerUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.pathParameters.person}/name/${params.pathParameters.name}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// GET : application/json
// 删除指定名称的Custom数据(Mock delete to get).
export async function customActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.pathParameters.name}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// GET : application/json
// 根据当前的访问用户获取Custom数据.
export async function customActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// PUT : application/json
// 更新指定名称的Custom.
export async function customActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// DELETE : application/json
// 删除指定名称的Custom数据.
export async function customActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// POST : application/json
// 更新指定名称的Definition MockPutToPost.
export async function definitionActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.pathParameters.name}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// GET : application/json
// 删除指定名称的Definition MockDeleteToGet.
export async function definitionActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.pathParameters.name}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// GET : application/json
// 访问当前用户指定名称的自定义数据.
export async function definitionActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// PUT : application/json
// 更新指定名称的Definition.
export async function definitionActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称   
// DELETE : application/json
// 删除指定名称的Definition.
export async function definitionActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.pathParameters.name}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 启用授权
export async function empowerActionEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}/enable`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 禁用授权
export async function empowerActionDisable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}/disable`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员   
// GET : application/json
// 查询指定人员的授权.
export async function empowerActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/person/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// PUT : application/json
// 更新授权.
export async function empowerActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// POST : application/json
// 更新授权(Mock put to post).
export async function empowerActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理员列示授权对象,下一页.
export async function empowerActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员的被授权.
export async function empowerActionListTo (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/to`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// PUT : application/json
// 管理员更新授权.
export async function empowerActionManagerEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取当前人员的生效的被授权.
export async function empowerActionListToEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/to/enable`, params.data)
    return data.data
}

   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// POST : application/json
// 管理员创建授权.
export async function empowerActionManagerCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理员列示授权对象,上一页.
export async function empowerActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 管理员删除授权
export async function empowerActionManagerDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// fromPerson: String: 授权人.
// startTime: String: (授权创建时间)开始时间, 格式为: yyyy-MM-dd HH:mm:ss
// endTime: String: (授权创建时间)结束时间, 格式为: yyyy-MM-dd HH:mm:ss
// POST : application/json
// 管理员根据条件查询授权记录.
export async function empowerActionManagerlistPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取当前人员生效的授权.
export async function empowerActionListWithCurrentPersonEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/currentperson/enable`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员的授权.
export async function empowerActionListWithCurrentPerson (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/currentperson`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// POST : application/json
// 管理员更新授权(Mock put to post).
export async function empowerActionManagerEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.pathParameters.id}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 删除授权 MockDeleteToGet
export async function empowerActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 管理员删除授权 MockDeleteToGet
export async function empowerActionManagerDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取用户授权对象.
export async function empowerActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除授权
export async function empowerActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// edition: String: 流程版本.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// filterListData: String: 过滤条件.
// type: String: 授权类型:all,application,process,filter.
// startTime: Date: 授权开始时间.
// completedTime: Date: 授权结束时间.
// enable: Boolean: 是否启用.
// POST : application/json
// 创建授权.
export async function empowerActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理员列示授权日志对象,下一页.
export async function empowerLogActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理员列示授权日志对象,上一页.
export async function empowerLogActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// fromPerson: String: 授权人
// key: String: 匹配关键字
// startTime: String: (授权创建时间)开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: (授权创建时间)结束时间yyyy-MM-dd HH:mm:ss
// POST : application/json
// 管理员根据条件查询授权日志.
export async function empowerLogActionManagerlistPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/manager/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 删除授权日志 MockDeleteToGet
export async function empowerLogActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// key: String: 匹配关键字
// POST : application/json
// 获取当前人员的授权日志.
export async function empowerLogActionListWithCurrentPersonPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/currentperson/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// key: String: 匹配关键字
// POST : application/json
// 获取当前人员的被授权日志.
export async function empowerLogActionListToCurrentPersonPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/to/currentperson/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除授权日志.
export async function empowerLogActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前用户邮件单点登录地址.
export async function exmailActionSso (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/sso`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前用户腾讯企业邮标题,读取通过回调写入PersonAttribute的值.
export async function exmailActionListTitlePassive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/list/title/passive`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前用户的exmail邮件数量,读取通过回调写入PersonAttribute的值.
export async function exmailActionNewCountPassive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/new/count/passive`, params.data)
    return data.data
}

  
// queryParameters
// msg_signature: String: msg_signature
// timestamp: String: timestamp
// nonce: String: nonce
// echostr: String: echostr 
// GET : application/json
// 接收腾讯企业邮回调GET方法.
export async function exmailActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail?msg_signature=${params.queryParameters.msg_signature }&timestamp=${params.queryParameters.timestamp }&nonce=${params.queryParameters.nonce }&echostr=${params.queryParameters.echostr }`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前用户的exmail邮件数量,即时访问腾讯企业邮获取.
export async function exmailActionNewCount (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/new/count`, params.data)
    return data.data
}

  
// queryParameters
// msg_signature: String: msg_signature
// timestamp: String: timestamp
// nonce: String: nonce 
// POST : application/json
// 接收腾讯企业邮回调POST方法.
export async function exmailActionCallback (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail?msg_signature=${params.queryParameters.msg_signature }&timestamp=${params.queryParameters.timestamp }&nonce=${params.queryParameters.nonce }`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// person: String: 应用标识   
// GET : application/json
// 获取个人头像.
export async function iconActionGetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/icon/${params.pathParameters.person}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/openapi`, params.data)
    return data.data
}

   
// ins
// oldPassword: String: 原密码
// newPassword: String: 新密码
// confirmPassword: String: 确认新密码
// PUT : application/json
// 修改密码.
export async function passwordActionChangePassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/password`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// oldPassword: String: 原密码
// newPassword: String: 新密码
// confirmPassword: String: 确认新密码
// POST : application/json
// 修改密码 MockPutToPost.
export async function passwordActionChangePasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/password/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// oldPassword: String: 原密码
// newPassword: String: 新密码
// confirmPassword: String: 确认新密码
// isEncrypted: String: 是否启用加密,默认不加密,启用(y)。注意:使用加密先要在服务器运行 create encrypt key
// PUT : application/json
// 更新指定个人的密码.
export async function personActionSetPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/password`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取个人头像.
export async function personActionGetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`, params.data)
    return data.data
}

 
// formParameters
// file: File: 头像文件  
// PUT : multipart/form-data
// 设置个人的头像.
export async function personActionSetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`, params.data)
    return data.data
}

   
// ins
// genderType: GenderType: 性别.男:m,女:f,未知:d
// signature: String: 个性签名.
// description: String: 描述.
// nickName: String: 昵称.
// distinguishedName: String: 识别名,自动填充,@P结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// changePasswordTime: Date: 用户密码最后修改时间.
// mail: String: 邮件地址.
// weixin: String: 微信号.
// qq: String: QQ号.
// mobile: String: 必填,手机号.
// hiddenMobile: Boolean: 是否隐藏手机号.
// officePhone: String: 办公电话.
// boardDate: Date: 入职时间.
// birthday: Date: 生日.
// age: Integer: 年龄
// dingdingId: String: 钉钉人员ID.
// dingdingHash: String: 钉钉人员哈希特征.
// weLinkId: String: WeLikn人员ID.
// weLinkHash: String: WeLink人员哈希特征.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公人员ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公人员哈希特征.
// mpwxopenId: String: 微信公众号人员openid.
// open1Id: String: oauth登录id1.
// open2Id: String: oauth登录id2.
// open3Id: String: oauth登录id3.
// open4Id: String: oauth登录id4.
// open5Id: String: oauth登录id5.
// failureTime: Date: 登录失败记录时间.
// failureCount: Integer: 登录失败次数
// language: String: 国际化语言,如：zh-CN,zh,en,zh_TW等.
// topUnitList: List<String>: 所属顶层组织.
// PUT : application/json
// 更新个人的信息,不更新superior和controllerList
export async function personActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// genderType: GenderType: 性别.男:m,女:f,未知:d
// signature: String: 个性签名.
// description: String: 描述.
// nickName: String: 昵称.
// distinguishedName: String: 识别名,自动填充,@P结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// changePasswordTime: Date: 用户密码最后修改时间.
// mail: String: 邮件地址.
// weixin: String: 微信号.
// qq: String: QQ号.
// mobile: String: 必填,手机号.
// hiddenMobile: Boolean: 是否隐藏手机号.
// officePhone: String: 办公电话.
// boardDate: Date: 入职时间.
// birthday: Date: 生日.
// age: Integer: 年龄
// dingdingId: String: 钉钉人员ID.
// dingdingHash: String: 钉钉人员哈希特征.
// weLinkId: String: WeLikn人员ID.
// weLinkHash: String: WeLink人员哈希特征.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公人员ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公人员哈希特征.
// mpwxopenId: String: 微信公众号人员openid.
// open1Id: String: oauth登录id1.
// open2Id: String: oauth登录id2.
// open3Id: String: oauth登录id3.
// open4Id: String: oauth登录id4.
// open5Id: String: oauth登录id5.
// failureTime: Date: 登录失败记录时间.
// failureCount: Integer: 登录失败次数
// language: String: 国际化语言,如：zh-CN,zh,en,zh_TW等.
// topUnitList: List<String>: 所属顶层组织.
// POST : application/json
// 更新个人的信息,不更新superior和controllerList MockPutToPost
export async function personActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

 
// formParameters
// file: File: 头像文件  
// POST : multipart/form-data
// 设置个人的头像 MockPutToPost.
export async function personActionSetIconMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon/mockputtopost`, params.data)
    return data.data
}

   
// POST : application/octet-stream
// 设置头像.为了兼容前台增加的POST方法.
export async function personActionUploadPostOctetStream (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`, params.data)
    return data.data
}

   
// ins
// oldPassword: String: 原密码
// newPassword: String: 新密码
// confirmPassword: String: 确认新密码
// isEncrypted: String: 是否启用加密,默认不加密,启用(y)。注意:使用加密先要在服务器运行 create encrypt key
// POST : application/json
// 更新指定个人的密码 MockPutToPost.
export async function personActionSetPasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/password/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取个人可以自己的内容
export async function personActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person`, params.data)
    return data.data
}


// pathParameters
// width: Integer: 图像宽度
// height: Integer: 图像高度   
// GET : application/json
// 生成一个captcha
export async function registActionCaptcha (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/captcha/width/${params.pathParameters.width}/height/${params.pathParameters.height}`, params.data)
    return data.data
}


// pathParameters
// mobile: String: 电话号码   
// GET : application/json
// 校验mobile是否已经存在
export async function registActionCheckMobile (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/mobile/${params.pathParameters.mobile}`, params.data)
    return data.data
}


// pathParameters
// password: String: 密码   
// GET : application/json
// 校验password密码等级.
export async function registActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/password/${params.pathParameters.password}`, params.data)
    return data.data
}


// pathParameters
// name: String: 用户名   
// GET : application/json
// 校验name是否已经存在
export async function registActionCheckName (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/name/${params.pathParameters.name}`, params.data)
    return data.data
}

   
// GET : application/json
// 当前允许的注册模式,disable,captcha,code
export async function registActionMode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/mode`, params.data)
    return data.data
}

   
// ins
// name: String: 用户名称.
// genderType: GenderType: 性别.男:m,女:f,未知:d
// password: String: 密码.
// mobile: String: 必填,手机号.
// codeAnswer: String: 手机认证码
// captchaAnswer: String: 图片认证码
// captcha: String: 图片认证编号
// mail: String: 邮件地址(非必填).
// unit: String: 归属组织(非必填).
// POST : application/json
// 注册人员
export async function registActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// mobile: String: 电话号码   
// GET : application/json
// 生成一个code
export async function registActionCode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/code/mobile/${params.pathParameters.mobile}`, params.data)
    return data.data
}


// pathParameters
// credential: String: 用户标识   
// GET : application/json
// 验证人员是否存在.
export async function resetActionCheckCredential (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/check/credential/${params.pathParameters.credential}`, params.data)
    return data.data
}

   
// ins
// credential: String: 用户标识
// password: String: 密码
// codeAnswer: String: 认证码
// POST : application/json
// 重置密码MockPutToPost.
export async function resetActionResetMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// password: String: 密码   
// GET : application/json
// 验证密码强度等级.
export async function resetActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/check/password/${params.pathParameters.password}`, params.data)
    return data.data
}

   
// ins
// userName: String: 用户名
// oldPassword: String: 原密码
// newPassword: String: 新密码
// confirmPassword: String: 确认新密码
// isEncrypted: String: 是否启用加密,默认不加密,启用(y)。注意:使用加密先要在服务器运行 create encrypt key
// POST : application/json
// 匿名更新个人的密码.
export async function resetActionSetPasswordAnonymous (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/password/anonymous`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// credential: String: 用户标识
// password: String: 密码
// codeAnswer: String: 认证码
// PUT : application/json
// 重置密码.
export async function resetActionReset (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// credential: String: 用户标识   
// GET : application/json
// 获取短信验证码
export async function resetActionCode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/code/credential/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
