
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// POST : application/json
// 指定应用根据路径更新数据字典数据(mock put to post).
export async function dictActionUpdateDataPathMockPutToPost (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// GET : application/json
// 指定应用根据路径删除数据字典数据(mock delete to get).
export async function dictActionDeleteDataPathMockDeleteToGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// portalFlag: String: 门户应用标识   
// GET : application/json
// 获取指定应用的数据字典列表.
export async function dictActionListWithApplication (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/list/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// POST : application/json
// 指定应用根据路径添加数据字典数据.
export async function dictActionCreateDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// PUT : application/json
// 指定应用根据路径更新数据字典数据.
export async function dictActionUpdateDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// GET : application/json
// 指定应用根据路径获取数据字典数据.
export async function dictActionGetDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)   
// DELETE : application/json
// 指定应用根据路径删除数据字典数据.
export async function dictActionDeleteDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/${params.pathParameters.path}/data`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识   
// GET : application/json
// 获取单个数据字典以及数据字典数据.
export async function dictActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识   
// GET : application/json
// 指定应用获取数据字典数据.
export async function dictActionGetData (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.pathParameters.dictFlag}/portal/${params.pathParameters.portalFlag}/data`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 应用标识   
// GET : application/json
// 访问文件内容.义stream格式下载
export async function fileActionDownload (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}/download`, params.data)
    return data.data
}


// pathParameters
// portalFlag: String: 标识   
// GET : application/json
// 列示指定站点的下所有可见的文件.
export async function fileActionListWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/list/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文件标识(文件id、文件别名或者文件短url编码)   
// GET : application/json
// 访问文件内容.
export async function fileActionContentV2 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文件标识(文件id、文件别名或者文件短url编码)   
// GET : application/json
// 访问文件内容.义stream格式下载
export async function fileActionDownloadV2 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.pathParameters.flag}/download`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 应用标识   
// GET : application/json
// 访问文件内容.
export async function fileActionContent (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}/content`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面Mobile.
export async function pageActionV2GetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}/mobile`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面Mobile.
export async function pageActionGetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}/mobile`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Page内容Mobile.
export async function pageActionGetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.pathParameters.id}/mobile`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取PageMobile.
export async function pageActionV2GetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.pathParameters.id}/mobile`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面.
export async function pageActionV2GetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Page.
export async function pageActionV2Get (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面.
export async function pageActionGetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Page内容.
export async function pageActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// portal: String: 门户   
// GET : application/json
// 列示属于指定Portal的Page.
export async function pageActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/list/portal/${params.pathParameters.portal}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Portal的图标.
export async function portalActionIcon (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.pathParameters.id}/icon`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Portal的图标Base64编码.
export async function portalActionIconBase64 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.pathParameters.id}/icon/base64`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取Portal的角标数量(根据Portal的角标脚本计算得出).
export async function portalActionGetCornerMark (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.pathParameters.flag}/corner/mark`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前用户mobile端所有可见的Portal.
export async function portalActionListMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/list/mobile`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取单个的Portal.
export async function portalActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前用户PC端所有可见的Portal.
export async function portalActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/list`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称
// portal: String: 门户标识   
// GET : application/json
// 获取Script内容,并递归附带应用脚本.
export async function scriptActionGetImported (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/portal/${params.pathParameters.portal}/name/${params.pathParameters.name}/imported`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Script内容.
export async function scriptActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// portal: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的Script.
export async function scriptActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/list/portal/${params.pathParameters.portal}`, params.data)
    return data.data
}


// pathParameters
// name: String: 名称
// portal: String: 门户标识   
// ins
// importedList: List<String>: 已经导入的脚本
// POST : application/json
// 在指定的Portal下根据flag获取Script.
export async function scriptActionFlag (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/portal/${params.pathParameters.portal}/name/${params.pathParameters.name}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的部件,其中Portal可以用name,alias和id标识,部件为在此Portal下的页面Mobile.
export async function widgetActionGetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}/mobile`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取部件内容Mobile.
export async function widgetActionGetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.pathParameters.id}/mobile`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// portalFlag: String: 门户标识   
// GET : application/json
// 列示属于指定Portal的部件,其中Portal可以用name,alias和id标识,部件为在此Portal下的页面.
export async function widgetActionGetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.pathParameters.flag}/portal/${params.pathParameters.portalFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取部件内容.
export async function widgetActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// portal: String: 门户   
// GET : application/json
// 列示属于指定Portal的部件.
export async function widgetActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/list/portal/${params.pathParameters.portal}`, params.data)
    return data.data
}
