
   
// ins
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// POST : application/json
// 创建应用.
export async function applicationActionPost (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationCategory: String: 应用分类   
// GET : application/json
// 根据应用分类获取应用,应用分类不为null.
export async function applicationActionListWithApplicationCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/list/applicationcategory/${params.pathParameters.applicationCategory}`, params.data)
    return data.data
}


// pathParameters
// applicationCategory: String: 应用分类   
// GET : application/json
// 根据应用分类获取应用的简要信息,不包含流程表单,应用分类不为null.
export async function applicationActionListSummaryWithApplicationCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/list/summary/applicationcategory/${params.pathParameters.applicationCategory}`, params.data)
    return data.data
}


// pathParameters
// id: String: 应用标识 
// formParameters
// file: File: 头像文件  
// PUT : multipart/form-data
// 更新应用图标.
export async function applicationActionSetIcon (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/${params.pathParameters.id}/icon`, params.data)
    return data.data
}


// pathParameters
// id: String: 应用标识   
// ins
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// PUT : application/json
// 更新应用.
export async function applicationActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// controllerList: List<String>: 应用管理者.
// POST : application/json
// 设置应用权限.
export async function applicationActionUpdatePermission (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 列示所有应用，同时附带流程简要信息和表单简要信息.返回值按名称进行排序
export async function applicationActionListSummary (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/list/summary`, params.data)
    return data.data
}


// pathParameters
// id: String: 应用标识   
// GET : application/json
// 获取单个应用信息.
export async function applicationActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有应用
export async function applicationActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 应用标识
// onlyRemoveNotCompleted: boolean: 是否仅删除在流转中的Work   
// DELETE : application/json
// 删除应用,将同时删除所有相关内容.
export async function applicationActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/application/${params.pathParameters.id}/${params.pathParameters.onlyRemoveNotCompleted}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应用分类信息并统计同一分类的数量.
export async function applicationCategoryActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationcategory/list`, params.data)
    return data.data
}

   
// ins
// data: JsonElement: 字典数据(json格式).
// id: String: 数据库主键,自动生成.
// application: String: 应用.
// name: String: 字典名称.
// alias: String: 别名.
// description: String: 说明.
// POST : application/json
// 创建数据字典以及数据.
export async function applicationDictActionPost (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 获取Application的数据字典列表.
export async function applicationDictActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict/list/application/${params.pathParameters.applicationId}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示数据字典对象.
export async function applicationDictActionListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取单个数据字典以及数据字典数据.
export async function applicationDictActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// data: JsonElement: 字典数据(json格式).
// id: String: 数据库主键,自动生成.
// application: String: 应用.
// name: String: 字典名称.
// alias: String: 别名.
// description: String: 说明.
// PUT : application/json
// 更新数据字典以及数据.
export async function applicationDictActionPut (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的数据字典以及数据字典数据.
export async function applicationDictActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/applicationdict/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 根据关键字搜索设计对象.
export async function designerActionGetRoute (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/designer/route/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// designerTypes: List<String>: 设计类型：script|form|page|widget|process
// moduleAppList: List<ModuleApp>: 模块的应用列表.
// POST : application/json
// 根据关键字搜索设计对象.
export async function designerActionSearch (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/designer/search`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/echo`, params.data)
    return data.data
}

   
// GET : application/json
// ApplicationDict对象中的孤立对象,包括item对象
export async function elementToolActionApplicationDictOrphan (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/elementtool/applicationdict/orphan`, params.data)
    return data.data
}

   
// GET : application/json
// Form对象中的孤立对象,包括Form和FormField
export async function elementToolActionFormOrphan (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/elementtool/form/orphan`, params.data)
    return data.data
}

   
// GET : application/json
// Process对象中的孤立对象,包括Process的子元素
export async function elementToolActionProcessOrphan (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/elementtool/process/orphan`, params.data)
    return data.data
}

   
// GET : application/json
// Script对象中的孤立对象.
export async function elementToolActionScriptOrphan (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/elementtool/script/orphan`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识 
// formParameters
// file: File: 文件内容
// fileName: String: 附件名称  
// POST : multipart/form-data
// 上传文件内容.
export async function fileActionUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.id}/upload`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取文件内容.以stream方式下载.
export async function fileActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用列示文件.
export async function fileActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示文件对象,下一页.
export async function fileActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示文件对象,上一页.
export async function fileActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取文件内容.
export async function fileActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 文件名称.
// alias: String: 文件别名.
// description: String: 描述.
// application: String: 文件所属应用.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// data: String: 编码后文本内容.
// fileName: String: 文件名称.
// length: Long: 文件大小.
// PUT : application/json
// 更新文件.
export async function fileActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除文件.
export async function fileActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 复制资源文件到新的应用.
export async function fileActionCopy (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 文件名称.
// alias: String: 文件别名.
// description: String: 描述.
// application: String: 文件所属应用.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// data: String: 编码后文本内容.
// fileName: String: 文件名称.
// length: Long: 文件大小.
// POST : application/json
// 创建文件.
export async function fileActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取文件内容.
export async function fileActionContent (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/file/${params.pathParameters.id}/content`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 根据指定的应用获取应用下所有表单包含的字段字段信息.
export async function formActionListFornFiledWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/list/formfield/application/${params.pathParameters.applicationId}`, params.data)
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 根据应用列示Form.
export async function formActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/list/application/${params.pathParameters.applicationId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 根据指定的Form获取所有包含的字段信息.
export async function formActionListFornFiledWithForm (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/list/${params.pathParameters.id}/formfield`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Form对象,下一页.
export async function formActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Form对象,上一页.
export async function formActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取表单内容.
export async function formActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// formFieldList: List<WiFormField>: 字段
// relatedFormList: List<String>: 关联表单
// mobileRelatedFormList: List<String>: 移动端关联表单
// relatedScriptMap: Map<String,String>: 关联脚本.
// mobileRelatedScriptMap: Map<String,String>: 移动端关联脚本.
// name: String: 名称.
// category: String: 分类
// alias: String: 表单别名.
// description: String: 描述.
// application: String: 表单所属应用.
// icon: String: icon Base64编码后的文本.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// properties: FormProperties: 属性对象存储字段.
// PUT : application/json
// 更新表单.
export async function formActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除表单.
export async function formActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// formFieldList: List<WiFormField>: 字段
// relatedFormList: List<String>: 关联表单
// mobileRelatedFormList: List<String>: 移动端关联表单
// relatedScriptMap: Map<String,String>: 关联脚本.
// mobileRelatedScriptMap: Map<String,String>: 移动端关联脚本.
// name: String: 名称.
// category: String: 分类
// alias: String: 表单别名.
// description: String: 描述.
// application: String: 表单所属应用.
// icon: String: icon Base64编码后的文本.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// properties: FormProperties: 属性对象存储字段.
// POST : application/json
// 创建表单.
export async function formActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/form`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// formId: String: form标识   
// GET : application/json
// 根据脚本id获取历史版本列表.
export async function formVersionActionListWithForm (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/formversion/list/form/${params.pathParameters.formId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取表单历史版本内容.
export async function formVersionActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/formversion/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 创建用于ID值的UUID
export async function idActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/id/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 覆盖应用.
export async function inputActionCover (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/input/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备创建应用.
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/input/prepare/create`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备覆盖应用.
export async function inputActionPrepareCover (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/input/prepare/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 上传对比数据内容.
export async function inputActionCompare (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/input/compare`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 创建应用.
export async function inputActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/input/create`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用获取表映射.
export async function mappingActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// enable: Boolean: 是否启用.
// name: String: 名称.
// description: String: 描述.
// application: String: 所属应用.
// process: String: 所属流程.
// data: String: 映射方案.
// tableName: String: 映射表名称
// PUT : application/json
// 更新表映射.
export async function mappingActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表映射对象,下一页.
export async function mappingActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表映射对象,上一页.
export async function mappingActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取单个表映射对象.
export async function mappingActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 执行表映射.
export async function mappingActionExecute (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/${params.pathParameters.flag}/execute`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除表映射对象.
export async function mappingActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// enable: Boolean: 是否启用.
// name: String: 名称.
// description: String: 描述.
// application: String: 所属应用.
// process: String: 所属流程.
// data: String: 映射方案.
// tableName: String: 映射表名称
// POST : application/json
// 创建表映射.
export async function mappingActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/mapping`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// ins
// processList: List<WrapProcess>: 导出的流程
// formList: List<WrapForm>: 导出的表单
// applicationDictList: List<WrapApplicationDict>: 导出的数据字典
// scriptList: List<WrapScript>: 导出的脚本
// fileList: List<WrapFile>: 导出的文件
// id: String: 数据库主键,自动生成.
// defaultForm: String: 应用默认表单.
// maintenanceIdentity: String: 流程维护身份,如果无法找到处理身份默认的流程处理身份.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 可见应用的身份.
// availableUnitList: List<String>: 可见应用的组织.
// availableGroupList: List<String>: 可见应用的群组,目前无效,没有对组织的设置接口.
// applicationCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 应用管理者.
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// properties: ApplicationProperties: 属性对象存储字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 选择应用结构.
export async function outputActionSelect (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/output/${params.pathParameters.applicationFlag}/select`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查看所有应用.
export async function outputActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/output/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取启用版本流程内容.含所有节点和路由信息
export async function processActionGetEnabled (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/enabled`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// POST : application/json
// 升级流程.
export async function processActionUpgrade (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/upgrade`, params.data)
    return data.data
}

   
// POST : application/json
// 创建流程.
export async function processActionPost (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 仅获取流程内容，不包含节点和路由信息
export async function processActionGetProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/process`, params.data)
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 列示某个应用的所有流程.
export async function processActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/application/${params.pathParameters.applicationId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// elementWiList: List<ElementWi>: 查询元素列表(元素类型:route|begin|agent|...)
// POST : application/json
// 查询流程的指定节点或路由信息.
export async function processActionGetProcessElementList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/list/element`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// controllerList: List<String>: 流程管理者.
// startableIdentityList: List<String>: 在指定启动时候,允许新建Work的用户.
// startableUnitList: List<String>: 在指定启动时候,允许新建Work的组织.
// startableGroupList: List<String>: 在指定启动时候,允许新建Work的群组.
// POST : application/json
// 设置流程权限.
export async function processActionUpdatePermission (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// onlyRemoveNotCompleted: boolean: 仅删除流转中Work   
// DELETE : application/json
// 删除流程所有版本.
export async function processActionDeleteEdition (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/${params.pathParameters.onlyRemoveNotCompleted}/edition`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 导出流程.
export async function processActionLeadOut (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/lead/out`, params.data)
    return data.data
}


// pathParameters
// applicationId: String: 应用标识
// edition: String: 流程版本标志   
// GET : application/json
// 列示流程的所有版本.
export async function processActionListEdition (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/application/${params.pathParameters.applicationId}/edition/${params.pathParameters.edition}`, params.data)
    return data.data
}

   
// GET : application/json
// 给所有流程打上版本信息.
export async function processActionUpgradeAll (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/upgrade/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 启用当前版本流程.
export async function processActionEnableProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/enable`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// dummy: String: 无效字段
// POST : application/json
// 执行流程数据映射.
export async function processActionExecuteProjection (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/execute/projection`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 列示未启用的流程版本.
export async function processActionListDisableEdition (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/application/${params.pathParameters.applicationId}/disable/edition`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 停用当前版本流程.
export async function processActionDisableProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/disable`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取流程内容.含所有节点和路由信息
export async function processActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// PUT : application/json
// 更新流程.
export async function processActionPut (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// onlyRemoveNotCompleted: boolean: 仅删除流转中Work   
// DELETE : application/json
// 删除流程.
export async function processActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/process/${params.pathParameters.id}/${params.pathParameters.onlyRemoveNotCompleted}`, params.data)
    return data.data
}


// pathParameters
// processId: String: process标识   
// GET : application/json
// 根据脚本id获取历史版本列表.
export async function processVersionActionListWithForm (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/processversion/list/process/${params.pathParameters.processId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取流程历史版本内容.
export async function processVersionActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/processversion/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// validated: Boolean: 代码格式是否正确.
// application: String: 脚本所属应用.
// text: String: 脚本内容.
// dependScriptList: List<String>: 依赖的函数列表.
// creatorPerson: String: 流程创建者.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// POST : application/json
// 创建脚本.
export async function scriptActionPost (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationId: String: 应用标识   
// GET : application/json
// 列示应用所有脚本.
export async function scriptActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/application/${params.pathParameters.applicationId}`, params.data)
    return data.data
}


// pathParameters
// applicationId: String: 应用标识
// name: String: 名称   
// GET : application/json
// 根据应用ID和脚本名称获取脚本.
export async function scriptActionGetWithApplicationWithName (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/application/${params.pathParameters.applicationId}/name/${params.pathParameters.name}`, params.data)
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// appIdList: List<String>: 应用ID列表.
// POST : application/json
// 列示Script对象（管理员权限）.
export async function scriptActionManagerList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/list/manager`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示Script对象.
export async function scriptActionListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Script对象,下一页.
export async function scriptActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Script对象,上一页.
export async function scriptActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取指定的脚本信息.
export async function scriptActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// validated: Boolean: 代码格式是否正确.
// application: String: 脚本所属应用.
// text: String: 脚本内容.
// dependScriptList: List<String>: 依赖的函数列表.
// creatorPerson: String: 流程创建者.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// PUT : application/json
// 更新脚本.
export async function scriptActionPut (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除脚本.
export async function scriptActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/script/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// scriptId: String: process标识   
// GET : application/json
// 根据脚本id获取历史版本列表.
export async function scriptVersionActionListWithForm (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/scriptversion/list/script/${params.pathParameters.scriptId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取脚本历史版本内容.
export async function scriptVersionActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/scriptversion/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 表单别名.
// category: String: 模版分类.
// description: String: 描述.
// icon: String: icon Base64编码后的文本.
// outline: String: 缩略图.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 按分类名称列示模版表单.
export async function templateFormActionListWithCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform/list/category`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 列示所有分类名称以及分类数量.
export async function templateFormActionListCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform/list/category`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取模版表单内容.
export async function templateFormActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有模版表单.
export async function templateFormActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除模版表单.
export async function templateFormActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 表单别名.
// category: String: 模版分类.
// description: String: 描述.
// icon: String: icon Base64编码后的文本.
// outline: String: 缩略图.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// POST : application/json
// 创建模版表单或者更新模版表单.
export async function templateFormActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/templateform`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// processFlag: String: 流程标识   
// GET : application/json
// 指定process合并DataItem数据到WorkCompleted,并删除Item表中的数据.
export async function workCompletedActionMergeDataWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/workcompleted/process/${params.pathParameters.processFlag}/merge/data`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 指定application合并DataItem数据到WorkCompleted,并删除Item表中的数据.
export async function workCompletedActionMergeDataWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_designer/jaxrs/workcompleted/application/${params.pathParameters.applicationFlag}/merge/data`, params.data)
    return data.data
}
