

// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的待办数量,没有权限限制.
export async function anonymousActionTaskCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/anonymous/task/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的待阅数量,没有权限限制.
export async function anonymousActionReadCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/anonymous/read/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 应用标识   
// GET : application/json
// 获取指定的应用信息,并附带其操作权限.
export async function applicationActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 应用标识   
// GET : application/json
// 仅获取指定Application的Icon,没有权限限制.
export async function applicationActionGetIcon (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.pathParameters.flag}/icon`, params.data)
    return data.data
}


// pathParameters
// key: String: 关键字   
// GET : application/json
// 获取可见的应用,同时判断应用下有启动的流程,并进行流程的名称匹配.
export async function applicationActionListWithPersonLike (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/key/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 应用标识   
// GET : application/json
// 校验当前用户是否是指定应用的管理员.
export async function applicationActionIsManager (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.pathParameters.flag}/is/manager`, params.data)
    return data.data
}

   
// GET : application/json
// 获取可见的应用,同时判断应用下有启动的流程.
export async function applicationActionListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户   
// GET : application/json
// 根据传入用户，获取可见的Application,并绑定其启动的Process.
export async function applicationActionManageListWithPersonComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/complex/manage/${params.pathParameters.person}`, params.data)
    return data.data
}

   
// GET : application/json
// 根据当前用户所有可见的Application,并绑定其启动的Process.
export async function applicationActionListWithPersonComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/complex`, params.data)
    return data.data
}


// pathParameters
// terminal: String: 流程启动终端：client(pc端可启动)、mobile(手机端可启动)   
// GET : application/json
// 根据当前用户所有可见的Application,并绑定其可启动终端的Process.
export async function applicationActionListWithPersonAndTerminal (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/terminal/${params.pathParameters.terminal}`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取单个数据字典以及数据字典数据.
export async function applicationDictActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 指定应用获取数据字典数据.
export async function applicationDictActionGetData (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 指定应用根据七级路径获取数据字典数据.
export async function applicationDictActionGetDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// PUT : application/json
// 指定应用根据一级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径   
// PUT : application/json
// 指定应用根据二级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// PUT : application/json
// 指定应用根据四级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// PUT : application/json
// 指定应用根据五级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// PUT : application/json
// 指定应用根据六级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 指定应用根据三级路径获取数据字典数据.
export async function applicationDictActionGetDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// PUT : application/json
// 指定应用根据八级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// POST : application/json
// 指定应用根据一级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 指定应用根据六级路径获取数据字典数据.
export async function applicationDictActionGetDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 0级路径   
// POST : application/json
// 指定应用根据二级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 指定应用根据三级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// PUT : application/json
// 指定应用根据三级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 指定应用根据五级路径获取数据字典数据.
export async function applicationDictActionGetDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 指定应用根据八级路径获取数据字典数据.
export async function applicationDictActionGetDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// GET : application/json
// 指定应用根据四级路径获取数据字典数据.
export async function applicationDictActionGetDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// PUT : application/json
// 指定应用根据七级路径更新数据字典数据.
export async function applicationDictActionUpdateDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// GET : application/json
// 指定应用根据一级路径获取数据字典数据.
export async function applicationDictActionGetDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 指定应用根据二级路径获取数据字典数据.
export async function applicationDictActionGetDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 指定应用根据七级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// DELETE : application/json
// 指定应用根据六级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径   
// DELETE : application/json
// 指定应用根据一级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// DELETE : application/json
// 指定应用根据四级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// DELETE : application/json
// 指定应用根据三级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// DELETE : application/json
// 指定应用根据五级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// DELETE : application/json
// 指定应用根据八级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// DELETE : application/json
// 指定应用根据七级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 指定应用根据四级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// DELETE : application/json
// 指定应用根据一级路径删除数据字典数据.
export async function applicationDictActionDeleteDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 根据字典ID和路径添加Application下的新的局部数据.
export async function applicationDictActionCreateDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 指定应用根据六级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 指定应用根据八级路径添加数据字典数据.
export async function applicationDictActionCreateDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 指定应用根据六级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath5MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 指定应用根据三级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath2MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// POST : application/json
// 指定应用根据一级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径   
// GET : application/json
// 指定应用根据一级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath0MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 指定应用根据七级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath6MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径   
// POST : application/json
// 指定应用根据二级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// DELETE : application/json
// 指定应用根据四级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath3MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 指定应用根据三级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取指定应用的数据字典列表.
export async function applicationDictActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 指定应用根据五级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 指定应用根据五级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath4MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 指定应用根据四级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 指定应用根据六级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 指定应用根据八级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 指定应用根据八级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath7MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 指定应用根据七级路径更新数据字典数据(mock put to post).
export async function applicationDictActionUpdateDataPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/data/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 指定应用根据二级路径删除数据字典数据(mock delete to get).
export async function applicationDictActionDeleteDataPath1MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.pathParameters.applicationDictFlag}/application/${params.pathParameters.applicationFlag}/${params.pathParameters.path0}/${params.pathParameters.path1}/data/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 附件
// fileName: String: 附件名称  
// PUT : multipart/form-data
// 根据工作标识更新附件内容.
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.pathParameters.id}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// DELETE : application/json
// 删除指定标识的附件.
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 判断文件是否存在.
export async function attachmentActionAvailable (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/available`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// GET : application/json
// 获取指定附件标识的附件的文本识别内容.
export async function attachmentActionGetText (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}/text`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 
// fileName: String: 附件名称
// site: String: 位置  
// POST : multipart/form-data
// 上传附件.
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 下载指定标识的附件.
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// GET : application/json
// 根据工作标识列示附件.
export async function attachmentActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// readIdentityList: List<String>: 可以访问的身份.
// readUnitList: List<String>: 可以访问的组织.
// editIdentityList: List<String>: 可以修改的用户.
// editUnitList: List<String>: 可以修改的组织.
// controllerIdentityList: List<String>: 可以管理的用户.
// controllerUnitList: List<String>: 可以管理的组织.
// divisionList: List<String>: 分组.
// stringValue01: String: 预留数据String值01.
// stringValue02: String: 预留数据String值02.
// stringValue03: String: 预留数据String值03.
// POST : application/json
// M更新指定附件标识的附件信息(mock put to post).
export async function attachmentActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.pathParameters.id}/work/${params.pathParameters.workId}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// readIdentityList: List<String>: 可以访问的身份.
// readUnitList: List<String>: 可以访问的组织.
// editIdentityList: List<String>: 可以修改的用户.
// editUnitList: List<String>: 可以修改的组织.
// controllerIdentityList: List<String>: 可以管理的用户.
// controllerUnitList: List<String>: 可以管理的组织.
// divisionList: List<String>: 分组.
// stringValue01: String: 预留数据String值01.
// stringValue02: String: 预留数据String值02.
// stringValue03: String: 预留数据String值03.
// PUT : application/json
// 更新指定附件标识的附件信息.
export async function attachmentActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.pathParameters.id}/work/${params.pathParameters.workId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识
// site: String: 位置   
// GET : application/json
// 更新指定附件标识的附件位置信息.
export async function attachmentActionChangeSite (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}/change/site/${params.pathParameters.site}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取指定附件标识返回图片格式预览文件,支持doc,docx.
export async function attachmentActionPreviewImageResult (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/preview/image/${params.pathParameters.flag}/result`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// ins
// attachmentList: List<WiAttachment>: 附件对象.
// POST : application/json
// 由工作标识指定的工作拷贝附件.
export async function attachmentActionCopyToWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/work/${params.pathParameters.workId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workId: String: Work或WorkCompleted的工作标识
// flag: String: 另存为格式：(0)表示不转换|pdf表示转为pdf|word表示转为word   
// ins
// workHtml: String: 待转换html.
// pageWidth: Float: 转pdf页面宽度，默认A4.
// PUT : application/json
// 上传工单的表单、审批记录等html信息到缓存.
export async function attachmentActionUploadWorkInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.pathParameters.workId}/save/as/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workId: String: *Work或WorkCompleted的工作标识
// flag: String: *通过uploadWorkInfo上传返回的附件id  
// queryParameters
// stream: Boolean: 是否直接下载(true|false) 
// GET : application/json
// 下载工单的表单,审批记录等html信息.
export async function attachmentActionDownloadWorkInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/work/${params.pathParameters.workId}/att/${params.pathParameters.flag}?stream=${params.queryParameters.stream }`, params.data)
    return data.data
}

 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 
// fileName: String: 附件名称
// isSoftUpload: Boolean: 是否根据主工作软拷贝附件到其他工作，所有文档共享主文档的存储附件
// mainWork: String: 主工作标志(isSoftUpload为true时必填)
// orderNumber: Integer: 附件排序号
// person: String: 上传到指定用户
// site: String: 位置
// workIds: String: 工作标识列表，多值逗号隔开  
// POST : multipart/form-data
// 管理员批量上传附件.
export async function attachmentActionManageBatchUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/upload/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// DELETE : application/json
// 根据工作标识和附件标识删除附件.
export async function attachmentActionDeleteWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据工作标识和附件标识下载附件.
export async function attachmentActionDownloadWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/work/${params.pathParameters.workId}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}

   
// ins
// valueList: List<String>: 字符串多值.
// POST : application/json
// 下载指定标识的图片，以 base64 编码输出.
export async function attachmentActionDownloadBaseList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/downloadBaseList`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 下载指定标识的图片，以 base64 编码输出.
export async function attachmentActionDownloadBase (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/downloadBase/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// fileName: String: 文件名称,不带扩展名的文件名.
// PUT : application/json
// 根据附件标识和工作标识更新附件信息.
export async function attachmentActionUpdateContent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/content/${params.pathParameters.id}/work/${params.pathParameters.workId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// ins
// attachmentList: List<WiAttachment>: 附件对象
// POST : application/json
// 由工作标识指定的工作软拷贝附件(不拷贝真实存储附件，共用附件，此接口拷贝的附件删除时只删除记录不删附件).
export async function attachmentActionCopyToWorkSoft (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/work/${params.pathParameters.workId}/soft`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识
// orderNumber: Integer: 排序号   
// GET : application/json
// 更新指定附件标识的附件排序号.
export async function attachmentActionChangeOrderNumber (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}/change/ordernumber/${params.pathParameters.orderNumber}`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// ins
// fileName: String: 转换文件名.
// site: String: 附件site.
// content: String: 内容.
// POST : application/json
// 获取指定工作标识的工作,将html版式公文转换成成Word文件并添加在附件中.
export async function attachmentActionDocToWord (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/doc/to/word/work/${params.pathParameters.workId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// text: String: 文本.
// PUT : application/json
// 更新指定附件标识的附件的文本识别内容.
export async function attachmentActionExitText (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.pathParameters.id}/work/${params.pathParameters.workId}/text`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取指定附件标识返回pdf格式预览文件信息,支持doc,docx.
export async function attachmentActionPreviewPdf (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/preview/pdf`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取指定附件标识返回pdf格式预览文件,支持doc,docx.
export async function attachmentActionPreviewPdfResult (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/preview/pdf/${params.pathParameters.flag}/result`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// page: Integer: 页数   
// GET : application/json
// 获取指定附件标识返回图片格式预览文件信息,支持doc,docx.
export async function attachmentActionPreviewImage (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/preview/image/page/${params.pathParameters.page}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 附件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 根据附件标识和工作标识更新附件,与update方法同,为了兼容ntko对于附件上传只能设置post方法.
export async function attachmentActionUpdatePost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.pathParameters.id}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 下载指定标识的附件,设定使用流输出.
export async function attachmentActionDownloadStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/stream?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识
// callback: String: 回调函数名 
// formParameters
// file: File: 
// fileName: String: 附件名称
// site: String: 位置  
// POST : multipart/form-data
// 根据工作标识上传附件,回调jsonp.
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.pathParameters.workId}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识
// callback: String: 回调函数名 
// formParameters
// file: File: 附件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 根据附件标识和工作标识更新附件,回调jsonp.
export async function attachmentActionUpdateCallback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.pathParameters.id}/work/${params.pathParameters.workId}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识
// id: String: 附件标识   
// GET : application/json
// 根据工作标识和附件标识获取附件信息.
export async function attachmentActionGetWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}

   
// ins
// idList: List<String>: 待删除附件列表.
// POST : application/json
// 管理员批量删除附件.
export async function attachmentActionManageBatchDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/delete/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 指定附件标识,管理员下载附件.
export async function attachmentActionManageDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/manage`, params.data)
    return data.data
}

   
// ins
// workHtml: String: 待转换html.
// pageWidth: Float: 转pdf页面宽度，默认A4.
// title: String: pdf标题.
// POST : application/json
// html转pdf工具类,转换后通过downloadTransfer接口下载.
export async function attachmentActionHtmlToPdf (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/html/to/pdf`, JSON.stringify(params.data))
    return data.data
}

 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 
// fileName: String: 附件名称
// ids: String: 附件Id列表，多值逗号隔开  
// POST : multipart/form-data
// 管理员批量替换附件.
export async function attachmentActionManageBatchUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/update/manage`, params.data)
    return data.data
}


// pathParameters
// flag: String: *转换后附件id  
// queryParameters
// stream: Boolean: 是否直接下载(true|false) 
// GET : application/json
// html转pdf工具类,下载转换后的附件.
export async function attachmentActionDownloadTransfer (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/transfer/flag/${params.pathParameters.flag}?stream=${params.queryParameters.stream }`, params.data)
    return data.data
}

   
// ins
// workId: String: *Work或WorkCompleted的id.
// fileName: String: *文件名称,带扩展名的文件名.
// fileUrl: String: *附件来源url地址.
// site: String: *附件分类.
// person: String: 上传人员（仅对管理员生效）.
// POST : application/json
// 上传附件
export async function attachmentActionUploadWithUrl (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/with/url`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// workHtml: String: *待转换html.
// title: String: 图片标题
// htmlWidth: Double: html正文宽度，允许为空.
// htmlHeight: Double: html正文高度，允许为空.
// startX: Double: html的X轴开始位置，允许为空.
// startY: Double: html的Y轴开始位置，允许为空.
// omitBackground: Boolean: 背景是否透明，默认为false.
// workId: String: 工作标识，把图片保存到工单的附件中，非必填
// site: String: 位置，工作标识不为空的时候必填
// POST : application/json
// html转图片工具类，通过微软playwright工具以截图方式生成图片，转换后如果工作不为空通过downloadWithWork接口下载，为空downloadTransfer接口下载.
export async function attachmentActionHtmlToImage (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/html/to/image`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取指定附件的在线编辑信息.
export async function attachmentActionGetOnlineInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/online/info`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job   
// GET : application/json
// 根据任务标识获取附件列表.
export async function attachmentActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据已完成工作标识和附件标识以指定的名称下载附件,设定使用流输出.
export async function attachmentActionDownloadWithWorkCompletedStreamWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}/stream/${params.pathParameters.fileName}.${params.pathParameters.extension}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据已完成工作标识和附件标识以指定的名称下载附件.
export async function attachmentActionDownloadWithWorkCompletedWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}/${params.pathParameters.fileName}.${params.pathParameters.extension}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据工作标识和附件标识以指定的名称下载附件,设定使用流输出.
export async function attachmentActionDownloadWithWorkStreamWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/work/${params.pathParameters.workId}/stream/${params.pathParameters.fileName}.${params.pathParameters.extension}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识   
// GET : application/json
// 根据已完成工作标识和附件标识删除附件(mock delete to get).
export async function attachmentActionDeleteWithWorkCompletedMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workId: String: *Work或WorkCompleted的工作标识
// site: String: *附件框分类,多值~隔开,(0)表示全部  
// queryParameters
// fileName: String: 下载附件名称
// flag: String: 通过uploadWorkInfo上传返回的工单信息存储id，多值逗号隔开 
// GET : application/json
// 根据工作标识或已完成工作标识批量下载附件并压缩.
export async function attachmentActionBatchDownloadWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/download/work/${params.pathParameters.workId}/site/${params.pathParameters.site}?fileName=${params.queryParameters.fileName }&flag=${params.queryParameters.flag }`, params.data)
    return data.data
}


// pathParameters
// workId: String: *Work或WorkCompleted的工作标识
// site: String: *附件框分类,多值~隔开,(0)表示全部  
// queryParameters
// fileName: String: 下载附件名称
// flag: String: 通过uploadWorkInfo上传返回的工单信息存储id，多值逗号隔开 
// GET : application/json
// 根据工作标识或已完成工作标识批量下载附件并压缩,设定使用stream输出.
export async function attachmentActionBatchDownloadWithWorkOrWorkCompletedStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/download/work/${params.pathParameters.workId}/site/${params.pathParameters.site}/stream?fileName=${params.queryParameters.fileName }&flag=${params.queryParameters.flag }`, params.data)
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识   
// GET : application/json
// 根据已完成工作标识列示附件.
export async function attachmentActionListWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/workcompleted/${params.pathParameters.workCompletedId}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 根据工作或已完成工作标识获取附件列表.
export async function attachmentActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 删除指定标识的附件(mock delete to get).
export async function attachmentActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识
// id: String: 附件标识   
// GET : application/json
// 根据WorkCompleted和附件Id获取单个附件信息
export async function attachmentActionGetWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识
// id: String: 附件标识   
// GET : application/json
// 根据工作标识或者已完成工作标识和附件标识获取附件信息.
export async function attachmentActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据工作标识和附件标识以指定的名称下载附件.
export async function attachmentActionDownloadWithWorkWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/work/${params.pathParameters.workId}/${params.pathParameters.fileName}.${params.pathParameters.extension}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据已完成工作标识和附件标识下载附件.
export async function attachmentActionDownloadWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据已完成工作标识和附件标识下载附件,设定使用流输出.
export async function attachmentActionDownloadWithWorkCompletedStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}/stream?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识  
// queryParameters
// fileName: String: 下载附件名称 
// GET : application/json
// 根据工作标识和附件标识以指定的名称下载附件,设定使用流输出.
export async function attachmentActionDownloadWithWorkStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/work/${params.pathParameters.workId}/stream?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// GET : application/json
// 根据工作标识和附件标识删除附件(mock delete to get).
export async function attachmentActionDeleteWithWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/work/${params.pathParameters.workId}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识   
// ins
// attachmentList: List<WiAttachment>: 附件对象
// POST : application/json
// 由已完成工作标识指定的工作拷贝附件.
export async function attachmentActionCopyToWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/workcompleted/${params.pathParameters.workCompletedId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识   
// ins
// attachmentList: List<WiAttachment>: 附件对象
// POST : application/json
// 由已完成工作标识指定的工作软拷贝附件(不拷贝真实存储附件，共用附件，此接口拷贝的附件删除时只删除记录不删附件).
export async function attachmentActionCopyToWorkCompletedSoft (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/workcompleted/${params.pathParameters.workCompletedId}/soft`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 
// fileName: String: 附件名称
// site: String: 位置  
// POST : multipart/form-data
// 上传附件.
export async function attachmentActionUploadWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/workcompleted/${params.pathParameters.workCompletedId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识   
// DELETE : application/json
// 根据已完成工作标识和附件标识删除附件. 
export async function attachmentActionDeleteWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.pathParameters.id}/workcompleted/${params.pathParameters.workCompletedId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// fileName: String: 文件名称,不带扩展名的文件名.
// POST : application/json
// 根据附件标识和工作标识更新附件信息(mock put to post).
export async function attachmentActionUpdateContentMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/content/${params.pathParameters.id}/work/${params.pathParameters.workId}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识 
// formParameters
// extraParam: String: 天印扩展字段
// file: File: 附件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 根据工作标识更新附件内容(mock put to post).
export async function attachmentActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.pathParameters.id}/work/${params.pathParameters.workId}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作已完成工作标识   
// ins
// fileName: String: 转换文件名.
// site: String: 附件site.
// content: String: 内容.
// POST : application/json
// 获取指定工作标识或已完成工作标识,将html版式公文转换成成Word文件并添加在附件中.
export async function attachmentActionDocToWordWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/doc/to/word/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 指定附件标识,管理员下载附件,设定使用stream输出.
export async function attachmentActionManageDownloadStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.pathParameters.id}/manage/stream`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// workId: String: 工作标识   
// ins
// text: String: 文本.
// POST : application/json
// 更新指定附件标识的附件的文本识别内容(mock put to post).
export async function attachmentActionExitTextMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.pathParameters.id}/work/${params.pathParameters.workId}/text/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workId: String: Work或WorkCompleted的工作标识
// flag: String: 另存为格式：(0)表示不转换|pdf表示转为pdf|word表示转为word   
// ins
// workHtml: String: 待转换html.
// pageWidth: Float: 转pdf页面宽度，默认A4.
// POST : application/json
// 上传工单的表单,审批记录等html信息到打包下载附件(mock put to post).
export async function attachmentActionUploadWorkInfoMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.pathParameters.workId}/save/as/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// ins
// site: String: 附件位置.
// content: String: 附件内容,base64编码文本.
// fileName: String: 文件名.
// POST : application/json
// V2根据工作标识或已完成工作标识上传附件,上传文件内容经过base64编码后的文本,如果同名附件存在则替换.
export async function attachmentActionV2UploadWorkOrWorkCompletedBase64 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/v2/upload/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}/base64`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识 
// formParameters
// file: File: 
// fileName: String: 附件名称
// site: String: 位置  
// POST : multipart/form-data
// V2根据工作标识或已完成工作标识上传附件,如果同名附件存在则替换.
export async function attachmentActionV2UploadWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/v2/upload/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 根据工作标识或完成工作标识获取权限.
export async function controlActionGetWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/control/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识   
// ins
// targetList: List<TargetWi>: 关联目标.
// POST : application/json
// 根据任务标识创建关联内容.
export async function correlationActionCreateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/job/${params.pathParameters.job}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// ins
// idList: List<String>: 取消关联目标.
// POST : application/json
// 删除关联内容.
export async function correlationActionDeleteWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/job/${params.pathParameters.job}/delete`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据任务标识列示关联内容.
export async function correlationActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识
// site: String: 关联内容框标识   
// GET : application/json
// 根据任务标识关联内容框标识列示关联内容.
export async function correlationActionListWithJobWithSite (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/list/job/${params.pathParameters.job}/site/${params.pathParameters.site}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// DELETE : application/json
// 根据工作标识删除业务数据.
export async function dataActionDeleteWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 根据工作标识获取业务数据.
export async function dataActionGetWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识   
// PUT : application/json
// 根据任务标识更新业务数据.
export async function dataActionUpdateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// GET : application/json
// 根据工作标识和一级路径获取业务数据.
export async function dataActionGetWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// GET : application/json
// 根据任务标识和四级路径获取业务数据.
export async function dataActionGetWithJobPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 根据任务标识和六级路径获取业务数据.
export async function dataActionGetWithJobPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 根据路径获取指定work的data数据.
export async function dataActionGetWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 根据工作标识和七级路径获取业务数据.
export async function dataActionGetWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识   
// GET : application/json
// 根据任务标识获取业务数据.
export async function dataActionGetWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 根据任务标识和五级路径获取业务数据.
export async function dataActionGetWithJobPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径   
// GET : application/json
// 根据任务标识和一级路径获取业务数据.
export async function dataActionGetWithJobPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 根据任务标识和二级路径获取业务数据.
export async function dataActionGetWithJobPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 根据工作标识和六级路径获取业务数据.
export async function dataActionGetWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 根据工作标识和八级路径获取业务数据.
export async function dataActionGetWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// PUT : application/json
// 根据任务标识和五级路径更新业务数据.
export async function dataActionUpdateWithJobPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识   
// ins
// pathList: List<String>: 查询路径.
// POST : application/json
// 根据任务标识获取指定路径的部分业务数据.
export async function dataActionFetchWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/fetch/job/${params.pathParameters.job}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// GET : application/json
// 根据工作标识和四级路径获取业务数据.
export async function dataActionGetWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// 根据工作标识更新业务数据.
export async function dataActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// PUT : application/json
// 根据任务标识和七级路径更新业务数据.
export async function dataActionUpdateWithJobPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// PUT : application/json
// 根据任务标识和四级路径更新业务数据.
export async function dataActionUpdateWithJobPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 根据任务标识和三级路径获取业务数据.
export async function dataActionGetWithJobPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 根据任务标识和七级路径获取业务数据.
export async function dataActionGetWithJobPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// PUT : application/json
// 根据任务标识和三级路径更新业务数据.
export async function dataActionUpdateWithJobPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 根据工作标识和五级路径获取业务数据.
export async function dataActionGetWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径   
// PUT : application/json
// 根据任务标识和一级路径更新业务数据.
export async function dataActionUpdateWithJobPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// PUT : application/json
// 根据任务标识和六级路径更新业务数据.
export async function dataActionUpdateWithJobPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// PUT : application/json
// 根据任务标识和八级路径更新业务数据.
export async function dataActionUpdateWithJobPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 根据工作标识和二级路径获取业务数据.
export async function dataActionGetWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 根据任务标识和八级路径获取业务数据.
export async function dataActionGetWithJobPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径   
// PUT : application/json
// 根据任务标识和二级路径更新业务数据.
export async function dataActionUpdateWithJobPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// PUT : application/json
// 根据工作标识更新业务数据.
export async function dataActionUpdateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 根据工作标识和六级路径删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkPath5MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// DELETE : application/json
// 根据工作标识和八级路径删除业务数据.
export async function dataActionDeleteWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 根据工作标识和七级路径删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkPath6MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// DELETE : application/json
// 根据工作标识和七级路径删除业务数据.
export async function dataActionDeleteWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 根据工作标识和八级路径删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkPath7MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识   
// GET : application/json
// 根据已完成工作标识获取业务数据.
export async function dataActionGetWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 根据工作标识删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 根据已完成工作标识和四级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 根据已完成工作标识和七级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径   
// POST : application/json
// 根据已完成工作标识和一级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识   
// POST : application/json
// 根据已完成工作标识更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 根据已完成工作标识和六级路径更新业务数据mock put to post).
export async function dataActionUpdateWithWorkCompletedPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 根据已完成工作标识和三级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// POST : application/json
// 根据已完成工作标识和二级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 根据已完成工作标识和八级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 根据已完成工作标识和五级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkCompletedPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// PUT : application/json
// 根据已完成工作标识和八级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// PUT : application/json
// 根据已完成工作标识和六级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 根据工作标识和三级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// PUT : application/json
// 根据工作标识和八级路径更新业务数据.
export async function dataActionUpdateWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// PUT : application/json
// 根据已完成工作标识和五级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// DELETE : application/json
// 根据工作标识和二级路径删除业务数据.
export async function dataActionDeleteWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 根据工作标识和七级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// GET : application/json
// 根据工作标识和四级路径删除业务数据(mock put to post).
export async function dataActionDeleteWithWorkPath3MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// DELETE : application/json
// 根据工作标识和一级路径删除业务数据.
export async function dataActionDeleteWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// DELETE : application/json
// 根据工作标识和五级路径删除业务数据.
export async function dataActionDeleteWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 根据工作标识和二级路径删除业务数据(mock put to post).
export async function dataActionDeleteWithWorkPath1MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// PUT : application/json
// 根据工作标识和五级路径更新业务数据.
export async function dataActionUpdateWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// PUT : application/json
// 根据工作标识和三级路径更新业务数据.
export async function dataActionUpdateWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// PUT : application/json
// 根据工作标识和四级路径更新业务数据.
export async function dataActionUpdateWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 根据工作标识和四级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 根据工作标识和八级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// PUT : application/json
// 根据已完成工作标识和四级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// PUT : application/json
// 根据工作标识和七级路径更新业务数据.
export async function dataActionUpdateWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 根据工作标识和五级路径删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkPath4MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// DELETE : application/json
// 根据工作标识和三级路径删除业务数据.
export async function dataActionDeleteWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// DELETE : application/json
// 根据工作标识和六级路径删除业务数据.
export async function dataActionDeleteWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径   
// PUT : application/json
// 根据已完成工作标识和一级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 根据工作标识和五级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// DELETE : application/json
// 根据工作标识和四级路径删除业务数据.
export async function dataActionDeleteWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 根据工作标识和六级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// PUT : application/json
// 根据已完成工作标识和三级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// PUT : application/json
// 根据已完成工作标识和七级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// PUT : application/json
// 根据工作标识和六级路径更新业务数据.
export async function dataActionUpdateWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// GET : application/json
// 根据工作标识和一级路径删除业务数据(mock delete to get).
export async function dataActionDeleteWithWorkPath0MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 根据工作标识和三级路径删除业务数据(mock put to post).
export async function dataActionDeleteWithWorkPath2MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// POST : application/json
// 对指定的work添加局部data数据.
export async function dataActionCreateWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识   
// PUT : application/json
// 根据已完成工作标识更新业务数据.
export async function dataActionUpdateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// PUT : application/json
// 根据已完成工作标识和二级路径更新业务数据.
export async function dataActionUpdateWithWorkCompletedPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识   
// GET : application/json
// 从data中获取workCompleted的data数据.
export async function dataActionGetWithWorkCompletedFromData (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/from/data`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识   
// GET : application/json
// 从item中获取已完成工作的业务数据.
export async function dataActionGetWithWorkCompletedFromItem (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/from/item`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// POST : application/json
// 根据任务标识和五级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// GET : application/json
// 根据路径获取指定workCompleted的data数据.
export async function dataActionGetWithWorkCompletedPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// PUT : application/json
// 根据工作标识和一级路径更新业务数据.
export async function dataActionUpdateWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径   
// POST : application/json
// 根据任务标识和一级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// GET : application/json
// 根据已完成工作标识和二级路径获取业务数据.
export async function dataActionGetWithWorkCompletedPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径   
// POST : application/json
// 根据任务标识和二级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// POST : application/json
// 根据任务标识和六级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径   
// GET : application/json
// 根据已完成工作标识和一级路径获取业务数据.
export async function dataActionGetWithWorkCompletedPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// GET : application/json
// 根据已完成工作标识和三级路径获取业务数据.
export async function dataActionGetWithWorkCompletedPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径   
// GET : application/json
// 根据路径获取指定workCompleted的data数据.
export async function dataActionGetWithWorkCompletedPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径   
// GET : application/json
// 根据已完成工作标识和五级路径获取业务数据.
export async function dataActionGetWithWorkCompletedPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// GET : application/json
// 根据路径获取指定workCompleted的data数据.
export async function dataActionGetWithWorkCompletedPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识   
// POST : application/json
// 根据任务标识更新业务数据(mock put to post).
export async function dataActionUpdateWithJobMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径   
// POST : application/json
// 根据任务标识和八级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/${params.pathParameters.path7}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径   
// POST : application/json
// 根据任务标识和七级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/${params.pathParameters.path4}/${params.pathParameters.path5}/${params.pathParameters.path6}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径   
// POST : application/json
// 根据任务标识和三级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// POST : application/json
// 根据任务标识和四级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithJobPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.pathParameters.job}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// 根据工作标识更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径   
// POST : application/json
// 根据工作标识和一级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径   
// GET : application/json
// 根据已完成工作标识和四级路径获取业务数据.
export async function dataActionGetWithWorkCompletedPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/${params.pathParameters.path2}/${params.pathParameters.path3}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// PUT : application/json
// 根据工作标识和二级路径更新业务数据.
export async function dataActionUpdateWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径   
// PUT : application/json
// 根据工作标识和二级路径更新业务数据(mock put to post).
export async function dataActionUpdateWithWorkPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.pathParameters.id}/${params.pathParameters.path0}/${params.pathParameters.path1}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job
// path: String: 字段path   
// GET : application/json
// 根据任务标识和业务字段获取数据变更记录.
export async function dataRecordActionGetWithJobPath (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/datarecord/get/job/${params.pathParameters.job}/path/${params.pathParameters.path}`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job   
// GET : application/json
// 根据任务标识获取业务数据变更记录.
export async function dataRecordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/datarecord/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 根据版式文件历史版本标识获取内容.
export async function documentVersionActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// work: String: 标识   
// ins
// category: String: 类别,一份work中允许有多个版式文件.
// data: String: 版式文件数据.
// POST : application/json
// 指定工作标识创建版式文件版本.
export async function documentVersionActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/work/${params.pathParameters.work}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 标识   
// GET : application/json
// 列示指定任务标识的版式文件历史版本.
export async function documentVersionActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 标识   
// GET : application/json
// 列示指定工作或已完成工作的版式文件历史版本.
export async function documentVersionActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 标识
// category: String: 类型   
// GET : application/json
// 列示指定工作或已完成工作以及类型的版式文件历史版本.
export async function documentVersionActionListWithWorkOrWorkCompletedCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}/category/${params.pathParameters.category}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// category: String: 类型   
// GET : application/json
// 列示指定任务标识以及类型的版式文件历史版本.
export async function documentVersionActionListWithJobCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/job/${params.pathParameters.job}/category/${params.pathParameters.category}`, params.data)
    return data.data
}


// pathParameters
// id: String: 草稿标识   
// GET : application/json
// 指定草稿标识,获取草稿内容.
export async function draftActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 草稿标识   
// DELETE : application/json
// 指定草稿标识,删除草稿.
export async function draftActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 草稿标识   
// GET : application/json
// 指定草稿标识,将草稿启动成为工作.
export async function draftActionStart (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.pathParameters.id}/start`, params.data)
    return data.data
}

   
// ins
// data: Data: 业务数据.
// work: Work: 工作.
// identity: String: 身份.
// PUT : application/json
// 保存草稿内容.
export async function draftActionSave (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// creatorUnitList: List<String>: 创建组织.
// title: String: 标题.
// POST : application/json
// 分页列示当前用户创建的草稿.
export async function draftActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 草稿标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户创建的草稿,上一页.
export async function draftActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// processFlag: String: 流程标识   
// ins
// title: String: 标题.
// identity: String: 启动人员身份.
// data: Data: 业务数据.
// POST : application/json
// 指定流程标识,创建草稿.
export async function draftActionDraw (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/process/${params.pathParameters.processFlag}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// data: Data: 业务数据.
// work: Work: 工作.
// identity: String: 身份.
// POST : application/json
// M保存草稿内容(mock put to post).
export async function draftActionSaveMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 草稿标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户创建的草稿,下一页.
export async function draftActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 草稿标识   
// GET : application/json
// 指定草稿标识,删除草稿(mock delete to get).
export async function draftActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用标识和文件标识访问文件内容.
export async function fileActionContent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}/content`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用标识和文件标识访问文件内容,设定使用流输出.
export async function fileActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}/download`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 标识   
// GET : application/json
// 列示指定应用标识下所有可见的文件.
export async function fileActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 表单标识   
// GET : application/json
// 获取表单内容.
export async function formActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 表单标识   
// GET : application/json
// 获取移动端表单内容.
export async function formActionGetMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.pathParameters.flag}/mobile`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识  
// queryParameters
// t: String: 缓存标志 
// GET : application/json
// 根据表单标识获取移动表单.
export async function formActionV2GetMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/${params.pathParameters.id}/mobile?t=${params.queryParameters.t }`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识  
// queryParameters
// t: String: 缓存标志 
// GET : application/json
// 根据表单标识获取表单.
export async function formActionV2Get (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/${params.pathParameters.id}?t=${params.queryParameters.t }`, params.data)
    return data.data
}


// pathParameters
// flag: String: 表单标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据标识和应用标识获取表单.
export async function formActionGetWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 表单标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据标识和应用标识获取移动端表单.
export async function formActionGetWithApplicationMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}/mobile`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 查询表单,如果有表单那么返回表单标识,如果表单不存在且是已完成工作,那么返回储存表单.
export async function formActionV2LookupWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/lookup/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 查询表单,如果有表单那么返回表单id,如果表单不存在且是已完成工作,那么返回storeFormMobile.
export async function formActionV2LookupWorkOrWorkCompletedMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/lookup/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}/mobile`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识   
// GET : application/json
// 根据给定的任务标识立即执行字段映射.
export async function jobActionV2Projection (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/v2/${params.pathParameters.job}/projection`, params.data)
    return data.data
}


// pathParameters
// serial: String: 编号   
// GET : application/json
// 根据问号查找工作或已完成工作,并返回最新创建的一个工作或已完成工作.
export async function jobActionLatestWorkWorkCompletedWithSerial (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/latest/work/workcompleted/serial/${params.pathParameters.serial}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据任务标识查找属于这个工作和已完成工作.
export async function jobActionFindWorkWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/${params.pathParameters.job}/find/work/workcompleted`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识
// person: String: 标识   
// GET : application/json
// 返回指定job是否allowVisit.
export async function jobActionAllowVisitWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/${params.pathParameters.job}/allow/visit/person/${params.pathParameters.person}`, params.data)
    return data.data
}

   
// ins
// key: String: 锁定工作标识.
// PUT : application/json
// 使用当前用户身份锁定工作.
export async function keyLockActionLock (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/keylock/lock`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 锁定工作标识.
// POST : application/json
// Mock Post To Put.
export async function keyLockActionLockMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/keylock/lock/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// GET : application/json
// 根据流程标识获取流程.
export async function processActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// GET : application/json
// 根据流程标识获取指定流程可调度到的节点.
export async function processActionGetAllowRerouteTo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.pathParameters.flag}/allowrerouteto`, params.data)
    return data.data
}


// pathParameters
// activity: String: 流程节点标志
// activityType: String: 流程节点类型   
// GET : application/json
// 根据活动标识和活动类型获取流程节点信息.
export async function processActionGetActivity (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/activity/${params.pathParameters.activity}/activityType/${params.pathParameters.activityType}`, params.data)
    return data.data
}

   
// ins
// processList: List<String>: 流程(多值逗号隔开).
// includeEdition: boolean: 是否同时查询同版本的流程(true|false).
// POST : application/json
// 根据流程标识查询流程简要信息.
export async function processActionListWithIds (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/ids`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// GET : application/json
// 获取流程内容,附带所有的活动节点信息.
export async function processActionGetComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.pathParameters.flag}/complex`, params.data)
    return data.data
}


// pathParameters
// flag: String: 流程标识
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用标识和流程标识获取流程.
export async function processActionGetWithProcessWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据指定应用标识获取可启动的流程.
export async function processActionListWithPersonWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据指定应用标识获取可管理的流程.
export async function processActionListControllableWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/controllable/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// GET : application/json
// 获取当前用户在指定流程中可启动流程的身份.
export async function processActionListAvailableIdentityWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/available/identity/process/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// ins
// startableTerminal: String: 可启动流程终端类型,可选值 client,mobile,all.
// POST : application/json
// 根据指定应用标识和指定条件过滤可启动的流程.
export async function processActionListWithPersonWithApplicationFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/application/${params.pathParameters.applicationFlag}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// GET : application/json
// 获取待阅内容,
export async function readActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// GET : application/json
// 列示指定待阅后续的所有Work和WorkCompleted.
export async function readActionReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/reference`, params.data)
    return data.data
}


// pathParameters
// work: String: 工作标识   
// GET : application/json
// 根据work获取待阅.
export async function readActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/work/${params.pathParameters.work}`, params.data)
    return data.data
}

   
// ins
// credentialList: List<String>: 人员标识.
// appliationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// POST : application/json
// 获取指定人员在指定范围内的待阅数量没有权限限制.
export async function readActionCountWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/count/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// creatorUnitList: List<String>: 创建身份所在组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// activityNameList: List<String>: 活动名称.
// key: String: 搜索关键字.
// POST : application/json
// 按条件对当前用户待阅分页显示.
export async function readActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/my/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 待阅意见.
// POST : application/json
// Mock Post To Put.
export async function readActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户的待阅,上一页.
export async function readActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户创建的工作的待阅,上一页.
export async function readActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// GET : application/json
// 列示当前用户的待阅,分页.
export async function readActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// ins
// jobList: List<String>: job标识
// idList: List<String>: 标识
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示待阅.
export async function readActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupByApplication: Boolean: 按应用分类
// groupByProcess: Boolean: 按流程分类
// groupByCreatorPerson: Boolean: 按创建人分类
// groupByCreatorUnit: Boolean: 按创建人分类
// groupByStartTimeMonth: Boolean: 按创建年月分类
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 统计待阅数量.
export async function readActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/count`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取可用与filter的分类值
export async function readActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/filter/attribute`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取制定人员的待阅数量,没有权限限制.
export async function readActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// creatorUnitList: List<String>: 创建身份所在组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// activityNameList: List<String>: 活动名称.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户过滤的Read,下一页.
export async function readActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 办理意见.
// PUT : application/json
// 管理修改意见.
export async function readActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/opinion/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 待阅意见.
// PUT : application/json
// 更新待阅内容,仅更新待阅意见.
export async function readActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 待阅意见.
// PUT : application/json
// 管理待阅转已阅.
export async function readActionManageProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/processing/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// DELETE : application/json
// 管理删除待阅.
export async function readActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户创建的工作的待阅,分页.
export async function readActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// creatorUnitList: List<String>: 创建身份所在组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// activityNameList: List<String>: 活动名称.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户过滤的Read,上一页.
export async function readActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户创建的工作的待阅,下一页.
export async function readActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户的Read对象,上一页.
export async function readActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户的待阅,分页.
export async function readActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建身份用户.
// creatorUnitList: List<String>: 创建身份所属组织.
// startTimeMonthList: List<String>: 待阅开始时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 搜索关键字.
// POST : application/json
// 列示当前用户的待阅,下一页.
export async function readActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// ins
// identityList: List<String>: 身份标识.
// notify: Boolean: 发送待阅通知.
// POST : application/json
// 根据work创建待阅.
export async function readActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/work/${params.pathParameters.workId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// identityList: List<String>: 重置待阅人身份.
// opinion: String: 待阅意见.
// PUT : application/json
// 重置待阅,将之前的待办转为已办,opinion:办理意见,identityList:新的待阅人.
export async function readActionManageResetRead (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/reset/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// date: String: 日期（如:2020-09-11）   
// GET : application/json
// 按创建时间查询指定时间段内当前所有待阅.
export async function readActionManageListWithDate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/date/${params.pathParameters.date}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户的Read对象,下一页.
export async function readActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 待阅意见.
// POST : application/json
// 保存待阅并创建已阅.
export async function readActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/processing`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据job获取待阅.
export async function readActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 待阅意见.
// POST : application/json
// Mock Post To Put.
export async function readActionManageProcessingMockPostToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/processing/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// identityList: List<String>: 重置待阅人身份.
// opinion: String: 待阅意见.
// POST : application/json
// Mock Post To Put.
export async function readActionManageResetReadMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/reset/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workCompletedId: String: 已完成工作标识   
// ins
// identityList: List<String>: 身份标识.
// notify: Boolean: 发送待阅通知.
// POST : application/json
// 根据workCompleted创建待阅.
export async function readActionCreateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/workcompleted/${params.pathParameters.workCompletedId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的Read对象,上一页.
export async function readActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户在指定应用下的待阅，按流程分类.
export async function readActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户在指定应用下的待阅，按应用分类.
export async function readActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// ins
// opinion: String: 办理意见.
// POST : application/json
// Mock Post To Put.
export async function readActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/opinion/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待阅标识   
// GET : application/json
// 管理删除待阅.
export async function readActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.pathParameters.id}/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户   
// GET : application/json
// 获取指定用户当前所有待阅.
export async function readActionManageListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/person/${params.pathParameters.person}/manage`, params.data)
    return data.data
}

   
// ins
// applicationList: List<String>: 限制应用范围.
// processList: List<String>: 限制流程范围.
// creatorUnitList: List<String>: 限制创建组织范围.
// startTimeMonthList: List<String>: 限制创建月份范围.
// activityNameList: List<String>: 限制活动名称范围.
// completedList: List<Boolean>: 可选择的完成状态.
// POST : application/json
// 获取可用与filter的分类值,通过输入值进行范围限制.
export async function readActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/filter/attribute/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss
// credentialList: List<String>: 人员标识.
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建身份所在组织.
// workList: List<String>: 工作标识.
// jobList: List<String>: 任务标识.
// startTimeMonthList: List<String>: 开始年月.
// key: String: 搜索关键字.
// person: String: 当前待阅人.
// stringValue01: String: 业务数据String值01.
// stringValue02: String: 业务数据String值02.
// stringValue03: String: 业务数据String值03.
// stringValue04: String: 业务数据String值04.
// stringValue05: String: 业务数据String值05.
// stringValue06: String: 业务数据String值06.
// stringValue07: String: 业务数据String值07.
// stringValue08: String: 业务数据String值08.
// stringValue09: String: 业务数据String值09.
// stringValue10: String: 业务数据String值10.
// POST : application/json
// 按条件对待阅分页显示.
export async function readActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作或完成工作获取待阅.
export async function readActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的Read对象,下一页.
export async function readActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的Read对象,上一页.
export async function readActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待阅标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的Read对象,下一页.
export async function readActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识   
// GET : application/json
// 根据标识获取已阅内容.
export async function readCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识   
// GET : application/json
// 列示指定已阅后续的所有工作和已完成工作.
export async function readCompletedActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.pathParameters.id}/reference`, params.data)
    return data.data
}


// pathParameters
// work: String: 工作标识   
// GET : application/json
// 根据工作标识获取已阅.
export async function readCompletedActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/work/${params.pathParameters.work}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间(年月).
// completedTimeMonthList: List<String>: 结束时间(年月).
// key: String: 匹配关键字.
// POST : application/json
// 分页列示按过滤条件过滤当前用户的已阅.
export async function readCompletedActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/my/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示当前用户的已阅,上一页.
export async function readCompletedActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示当前用户创建的工作的已阅,上一页.
export async function readCompletedActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// GET : application/json
// 分页列示当前用户的已阅.
export async function readCompletedActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// ins
// jobList: List<String>: 任务标识.
// idList: List<String>: 已阅标识.
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 列示已阅.
export async function readCompletedActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupByApplication: Boolean: 按应用分类.
// groupByProcess: Boolean: 按流程分类.
// groupByCreatorPerson: Boolean: 按创建人分类.
// groupByCreatorUnit: Boolean: 按创建人分类.
// groupByStartTimeMonth: Boolean: 按创建年月分类.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 统计已阅数量.
export async function readCompletedActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/count`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取可用与过滤的分类值.
export async function readCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/filter/attribute`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的已办数量,没有权限限制.
export async function readCompletedActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// creatorUnitList: List<String>: 创建人所在组织.
// startTimeMonthList: List<String>: 开始时间月份.
// completedTimeMonthList: List<String>: 结束时间月份.
// activityNameList: List<String>: 活动.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示按过滤条件过滤的已阅,下一页.
export async function readCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已阅标识   
// DELETE : application/json
// 根据已阅标识删除已阅,需要管理权限.
export async function readCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 分页列示当前用户创建工作的已阅.
export async function readCompletedActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// creatorUnitList: List<String>: 创建人所在组织.
// startTimeMonthList: List<String>: 开始时间月份.
// completedTimeMonthList: List<String>: 结束时间月份.
// activityNameList: List<String>: 活动.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示按过滤条件过滤的已阅,上一页.
export async function readCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示当前用户创建的工作的已阅,下一页.
export async function readCompletedActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户的已阅,上一页.
export async function readCompletedActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示当前用户的已阅.
export async function readCompletedActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// title: String: 标题.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建用户.
// creatorUnitList: List<String>: 创建组织.
// startTimeMonthList: List<String>: 开始时间.
// completedTimeMonthList: List<String>: 结束时间.
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的.
// key: String: 匹配关键字.
// POST : application/json
// 翻页列示当前用户的已阅,下一页.
export async function readCompletedActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已阅标识   
// ins
// opinion: String: 意见.
// POST : application/json
// 根据已阅标识修改意见,需要管理权限.
export async function readCompletedActionManageUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.pathParameters.id}/opinion/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// date: String: 日期（如:2020-09-11）   
// GET : application/json
// 按创建时间查询指定时间段内当前所有已阅,需要管理权限.
export async function readCompletedActionManageListWithDate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/date/${params.pathParameters.date}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户的已阅,下一页.
export async function readCompletedActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据任务标识获取已阅.
export async function readCompletedActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 翻页列示当前用户指定流程标识的已阅,上一页.
export async function readCompletedActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户指定应用标识按流程分类的已阅.
export async function readCompletedActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户按应用分类的已阅.
export async function readCompletedActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识   
// GET : application/json
// 根据已阅标识删除已阅,需要管理权限(mock delete to get).
export async function readCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.pathParameters.id}/manage/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// applicationList: List<String>: 限制应用标识.
// processList: List<String>: 限制流程标识.
// creatorUnitList: List<String>: 限制创建组织范围.
// startTimeMonthList: List<String>: 限制创建月份范围.
// completedTimeMonthList: List<String>: 限制结束月份范围.
// activityNameList: List<String>: 限制活动名称范围.
// completedList: List<Boolean>: 可选择的完成状态.
// POST : application/json
// 获取可用与过滤的分类值,通过输入值进行范围限制.
export async function readCompletedActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/filter/attribute/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false.
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss.
// credentialList: List<String>: 人员.
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建组织.
// workList: List<String>: 工作标识.
// jobList: List<String>: 任务标识.
// startTimeMonthList: List<String>: 开始时期(年月).
// key: String: 匹配关键字.
// person: String: 当前待办人.
// stringValue01: String: 业务数据String值01.
// stringValue02: String: 业务数据String值02.
// stringValue03: String: 业务数据String值03.
// stringValue04: String: 业务数据String值04.
// stringValue05: String: 业务数据String值05.
// stringValue06: String: 业务数据String值06.
// stringValue07: String: 业务数据String值07.
// stringValue08: String: 业务数据String值08.
// stringValue09: String: 业务数据String值09.
// stringValue10: String: 业务数据String值10.
// POST : application/json
// 分页列示按过滤条件过滤的已阅,需要管理权限.
export async function readCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作标识或完成工作标识获取已阅.
export async function readCompletedActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 翻页列示当前用户指定应用标识的已阅,下一页.
export async function readCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 翻页列示当前用户指定应用标识的已阅,上一页.
export async function readCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 已阅标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 翻页列示当前用户指定流程标识的已阅,下一页.
export async function readCompletedActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job   
// GET : application/json
// 根据任务标识获取阅读记录.
export async function readRecordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readrecord/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作或完成工作标识获取阅读记录.
export async function readRecordActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readrecord/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 根据记录标识删除记录,需要管理权限.
export async function recordActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job
// page: Integer: 分页
// size: Integer: 数量   
// GET : application/json
// 分页列示根据任务标识获取的记录.
export async function recordActionListWithJobPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/job/${params.pathParameters.job}/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// application: String: 应用.
// process: String: 流程ID.
// job: String: 任务标识
// work: String: 工作
// workCompleted: String: 已完成工作
// completed: Boolean: 工作是否已经完成.
// display: Boolean: 是否显示.
// order: Long: 显示排序.
// properties: RecordProperties: 属性对象存储字段.
// fromActivity: String: 开始活动Id
// fromActivityType: ActivityType: 开始活动类型.
// fromActivityName: String: 开始活动名称
// fromActivityAlias: String: 开始活动别名
// fromActivityToken: String: 开始节点Token
// arrivedActivity: String: 结束活动Id，可能为空，如果是未Connected的流程记录
// arrivedActivityType: ActivityType: 结束活动类型.
// arrivedActivityName: String: 结束活动名称.
// arrivedActivityAlias: String: 结束活动名称.
// arrivedActivityToken: String: 结束活动Token.
// recordTime: Date: 记录时间.
// person: String: 记录人员
// identity: String: 记录身份
// unit: String: 记录人员所在组织.
// type: String: 类型.
// PUT : application/json
// 根据记录标识修改记录,需要管理权限.
export async function recordActionManageEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.pathParameters.id}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 工作的job   
// GET : application/json
// 根据任务标识获取记录.
export async function recordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 根据记录标识删除记录,需要管理权限(mock delete to get).
export async function recordActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.pathParameters.id}/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作或完成工作标识获取记录.
export async function recordActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// job: String: 标识   
// ins
// application: String: 应用.
// process: String: 流程ID.
// job: String: 任务标识
// work: String: 工作
// workCompleted: String: 已完成工作
// completed: Boolean: 工作是否已经完成.
// display: Boolean: 是否显示.
// order: Long: 显示排序.
// properties: RecordProperties: 属性对象存储字段.
// fromActivity: String: 开始活动Id
// fromActivityType: ActivityType: 开始活动类型.
// fromActivityName: String: 开始活动名称
// fromActivityAlias: String: 开始活动别名
// fromActivityToken: String: 开始节点Token
// arrivedActivity: String: 结束活动Id，可能为空，如果是未Connected的流程记录
// arrivedActivityType: ActivityType: 结束活动类型.
// arrivedActivityName: String: 结束活动名称.
// arrivedActivityAlias: String: 结束活动名称.
// arrivedActivityToken: String: 结束活动Token.
// recordTime: Date: 记录时间.
// person: String: 记录人员
// identity: String: 记录身份
// unit: String: 记录人员所在组织.
// type: String: 类型.
// POST : application/json
// 根据任务标识创建记录,需要管理权限.
export async function recordActionManageCreateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/job/${params.pathParameters.job}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// application: String: 应用.
// process: String: 流程ID.
// job: String: 任务标识
// work: String: 工作
// workCompleted: String: 已完成工作
// completed: Boolean: 工作是否已经完成.
// display: Boolean: 是否显示.
// order: Long: 显示排序.
// properties: RecordProperties: 属性对象存储字段.
// fromActivity: String: 开始活动Id
// fromActivityType: ActivityType: 开始活动类型.
// fromActivityName: String: 开始活动名称
// fromActivityAlias: String: 开始活动别名
// fromActivityToken: String: 开始节点Token
// arrivedActivity: String: 结束活动Id，可能为空，如果是未Connected的流程记录
// arrivedActivityType: ActivityType: 结束活动类型.
// arrivedActivityName: String: 结束活动名称.
// arrivedActivityAlias: String: 结束活动名称.
// arrivedActivityToken: String: 结束活动Token.
// recordTime: Date: 记录时间.
// person: String: 记录人员
// identity: String: 记录身份
// unit: String: 记录人员所在组织.
// type: String: 类型.
// POST : application/json
// 根据记录标识修改记录,需要管理权限(mock put to post).
export async function recordActionManageEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.pathParameters.id}/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识
// page: Integer: 分页
// size: Integer: 数量   
// GET : application/json
// 分页列示根据工作或完成工作标识获取的记录.
export async function recordActionListWithWorkOrWorkCompletedPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 参阅标识   
// GET : application/json
// 获取参阅内容,
export async function reviewActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 参阅标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户的参阅,上一页.
export async function reviewActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 参阅标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户创建的工作的参阅,上一页.
export async function reviewActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// jobList: List<String>: job标识
// idList: List<String>: 标识
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示参阅.
export async function reviewActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupByApplication: Boolean: 按应用分类
// groupByProcess: Boolean: 按流程分类
// groupByCreatorPerson: Boolean: 按创建人分类
// groupByCreatorUnit: Boolean: 按创建人分类
// groupByStartTimeMonth: Boolean: 按创建年月分类
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 统计参阅数量.
export async function reviewActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/count`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 是否已经结束
// key: String: 关键字
// POST : application/json
// 获取可用与filter的分类值
export async function reviewActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/filter/attribute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 是否已经结束
// key: String: 关键字
// POST : application/json
// 获取人员的参阅数量,没有权限限制.
export async function reviewActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/count/person/${params.pathParameters.credential}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 参阅标识
// applicationFlag: String: 应用标识   
// DELETE : application/json
// 管理删除参阅.
export async function reviewActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.pathParameters.id}/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户创建的工作的参阅,分页.
export async function reviewActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 参阅标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户创建的工作的参阅,下一页.
export async function reviewActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户的参阅,分页.
export async function reviewActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 参阅标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 列示当前用户的参阅,下一页.
export async function reviewActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// work: String: 流转中工作
// personList: List<String>: 可阅读人员
// POST : application/json
// 根据workId创建一个review.
export async function reviewActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/create/work`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// query: String: 搜索内容.
// page: Integer: 分页.
// size: Integer: 数量.
// person: String: 用户.
// POST : application/json
// 搜索.
export async function reviewActionV2Search (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/search`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// personList: List<String>: 参阅用户
// jobList: List<String>: job标识
// idList: List<String>: 标识
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateTaskCompleted: Boolean: 是否关联taskCompleted
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// title: String: 标题
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 管理员分页查询参阅.
export async function reviewActionV2ManageListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据job获取参阅.
export async function reviewActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}

   
// ins
// workCompleted: String: 已完成工作
// personList: List<String>: 可阅读人员
// POST : application/json
// 根据workCompleted创建一个review.
export async function reviewActionCreateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/create/workcompleted`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 是否已经结束
// key: String: 关键字
// POST : application/json
// 获取当前人员的参阅数量按应用分类.
export async function reviewActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/count/application`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 参阅标识
// applicationFlag: String: 应用标识   
// GET : application/json
// Mock Get To Delete.
export async function reviewActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.pathParameters.id}/application/${params.pathParameters.applicationFlag}/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作或完成工作标识获取参阅.
export async function reviewActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 任务标识   
// GET : application/json
// 获取路由.
export async function routeActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// valueList: List<String>: 字符串多值.
// PUT : application/json
// 批量获取路由.
export async function routeActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// valueList: List<String>: 字符串多值.
// POST : application/json
// Mock Post To Put.
export async function routeActionListMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/list/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 任务标识   
// GET : application/json
// 获取选择人员配置.
export async function routeActionGetSelectConfig (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/${params.pathParameters.id}/selectconfig`, params.data)
    return data.data
}


// pathParameters
// flag: String: 脚本标识
// applicationFlag: String: 应用标识   
// ins
// importedList: List<String>: 导入标识
// POST : application/json
// 获取Script以及依赖脚本内容。
export async function scriptActionLoad (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/script/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 脚本标识
// applicationFlag: String: 应用标识   
// GET : application/json
// GET方法获取Script以及依赖脚本内容,POST无法缓存,GET方法不过滤已经导入的脚本.
export async function scriptActionGetImported (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/script/${params.pathParameters.flag}/application/${params.pathParameters.applicationFlag}/imported`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取SerialNumber内容,
export async function serialNumberActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// application: String: 应用.
// process: String: 流程ID.
// serial: Integer: 编号
// PUT : application/json
// 更新SerialNumber内容.
export async function serialNumberActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用的所有SerialNumber对象.
export async function serialNumberActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除SerialNumber内容.
export async function serialNumberActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// application: String: 应用.
// process: String: 流程ID.
// name: String: 编号名称.
// serial: Integer: 编号
// POST : application/json
// 创建SerialNumber内容.
export async function serialNumberActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// Mock Get To Delete.
export async function serialNumberActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// application: String: 应用.
// process: String: 流程ID.
// serial: Integer: 编号
// POST : application/json
// Mock Post To Put.
export async function serialNumberActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.pathParameters.id}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// PUT : application/json
// 访问服务.
export async function serviceActionTouch (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/service/work/${params.pathParameters.id}/touch`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// Mock Post To Put.
export async function serviceActionTouchMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/service/work/${params.pathParameters.id}/touch/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取签批信息.
export async function signActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除签批
export async function signActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// taskId: String: 待办ID   
// ins
// status: Integer: 状态：1(暂存)|2(签批正文不可以修改)|3(签批正文可以修改,正文保存为图片).
// htmlContent: String: 包含签批的html正文后内容，状态为3时必传.
// htmlWidth: Double: html正文宽度，允许为空.
// htmlHeight: Double: html正文高度，允许为空.
// inputList: List<String>: 输入框列表.
// scrawlList: List<String>: 涂鸦列表，示例["{'src':'base64图片','width':'100','height':'100'}"].
// POST : application/json
// 保存签批.
export async function signActionSave (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/save/task/${params.pathParameters.taskId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// scrawlId: String: 签批涂鸦附件标志   
// GET : application/json
// 下载签批涂鸦附件
export async function signActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/download/${params.pathParameters.scrawlId}`, params.data)
    return data.data
}


// pathParameters
// taskId: String: 待办标识   
// DELETE : application/json
// 根据task删除签批
export async function signActionDeleteByTask (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.pathParameters.taskId}`, params.data)
    return data.data
}


// pathParameters
// taskId: String: 任务ID   
// GET : application/json
// 根据task获取签批信息.
export async function signActionGetByTask (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.pathParameters.taskId}`, params.data)
    return data.data
}


// pathParameters
// job: String: 工作的job   
// GET : application/json
// 根据工作的job获取签批列表.
export async function signActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 删除签批
export async function signActionDeleteMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// taskId: String: 待办标识   
// GET : application/json
// 根据task删除签批mockdeletetoget
export async function signActionDeleteByTaskMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.pathParameters.taskId}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取快照对象.
export async function snapActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除快照
export async function snapActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.pathParameters.id}`, params.data)
    return data.data
}

 
// formParameters
// file: File:   
// POST : multipart/form-data
// 导入快照.
export async function snapActionUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/upload`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 导出快照.
export async function snapActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用id
// processList: List<String>: 流程
// personList: List<String>: 创建人
// key: String: 匹配关键字
// POST : application/json
// 按条件对当前用户快照分页显示.
export async function snapActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/my/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// GET : application/json
// 列示当前用户的快照,分页.
export async function snapActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示所有创建的快照对象,上一页.
export async function snapActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示所有创建的快照对象,下一页.
export async function snapActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/next/${params.pathParameters.count}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户创建的快照对象,上一页.
export async function snapActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// GET : application/json
// 挂起工作
export async function snapActionTypeSuspend (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.pathParameters.workId}/type/suspend`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// GET : application/json
// 对工作进行快照,并标记为废弃.
export async function snapActionTypeAbandoned (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.pathParameters.workId}/type/abandoned`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 恢复快照
export async function snapActionRestore (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.pathParameters.id}/restore`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// GET : application/json
// 对工作进行快照.
export async function snapActionTypeSnap (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.pathParameters.workId}/type/snap`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户创建的快照对象,下一页.
export async function snapActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorUnitList: List<String>: 创建组织
// credentialList: List<String>: 创建用户
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// key: String: 关键字
// title: String: 标题
// activityNameList: List<String>: 活动名称
// POST : application/json
// 分页列示指定应用下根据过滤条件的snap.
export async function snapActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的快照对象,上一页.
export async function snapActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用id
// processList: List<String>: 流程
// personList: List<String>: 创建人
// key: String: 匹配关键字
// POST : application/json
// 获取指定条件的快照,上一页.
export async function snapActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用id
// processList: List<String>: 流程
// personList: List<String>: 创建人
// key: String: 匹配关键字
// POST : application/json
// 获取指定条件的快照,下一页.
export async function snapActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用id
// processList: List<String>: 流程
// personList: List<String>: 创建人
// key: String: 匹配关键字
// POST : application/json
// 按条件对快照分页显示.
export async function snapActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的快照对象,下一页.
export async function snapActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的快照对象,上一页.
export async function snapActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的快照对象,下一页.
export async function snapActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 删除快照
export async function snapActionDeleteMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workCompletedId: String: 工作标识   
// GET : application/json
// 对已完成工作进行快照,并标记为废弃.
export async function snapActionTypeAbandonedWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/workcompleted/${params.pathParameters.workCompletedId}/type/abandonedworkcompleted`, params.data)
    return data.data
}


// pathParameters
// workCompletedId: String: 工作标识   
// GET : application/json
// 对已完成工作进行快照.
export async function snapActionTypeSnapWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/workcompleted/${params.pathParameters.workCompletedId}/type/snapworkcompleted`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}


// pathParameters
// id: String: 待办标识   
// GET : application/json
// 根据标识获取待办内容.
export async function taskActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// PUT : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
export async function taskActionReset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/reset`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 取得复合的待办信息,包括:待办对象,工作对象,附件对象,已完成工作对象和工作日志对象.
export async function taskActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/reference`, params.data)
    return data.data
}


// pathParameters
// work: String: 工作标识   
// GET : application/json
// 根据工作获取待办.
export async function taskActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/work/${params.pathParameters.work}`, params.data)
    return data.data
}

   
// ins
// credentialList: List<String>: 人员
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// POST : application/json
// 获取指定人员,应用,流程在指定范围内的待办数量,没有权限限制.
export async function taskActionCountWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/count/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// isExcludeDraft: Boolean: 是否排除草稿待办：false(默认不查找)|true
// startTime: String: 开始时间,格式为: yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间,格式为: yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// expireTime: String: 时效超时时间（0表示所有已超时的、1表示超时1小时以上的、2、3...）
// urgeTime: String: 催办超时时间（0表示所有已超时的、1表示超时1小时以上的、2、3...）
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// POST : application/json
// 分页显示根据条件过滤当前用户待办,可选条件:应用,流程,开始时间,结束时间,创建组织,创建年月,活动名称,过期时间,催办时间,是否包含草稿,关键字.
export async function taskActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/my/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 选择的路由名称
// opinion: String: 意见
// POST : application/json
// 更新指定待办的选择的路由及意见(MockPutToPost).
export async function taskActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 翻页显示按条件过滤的当前用户待办,上一页.
export async function taskActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 翻页显示当前用户创建工作的待办,上一页.
export async function taskActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// GET : application/json
// 分页显示当前用户的待办.
export async function taskActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// ins
// jobList: List<String>: 任务标识.
// idList: List<String>: 待办标识.
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 按条件过滤的当前用户待办.
export async function taskActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupByApplication: Boolean: 按应用分类
// groupByProcess: Boolean: 按流程分类
// groupByCreatorPerson: Boolean: 按创建人分类
// groupByCreatorUnit: Boolean: 按创建人分类
// groupByStartTimeMonth: Boolean: 按创建年月分类
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 按条件过滤统计待办数量.
export async function taskActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/count`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取可用与过滤的的待办分类值.
export async function taskActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/filter/attribute`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的待办数量,没有权限限制.
export async function taskActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 路由名称
// opinion: String: 意见
// optionList: List<Option>: 操作
// remove: Boolean: 是否删除指定待办身份
// POST : application/json
// 在指定待办位置新增处理人.
export async function taskActionV2Add (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.pathParameters.id}/add`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据:true(默认查找)|false
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// POST : application/json
// 翻页显示当前用户待办,通过输入过滤值进行范围限制,下一页.
export async function taskActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// POST : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
export async function taskActionResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/reset/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 待办标识   
// ins
// opinion: String: 办理意见.
// PUT : application/json
// 管理维护接口:管理修改意见,需要管理权限.
export async function taskActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/opinion/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理维护接口:翻页显示所有待办,上一页.
export async function taskActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 选择的路由名称
// opinion: String: 意见
// PUT : application/json
// 更新指定待办的选择的路由及意见.
export async function taskActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识   
// ins
// routeName: String: 办理选择路由名称.
// opinion: String: 办理意见.
// PUT : application/json
// 管理维护接口:待办转已办,需要管理权限.
export async function taskActionManageProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/processing/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 管理维护接口:删除待办,需要管理权限.
export async function taskActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 分页显示当前用户创建工作的待办.
export async function taskActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// POST : application/json
// 翻页显示当前用户待办,通过输入过滤值进行范围限制,上一页.
export async function taskActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 管理维护接口:翻页显示所有待办,下一页.
export async function taskActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 翻页显示当前用户创建工作的待办,下一页.
export async function taskActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户的待办对象,上一页.
export async function taskActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 分页显示按条件过滤的当前用户待办.
export async function taskActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联工作.
// relateWorkCompleted: Boolean: 是否关联已完成工作.
// relateTaskCompleted: Boolean: 是否关联已办.
// relateRead: Boolean: 是否关联待阅.
// relateReadCompleted: Boolean: 是否关联已阅.
// relateReview: Boolean: 是否关联参阅.
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办:true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办:false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// activityNameList: List<String>: 活动名称.
// creatorPersonList: List<String>: 创建工作人员.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM.
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// title: String: 标题.
// POST : application/json
// 翻页显示按条件过滤的当前用户待办,下一页.
export async function taskActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 路由名称
// opinion: String: 意见
// keep: Boolean: 保留自身待办.
// identityList: List<String>: 重置身份
// PUT : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
export async function taskActionV2Reset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.pathParameters.id}/reset`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// type: String: 神经网络类型
// POST : application/json
// 使用神经网络自动进行处理
export async function taskActionProcessingNeural (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/processing/neural`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 预计下一活动处理状态及处理人.
export async function taskActionWill (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/will`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 管理维护接口:待办提醒.
export async function taskActionManagePress (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/press/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// PUT : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
export async function taskActionManageReset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/reset/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 挂起待办,暂停待办处理计时.
export async function taskActionV2Pause (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.pathParameters.id}/pause`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 取消挂起待办,恢复待办处理计时.
export async function taskActionV2Resume (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.pathParameters.id}/resume`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 翻页列示当前用户的待办对象,下一页.
export async function taskActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 待办选择路由名称.
// decision: String: 决策.
// opinion: String: 待办办理意见.
// mediaOpinion: String: 多媒体意见.
// routeData: JsonElement: 路由数据.
// appendTaskIdentityList: List<String>: 新添加的待办处理人身份.
// ignoreEmpowerIdentityList: List<String>: 忽略授权身份.
// action: String: 待办处理类型:goBack.
// option: JsonElement: action的参数对象.
// POST : application/json
// 保存待办意见并继续流转.返回流转记录.
export async function taskActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/processing`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据指定的job列示待办.
export async function taskActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// date: String: 日期（如:2020-09-11）
// hour: Integer: 小时（0-23）
// isExcludeDraft: Boolean: 是否排除草稿待办：false(不排除)|true   
// GET : application/json
// 管理维护接口:按创建时间查询指定时间段内当前所有待办.
export async function taskActionManageListWithDateHour (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/date/${params.pathParameters.date}/hour/${params.pathParameters.hour}/exclude/draft/${params.pathParameters.isExcludeDraft}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的待办对象,上一页.
export async function taskActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// POST : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
export async function taskActionManageResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/reset/manage/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户指定应用中按流程分类待办数量.
export async function taskActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户按应用分类待办数量.
export async function taskActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 待办标识   
// ins
// opinion: String: 办理意见.
// POST : application/json
// 管理维护接口:管理修改意见,需要管理权限(MockPostToPut).
export async function taskActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/opinion/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 管理维护接口:删除待办,需要管理权限.MockGetToDelete.
export async function taskActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户
// isExcludeDraft: Boolean: 是否排除草稿待办：false(不排除)|true   
// GET : application/json
// 管理维护接口:列示指定人员的待办.
export async function taskActionManageListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/person/${params.pathParameters.person}/exclude/draft/${params.pathParameters.isExcludeDraft}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// credentialList: List<String>: 人员标识.
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// POST : application/json
// 管理维护接口:获取指定过滤条件过滤的待办,上一页.
export async function taskActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 待办标识   
// ins
// routeName: String: 办理选择路由名称.
// opinion: String: 办理意见.
// POST : application/json
// 管理维护接口:待办转已办,需要管理权限(MockPostToPut).
export async function taskActionManageProcessingMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.pathParameters.id}/processing/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// applicationList: List<String>: 限制应用范围
// processList: List<String>: 限制流程范围
// creatorUnitList: List<String>: 限制创建组织范围
// startTimeMonthList: List<String>: 限制创建月份范围
// activityNameList: List<String>: 限制活动名称范围
// POST : application/json
// 根据输入的分类过滤值,获取可用与过滤的的待办分类值.
export async function taskActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/filter/attribute/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// credentialList: List<String>: 人员标识.
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// POST : application/json
// 管理维护接口:获取指定过滤条件过滤的待办,下一页.
export async function taskActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程待办：true(默认查找)|false.
// isExcludeDraft: Boolean: 是否排除草稿待办：false(默认不排除)|true.
// startTime: String: 开始时间,格式为:yyyy-MM-dd HH:mm:ss.
// endTime: String: 结束时间,格式为:yyyy-MM-dd HH:mm:ss.
// credentialList: List<String>: 人员标识.
// activityNameList: List<String>: 活动名称.
// creatorUnitList: List<String>: 创建工作身份所属组织.
// workList: List<String>: 工作标识.
// jobList: List<String>: 任务标识.
// startTimeMonthList: List<String>: 开始年月,格式为文本格式 yyyy-MM
// expireTime: String: 时效超时时间（0表示所有已超时的、1表示超时1小时以上的、2、3...）
// urgeTime: String: 催办超时时间（0表示所有已超时的、1表示超时1小时以上的、2、3...）
// key: String: 搜索关键字,搜索范围为:标题,意见,文号,创建人,创建部门.
// stringValue01: String: 业务数据String值01.
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 管理维护接口:翻页显示按条件过滤待办.
export async function taskActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// routeName: String: 路由名称
// opinion: String: 意见
// keep: Boolean: 保留自身待办.
// identityList: List<String>: 重置身份
// POST : application/json
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人(MockPutToPost)
export async function taskActionV2ResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.pathParameters.id}/reset/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 翻页显示当前用户指定应用的待办,下一页.
export async function taskActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 翻页显示当前用户指定应用的待办,上一页.
export async function taskActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 翻页显示当前用户指定流程的待办,下一页.
export async function taskActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 参阅标识   
// GET : application/json
// 获取已办内容,
export async function taskCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 列示指定已办后续的所有Work和WorkCompleted.
export async function taskCompletedActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/reference`, params.data)
    return data.data
}


// pathParameters
// work: String: 工作标识   
// GET : application/json
// 根据work获取已办.
export async function taskCompletedActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/work/${params.pathParameters.work}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间(月)
// completedTimeMonthList: List<String>: 结束时间(月)
// completedList: List<Boolean>: 可选择的完成状态
// key: String: 匹配关键字
// POST : application/json
// 按条件对当前用户已办分页显示.
export async function taskCompletedActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/my/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户的已办,上一页.
export async function taskCompletedActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户创建的工作的已办,上一页.
export async function taskCompletedActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// GET : application/json
// 列示当前用户的已办,分页.
export async function taskCompletedActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// ins
// jobList: List<String>: job标识
// idList: List<String>: 标识
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示已办.
export async function taskCompletedActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupByApplication: Boolean: 按应用分类
// groupByProcess: Boolean: 按流程分类
// groupByCreatorPerson: Boolean: 按创建人分类
// groupByCreatorUnit: Boolean: 按创建人分类
// groupByStartTimeMonth: Boolean: 按创建年月分类
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 统计已办数量.
export async function taskCompletedActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/count`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取可用与filter的分类值.
export async function taskCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/filter/attribute`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的已办数量,没有权限限制.
export async function taskCompletedActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间(月)
// completedTimeMonthList: List<String>: 结束时间(月)
// completedList: List<Boolean>: 可选择的完成状态
// key: String: 关键字
// POST : application/json
// 获取用户对已办的过滤信息,下一页.
export async function taskCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已办标识   
// ins
// opinion: String: 意见
// PUT : application/json
// 管理修改意见.
export async function taskCompletedActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/opinion/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 管理删除已办.
export async function taskCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户创建的工作的已办,分页.
export async function taskCompletedActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间(月)
// completedTimeMonthList: List<String>: 结束时间(月)
// completedList: List<Boolean>: 可选择的完成状态
// POST : application/json
// 获取用户对已办的过滤信息,上一页.
export async function taskCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户创建的工作的已办,下一页.
export async function taskCompletedActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户的已办对象,上一页.
export async function taskCompletedActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户的已办,分页.
export async function taskCompletedActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 已办标识
// count: Integer: 数量   
// ins
// relateWork: Boolean: 是否关联work
// relateWorkCompleted: Boolean: 是否关联workCompleted
// relateTask: Boolean: 是否关联task
// relateRead: Boolean: 是否关联read
// relateReadCompleted: Boolean: 是否关联readCompleted
// relateReview: Boolean: 是否关联review
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// activityNameList: List<String>: 活动名称
// creatorPersonList: List<String>: 创建用户
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 开始时间
// completedTimeMonthList: List<String>: 结束时间
// completed: Boolean: 已经结束的.
// notCompleted: Boolean: 尚未结束的
// latest: Boolean: 同一Job,同一处理人最后一条已办.
// key: String: 关键字
// title: String: 标题
// POST : application/json
// 列示当前用户的已办,下一页.
export async function taskCompletedActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 列示指定已办后续的所有Work和WorkCompleted的简单内容和权限.
export async function taskCompletedActionReferenceControl (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/reference/control`, params.data)
    return data.data
}


// pathParameters
// work: String: 工作标识   
// GET : application/json
// 提醒.
export async function taskCompletedActionPress (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/press/work/${params.pathParameters.work}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 待办或已办标识   
// GET : application/json
// 根据待办或者已办取得上一人工活动已办.
export async function taskCompletedActionListPrevManual (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/prev/manual/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户的已办对象,下一页.
export async function taskCompletedActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据job获取已办.
export async function taskCompletedActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// date: String: 日期（如:2020-09-11）
// hour: Integer: 小时（0-23）   
// GET : application/json
// 按创建时间查询指定时间段内当前所有已办.
export async function taskCompletedActionManageListWithDateHour (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/date/${params.pathParameters.date}/hour/${params.pathParameters.hour}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的已办对象,上一页.
export async function taskCompletedActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户在指定应用下的已办,按流程分类.
export async function taskCompletedActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户按应用分类的已办.
export async function taskCompletedActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 已办标识   
// ins
// opinion: String: 意见
// POST : application/json
// Mock Post To Put.
export async function taskCompletedActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/opinion/manage/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// Mock Get To Delete.
export async function taskCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.pathParameters.id}/manage/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// applicationList: List<String>: 限制应用范围
// processList: List<String>: 限制流程范围
// creatorUnitList: List<String>: 限制创建组织范围
// startTimeMonthList: List<String>: 限制创建月份范围
// completedTimeMonthList: List<String>: 限制结束月份范围
// activityNameList: List<String>: 限制活动名称范围
// completedList: List<Boolean>: 可选择的完成状态
// POST : application/json
// 获取可用与filter的分类值,通过输入值进行范围限制.
export async function taskCompletedActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/filter/attribute/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// credentialList: List<String>: 人员
// activityNameList: List<String>: 活动名称
// creatorUnitList: List<String>: 创建组织
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// startTimeMonthList: List<String>: 开始时期
// key: String: 匹配关键字
// person: String: 当前待办人
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 按条件对已办分页显示.
export async function taskCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或完成工作标识   
// GET : application/json
// 根据工作或完成工作获取已办,
export async function taskCompletedActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的已办对象,下一页.
export async function taskCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户的已办对象,上一页.
export async function taskCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户的已办对象,下一页.
export async function taskCompletedActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 根据id获取工作.
export async function workActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// DELETE : application/json
// 删除工作，需要应用管理权限或者是工作的创建者。
export async function workActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// processFlag: String: 流程标识   
// ins
// latest: Boolean: 直接打开指定人员已经有的草稿,草稿判断:工作没有已办,只有一条此人的待办.
// title: String: 标题.
// identity: String: 启动人员身份.
// data: JsonElement: 工作数据.
// parentWork: String: 父工作标识.
// allowEdition: Boolean: 允许启动非当但版本流程,默认否并自动升级到当前版本流程.
// skipDraftCheck: Boolean: 是否跳过新建检查(默认根据流程的新建检查配置，设置true则不进行新建检查).
// POST : application/json
// 创建工作（创建启动版本的流程）.
export async function workActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/process/${params.pathParameters.processFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// workLog: String: 工作日志
// PUT : application/json
// 回滚工作到指定的workLog
export async function workActionRollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/rollback`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// POST : application/json
// 翻页显示按条件过滤的当前用户创建的工作,上一页.
export async function workActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用标识.
// processList: List<String>: 流程标识.
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间, 格式: yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间, 格式: yyyy-MM-dd HH:mm:ss
// startTimeMonthList: List<String>: 启动月份, 格式: yyyy-MM.
// activityNameList: List<String>: 活动名称.
// workThroughManual: Boolean: 是否已经经过人工节点,用于判断是否是草稿.在到达环节进行判断.
// dataChanged: Boolean: 当前工作是否经过保存修改的操作,用于判断是否是默认生成的未经修改的.
// key: String: 关键字.
// POST : application/json
// 列示当前用户创建的工作,可以根据条件过滤,分页.
export async function workActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/my/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// POST : application/json
// 按条件过滤的当前用户创建的待办.
export async function workActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取用于过滤的可选属性值,限定范围为我创建的工作
export async function workActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/filter/attribute/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识   
// GET : application/json
// 获取指定人员的Task,TaskCompleted,Read,ReadCompleted,Review.没有权限限制
export async function workActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/count/${params.pathParameters.credential}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 启动月份
// activityNameList: List<String>: 活动名称
// workStatusList: List<WorkStatus>: 工作状态
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的Work,下一页,限定范围为我创建的工作以及应用.
export async function workActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 最后一个Work的ID
// count: Integer: 返回数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用不带权限区分的所有Work,上一页.
export async function workActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 启动月份
// activityNameList: List<String>: 活动名称
// workStatusList: List<WorkStatus>: 工作状态
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的Work,上一页,限定范围为我创建的工作以及应用.
export async function workActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 最后一个Work的ID
// count: Integer: 返回数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用不带权限区分的所有Work,下一页.
export async function workActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页显示按条件过滤的当前用户创建的工作.
export async function workActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// POST : application/json
// 翻页显示按条件过滤的当前用户创建的工作,下一页.
export async function workActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 指定Work运行映射.
export async function workActionProjection (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/projection`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// PUT : application/json
// V2_工作召回。
export async function workActionV2Retract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/retract`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// person: String: 召回工作已办人员（根据流转记录确认）   
// PUT : application/json
// 管理员替代person操作工作召回。
export async function workActionV2ManageRetract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/person/${params.pathParameters.person}/retract/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// PUT : application/json
// 将工作召回。
export async function workActionRetract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/retract`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 取得指定work当前人员所有的task,taskCompleted,read,readCompleted,review
export async function workActionRefer (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/refer`, params.data)
    return data.data
}


// pathParameters
// processFlag: String: 流程标识   
// ins
// latest: Boolean: 直接打开指定人员已经有的草稿,草稿判断:工作没有已办,只有一条此人的待办.
// title: String: 标题.
// identity: String: 启动人员身份.
// data: JsonElement: 工作数据.
// parentWork: String: 父工作标识.
// POST : application/json
// 创建工作（强制创建存在的流程）.
export async function workActionCreateForce (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/process/${params.pathParameters.processFlag}/force`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 完成工作关闭时候的检查,1.检查是否要删除处于草稿状态的工作,没有保存过任何数据将被认为是草稿.2.检查是否需要释放抢办.
export async function workActionCloseCheck (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/close/check`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 列示关联的Work对象.
export async function workActionManageListRelative (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/relative/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// workLog: String: 工作日志
// taskCompletedIdentityList: List<String>: 已完成工作处理人.
// processing: Boolean: 是否尝试流转
// PUT : application/json
// V2_回滚工作.
export async function workActionV2Rollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/rollback`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// splitValueList: List<String>: 添加的拆分值.
// trimExist: Boolean: 是否排除已经存在的拆分值.
// workLog: String: 添加分支的工作日志标识.
// PUT : application/json
// V2_增加一个会签分支
export async function workActionV2AddSplit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/add/split`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 获取工作内容.
export async function workActionManageGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// splitValueList: List<String>: 添加的拆分值.
// trimExist: Boolean: 排除已经存在的拆分值.
// PUT : application/json
// 增加一个会签分支
export async function workActionAddSplit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/add/split`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// activity: String: 活动节点
// activityType: String: 节点类型
// mergeWork: Boolean: 是否合并所有的work
// manualForceTaskIdentityList: List<String>: 人工活动强制处理人
// PUT : application/json
// V2_工作调度.
export async function workActionV2Reroute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/reroute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// 完成工作关闭时候的检查,1.检查是否要删除处于草稿状态的工作,没有保存过任何数据将被认为是草稿.2.检查是否需要释放抢办.为了支持信标方法(Navigator.sendBeacon())单独增加的方法.
export async function workActionCloseCheckPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/close/check`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// activityId: String: 活动标识
// activityType: ActivityType: 活动类型   
// ins
// forceJoinAtArrive: Boolean: 强制从arrive开始
// forceJoinAtInquire: Boolean: 强制从inquire开始
// ignoreEmpowerIdentityList: List<String>: 忽略授权的身份
// person: String: 当前处理人
// identity: String: 当前处理人身份
// PUT : application/json
// 将工作调度。
export async function workActionReroute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/reroute/activity/${params.pathParameters.activityId}/activitytype/${params.pathParameters.activityType}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// PUT : application/json
// 尝试流转一个Work.
export async function workActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/processing`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// activity: String: 活动节点
// activityType: String: 节点类型
// mergeWork: Boolean: 是否合并所有的work
// manualForceTaskIdentityList: List<String>: 人工活动强制处理人
// POST : application/json
// Mock Post To Put.
export async function workActionV2RerouteMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/reroute/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// creatorUnitList: List<String>: 创建组织
// credentialList: List<String>: 创建用户
// title: String: 标题
// activityNameList: List<String>: 活动名称
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// workStatus: String: 工作状态：start|processing|hanging
// key: String: 关键字
// workThroughManual: Boolean: 是否已经经过人工节点,
// workCreateType: String: 工作创建类型,
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 分页列示指定应用下根据过滤条件的Work.
export async function workActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// splitValueList: List<String>: 添加的拆分值.
// trimExist: Boolean: 是否排除已经存在的拆分值.
// workLog: String: 添加分支的工作日志标识.
// POST : application/json
// Mock Post To Put.
export async function workActionV2AddSplitMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/add/split/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// DELETE : application/json
// 删除单个工作.
export async function workActionManageDeleteSingleWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/single/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 列示指定Work下所有的待办已办,待阅已阅和参阅.
export async function workActionManageGetAssignment (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/assignment/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// ins
// processList: List<String>: 流程
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 启动月份
// activityNameList: List<String>: 活动名称
// workStatusList: List<WorkStatus>: 工作状态
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的我创建的工作,上一页.
export async function workActionListPrevCreatorWithCurrentFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/creator/current/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// person: String: 召回工作已办人员（根据流转记录确认）   
// POST : application/json
// Mock Post To Put.
export async function workActionV2ManageRetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/person/${params.pathParameters.person}/retract/manage/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取用于过滤的可选属性值
export async function workActionManageFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/filter/attribute/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户创建的Work对象,上一页.
export async function workActionListPrevCreatorWithCurrent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/creator/current`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// Mock Post To Put.
export async function workActionRetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/retract/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// workLog: String: 工作日志
// POST : application/json
// Mock Post To Put.
export async function workActionRollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/rollback/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// activityId: String: 活动标识
// activityType: ActivityType: 活动类型   
// ins
// forceJoinAtArrive: Boolean: 强制从arrive开始
// forceJoinAtInquire: Boolean: 强制从inquire开始
// ignoreEmpowerIdentityList: List<String>: 忽略授权的身份
// person: String: 当前处理人
// identity: String: 当前处理人身份
// POST : application/json
// 将工作调度。
export async function workActionRerouteMockPost2Put (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/reroute/activity/${params.pathParameters.activityId}/activitytype/${params.pathParameters.activityType}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// 按条件过滤的当前用户创建的待办.
export async function workActionV2ListActivityGoBack (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.pathParameters.id}/activity/goback`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// Mock Post To Put.
export async function workActionV2RetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/retract/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// identity: String: 身份
// optionList: List<Option>: 操作
// remove: Boolean: 是否删除指定待办身份
// POST : application/json
// 对指定的工作添加待办身份.
export async function workActionV2AddManualTaskIdentityMatrix (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/add/manual/task/identity/matrix`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// splitValueList: List<String>: 添加的拆分值.
// trimExist: Boolean: 排除已经存在的拆分值.
// POST : application/json
// Mock Post To Put.
export async function workActionAddSplitMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/add/split/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定application下根据porcess分类的work数量.
export async function workActionManageListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application/${params.pathParameters.applicationFlag}/process/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// DELETE : application/json
// 删除所有相关联的工作.
export async function workActionManageDeleteRelativeWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/relative/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// ins
// workLog: String: 工作日志
// taskCompletedIdentityList: List<String>: 已完成工作处理人.
// processing: Boolean: 是否尝试流转
// POST : application/json
// Mock Post To Put.
export async function workActionV2RollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.pathParameters.id}/rollback/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// ins
// processList: List<String>: 流程标识.
// creatorUnitList: List<String>: 创建工作人员身份所属组织.
// startTimeMonthList: List<String>: 创建工作启动月份,格式为: yyyy-MM.
// activityNameList: List<String>: 活动名称.
// workStatusList: List<WorkStatus>: 工作状态.
// key: String: 关键字.
// POST : application/json
// 列示根据过滤条件的我创建的工作,下一页
export async function workActionListNextCreatorWithCurrentFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/creator/current/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作标识   
// GET : application/json
// V2_根据Work或workCompleted取得内容.
export async function workActionV2GetWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// credential: String: 个人标识
// appId: String: 应用标志   
// GET : application/json
// 获取指定人员在指定应用的Task,TaskCompleted,Read,ReadCompleted,Review.没有权限限制
export async function workActionCountWithPersonAndApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/count/${params.pathParameters.credential}/application/${params.pathParameters.appId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// POST : application/json
// Mock Post To Put.
export async function workActionProcessingMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/processing/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识
// processFlag: String: 流程标识   
// ins
// latest: Boolean: 直接打开指定人员已经有的草稿,草稿判断:工作没有已办,只有一条此人的待办.
// title: String: 标题.
// identity: String: 启动人员身份.
// data: JsonElement: 工作数据.
// parentWork: String: 父工作标识.
// allowEdition: Boolean: 允许启动非当但版本流程,默认否并自动升级到当前版本流程.
// skipDraftCheck: Boolean: 是否跳过新建检查(默认根据流程的新建检查配置，设置true则不进行新建检查).
// POST : application/json
// 创建工作（创建启动版本的流程）.
export async function workActionCreateWithApplicationProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/application/${params.pathParameters.applicationFlag}/process/${params.pathParameters.processFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识
// processFlag: String: 流程标识   
// ins
// latest: Boolean: 直接打开指定人员已经有的草稿,草稿判断:工作没有已办,只有一条此人的待办.
// title: String: 标题.
// identity: String: 启动人员身份.
// data: JsonElement: 工作数据.
// parentWork: String: 父工作标识.
// POST : application/json
// 创建工作（强制创建存在的流程）.
export async function workActionCreateWithApplicationProcessForce (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/application/${params.pathParameters.applicationFlag}/process/${params.pathParameters.processFlag}/force`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户创建的Work对象,下一页.
export async function workActionListNextCreatorWithCurrent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/creator/current`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户创建的Work，按应用分类.
export async function workActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// processFlag: String: 应用标识   
// GET : application/json
// 列示指定流程当前用户创建的Work对象,上一页.
export async function workActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户在指定应用下的待办，按流程分类.
export async function workActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 启动月份
// activityNameList: List<String>: 活动名称
// workStatusList: List<WorkStatus>: 工作状态
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的Work,上一页.
export async function workActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// creatorUnitList: List<String>: 创建组织
// startTimeMonthList: List<String>: 启动月份
// activityNameList: List<String>: 活动名称
// workStatusList: List<WorkStatus>: 工作状态
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的Work,下一页.
export async function workActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// startTimeMonthList: List<String>: 启动月份
// creatorUnitList: List<String>: 创建组织
// credentialList: List<String>: 创建用户
// activityNameList: List<String>: 活动名称
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// workStatus: String: 工作状态：start|processing|hanging
// key: String: 关键字
// workThroughManual: Boolean: 是否已经经过人工节点,
// workCreateType: String: 工作创建类型,
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 按条件对Work分页显示.
export async function workActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// Mock Get To Delete.
export async function workActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 获取工作或者已完成工作内容.
export async function workActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// Mock Get To Delete.
export async function workActionManageDeleteRelativeWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/relative/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识   
// GET : application/json
// Mock Get To Delete.
export async function workActionManageDeleteSingleWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.pathParameters.id}/single/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户创建的Work对象,下一页.
export async function workActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定应用当前用户创建的Work对象,上一页.
export async function workActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作标识
// count: Integer: 数量
// processFlag: String: 流程标识   
// GET : application/json
// 列示指定流程当前用户创建的Work对象,下一页.
export async function workActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.pathParameters.id}/next/${params.pathParameters.count}/process/${params.pathParameters.processFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取WorkCompleted.
export async function workCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// processFlag: String: 流程标识   
// ins
// title: String: 标题.
// serial: String: 序号.
// form: String: 指定表单.
// formData: String: 指定表单数据.
// identity: String: 启动人员身份.
// startTime: Date: 开始日期.
// completedTime: Date: 结束日期.
// data: JsonElement: 工作数据.
// POST : application/json
// 创建已完成工作.
export async function workCompletedActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/process/${params.pathParameters.processFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// ins
// workLog: String: 工作日志
// PUT : application/json
// 完成工作重新回滚.
export async function workCompletedActionRollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.flag}/rollback`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取用于过滤的可选属性值
export async function workCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/attribute/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// completedTimeMonthList: List<String>: 结束年月
// startTimeMonthList: List<String>: 开始年月
// key: String: 关键字
// POST : application/json
// 根据过滤属性列示WorkCompleted,下一页.
export async function workCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示当前用户创建的WorkCompleted对象,上一页.
export async function workCompletedActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除所有相关数据.
export async function workCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.id}/delete/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// completedTimeMonthList: List<String>: 结束年月
// startTimeMonthList: List<String>: 开始年月
// key: String: 关键字
// POST : application/json
// 根据过滤属性列示WorkCompleted,上一页.
export async function workCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 如果是xadmin或者是ProcessPlatformManager或Manager角色那么显示这个应用下的所有WorkCompleted,如果是Process的管理员,那么显示Process下的WorkCompleted.下一页.
export async function workCompletedActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取工作内容.
export async function workCompletedActionManageGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.id}/manage`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 统计当前用户在指定应用下的WorkCompleted，按流程分类.
export async function workCompletedActionCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application/${params.pathParameters.applicationFlag}/process`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true|false(默认不查找)
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// title: String: 标题
// creatorUnitList: List<String>: 创建组织
// credentialList: List<String>: 创建用户
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 分页列示指定应用下根据过滤条件的WorkCompleted.
export async function workCompletedActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 列示指定Work下所有的待办已办,待阅已阅和参阅.
export async function workCompletedActionManageGetAssignment (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.id}/assignment/manage`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 获取用于过滤的可选属性值
export async function workCompletedActionManageFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/attribute/application/${params.pathParameters.applicationFlag}/manage`, params.data)
    return data.data
}


// pathParameters
// flag: String: 流程标识   
// ins
// workLog: String: 工作日志
// POST : application/json
// Mock Post To Put.
export async function workCompletedActionRollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.flag}/rollback/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示指定application下根据porcess分类的workCompleted数量.
export async function workCompletedActionManageListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application/${params.pathParameters.applicationFlag}/process/manage`, params.data)
    return data.data
}

   
// GET : application/json
// 统计当前用户创建的WorkCompleted，按应用分类.
export async function workCompletedActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// Mock Get To Delete.
export async function workCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.pathParameters.id}/delete/manage/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// startTimeMonthList: List<String>: 启动月份
// completedTimeMonthList: List<String>: 完成月份
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的WorkCompleted,上一页.
export async function workCompletedActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// ins
// processList: List<String>: 流程
// startTimeMonthList: List<String>: 启动月份
// completedTimeMonthList: List<String>: 完成月份
// key: String: 关键字
// POST : application/json
// 列示根据过滤条件的WorkCompleted,下一页.
export async function workCompletedActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}/filter/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// applicationList: List<String>: 应用
// processList: List<String>: 流程
// relateEditionProcess: Boolean: 是否查找同版本流程数据：true(默认查找)|false
// startTime: String: 开始时间yyyy-MM-dd HH:mm:ss
// endTime: String: 结束时间yyyy-MM-dd HH:mm:ss
// startTimeMonthList: List<String>: 启动月份
// creatorUnitList: List<String>: 创建组织
// credentialList: List<String>: 创建用户
// workList: List<String>: work工作
// jobList: List<String>: job工作实例
// key: String: 关键字
// stringValue01: String: 业务数据String值01
// stringValue02: String: 业务数据String值02
// stringValue03: String: 业务数据String值03
// stringValue04: String: 业务数据String值04
// stringValue05: String: 业务数据String值05
// stringValue06: String: 业务数据String值06
// stringValue07: String: 业务数据String值07
// stringValue08: String: 业务数据String值08
// stringValue09: String: 业务数据String值09
// stringValue10: String: 业务数据String值10
// POST : application/json
// 按条件对WorkCompleted分页显示.
export async function workCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示当前用户在指定的application下创建的WorkCompleted对象,下一页.
export async function workCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/next/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识   
// GET : application/json
// 列示当前用户在指定的application下创建的WorkCompleted对象,上一页.
export async function workCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 根据指定job获取工作日志.
export async function workLogActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 根据指定Work或者WorkCompleted获取工作日志.
export async function workLogActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// workOrWorkCompleted: String: 工作或已完成工作标识   
// GET : application/json
// 获取工作或完成工作可回滚的工作日志.
export async function workLogActionListRollbackWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/rollback/workorworkcompleted/${params.pathParameters.workOrWorkCompleted}`, params.data)
    return data.data
}


// pathParameters
// workId: String: 工作标识   
// GET : application/json
// 获取工作或完成工作可回滚的工作日志.
export async function workLogActionListAddSplitWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/add/split/work/${params.pathParameters.workId}`, params.data)
    return data.data
}
