
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// designerTypes: List<String>: 搜索设计类型：script|form|page|widget|process|view|table|stat|statement
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// moduleList: List<Module>: 限制查询的模块列表(模块类型：processPlatform|cms|portal|query|service)<br/>


// POST : application/json
// 全平台设计搜索.
export async function designActionSearch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/design/search`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// ins
// category: String: 分类.
// key: String: 标识.
// POST : application/json
// 目录中索引数量,category,type,key为空统计search目录数量.
export async function indexActionDirectoryDocumentCount (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/index/directory/document/count`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识
// workId: String: 工作标识   
// GET : application/json
// 计算输入工作ID进行计算.
export async function neuralActionListCalculateWithWork (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/list/calculate/model/${params.pathParameters.modelFlag}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 学习.
export async function neuralActionLearn (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/learn/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 停止学习.
export async function neuralActionStopLearning (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/stop/learning/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 项目标识   
// GET : application/json
// 停止数据生成.
export async function neuralActionStopGenerating (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/stop/generating/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 创建用于学习的数据集.
export async function neuralActionGenerate (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/generate/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// GET : application/json
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/reload/dynamic`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// bundle: String: 数据行标识   
// POST : application/json
// 更新指定表中的行.
export async function tableActionUpdateWithBundle (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/${params.pathParameters.flag}/update/${params.pathParameters.bundle}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// POST : application/json
// 指定表中插入行.
export async function tableActionInsert (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/${params.pathParameters.flag}/insert`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行文档高频索引,(0)表示在所有节点上执行.
export async function touchActionHighFreqDocumentTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/document/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行已完成工作低频索引,(0)表示在所有节点上执行.
export async function touchActionLowFreqWorkCompletedTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/workcompleted/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行已完成工作高频索引,(0)表示在所有节点上执行.
export async function touchActionHighFreqWorkCompletedTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/workcompleted/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置已完成工作高频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionHighFreqWorkCompletedReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/workcompleted/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置已完成工作低频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionLowFreqWorkCompletedReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/workcompleted/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置文档高频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionHighFreqDocumentReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/document/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行文档低频索引,(0)表示在所有节点上执行.
export async function touchActionLowFreqDocumentTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/document/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置文档低频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionLowFreqDocumentReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/document/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行优化索引,(0)表示在所有节点上执行.
export async function touchActionOptimizeIndex (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/optimize/index/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置在流转工作高频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionHighFreqWorkReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/work/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行在流转工作低频索引,(0)表示在所有节点上执行.
export async function touchActionLowFreqWorkTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/work/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 执行在流转工作高频索引,(0)表示在所有节点上执行.
export async function touchActionHighFreqWorkTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/work/node/${params.pathParameters.node}/touch`, params.data)
    return data.data
}


// pathParameters
// node: String: 节点   
// GET : application/json
// 重置在流转工作低频索引定时任务状态,(0)表示在所有节点上执行.
export async function touchActionLowFreqWorkReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/work/node/${params.pathParameters.node}/reset`, params.data)
    return data.data
}
