import os
import json


def lower_first_letter(text):
    """
    将字符串第一个字母小写
    """
    return text[0].lower() + text[1:]


def capitalize_first_letter(text):
    """
    将字符串第一个字母大写
    """
    return text[0].upper() + text[1:]


dir_path = "json"
json_data = {}
# 遍历 json 文件夹下的所有文件夹
for subdir in os.listdir(dir_path):
    subdir_path = os.path.join(dir_path, subdir)

    # 获取 api.json 和 describe.json 的路径
    api_json_path = os.path.join(subdir_path, "api.json")
    describe_json_path = os.path.join(subdir_path, "describe.json")

    # 读取 api.json 和 describe.json
    with open(api_json_path, 'r', encoding='utf-8') as f:
        api_json = json.load(f)

    with open(describe_json_path, 'r', encoding='utf-8') as f:
        describe_json = json.load(f)

    json_data = {
        "name": subdir,
        "api": api_json,
        "describe": describe_json
    }

    # 生成 js 文件
    with open(f'./js/{subdir}.js', 'w', encoding='utf-8') as f:
        for (index_i, jaxr) in enumerate(json_data["api"]["jaxrs"]):
            for method in jaxr["methods"]:
                function_name = lower_first_letter(jaxr["name"]) + capitalize_first_letter(method["name"])

                # 判断 index_i 对应位置的 describe.json 字段是否与 api.json 字段一致
                if json_data["describe"]["jaxrs"][index_i]["name"] != jaxr["name"]:
                    print("error")

                # 解析 describe.json
                for describe in json_data["describe"]["jaxrs"][index_i]["methods"]:
                    
                    # 使 describe.json 与 api.json 一一对应
                    if describe["name"] != method["name"]:
                        continue

                    path_parameters = "\n// pathParameters"
                    for param in describe["pathParameters"]:
                        path_parameters += f"\n// {param['name']}: {param['type']}: {param['description']}"
                    path_parameters = "" if path_parameters == "\n// pathParameters" else path_parameters

                    form_parameters = "\n// formParameters"
                    for param in describe["formParameters"]:
                        form_parameters += f"\n// {param['name']}: {param['type']}: {param['description']}"
                    form_parameters = "" if form_parameters == "\n// formParameters" else form_parameters
                    
                    query_parameters = "\n// queryParameters"
                    for param in describe["queryParameters"]:
                        query_parameters += f"\n// {param['name']}: {param['type']}: {param['description']}"
                    query_parameters = "" if query_parameters == "\n// queryParameters" else query_parameters

                    ins = "\n// ins"
                    for param in describe["ins"]:
                        ins += f"\n// {param['name']}: {param['type']}: {param['description']}"
                    ins = "" if ins == "\n// ins" else ins
                    
                    url = f"/{subdir}/{describe['path']}".replace("{", "${params.pathParameters.")
                    if query_parameters != "":
                        url += "?"
                        for param in describe["queryParameters"]:
                            url += "{param_name}=${{params.queryParameters.{param_name} }}&".format(param_name=param["name"])
                        url = url[:-1]

                    content = """
{path_parameters} \
{form_parameters} \
{query_parameters} \
{ins}
// {query_type} : {query_content_type}
// {query_description}
export async function {function_name} (params) {{
    const {{data}} = await request({url}, {params})
    return data.data
}}
""".format(
            path_parameters=path_parameters,
            form_parameters=form_parameters,
            query_parameters=query_parameters,
            ins=ins,
            query_type=describe["type"],
            query_content_type=describe["contentType"],
            query_description=describe["description"],
            function_name=function_name,
            url=f"`{url}`",
            params="JSON.stringify(params.data)" if ins != "" else "params.data"
        )
                    f.write(content)
