package org.linkor.db;
import com.taosdata.jdbc.TSDBDriver;
import com.taosdata.jdbc.TSDBPreparedStatement;

import java.sql.*;
import java.util.Properties;

/**
 * TDengine 数据库相关操作
 */
public class TDengineUtils {

    private static Connection conn = null;

    public static void init() throws SQLException {
        String jdbcUrl = "jdbc:TAOS://192.168.0.176:6030?user=root&password=taosdata";
        Properties properties = new Properties();
        properties.setProperty(TSDBDriver.PROPERTY_KEY_CHARSET, "UTF-8");
        properties.setProperty(TSDBDriver.PROPERTY_KEY_LOCALE, "en_US.UTF-8");
        properties.setProperty(TSDBDriver.PROPERTY_KEY_TIME_ZONE, "UTC-8");
        conn = DriverManager.getConnection(jdbcUrl, properties);
        System.out.println("Connected to TDengine");

        try (Statement stmt = conn.createStatement()) {
            stmt.execute("CREATE DATABASE if not exists power KEEP 3650");
            stmt.executeUpdate("use power");
            stmt.execute("CREATE STABLE if not exists o2oa (ts TIMESTAMP, st BOOL, temperature INT, press INT) " +
                                 "TAGS (location BINARY(64))");
            System.out.println("Created table o2oa");
        }
    }

    public static void insertData(String location, boolean state, int temperature, int press){
        String psql = "INSERT INTO ? USING power.o2oa TAGS(?) VALUES (?, ?, ?, ?)";
        assert conn != null;

//        try(TSDBPreparedStatement pst = (TSDBPreparedStatement) conn.prepareStatement(psql)) {
//            pst.setTableName("d1001");
//            pst.setTagString(0, location);
//
//            System.out.println(333);
//            pst.setTimestamp(0, new Timestamp(System.currentTimeMillis()));
//            pst.setBoolean(1, state);
//            pst.setInt(2, temperature);
//            pst.setInt(3, press);
//
//            pst.executeUpdate(psql);
//            System.out.println(444);
//        } catch (SQLException e) {
//            e.printStackTrace();
//        }
        try (Statement stmt = conn.createStatement()) {
            String sql = getRawData(location, state, temperature, press);
            int rowCount = stmt.executeUpdate(sql);
        }catch (SQLException e){
            e.printStackTrace();
        }
    }

    public static String getRawData (String location, boolean state, int temperature, int press){
        StringBuilder sb = new StringBuilder("INSERT INTO power.s USING power.o2oa TAGS(");
        sb.append('\'').append(location).append('\'') // tag: location
                .append(") VALUES(")
                .append('\'').append(new Timestamp(System.currentTimeMillis())).append('\'').append(",") // ts
                .append(state).append(",") // state
                .append(temperature).append(",") // temperature
                .append(press).append(") "); // press
        return sb.toString();
    }
}
