package org.linkor;

import java.sql.*;

/**
 * 请求数据
 */
public class QueryDemo {
    private static Connection getConnection() throws SQLException {
        String jdbcUrl = "jdbc:TAOS://192.168.0.176:6030/power?user=root&password=taosdata";
        return DriverManager.getConnection(jdbcUrl);
    }

    private static void printRow(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); i++) {
            String value = rs.getString(i);
            System.out.print(value);
            System.out.print("\t");
        }

        System.out.println();
        for (int i = 1; i <= meta.getColumnCount(); i++) {
            System.out.print(rs.getString(i).getClass().getName());
            System.out.print("\t");
        }
    }

    private static void printColName(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); i++) {
            String colLabel = meta.getColumnLabel(i);
            System.out.print(colLabel);
            System.out.print("\t");
        }

        System.out.println();
    }

    private static void processResult(ResultSet rs) throws SQLException {
        printColName(rs);
//        while (rs.next()) {
//            printRow(rs);
//        }
        rs.next();
        printRow(rs);
    }

    private static void queryData() throws SQLException {
        try (Connection conn = getConnection()) {
            try (Statement stmt = conn.createStatement()) {
                ResultSet rs = stmt.executeQuery("SELECT * FROM power.s");
                processResult(rs);
            }
        }
    }

    public static void main(String[] args) throws SQLException {
        queryData();
    }
}
