
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/cache/config/flush`, params.data)
    return data.data
}


// pathParameters
// document: String: 内容管理文档标识   
// GET : application/json
// 列示内容管理指定document标识的关联内容.
export async function correlationActionListTypeCms (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/list/type/cms/document/${params.pathParameters.document}`, params.data)
    return data.data
}


// pathParameters
// document: String: 内容管理文档标识   
// ins
// person: String: 用户.
// targetList: List<TargetWi>: 关联目标.
// POST : application/json
// 指定内容管理文档创建关联内容.
export async function correlationActionCreateTypeCms (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/type/cms/document/${params.pathParameters.document}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// document: String: 流程平台任务标识   
// ins
// idList: List<String>: 关联内容标识.
// POST : application/json
// 根据id删除多个内容管理关联内容.
export async function correlationActionDeleteTypeCms (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/delete/type/cms/document/${params.pathParameters.document}`, JSON.stringify(params.data))
    return data.data
}

   
// POST : application/json
// 判断内容平台指定document的任务是否通过被关联具有阅读权限.
export async function correlationActionReadableTypeCms (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/readable/type/cms`, params.data)
    return data.data
}


// pathParameters
// job: String: 流程平台任务标识   
// ins
// person: String: 用户.
// targetList: List<TargetWi>: 关联目标.
// POST : application/json
// 指定流程平台工作或已完成工作创建关联内容.
export async function correlationActionCreateTypeProcessPlatform (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/type/processplatform/job/${params.pathParameters.job}`, JSON.stringify(params.data))
    return data.data
}

   
// POST : application/json
// 判断流程平台指定job的任务是否通过被关联具有阅读权限.
export async function correlationActionReadableTypeProcessPlatform (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/readable/type/processplatform`, params.data)
    return data.data
}


// pathParameters
// job: String: 流程平台任务标识   
// ins
// idList: List<String>: 关联内容标识.
// POST : application/json
// 根据id删除多个流程平台关联内容.
export async function correlationActionDeleteTypeProcessPlatform (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/delete/type/processplatform/job/${params.pathParameters.job}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// job: String: 任务标识   
// GET : application/json
// 列示流程平台指定job标识的关联内容.
export async function correlationActionListTypeProcessPlatform (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/list/type/processplatform/job/${params.pathParameters.job}`, params.data)
    return data.data
}


// pathParameters
// document: String: 内容管理文档标识
// site: String: 关联内容框标识   
// GET : application/json
// 列示内容管理指定document标识指定关联内容框标识的关联内容.
export async function correlationActionListTypeCmsWithSite (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/list/type/cms/document/${params.pathParameters.document}/site/${params.pathParameters.site}`, params.data)
    return data.data
}


// pathParameters
// job: String: 任务标识
// site: String: 关联内容框标识   
// GET : application/json
// 列示流程平台指定job标识指定关联内容框标识的关联内容.
export async function correlationActionListTypeProcessPlatformWithSite (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/correlation/list/type/processplatform/job/${params.pathParameters.job}/site/${params.pathParameters.site}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_correlation_service_processing/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
