
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示对象.
export async function deviceEntityClassNameActionListPaging (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// GET : application/json
// 测试定时任务的有效性
export async function deviceEntityClassNameActionTest1 (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/test1`, params.data)
    return data.data
}


// pathParameters
// id: String: 示例-信息ID   
// GET : application/json
// 根据ID获取示例-信息
export async function deviceEntityClassNameActionGet (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 需要更新的-信息ID   
// ins
// name: String: 产品名称
// number: String: 产品编号
// model: String: 型号
// mapNumber: String: 产品图号
// positionNumber: String: 位号
// bodyMaterial: String: 主体材料
// containerClass: String: 容器类别
// isUsing: String: 是否启用
// extend: String: 拓展字段(以json的形式存储)
// PUT : application/json
// 更新新示例-信息
export async function deviceEntityClassNameActionUpdate (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 需要删除的数据ID   
// DELETE : application/json
// 根据标识ID删除信息.
export async function deviceEntityClassNameActionDelete (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 测试第三方包的调用
export async function deviceEntityClassNameActionTest (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample/test`, params.data)
    return data.data
}

   
// ins
// name: String: 产品名称
// number: String: 产品编号
// model: String: 型号
// mapNumber: String: 产品图号
// positionNumber: String: 位号
// bodyMaterial: String: 主体材料
// containerClass: String: 容器类别
// isUsing: String: 是否启用
// extend: String: 拓展字段(以json的形式存储)
// POST : application/json
// 创建新示例-信息
export async function deviceEntityClassNameActionSave (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sample`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// POST : application/json
// 分页查询
export async function hikFireCloudActionGetOne (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/hik/artemis`, params.data)
    return data.data
}

   
// GET : application/json
// modbus 与 TDengine 数据库连接的接口, 返回 String
export async function modbusActionGetAll (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/modbus/all`, params.data)
    return data.data
}


// pathParameters
// startTime: String: 开始时间 样式为 'yyyy-mm-dd hh:MM:ss'
// endTime: String: 结束时间 样式为 'yyyy-mm-dd hh:MM:ss'   
// GET : application/json
// modbus 与 TDengine 数据库连接的接口
export async function modbusActionGetWithParams (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/modbus/getWithParams/${params.pathParameters.startTime}/${params.pathParameters.endTime}`, params.data)
    return data.data
}

   
// GET : application/json
// modbus 与 TDengine 数据库连接的接口, 返回 Wo
export async function modbusActionGetOne (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/modbus/one`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_device_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
