

// pathParameters
// province: String: 省
// city: String: 市   
// GET : application/json
// 列示指定省市所属区行政区域信息.
export async function areaActionListDistrict (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.pathParameters.province}/city/${params.pathParameters.city}`, params.data)
    return data.data
}


// pathParameters
// province: String: 省   
// GET : application/json
// 列示指定省所属市级行政区域信息.
export async function areaActionListCity (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.pathParameters.province}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示省级行政区域信息.
export async function areaActionListProvince (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list`, params.data)
    return data.data
}


// pathParameters
// province: String: 省
// city: String: 市
// district: String: 区   
// GET : application/json
// 列示指定省市区所属街道行政区域信息.
export async function areaActionListStreet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.pathParameters.province}/city/${params.pathParameters.city}/district/${params.pathParameters.district}`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/echo`, params.data)
    return data.data
}

   
// ins
// value: String: 字符串值.
// POST : application/json
// 文本纠错检查.
export async function ecnetActionCheck (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/ecnet/check`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 附件标识   
// GET : application/json
// 获取附件.
export async function generalFileActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/generalfile/flag/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// html转换成word结果流文件.
export async function officeActionHtmlToWordResult (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office/html/to/word/result/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// fileName: String: 转换文件名.
// content: String: 内容.
// POST : application/json
// html转换word.
export async function officeActionHtmlToWord (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office/html/to/word`, JSON.stringify(params.data))
    return data.data
}

 
// formParameters
// file: File: office文件  
// POST : multipart/form-data
// word转换html.
export async function officeActionInput (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}

   
// ins
// text: String: 转换文本.
// width: Integer: 图像宽度,默认200.
// height: Integer: 图像高度,默认200.
// POST : application/json
// POST方法生成二维码图像.
export async function qrCodeActionPostCreate (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/qrcode`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// width: Integer: 宽
// height: Integer: 高
// text: String: 文本   
// GET : application/json
// GET方法生成二维码图像.
export async function qrCodeActionGetCreate (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/qrcode/width/${params.pathParameters.width}/height/${params.pathParameters.height}/text/${params.pathParameters.text}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// GET : application/json
// 在流程引擎路由中将route.getProperties().getSoleDirect()的值强制全部设置为false.
export async function upgradeActionAction2021090902 (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/upgrade/2021090902`, params.data)
    return data.data
}

   
// GET : application/json
// 在流程引擎路由中增加字段defaultSelected,将defaultSelected的值直接设置成sole的值.
export async function upgradeActionAction2021090901 (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/upgrade/2021090901`, params.data)
    return data.data
}


// pathParameters
// date: String: 指定日期   
// GET : application/json
// 返回指定时间是否是节假日.
export async function workTimeActionIsHoliday (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isholiday/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// startDate: String: 开始日期
// endDate: String: 结束日期   
// GET : application/json
// 根据2个日期计算出节假天数.
export async function workTimeActionBetweenHolidayCount (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/betweenholidaycount/start/${params.pathParameters.startDate}/end/${params.pathParameters.endDate}`, params.data)
    return data.data
}


// pathParameters
// date: String: 指定日期   
// GET : application/json
// 返回指定时间是否定义为节假日.
export async function workTimeActionInDefinedHoliday (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/indefinedholiday/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// start: String: 开始时间
// end: String: 结束时间   
// GET : application/json
// 计算开始时间和结束时间之间的工作时间间隔(分钟).
export async function workTimeActionBetweenMinutes (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/betweenminutes/start/${params.pathParameters.start}/end/${params.pathParameters.end}`, params.data)
    return data.data
}


// pathParameters
// start: String: 开始时间
// days: int: 前进工作天数   
// GET : application/json
// 计算开始时间前进指定工作天数后的工作时间.
export async function workTimeActionForwardDays (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/forwarddays/start/${params.pathParameters.start}/days/${params.pathParameters.days}`, params.data)
    return data.data
}


// pathParameters
// date: String: 指定时间   
// GET : application/json
// 返回指定时间是否是工作时间.
export async function workTimeActionIsWorkTime (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isworktime/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// start: String: 开始时间
// minutes: int: 前进分钟数   
// GET : application/json
// 计算开始时间前进指定分钟数后的工作时间.
export async function workTimeActionForwardMinutes (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/forwardminutes/start/${params.pathParameters.start}/minutes/${params.pathParameters.minutes}`, params.data)
    return data.data
}

   
// GET : application/json
// 返回一个工作日的工作分钟数.
export async function workTimeActionMinutesOfWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/minutesofworkday`, params.data)
    return data.data
}


// pathParameters
// date: String: 指定日期   
// GET : application/json
// 返回指定时间是否定义为工作日.
export async function workTimeActionInDefinedWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/indefinedworkday/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// date: String: 指定日期   
// GET : application/json
// 返回指定时间是否是工作日.
export async function workTimeActionIsWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isworkday/${params.pathParameters.date}`, params.data)
    return data.data
}
