

// pathParameters
// meetingId: String: 会议标识
// summary: boolean: 是否是会议纪要 
// formParameters
// file: File: 文件
// fileName: String:   
// POST : multipart/form-data
// 创建会议附件.
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/meeting/${params.pathParameters.meetingId}/upload/${params.pathParameters.summary}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// stream: boolean: 是否直接下载附件,不使用浏览器打开   
// GET : application/json
// 下载附件内容.
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.pathParameters.id}/download/${params.pathParameters.stream}`, params.data)
    return data.data
}

   
// ins
// meeting: String: 会议标识
// work: String: 工作标识
// attachmentList: List<String>: 附件标识
// POST : application/json
// 将流程平台中的work附带的附件作为会议的附件.
export async function attachmentActionCreateFormProcessPlatform (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/create/from/processplatform`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Attachment对象,上一页.仅管理员可用
export async function attachmentActionListPrev (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Attachment对象,下一页.仅管理员可用
export async function attachmentActionListNext (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识
// callback: String: 回调函数名 
// formParameters
// file: File: 文件  
// POST : multipart/form-data
// 更新会议附件内容
export async function attachmentActionUpdateCallback (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.pathParameters.id}/update/callback/${params.pathParameters.ballback}`, params.data)
    return data.data
}


// pathParameters
// meetingId: String: 会议标识   
// GET : application/json
// 列示指定会议的附件.
export async function attachmentActionListWithMeeting (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/meeting/${params.pathParameters.meetingId}`, params.data)
    return data.data
}


// pathParameters
// meetingId: String: 会议标识
// summary: boolean: 是否是会议纪要
// callback: String: 回调函数名 
// formParameters
// file: File: 文件
// fileName: String:   
// POST : multipart/form-data
// 创建会议附件.
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/meeting/${params.pathParameters.meetingId}/upload/${params.pathParameters.summary}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取指定的Attachment信息.
export async function attachmentActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识 
// formParameters
// file: File: 文件  
// PUT : multipart/form-data
// 更新会议附件内容
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.pathParameters.id}/update`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除Attachment.
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// start: String: 开始时间
// completed: String: 结束时间
// room: String: 会议室标识
// meeting: String: 会议标识   
// GET : application/json
// 列示在所有building和下属的room，和room下面将来的会议，同时判断在指定时间内room是否空闲,用于修改当前预定会议时间
export async function buildingActionListWithStartCompletedRoom (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/start/${params.pathParameters.start}/completed/${params.pathParameters.completed}/room/${params.pathParameters.room}/meeting/${params.pathParameters.meeting}`, params.data)
    return data.data
}


// pathParameters
// start: String: 开始时间
// completed: String: 结束时间   
// GET : application/json
// 列示在所有building和下属的room，和room下面将来的会议，同时判断在指定时间内room是否空闲
export async function buildingActionListWithStartCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/start/${params.pathParameters.start}/completed/${params.pathParameters.completed}`, params.data)
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 根据拼音或者首字母进行模糊查询.
export async function buildingActionListLikePinyin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building//list/like/pinyin/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 根据名称进行模糊查询.
export async function buildingActionListLike (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/like/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 获取拼音首字母开始的Building.
export async function buildingActionListPinyinInitial (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/pinyininitial/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Building,同时获取Building下的Room 和 Room下的将来Meeting.
export async function buildingActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 建筑标识   
// ins
// id: String: 数据库主键,自动生成.
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// name: String: 名称,不可重名.
// address: String: 地点.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// PUT : application/json
// 更新Building.
export async function buildingActionPut (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有Building 同时获取Building下的Room 和 Room下的将来Meeting.
export async function buildingActionList (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 建筑标识   
// DELETE : application/json
// 删除Building.
export async function buildingActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// name: String: 名称,不可重名.
// address: String: 地点.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// POST : application/json
// 创建Building.
export async function buildingActionCreate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 获取会议系统配置(管理员)。
export async function configActionGetConfigManage (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config/system/config/manage`, params.data)
    return data.data
}

   
// GET : application/json
// 获取会议系统配置。
export async function configActionGetSystemConfig (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config/system/config`, params.data)
    return data.data
}

   
// ins
// process: Map<String,String>: 会议申请流程
// weekBegin: String: 一周开始日期
// mobileCreateEnable: Boolean: 是否允许移动端创建会议
// toMyMeetingViewName: String: 我的会议视图
// toMonthViewName: String: 月视图
// toWeekViewName: String: 周视图
// toDayViewName: String: 日视图
// toListViewName: String: 会议列表视图
// toRoomViewName: String: 会议室视图
// meetingViewer: List<String>: 会议详情可见范围
// typeList: List<String>: 会议类型
// disableViewList: List<String>: 
// enableOnline: Boolean: 是否启用线上会议
// onlineProduct: String: 线上会议产品，如：好视通
// onlineConfig: OnlineConfig: 线上会议配置(json对象：{'hstUrl':'好视通服务地址','hstKey':'好视通服务接口KEY','hstSecret':'好视通服务接口SECRET','hstAuth':'是否启用好视通会议鉴权登录，默认false','o2ToHstUid':'O2与好视通映射的唯一ID字段'}
// POST : application/json
// 保存会议系统配置.
export async function configActionSaveSystemConfig (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 拒绝会议邀请
export async function meetingActionReject (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/reject`, params.data)
    return data.data
}

   
// ins
// subject: String: 名称
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// description: String: 说明
// summary: String: 说明
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// inviteMemberList: List<String>: 邀请人员,身份,组织，群组.
// invitePersonList: List<String>: 邀请人员.
// inviteDelPersonList: List<String>: 邀请人员,身份,组织已删列表.
// acceptPersonList: List<String>: 接受人员.
// rejectPersonList: List<String>: 拒绝人员.
// checkinPersonList: List<String>: 签到人员.
// confirmStatus: ConfirmStatus: 会议预定状态
// manualCompleted: Boolean: 会议是否手工结束
// actualStartTime: Date: 实际开始时间.
// actualCompletedTime: Date: 实际结束时间.
// applicant: String: 会议申请人
// auditor: String: 会议审核人
// memo: String: 备注.
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 会议类型
// mode: String: 会议方式：online|线上会议;offline|线下会议
// roomId: String: 线上会议的会议号
// roomLink: String: 线上会议的链接
// POST : application/json
// 创建会议
export async function meetingActionPost (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 页面
// size: Integer: 数量   
// ins
// distinguishedName: String: 用户的全称
// subject: String: 标题.
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// confirmStatus: String: 会议预定状态.(allow|deny|wait)
// applicant: String: 创建人员.
// invitePersonList: String: 邀请人员,身份,组织.
// acceptPersonList: String: 接受人员.
// checkinPersonList: String: 签到人员.
// manualCompleted: Boolean: 会议是否手工结束.(true|false)
// meetingStatus: String: 会议当前状态.(wait|processing|completed)
// sortField: String: 排序字段.(startTime|completedTime|room)
// sortType: String: 排序.(desc|asc)
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 类型
// POST : application/json
// 管理员，分页列示Meeing对象
export async function meetingActionListMeetingPagingManage (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.pathParameters.page}/size/${params.pathParameters.size}/manage`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 列示我受到邀请的正在进行中的会议.
export async function meetingActionLisInvitedCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/completed`, params.data)
    return data.data
}


// pathParameters
// monthCount: Integer: 制定月数   
// GET : application/json
// 列示所有从当前时间开始指定月数内需要召开的会议
export async function meetingActionListForwardMonthAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/forward/monthcount/${params.pathParameters.monthCount}/all`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我申请的正在进行中的会议.
export async function meetingActionListAppliedProcessing (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/processing`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我申请的已经结束的会议.
export async function meetingActionListAppliedCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/completed`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我受到邀请的正在进行中的会议.
export async function meetingActionLisInvitedProcessing (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/processing`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// subject: String: 名称
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// description: String: 说明
// summary: String: 说明
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// inviteMemberList: List<String>: 邀请人员,身份,组织，群组.
// invitePersonList: List<String>: 邀请人员.
// inviteDelPersonList: List<String>: 邀请人员,身份,组织已删列表.
// acceptPersonList: List<String>: 接受人员.
// rejectPersonList: List<String>: 拒绝人员.
// checkinPersonList: List<String>: 签到人员.
// confirmStatus: ConfirmStatus: 会议预定状态
// manualCompleted: Boolean: 会议是否手工结束
// actualStartTime: Date: 实际开始时间.
// actualCompletedTime: Date: 实际结束时间.
// applicant: String: 会议申请人
// auditor: String: 会议审核人
// memo: String: 备注.
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 会议类型
// mode: String: 会议方式：online|线上会议;offline|线下会议
// roomId: String: 线上会议的会议号
// roomLink: String: 线上会议的链接
// POST : application/json
// 修改会议、标题、说明、邀请人
export async function meetingActionModify (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 拒绝会议预定.
export async function meetingActionConfirmDeny (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/confirm/deny`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// InvitePersonList: List<String>: 将要删除名单列表
// PUT : application/json
// 删除会议邀请人.
export async function meetingActionDeleteInvite (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/delete/invite`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// PUT : application/json
// 会议提前开始,修改开始时间
export async function meetingActionEditStartTime (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/modify/starttime`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// subject: String: 名称
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// description: String: 说明
// summary: String: 说明
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// inviteMemberList: List<String>: 邀请人员,身份,组织，群组.
// invitePersonList: List<String>: 邀请人员.
// inviteDelPersonList: List<String>: 邀请人员,身份,组织已删列表.
// acceptPersonList: List<String>: 接受人员.
// rejectPersonList: List<String>: 拒绝人员.
// checkinPersonList: List<String>: 签到人员.
// confirmStatus: ConfirmStatus: 会议预定状态
// manualCompleted: Boolean: 会议是否手工结束
// actualStartTime: Date: 实际开始时间.
// actualCompletedTime: Date: 实际结束时间.
// applicant: String: 会议申请人
// auditor: String: 会议审核人
// memo: String: 备注.
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 会议类型
// mode: String: 会议方式：online|线上会议;offline|线下会议
// roomId: String: 线上会议的会议号
// roomLink: String: 线上会议的链接
// PUT : application/json
// 修改会议,标题,说明,只能增加邀请人
export async function meetingActionEdit (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 会议签到二维码
export async function meetingActionCheckInBindCode (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/checkin/code`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 接受会议邀请
export async function meetingActionAccpet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/accept`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 手动结束Meeting.
export async function meetingActionManualCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/manual/completed`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 会议签到
export async function meetingActionCheckin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/checkin`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// id: String: 数据库主键,自动生成.
// subject: String: 名称
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// description: String: 说明
// summary: String: 说明
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// inviteMemberList: List<String>: 邀请人员,身份,组织，群组.
// invitePersonList: List<String>: 邀请人员.
// inviteDelPersonList: List<String>: 邀请人员,身份,组织已删列表.
// acceptPersonList: List<String>: 接受人员.
// rejectPersonList: List<String>: 拒绝人员.
// checkinPersonList: List<String>: 签到人员.
// confirmStatus: ConfirmStatus: 会议预定状态
// manualCompleted: Boolean: 会议是否手工结束
// actualStartTime: Date: 实际开始时间.
// actualCompletedTime: Date: 实际结束时间.
// applicant: String: 会议申请人
// auditor: String: 会议审核人
// memo: String: 备注.
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 会议类型
// mode: String: 会议方式：online|线上会议;offline|线下会议
// roomId: String: 线上会议的会议号
// roomLink: String: 线上会议的链接
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 增加会议邀请人.
export async function meetingActionAddInvite (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/add/invite`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// ins
// room: String: 所属楼层.
// completedTime: Date: 结束时间.
// PUT : application/json
// 会议提前结束,修改结束时间
export async function meetingActionEditCompletedTime (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/modify/completedtime`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 同意会议预定.
export async function meetingActionConfirmAllow (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}/confirm/allow`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我受到邀请的还未开始的会议.
export async function meetingActionLisInvitedWait (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/wait`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我申请的还未开始的会议.
export async function meetingActionListAppliedWait (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/wait`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// subject: String: 标题.
// room: String: 所属楼层.
// startTime: Date: 开始时间.
// completedTime: Date: 结束时间.
// confirmStatus: String: 会议预定状态.(allow|deny|wait)
// applicant: String: 创建人员.
// invitePersonList: String: 邀请人员,身份,组织.
// acceptPersonList: String: 接受人员.
// checkinPersonList: String: 签到人员.
// manualCompleted: Boolean: 会议是否手工结束.(true|false)
// meetingStatus: String: 会议当前状态.(wait|processing|completed)
// sortField: String: 排序字段.(startTime|completedTime|room)
// sortType: String: 排序.(desc|asc)
// hostUnit: String: 承办部门
// hostPerson: String: 主持人
// type: String: 类型
// POST : application/json
// 普通用户，分页列示Meeing对象
export async function meetingActionListMeetingPaging (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 列示我参与从当前日期开始指定月份范围的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
export async function meetingActionListComingMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/coming/month/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 列示我参与从当前日期开始指定日期范围的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
export async function meetingActionListComingDay (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/coming/day/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日   
// GET : application/json
// 列示所有指定日期的会议.
export async function meetingActionListOnDayAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.pathParameters.year}/month/${params.pathParameters.month}/day/${params.pathParameters.day}/all`, params.data)
    return data.data
}

   
// GET : application/json
// 列示等待我确认的会议.
export async function meetingActionListWaitConfirm (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/wait/confirm`, params.data)
    return data.data
}


// pathParameters
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日
// roomId: String: 会议室记录ID   
// GET : application/json
// 列示指定会议室id、指定日期的会议.
export async function meetingActionListOnDayByRoomID (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.pathParameters.year}/month/${params.pathParameters.month}/day/${params.pathParameters.day}/${params.pathParameters.roomId}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示我受到邀请的已经拒绝的会议.
export async function meetingActionLisInvitedRejected (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/rejected`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识
// count: Integer: 数量   
// GET : application/json
// 列示Meeing对象,上一页.仅管理员可用
export async function meetingActionListPrev (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// GET : application/json
// 等待我确认是否参加的会议.
export async function meetingActionListWaitAccept (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/wait/accept`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识
// count: Integer: 数量   
// GET : application/json
// 列示Meeting对象,下一页.仅管理员可用
export async function meetingActionListNext (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日   
// GET : application/json
// 列示我参与的指定日期的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
export async function meetingActionListOnDay (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.pathParameters.year}/month/${params.pathParameters.month}/day/${params.pathParameters.day}`, params.data)
    return data.data
}


// pathParameters
// monthCount: Integer: 制定月数   
// GET : application/json
// 列示当前用户从当前时间开始指定月数内需要参与的会议
export async function meetingActionListForwardMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/forward/monthcount/${params.pathParameters.monthCount}`, params.data)
    return data.data
}


// pathParameters
// year: Integer: 年
// month: Integer: 月   
// GET : application/json
// 列示我参与的指定日期当月的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
export async function meetingActionListOnMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.pathParameters.year}/month/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// year: Integer: 年
// month: Integer: 月   
// GET : application/json
// 列示当月所有的会议.
export async function meetingActionListOnMonthAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.pathParameters.year}/month/${params.pathParameters.month}/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// GET : application/json
// 获取指定会议内容.
export async function meetingActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议标识   
// DELETE : application/json
// 删除会议.
export async function meetingActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 根据拼音或者首字母进行模糊查询.
export async function roomActionListLikePinyin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/like/pinyin/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识 
// formParameters
// file: File: Excel文件  
// POST : multipart/form-data
// 设置会议室照片.
export async function roomActionSetPhoto (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.pathParameters.id}/photo`, params.data)
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 根据名称进行模糊查询.
export async function roomActionListLike (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/like/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议室标识   
// ins
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// name: String: 名称,不可重名.
// building: String: 所属building.
// floor: Integer: 所属楼层.
// roomNumber: String: 房号.
// phoneNumber: String: 分机号.
// device: String: 设备内容.
// photo: String: 照片.
// capacity: Integer: 会议室容量
// auditor: String: 会议室申请审核人
// available: Boolean: 会议室状态,可用,不可用
// PUT : application/json
// 更新Room.
export async function roomActionEdit (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// key: String: 拼音首字母   
// GET : application/json
// 获取拼音首字母开始的.
export async function roomActionListPinyinInitial (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/pinyininitial/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议室标识   
// GET : application/json
// 获取指定的会议室.
export async function roomActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有的会议室.
export async function roomActionList (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 会议室标识   
// DELETE : application/json
// 删除Room.
export async function roomActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// pinyin: String: name拼音.
// pinyinInitial: String: name拼音首字母.
// name: String: 名称,不可重名.
// building: String: 所属building.
// floor: Integer: 所属楼层.
// roomNumber: String: 房号.
// phoneNumber: String: 分机号.
// device: String: 设备内容.
// photo: String: 照片.
// capacity: Integer: 会议室容量
// auditor: String: 会议室申请审核人
// available: Boolean: 会议室状态,可用,不可用
// POST : application/json
// 创建Room.
export async function roomActionCreate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
