
   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// fileId: String: 文档id 
// formParameters
// file: File: 上传文件
// fileName: String: 文件名称  
// POST : multipart/form-data
// 更新文档附件
export async function onlyofficeActionUpdateFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.pathParameters.fileId}/update/file`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 
// size: Integer:    
// ins
// fileId: String: 文件名Id
// fileName: String: 文件名
// creator: String: 创建者
// startTime: Date: 开始时间
// endTime: Date: 结束时间
// category: String: 文档分类
// docId: String: 关联文档Id
// sortField: String: 排序字段(createTime|creator)
// sortType: String: 排序(desc|asc)
// POST : application/json
// 文档列表分页显示
export async function onlyofficeActionListPaging (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

 
// formParameters
// category: String: 文档类型
// file: File: 上传文件
// fileName: String: 文件名称
// relevanceId: String: 关联文档id  
// POST : multipart/form-data
// 上传文件并自动转换
export async function onlyofficeActionUpload (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/upload`, params.data)
    return data.data
}

   
// ins
// appToken: String: 临时秘钥
// fileId: String: 文件Id
// extendParam: Map<String,String>: 扩展参数，key:value对象
// POST : application/json
// 集成应用文件预览.
export async function onlyofficeActionPreview (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/preview`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: String: 文档版本   
// GET : application/json
// 获取加水印的文件正文内容
export async function onlyofficeActionGetMarkFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/markfile/${params.pathParameters.flag}/${params.pathParameters.version}`, params.data)
    return data.data
}

   
// ins
// appToken: String: 临时秘钥
// fileId: String: 文件Id
// mode: String: 编辑模式：edit(默认)|view
// extendParam: Map<String,String>: 扩展参数，key:value对象
// POST : application/json
// 集成应用文件编辑.
export async function onlyofficeActionAppFileEdit (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/app/file/edit`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// appToken: String: 应用ID
// workId: String: *流程Work、WorkCompleted或内容管理文档的id.
// fileName: String: *文件名称,带扩展名的文件名.
// site: String: *附件分类.
// tempId: String: 模板文件ID,为空或不存在就取空模板.
// POST : application/json
// 流程平台或者内容管理创建在线编辑文档.
export async function onlyofficeActionCreateForO2 (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/create/for/o2`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// tokenText: String: 加密文本，json字符串
// POST : application/json
// 根据传入内容生成only office的token
export async function onlyofficeActionToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/token`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 文档id   
// GET : application/json
// 获取文件信息
export async function onlyofficeActionGetInfo (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.pathParameters.flag}/info`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id   
// GET : application/json
// 获取文件编辑配置内容
export async function onlyofficeActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// url: String: 文件url
// userId: String: 用户userId
// fileType: String: 文件类型(docx|xlsx|pptx)
// fileName: String: 文件名
// POST : application/json
// 获取url预览.
export async function onlyofficeActionUrl (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/url`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 文档id   
// DELETE : application/json
// 删除文档.
export async function onlyofficeActionDelete (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/delete/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: String: 文档版本  
// queryParameters
// fileName: String: 文档名称(可选) 
// GET : application/json
// 获取正文文件
export async function onlyofficeActionGetFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/file/${params.pathParameters.flag}/${params.pathParameters.version}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}

   
// ins
// fileName: String: 文件名
// sampleName: String: 模板id
// fileType: String: 文件类型(docx|xlsx|pptx)
// relevanceId: String: 关联文档id
// category: String: 文档分类
// POST : application/json
// 创建文档.
export async function onlyofficeActionCreate (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/create`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: String: 文档版号   
// GET : application/json
// 获取文件编辑配置内容按版本
export async function onlyofficeActionGetVersion (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.pathParameters.flag}/${params.pathParameters.version}`, params.data)
    return data.data
}

   
// ins
// filesizeMax: String: 最大文件大小
// timeout: String: 超时时间
// storageFolder: String: 文件存储路径
// storageFolderTemplate: String: 文件模板存储路径
// storageFolderIndex: String: 文件索引存储路径
// storageFolderMark: String: 文件转pdf存储路径
// docbuilderEXEPath: String: 文件转换程序路径
// docserviceViewedDocs: String: 查看文件类型
// docserviceEditedDocs: String: 编辑文件类型
// docserviceConvertDocs: String: 转换文件类型
// docserviceConverter: String: onlyoffice转换地址
// docserviceTempstorage: String: onlyoffice临时存储路径
// docserviceApi: String: onlyoffice前端api地址
// docservicePreloader: String: onlyoffice前端刷新地址
// secret: String: 密钥，可为空
// downLoadUrl: String: 附件下载地址(供onlyOffice下载附件,配置到应用上下文即可，能用内网访问则配内网地址)
// ipWhiteList: String: 文件下载允许ip，多值逗号分隔。可为空，表示全允许
// gobackUrl: String: 回退地址
// POST : application/json
// 保存配置数据
export async function onlyofficeConfigActionSaveConfig (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/save`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取配置信息
export async function onlyofficeConfigActionGetConfig (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/get`, params.data)
    return data.data
}

   
// GET : application/json
// 刷新配置信息
export async function onlyofficeConfigActionRefresh (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/refresh`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: Integer: 文档版本   
// GET : application/json
// 获取文件正文内容的changes.zip
export async function onlyofficeFileActionGetFileDiff (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.pathParameters.flag}/${params.pathParameters.version}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: Integer: 文档版本   
// GET : application/json
// 获取文件正文内容的changes.zip
export async function onlyofficeFileActionGetFileDiffWithName (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.pathParameters.flag}/${params.pathParameters.version}/changes.zip`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: Integer: 文档版本
// token: String: 文档访问token   
// GET : application/json
// 获取文件正文内容的diff.zip
export async function onlyofficeFileActionGetFileDiffToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.pathParameters.flag}/${params.pathParameters.version}/${params.pathParameters.token}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: Integer: 文档版本
// token: String: 文档访问token   
// GET : application/json
// 获取文件正文内容
export async function onlyofficeFileActionGetFileToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/${params.pathParameters.flag}/${params.pathParameters.version}/${params.pathParameters.token}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id
// version: Integer: 文档版本(0待办最新版本)  
// queryParameters
// fileName: String: 文档名称(可选) 
// GET : application/json
// 获取文件正文内容
export async function onlyofficeFileActionGetFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/${params.pathParameters.flag}/${params.pathParameters.version}?fileName=${params.queryParameters.fileName }`, params.data)
    return data.data
}


// pathParameters
// flag: String: 文档id   
// ins
// type: String: 使用终端类型
// documentType: String: 文件类型
// document: Document: 文档属性
// editorConfig: EditorConfig: 文档编辑属性
// POST : application/json
// 获取文档访问token
export async function onlyofficeTokenActionCreateToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficetoken/createtoken/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
