
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// recordId: String: 导入记录标识   
// GET : application/json
// 获取导入记录.
export async function importModelActionGetRecord (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/record/${params.pathParameters.recordId}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 导入模型标识
// queryFlag: String: 查询标识   
// GET : application/json
// 根据查询获取导入模型对象.
export async function importModelActionGetWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}

   
// GET : application/json
// 生成唯一编码.
export async function importModelActionGetUUID (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/uuid`, params.data)
    return data.data
}


// pathParameters
// recordId: String: 导入记录标识   
// GET : application/json
// 重新导入失败的记录(执行导入是异步过程，请关注记录的状态).
export async function importModelActionReExecuteRecord (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/execute/record/${params.pathParameters.recordId}`, params.data)
    return data.data
}


// pathParameters
// recordId: String: 导入记录标识   
// GET : application/json
// 获取导入记录的执行状态.
export async function importModelActionGetRecordStatus (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/record/${params.pathParameters.recordId}/status`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// modelId: String: 导入模型ID.
// status: String: 状态：待导入|导入中|导入成功|部分成功|导入失败.
// POST : application/json
// 导入记录分页查询.
export async function importModelActionRecordListPaging (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/list/record/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// recordId: String: 导入记录标识   
// DELETE : application/json
// 删除导入记录.
export async function importModelActionDeleteRecord (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/record/${params.pathParameters.recordId}`, params.data)
    return data.data
}


// pathParameters
// queryFlag: String: 查询标识   
// GET : application/json
// 根据查询列示导入模型对象.
export async function importModelActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/list/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// recordId: String: 导入记录ID.
// status: String: 状态：导入成功|导入失败.
// POST : application/json
// 导入记录明细分页查询.
export async function importModelActionRecordItemListPaging (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/list/record/item/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// recordId: String: 导入记录标识   
// GET : application/json
// 删除导入记录mockdeletetoget.
export async function importModelActionDeleteRecordMockDeleteToGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/record/${params.pathParameters.recordId}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取导入模型.
export async function importModelActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 导入模型标识   
// ins
// recordId: String: 导入记录ID.
// data: JsonElement: 数据.
// POST : application/json
// 执行数据导入(执行导入是异步过程，请关注记录的状态)
export async function importModelActionExecute (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/importmodel/${params.pathParameters.id}/execute`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// flag: String: 标识.
// category: String: 分类.
// person: String: 指定用户.
// filterCategory: String: 过滤分类.
// filterType: String: 过滤类型.
// filterKey: String: 过滤目录类型.
// count: Integer: 返回数量.
// POST : application/json
// 相似查找.
export async function moreLikeThisActionPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/morelikethis`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// modelFlag: String: 项目标识
// workId: String: 工作标识   
// GET : application/json
// 神经网络计算.
export async function neuralActionListCalculate (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/neural/list/calculate/model/${params.pathParameters.modelFlag}/work/${params.pathParameters.workId}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/openapi`, params.data)
    return data.data
}

   
// GET : application/json
// 获取可见的应用,同时判断应用下有可见的流程.
export async function queryActionListWithPerson (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/query/list`, params.data)
    return data.data
}


// pathParameters
// key: String: 关键字   
// GET : application/json
// 获取可见的应用,同时判断应用下有可见的流程,并进行流程的名称匹配.
export async function queryActionListWithPersonLike (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/query/list/key/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 应用标识   
// GET : application/json
// 获取指定的Application信息,并在Control段附带其操作权限.
export async function queryActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/query/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// query: String: 搜索内容.
// page: Integer: 分页.
// size: Integer: 数量.
// person: String: 人员.
// filterList: List<Filter>: 过滤条件.
// POST : application/json
// POST方法执行搜索.
export async function searchActionPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/search`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 统计标识
// queryFlag: String: 查询标识   
// GET : application/json
// 根据查询获取统计对象.
export async function statActionGetWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// person: String: 当前用户
// unitList: List<String>: 组织
// groupList: List<String>: 群组
// roleList: List<String>: 角色
// unitAllList: List<String>: 所有群组
// identityList: List<String>: 身份
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// PUT : application/json
// 执行指定查询和统计名的统计
export async function statActionExecuteWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/execute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// queryFlag: String: 查询标识   
// GET : application/json
// 根据查询列示统计对象.
export async function statActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/list/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// person: String: 当前用户
// unitList: List<String>: 组织
// groupList: List<String>: 群组
// roleList: List<String>: 角色
// unitAllList: List<String>: 所有群组
// identityList: List<String>: 身份
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// POST : application/json
// 执行统计MockPutToPost
export async function statActionExecuteMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/${params.pathParameters.id}/execute/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// person: String: 当前用户
// unitList: List<String>: 组织
// groupList: List<String>: 群组
// roleList: List<String>: 角色
// unitAllList: List<String>: 所有群组
// identityList: List<String>: 身份
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// POST : application/json
// 执行指定查询和统计名的统计MockPutToPost
export async function statActionExecuteWithQueryMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/execute/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取统计内容.
export async function statActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// person: String: 当前用户
// unitList: List<String>: 组织
// groupList: List<String>: 群组
// roleList: List<String>: 角色
// unitAllList: List<String>: 所有群组
// identityList: List<String>: 身份
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// PUT : application/json
// 执行统计
export async function statActionExecute (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/stat/${params.pathParameters.id}/execute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取语句的格式.
export async function statementActionGetFormat (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/statement/${params.pathParameters.id}/format`, params.data)
    return data.data
}


// pathParameters
// queryFlag: String: 查询标识   
// ins
// hasView: Boolean: 是否只查询含有视图的语句.
// POST : application/json
// 根据查询列示语句对象.
export async function statementActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/statement/list/query/${params.pathParameters.queryFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识
// mode: String: 执行模式：data|count|all
// page: Integer: 页码
// size: Integer: 每页数量   
// ins
// filterList: List<FilterEntry>: 过滤条件.
// parameter: Map<String,Object>: 参数.
// POST : application/json
// 执行语句V2,可以同时执行查询结果及查询总数.
export async function statementActionExecuteV2 (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/statement/${params.pathParameters.flag}/execute/mode/${params.pathParameters.mode}/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取语句内容.
export async function statementActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/statement/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识
// page: Integer: 页码
// size: Integer: 每页数量   
// POST : application/json
// V8版本新版本查询语句,取消mode参数,增加自动count,增加自动内置参数判断,替换V2版本.
export async function statementActionExecute (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/statement/${params.pathParameters.flag}/execute/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// orderBy: String: 排序字段，默认根据创建时间排序
// descOrder: Boolean: 是否倒叙排序,默认倒叙
// POST : application/json
// 分页列示表中的数据
export async function tableActionListRowPaging (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/table/${params.pathParameters.tableFlag}/row/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示Table对象.
export async function tableActionListPaging (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// ins
// where: String: 查询条件，格式为jpql语法,o.name='zhangsan'，允许为空
// orderBy: String: 排序条件，格式为：o.updateTime desc，允许为空
// size: Integer: 返回结果集数量,允许为空
// POST : application/json
// 根据条件获取表中的数据
export async function tableActionListRowSelect (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.tableFlag}/row/select`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// POST : application/json
// 指定表中插入一行数据.
export async function tableActionRowInsertOne (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/one`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表对象,下一页.
export async function tableActionListNext (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Stat对象,上一页.
export async function tableActionListPrev (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// where: String: where语句   
// GET : application/json
// 通过where 统计数量
export async function tableActionRowCountWhere (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/count/where/${params.pathParameters.where}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// GET : application/json
// 获取表中某一行数据
export async function tableActionRowGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// where: String: where语句   
// GET : application/json
// 通过where 获取表中的数据,格式为jpql语法,o.name='zhangsan'
export async function tableActionListRowSelectWhere (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.tableFlag}/row/select/where/${params.pathParameters.where}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// POST : application/json
// 指定表中插入数据.
export async function tableActionRowInsert (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// DELETE : application/json
// 更新指定表中指定行数据.
export async function tableActionRowDeleteAll (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/delete/all`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表中的行对象,下一页.
export async function tableActionListRowNext (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表中的行对象,上一页.
export async function tableActionListRowPrev (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/list/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// PUT : application/json
// 更新指定表中指定行数据.
export async function tableActionRowUpdate (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// DELETE : application/json
// 更新指定表中指定行数据.
export async function tableActionRowDelete (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/reload/dynamic`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// POST : application/json
// 更新指定表中指定行数据 MockPutToPost.
export async function tableActionRowUpdateMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/mockputtopost`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// GET : application/json
// 更新指定表中指定行数据MockDeleteToGet.
export async function tableActionRowDeleteAllMockDeleteToGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/delete/all/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// GET : application/json
// 更新指定表中指定行数据MockDeleteToGet.
export async function tableActionRowDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 根据标识获取表.
export async function tableActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/table/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 对象标识   
// GET : application/json
// 导出Excel的执行结果.
export async function viewActionExcelResult (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/excel/result/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// GET : application/json
// 根据query获取view对象.
export async function viewActionGetWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// excelName: String: excel导出名称，默认为视图名称
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// PUT : application/json
// 将视图执行结果作为Excel导出
export async function viewActionExcel (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/excel`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// PUT : application/json
// 执行view
export async function viewActionExecuteWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/execute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// excelName: String: excel导出名称，默认为视图名称
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// POST : application/json
// 将视图执行结果作为Excel导出 MockPutToPost
export async function viewActionExcelMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/excel/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// excelName: String: excel导出名称，默认为视图名称
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// PUT : application/json
// 将视图执行结果作为Excel导出
export async function viewActionExcelWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/excel`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// PUT : application/json
// 列示按查询和视图标识执行后的bundle列表
export async function viewActionBundleWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/bundle`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// queryFlag: String: 查询标识   
// GET : application/json
// 根据query列示view对象.
export async function viewActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/list/query/${params.pathParameters.queryFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// POST : application/json
// 列示按查询和视图标识执行后的bundle列表 MockPutToPost
export async function viewActionBundleWithQueryMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/bundle/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// POST : application/json
// 执行view MockPutToPost
export async function viewActionExecuteMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/execute/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// POST : application/json
// 列示执行后的bundle列表 MockPutToPost
export async function viewActionBundleMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/bundle/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// excelName: String: excel导出名称，默认为视图名称
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// POST : application/json
// 将视图执行结果作为Excel导出 MockPutToPost
export async function viewActionExcelWithQueryMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/excel/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 视图标识
// queryFlag: String: 查询标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// POST : application/json
// 执行view MockPutToPost
export async function viewActionExecuteWithQueryMockPutToPost (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/flag/${params.pathParameters.flag}/query/${params.pathParameters.queryFlag}/execute/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取View内容.
export async function viewActionGet (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// PUT : application/json
// 列示执行后的bundle列表
export async function viewActionBundle (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/bundle`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// PUT : application/json
// 执行view
export async function viewActionExecute (params) {
    const {data} = await request(`/x_query_assemble_surface/jaxrs/view/${params.pathParameters.id}/execute`, JSON.stringify(params.data))
    return data.data
}
