
// 移动办公MOA点单登录.
// token: String: 单点票据
// enterId: String: 企业ID
// GET
export async function andFxActionMoaSso (params) {
    const {data} = await request(`jaxrs/andfx/moa/sso/token/${params.token}/enter/${params.enterId}`)
    return data.data
}


// 获取登录二维码.
// DELETE
export async function authenticationActionLogout (params) {
    const {data} = await request(`jaxrs/authentication`, params)
    return data.data
}


// 通过二维码进行登录.
// meta: String: 认证序列号
// POST
export async function authenticationActionLogin (params) {
    const {data} = await request(`jaxrs/authentication`, params)
    return data.data
}


// 二维码用户录入.
// meta: String: 认证序列号
// GET
export async function authenticationActionDingdingOauthConfig (params) {
    const {data} = await request(`jaxrs/authentication/oauth/dingding/config`)
    return data.data
}


// 获取图片验证码.
// width: Integer: 图片验证码宽度
// height: Integer: 图片验证码高度
// GET
export async function authenticationActionCaptchaRSAPublicKey (params) {
    const {data} = await request(`jaxrs/authentication/captchaRSAPublicKey`)
    return data.data
}


// 用户登录.credential=xxxx,password=xxxx,使用图片验证码验证.
// GET
export async function authenticationActionQiyeweixinOauthConfig (params) {
    const {data} = await request(`jaxrs/authentication/oauth/qywx/config`)
    return data.data
}


// 获取公钥publicKey
// POST
export async function authenticationActionSwitchUserMockPutToPost (params) {
    const {data} = await request(`jaxrs/authentication/switchuser/mockputtopost`, params)
    return data.data
}


// 检查用户名是否存在.
// credential: String: 凭证
// GET
export async function authenticationActionLogoutMockDeleteToGet (params) {
    const {data} = await request(`jaxrs/authentication/mockdeletetoget`)
    return data.data
}


// 获取短信验证码.
// credential: String: 凭证
// POST
export async function authenticationActionCaptchaLogin (params) {
    const {data} = await request(`jaxrs/authentication/captcha`, params)
    return data.data
}


// 用户登录.credential=xxxx,codeAnswer=xxxx,使用短信验证码登录.
// POST
export async function authenticationActionCodeLogin (params) {
    const {data} = await request(`jaxrs/authentication/code`, params)
    return data.data
}


// 钉钉oauth登录认证配置
// GET
export async function authenticationActionCheckCredential (params) {
    const {data} = await request(`jaxrs/authentication/check/credential/${params.credential}`)
    return data.data
}


// 用户登录.credential=xxxx,password=xxxx
// GET
export async function authenticationActionCaptcha (params) {
    const {data} = await request(`jaxrs/authentication/captcha/width/${params.width}/height/${params.height}`)
    return data.data
}


// 用户注销.
// GET
export async function authenticationActionOauth (params) {
    const {data} = await request(`jaxrs/authentication/oauth/name/${params.name}`)
    return data.data
}


// 用户注销 MockDeleteToGet.
// GET
export async function authenticationActionOauthLoginDingding (params) {
    const {data} = await request(`jaxrs/authentication/oauth/login/dingding/code/${params.code}`)
    return data.data
}


// 获取当前可用的登录模式.
// GET
export async function authenticationActionOauthBind (params) {
    const {data} = await request(`jaxrs/authentication/oauth/bind/name/${params.name}/code/${params.code}/redirecturi/${params.redirectUri}`)
    return data.data
}


// oauth登录认证地址
// name: String: oauthClient名称
// GET
export async function authenticationActionOauthLoginQywx (params) {
    const {data} = await request(`jaxrs/authentication/oauth/login/qywx/code/${params.code}`)
    return data.data
}


// oauth账户绑定.
// name: String: oauthClient名称
// code: String: code
// redirectUri: String: redirectUri
// GET
export async function authenticationActionSafeLogout (params) {
    const {data} = await request(`jaxrs/authentication/safe/logout`)
    return data.data
}


// oauth登录认证地址
// GET
export async function authenticationActionOauthLogin (params) {
    const {data} = await request(`jaxrs/authentication/oauth/login/name/${params.name}/code/${params.code}/redirecturi/${params.redirectUri}`)
    return data.data
}


// oauth登录认证
// name: String: oauthClient名称
// code: String: code
// redirectUri: String: redirectUri
// PUT
export async function authenticationActionSwitchUser (params) {
    const {data} = await request(`jaxrs/authentication/switchuser`, params)
    return data.data
}


// 钉钉oauth登录
// code: String: code
// GET
export async function authenticationActionBindLogin (params) {
    const {data} = await request(`jaxrs/authentication/bind/meta/${params.meta}`)
    return data.data
}


// 企业微信oauth登录
// code: String: code
// GET
export async function authenticationActionOauthList (params) {
    const {data} = await request(`jaxrs/authentication/oauth/list`)
    return data.data
}


// 企业微信oauth登录认证配置
// POST
export async function authenticationActionBindMeta (params) {
    const {data} = await request(`jaxrs/authentication/bind/meta/${params.meta}`, params)
    return data.data
}


// 安全注销用户,该用户所有session全部过期.
// GET
export async function authenticationActionMode (params) {
    const {data} = await request(`jaxrs/authentication/mode`)
    return data.data
}


// 切换当前用户,需要系统管理员权限.
// GET
export async function authenticationActionWho (params) {
    const {data} = await request(`jaxrs/authentication`)
    return data.data
}


// 切换当前用户,需要系统管理员权限 MockPutToPost.
// GET
export async function authenticationActionCode (params) {
    const {data} = await request(`jaxrs/authentication/code/credential/${params.credential}`)
    return data.data
}


// 获取当前用户,如果是未登录用户返回anonymous
// GET
export async function authenticationActionBind (params) {
    const {data} = await request(`jaxrs/authentication/bind`)
    return data.data
}


// 列示所有绑定对象.
// GET
export async function bindActionListNext (params) {
    const {data} = await request(`jaxrs/bind/list`)
    return data.data
}


// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}


// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}


// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}


// 钉钉点单登录.
// code: String: 登录code
// GET
export async function dingdingActionGetLogin (params) {
    const {data} = await request(`jaxrs/dingding/code/${params.code}`)
    return data.data
}


// 钉钉获取jsticket等信息.
// POST
export async function dingdingActionInfo (params) {
    const {data} = await request(`jaxrs/dingding/info`, params)
    return data.data
}


// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}


// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}


// 绑定微信公众号openid到当前登录用户.
// code: String: 码
// GET
export async function mPweixinActionBindWithCode (params) {
    const {data} = await request(`jaxrs/mpweixin/bind/code/${params.code}`)
    return data.data
}


// 微信公众号code登录.
// code: String: 码
// GET
export async function mPweixinActionLoginWithCode (params) {
    const {data} = await request(`jaxrs/mpweixin/login/code/${params.code}`)
    return data.data
}


// 测试发送模版消息
// person: String: 人员
// POST
export async function mPweixinActionTestSendMessage (params) {
    const {data} = await request(`jaxrs/mpweixin/menu/test/send/to/${params.person}`, params)
    return data.data
}


// GET方法实现oauth认证auth方法
// GET
export async function oauthActionGetInfo (params) {
    const {data} = await request(`jaxrs/oauth/info`)
    return data.data
}


// GET方法实现oauth认证info方法.
// GET
export async function oauthActionGetToken (params) {
    const {data} = await request(`jaxrs/oauth/token`)
    return data.data
}


// GET方法实现oauth认证info方法,适配jira.
// POST
export async function oauthActionPostToken (params) {
    const {data} = await request(`jaxrs/oauth/token`, params)
    return data.data
}


// GET方法实现oauth认证token方法
// POST
export async function oauthActionPostTokenJira (params) {
    const {data} = await request(`jaxrs/oauth/token/jira`, params)
    return data.data
}


// POST方法实现oauth认证info方法.
// GET
export async function oauthActionGetInfoJira (params) {
    const {data} = await request(`jaxrs/oauth/info/jira`)
    return data.data
}


// POST方法实现oauth认证info方法,适配jira.
// POST
export async function oauthActionPostInfo (params) {
    const {data} = await request(`jaxrs/oauth/info`, params)
    return data.data
}


// POST方法实现oauth认证token方法
// POST
export async function oauthActionPostInfoJira (params) {
    const {data} = await request(`jaxrs/oauth/info/jira`, params)
    return data.data
}


// POST方法实现oauth认证token方法,适配jira.
// GET
export async function oauthActionAuth (params) {
    const {data} = await request(`jaxrs/oauth/auth`)
    return data.data
}


// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}


// 企业微信点单登录.
// code: String: 码
// GET
export async function qiyeweixinActionUpdatePersonInfoFromQywx (params) {
    const {data} = await request(`jaxrs/qiyeweixin/update/person/detail/${params.code}`)
    return data.data
}


// 企业微信获取用户详细信息.
// code: String: 码
// GET
export async function qiyeweixinActionGetLogin (params) {
    const {data} = await request(`jaxrs/qiyeweixin/code/${params.code}`)
    return data.data
}


// GET方法,进行3DES加密,用于不方便进行加密的场景.
// client: String: 标识
// key: String: 口令
// credential: String: 凭证
// GET
export async function ssoActionGetEncrypt (params) {
    const {data} = await request(`jaxrs/sso/encrypt/client/${params.client}/key/${params.key}/credential/${params.credential}`)
    return data.data
}


// GET方法,使用token进行Sso登陆。格式加密后的credential#1970年毫秒数
// client: String: 标识
// token: String: 令牌
// POST
export async function ssoActionPostLogin (params) {
    const {data} = await request(`jaxrs/sso`, params)
    return data.data
}


// POST方法,进行3DES加密,用于不方便进行加密的场景.
// GET
export async function ssoActionGetLogin (params) {
    const {data} = await request(`jaxrs/sso/client/${params.client}/token/${params.token}`)
    return data.data
}


// POST方法,使用token进行Sso登陆。格式加密后的credential#1970年毫秒数
// POST
export async function ssoActionPostEncrypt (params) {
    const {data} = await request(`jaxrs/sso/encrypt`, params)
    return data.data
}


// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}


// WeLink单点登录.
// code: String: 登录code
// GET
export async function weLinkActionGetLogin (params) {
    const {data} = await request(`jaxrs/welink/code/${params.code}`)
    return data.data
}


// 钉钉点单登录.
// code: String: 登录code
// GET
export async function zhengwuDingdingActionGetLogin (params) {
    const {data} = await request(`jaxrs/zhengwudingding/code/${params.code}`)
    return data.data
}


// 钉钉获取jsticket等信息.
// POST
export async function zhengwuDingdingActionInfo (params) {
    const {data} = await request(`jaxrs/zhengwudingding/info`, params)
    return data.data
}

