
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 指定内容管理文档创建关联内容.
// document: String: 内容管理文档标识
// GET
export async function correlationActionListTypeCms (params) {
    const {data} = await request(`jaxrs/correlation/list/type/cms/document/${params.document}`)
    return data.data
}

    
// 指定流程平台工作或已完成工作创建关联内容.
// job: String: 流程平台任务标识
// POST
export async function correlationActionCreateTypeCms (params) {
    const {data} = await request(`jaxrs/correlation/type/cms/document/${params.document}`, params)
    return data.data
}

    
// 根据id删除多个内容管理关联内容.
// document: String: 流程平台任务标识
// POST
export async function correlationActionDeleteTypeCms (params) {
    const {data} = await request(`jaxrs/correlation/delete/type/cms/document/${params.document}`, params)
    return data.data
}

    
// 根据id删除多个流程平台关联内容.
// job: String: 流程平台任务标识
// POST
export async function correlationActionReadableTypeCms (params) {
    const {data} = await request(`jaxrs/correlation/readable/type/cms`, params)
    return data.data
}

    
// 列示内容管理指定document标识的关联内容.
// document: String: 内容管理文档标识
// POST
export async function correlationActionCreateTypeProcessPlatform (params) {
    const {data} = await request(`jaxrs/correlation/type/processplatform/job/${params.job}`, params)
    return data.data
}

    
// 列示内容管理指定document标识指定关联内容框标识的关联内容.
// document: String: 内容管理文档标识
// site: String: 关联内容框标识
// POST
export async function correlationActionReadableTypeProcessPlatform (params) {
    const {data} = await request(`jaxrs/correlation/readable/type/processplatform`, params)
    return data.data
}

    
// 列示流程平台指定job标识的关联内容.
// job: String: 任务标识
// POST
export async function correlationActionDeleteTypeProcessPlatform (params) {
    const {data} = await request(`jaxrs/correlation/delete/type/processplatform/job/${params.job}`, params)
    return data.data
}

    
// 列示流程平台指定job标识指定关联内容框标识的关联内容.
// job: String: 任务标识
// site: String: 关联内容框标识
// GET
export async function correlationActionListTypeProcessPlatform (params) {
    const {data} = await request(`jaxrs/correlation/list/type/processplatform/job/${params.job}`)
    return data.data
}

    
// 判断内容平台指定document的任务是否通过被关联具有阅读权限.
// GET
export async function correlationActionListTypeCmsWithSite (params) {
    const {data} = await request(`jaxrs/correlation/list/type/cms/document/${params.document}/site/${params.site}`)
    return data.data
}

    
// 判断流程平台指定job的任务是否通过被关联具有阅读权限.
// GET
export async function correlationActionListTypeProcessPlatformWithSite (params) {
    const {data} = await request(`jaxrs/correlation/list/type/processplatform/job/${params.job}/site/${params.site}`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    