
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 修改已经存在的热点图片的标题信息
// PUT
export async function hotPictureInfoActionListForPage (params) {
    const {data} = await request(`jaxrs/user/hotpic/filter/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 根据应用类型以及信息ID删除热图信息
// application: String: 应用标识
// infoId: String: 信息标识
// GET
export async function hotPictureInfoActionExistsCheck (params) {
    const {data} = await request(`jaxrs/user/hotpic/exists/check`)
    return data.data
}

    
// 根据ID删除指定的热图信息
// id: String: 信息标识
// POST
export async function hotPictureInfoActionChangeTitle (params) {
    const {data} = await request(`jaxrs/user/hotpic/changeTitle`, params)
    return data.data
}

    
// 检查所有的热点新闻还在不在
// GET
export async function hotPictureInfoActionListByApplicationAndInfoId (params) {
    const {data} = await request(`jaxrs/user/hotpic/${params.application}/${params.infoId}`)
    return data.data
}

    
// 查询指定的图片的base64编码
// id: String: 热图信息id
// GET
export async function hotPictureInfoActionGet (params) {
    const {data} = await request(`jaxrs/user/hotpic/${params.id}`)
    return data.data
}

    
// 根据应用类型以及信息ID查询热图信息
// application: String: 应用名称：CMS|BBS等等.
// infoId: String: 信息id
// DELETE
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`jaxrs/user/hotpic/${params.application}/${params.infoId}`, params)
    return data.data
}

    
// 列示根据过滤条件的HotPictureInfo,下一页
// page: Integer: 当前页码
// count: Integer: 每页数量
// DELETE
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`jaxrs/user/hotpic/${params.id}`, params)
    return data.data
}

    
// 创建新的热图信息或者更新热图信息
// POST
export async function hotPictureInfoActionSave (params) {
    const {data} = await request(`jaxrs/user/hotpic`, params)
    return data.data
}

    
// 根据BBS主贴ID删除热点信息
// id: String: BBS主贴ID
// DELETE
export async function hotPictureInfoCipherActionDeleteBBS (params) {
    const {data} = await request(`jaxrs/cipher/hotpic/bbs/${params.id}`, params)
    return data.data
}

    
// 根据CMS文档ID删除热点信息
// id: String: CMS文档ID
// PUT
export async function hotPictureInfoCipherActionListForPage (params) {
    const {data} = await request(`jaxrs/cipher/hotpic/filter/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 根据ID获取单个热图信息
// id: String: 热图信息id
// DELETE
export async function hotPictureInfoCipherActionDeleteCms (params) {
    const {data} = await request(`jaxrs/cipher/hotpic/cms/${params.id}`, params)
    return data.data
}

    
// 列示根据过滤条件的HotPictureInfo,下一页
// page: Integer: 当前页码
// count: Integer: 每页数量
// GET
export async function hotPictureInfoCipherActionGet (params) {
    const {data} = await request(`jaxrs/cipher/hotpic/${params.id}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    