
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 绑定设备
// GET
export async function deviceActionListAllByPushType (params) {
    const {data} = await request(`jaxrs/device/list/${params.pushType}`)
    return data.data
}

    
// 检查设备是否已经绑定
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios
// pushType: String: 推送通道类型：jpush|huawei
// DELETE
export async function deviceActionRemoveBind (params) {
    const {data} = await request(`jaxrs/device/unbind/${params.deviceName}/${params.deviceType}`, params)
    return data.data
}

    
// 查询推送通道类型，jpush|huawei
// GET
export async function deviceActionCheckBind (params) {
    const {data} = await request(`jaxrs/device/check/${params.deviceName}/${params.deviceType}/${params.pushType}`)
    return data.data
}

    
// 获取当前用户所有绑定设备
// pushType: String: 推送通道类型：jpush|huawei
// GET
export async function deviceActionRemoveBindNew (params) {
    const {data} = await request(`jaxrs/device/unbind/new/${params.deviceName}/${params.deviceType}/${params.pushType}`)
    return data.data
}

    
// 设备解除绑定
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios
// GET
export async function deviceActionConfigPushType (params) {
    const {data} = await request(`jaxrs/device/config/push/type`)
    return data.data
}

    
// 设备解除绑定，新版增加pushType字段
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios
// pushType: String: 推送通道类型：jpush|huawei
// POST
export async function deviceActionBind (params) {
    const {data} = await request(`jaxrs/device/bind`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 发送消息
// POST
export async function messageActionSendMessage (params) {
    const {data} = await request(`jaxrs/message/send`, params)
    return data.data
}

    
// 测试发送消息
// POST
export async function messageActionSendMessageTest (params) {
    const {data} = await request(`jaxrs/message/test/send`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    