
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 根据ID删除一个目录，如果目录是非空目录，则无法删除）
// id: String: 文件夹ID
// PUT
export async function mindFolderInfoActionMoveMindAndFolder (params) {
    const {data} = await request(`jaxrs/folder/move/${params.folderId}`, params)
    return data.data
}

    
// 根据ID强制删除一个目录，包括下级目录以及文件
// id: String: 文件夹ID
// POST
export async function mindFolderInfoActionSaveFolder (params) {
    const {data} = await request(`jaxrs/folder/save`, params)
    return data.data
}

    
// 将指定的脑图和文件夹移动到指定的文件夹内
// folderId: String: 文件夹ID
// DELETE
export async function mindFolderInfoActionFolderDeleteForce (params) {
    const {data} = await request(`jaxrs/folder/${params.id}/force`, params)
    return data.data
}

    
// 保存(创建或者更新)一个目录信息
// GET
export async function mindFolderInfoActionTreeMyFolder (params) {
    const {data} = await request(`jaxrs/folder/tree/my`)
    return data.data
}

    
// 列出用户自己的个人脑图文件夹（所有文件夹，按上下级树型组织信息）
// DELETE
export async function mindFolderInfoActionFolderDelete (params) {
    const {data} = await request(`jaxrs/folder/${params.id}`, params)
    return data.data
}

    
// 上传或者替换栏目的图标内容，可以指定压缩大小	.
// mindId: String: 脑图信息ID
// size: Integer: 最大宽度
// PUT
export async function mindInfoActionShareMindWithId (params) {
    const {data} = await request(`jaxrs/mind/share/${params.id}`, params)
    return data.data
}

    
// 根据脑图文件ID删除脑图信息
// id: String: 脑图ID
// POST
export async function mindInfoActionSaveMind (params) {
    const {data} = await request(`jaxrs/mind/save`, params)
    return data.data
}

    
// 从回收站根据信息ID删除脑图信息
// recycleId: String: 回收站脑图ID
// PUT
export async function mindInfoActionShareCancelWithId (params) {
    const {data} = await request(`jaxrs/mind/share/${params.shareId}/cancel`, params)
    return data.data
}

    
// 根据ID获取脑图信息
// id: String: 脑图ID
// DELETE
export async function mindInfoActionDestoryFromNormal (params) {
    const {data} = await request(`jaxrs/mind/${params.id}/destorymind`, params)
    return data.data
}

    
// 根据ID获取脑图缩略图
// id: String: 脑图ID
// POST
export async function mindInfoActionChangeMindIcon (params) {
    const {data} = await request(`jaxrs/mind/${params.mindId}/icon/size/${params.size}`, params)
    return data.data
}

    
// 列示符合过滤条件的脑图信息内容, 下一页.
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量
// PUT
export async function mindInfoActionListNextWithFilter (params) {
    const {data} = await request(`jaxrs/mind/filter/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示符合过滤条件的脑图信息内容, 下一页.
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量
// DELETE
export async function mindInfoActionRecycleMindWithId (params) {
    const {data} = await request(`jaxrs/mind/recycle/${params.id}`, params)
    return data.data
}

    
// 列示符合过滤条件的脑图信息内容, 下一页.
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量
// DELETE
export async function mindInfoActionDestoryFromRecycle (params) {
    const {data} = await request(`jaxrs/mind/${params.recycleId}/destoryrecycle`, params)
    return data.data
}

    
// 列示符合过滤条件的脑图信息内容, 下一页.
// id: String: 最后一条信息ID，如果是第一页，则可以用(0)代替
// count: Integer: 每页显示的条目数量
// GET
export async function mindInfoActionViewMindWithId (params) {
    const {data} = await request(`jaxrs/mind/view/${params.id}`)
    return data.data
}

    
// 根据脑图ID获取脑图所有的分享信息
// id: String: 脑图ID
// GET
export async function mindInfoActionRestoreMindWithId (params) {
    const {data} = await request(`jaxrs/mind/restore/${params.id}`)
    return data.data
}

    
// 根据脑图ID获取脑图所有的版本信息
// id: String: 脑图ID
// GET
export async function mindInfoActionGetMindIconWithId (params) {
    const {data} = await request(`jaxrs/mind/${params.id}/icon`)
    return data.data
}

    
// 将指定的脑图放入回收站
// id: String: 脑图ID
// GET
export async function mindInfoActionListVersionsWithMindId (params) {
    const {data} = await request(`jaxrs/mind/list/${params.id}/version`)
    return data.data
}

    
// 根据ID从回收站还原脑图信息
// id: String: 回收站脑图ID
// GET
export async function mindInfoActionViewMindVersionWithId (params) {
    const {data} = await request(`jaxrs/mind/version/${params.id}`)
    return data.data
}

    
// 保存(创建或者更新)一个脑图信息
// GET
export async function mindInfoActionListShareRecordsWithMindId (params) {
    const {data} = await request(`jaxrs/mind/list/${params.id}/shareRecords`)
    return data.data
}

    
// 根据分享记录ID取消对脑图的分享
// shareId: String: 脑图分享信息ID
// GET
export async function mindInfoActionGetMindBaseInfoWithId (params) {
    const {data} = await request(`jaxrs/mind/${params.id}`)
    return data.data
}

    
// 将指定的脑图分享给其他用户或者组织
// id: String: 脑图ID
// PUT
export async function mindInfoActionListMySharedMindNextWithFilter (params) {
    const {data} = await request(`jaxrs/mind/filter/shared/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 根据历史版本信息ID获取脑图信息，包括脑图内容
// id: String: 脑图历史版本信息ID
// PUT
export async function mindInfoActionListMyRecycleNextWithFilter (params) {
    const {data} = await request(`jaxrs/mind/filter/recycle/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 根据ID获取脑图信息，包括脑图内容
// id: String: 脑图ID
// PUT
export async function mindInfoActionListMyRecivedMindNextWithFilter (params) {
    const {data} = await request(`jaxrs/mind/filter/recived/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    