
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 根据关键字搜索设计对象.
// POST
export async function designerActionSearch (params) {
    const {data} = await request(`jaxrs/designer/search`, params)
    return data.data
}

    
// 删除指定的数据字典以及数据字典数据.
// id: String: 标识
// POST
export async function dictActionPost (params) {
    const {data} = await request(`jaxrs/dict`, params)
    return data.data
}

    
// 获取单个数据字典以及数据字典数据.
// id: String: 标识
// GET
export async function dictActionListWithApplication (params) {
    const {data} = await request(`jaxrs/dict/list/portal/${params.portalId}`)
    return data.data
}

    
// 分页列示数据字典对象.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function dictActionListPaging (params) {
    const {data} = await request(`jaxrs/dict/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取应用的数据字典列表.
// portalId: String: 门户应用标识
// GET
export async function dictActionGet (params) {
    const {data} = await request(`jaxrs/dict/${params.id}`)
    return data.data
}

    
// 创建数据字典以及数据.
// PUT
export async function dictActionPut (params) {
    const {data} = await request(`jaxrs/dict/${params.id}`, params)
    return data.data
}

    
// 更新数据字典以及数据.
// id: String: 标识
// DELETE
export async function dictActionDelete (params) {
    const {data} = await request(`jaxrs/dict/${params.id}`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// 创建文件.
// POST
export async function fileActionUpload (params) {
    const {data} = await request(`jaxrs/file/${params.id}/upload`, params)
    return data.data
}

    
// 删除文件.
// id: String: 标识
// GET
export async function fileActionDownload (params) {
    const {data} = await request(`jaxrs/file/${params.id}/download`)
    return data.data
}

    
// 获取文件内容.
// id: String: 标识
// GET
export async function fileActionListWithApplication (params) {
    const {data} = await request(`jaxrs/file/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取文件内容.
// flag: String: 标识
// GET
export async function fileActionListNext (params) {
    const {data} = await request(`jaxrs/file/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 列示文件对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionListPrev (params) {
    const {data} = await request(`jaxrs/file/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示文件对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionGet (params) {
    const {data} = await request(`jaxrs/file/${params.flag}`)
    return data.data
}

    
// 根据应用列示文件.
// applicationFlag: String: 应用标识
// PUT
export async function fileActionUpdate (params) {
    const {data} = await request(`jaxrs/file/${params.id}`, params)
    return data.data
}

    
// 更新文件.
// id: String: 标识
// DELETE
export async function fileActionDelete (params) {
    const {data} = await request(`jaxrs/file/${params.id}`, params)
    return data.data
}

    
// 上传文件内容.
// id: String: 标识
// POST
export async function fileActionCreate (params) {
    const {data} = await request(`jaxrs/file`, params)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 创建用于ID值的UUID
// count: Integer: 创建数量
// GET
export async function idActionGet (params) {
    const {data} = await request(`jaxrs/id/${params.count}`)
    return data.data
}

    
// 上传对比数据内容.
// PUT
export async function inputActionCover (params) {
    const {data} = await request(`jaxrs/input/cover`, params)
    return data.data
}

    
// 覆盖应用.
// PUT
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`jaxrs/input/prepare/create`, params)
    return data.data
}

    
// 创建应用.
// PUT
export async function inputActionPrepareCover (params) {
    const {data} = await request(`jaxrs/input/prepare/cover`, params)
    return data.data
}

    
// 准备覆盖应用.
// PUT
export async function inputActionCompare (params) {
    const {data} = await request(`jaxrs/input/compare`, params)
    return data.data
}

    
// 准备创建应用.
// PUT
export async function inputActionCreate (params) {
    const {data} = await request(`jaxrs/input/create`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 查看所有应用.
// PUT
export async function outputActionSelect (params) {
    const {data} = await request(`jaxrs/output/${params.portalFlag}/select`, params)
    return data.data
}

    
// 选择门户结构.
// portalFlag: String: 应用标识
// GET
export async function outputActionSelectOutput (params) {
    const {data} = await request(`jaxrs/output/${params.flag}/select/file`)
    return data.data
}

    
// 以文件方式导出应用.
// flag: String: 输出文件标识
// GET
export async function outputActionList (params) {
    const {data} = await request(`jaxrs/output/list`)
    return data.data
}

    
// 创建新的Page.
// GET
export async function pageActionListWithPortal (params) {
    const {data} = await request(`jaxrs/page/list/portal/${params.portalId}`)
    return data.data
}

    
// 删除指定的Page
// id: String: 标识
// PUT
export async function pageActionEdit (params) {
    const {data} = await request(`jaxrs/page/${params.id}`, params)
    return data.data
}

    
// 更新指定的Page.
// id: String: 标识
// GET
export async function pageActionGet (params) {
    const {data} = await request(`jaxrs/page/${params.id}`)
    return data.data
}

    
// 获取Page.
// id: String: 标识
// DELETE
export async function pageActionDelete (params) {
    const {data} = await request(`jaxrs/page/${params.id}`, params)
    return data.data
}

    
// 列示指定Portal下的Page.
// portalId: String: Portal标识
// POST
export async function pageActionCreate (params) {
    const {data} = await request(`jaxrs/page`, params)
    return data.data
}

    
// 创建新的Portal.需要对Portal模块的管理权限
// GET
export async function portalActionListSummaryWithPortalCategory (params) {
    const {data} = await request(`jaxrs/portal/list/summary/portalcategory/${params.portalCategory}`)
    return data.data
}

    
// 删除指定的Portal,需要指定权限.
// id: String: 标识
// GET
export async function portalActionListWithPortalCategory (params) {
    const {data} = await request(`jaxrs/portal/list/portalcategory/${params.portalCategory}`)
    return data.data
}

    
// 更新指定的Portal,需要对此portal的管理权限
// id: String: 标识
// POST
export async function portalActionListSummaryV2 (params) {
    const {data} = await request(`jaxrs/portal/list/summary/v2`, params)
    return data.data
}

    
// 获取单个Portal配置信息,检查是否有editable权限.
// id: String: 标识
// GET
export async function portalActionListSummary (params) {
    const {data} = await request(`jaxrs/portal/list/summary`)
    return data.data
}

    
// 列示当前用户可以管理的Portal.
// POST
export async function portalActionUpdatePermission (params) {
    const {data} = await request(`jaxrs/portal/${params.id}/permission`, params)
    return data.data
}

    
// 列示当前用户可以管理的Portal的简要信息包含page.
// PUT
export async function portalActionSetIcon (params) {
    const {data} = await request(`jaxrs/portal/${params.id}/icon`, params)
    return data.data
}

    
// 列示当前用户可以管理的Portal的简要信息.
// PUT
export async function portalActionEdit (params) {
    const {data} = await request(`jaxrs/portal/${params.id}`, params)
    return data.data
}

    
// 列示当前用户在指定分类下可以管理的Portal的简要信息包含page.
// portalCategory: String: 门户分类
// GET
export async function portalActionGet (params) {
    const {data} = await request(`jaxrs/portal/${params.id}`)
    return data.data
}

    
// 列示当前用户在指定分类下可以管理的Portal.
// portalCategory: String: 门户分类
// GET
export async function portalActionList (params) {
    const {data} = await request(`jaxrs/portal/list`)
    return data.data
}

    
// 更新Portal图标.
// id: String: 标识
// DELETE
export async function portalActionDelete (params) {
    const {data} = await request(`jaxrs/portal/${params.id}`, params)
    return data.data
}

    
// 设置门户应用权限.
// id: String: 标识
// POST
export async function portalActionCreate (params) {
    const {data} = await request(`jaxrs/portal`, params)
    return data.data
}

    
// 查看用户可管理的portalcategory.
// GET
export async function portalCategoryActionListWith (params) {
    const {data} = await request(`jaxrs/portalcategory/list`)
    return data.data
}

    
// 创建新的Script.
// GET
export async function scriptActionListWithPortal (params) {
    const {data} = await request(`jaxrs/script/list/portal/${params.portalId}`)
    return data.data
}

    
// 删除指定的Portal
// id: String: 标识
// POST
export async function scriptActionListPaging (params) {
    const {data} = await request(`jaxrs/script/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 更新指定的Portal.
// id: String: 标识
// POST
export async function scriptActionManagerList (params) {
    const {data} = await request(`jaxrs/script/list/manager`, params)
    return data.data
}

    
// 获取Script.
// id: String: 标识
// PUT
export async function scriptActionEdit (params) {
    const {data} = await request(`jaxrs/script/${params.id}`, params)
    return data.data
}

    
// 分页列示Script对象.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function scriptActionGet (params) {
    const {data} = await request(`jaxrs/script/${params.id}`)
    return data.data
}

    
// 列示指定Portal下的Script.
// portalId: String: Portal标识
// DELETE
export async function scriptActionDelete (params) {
    const {data} = await request(`jaxrs/script/${params.id}`, params)
    return data.data
}

    
// 列示Script对象（管理员权限）.
// POST
export async function scriptActionCreate (params) {
    const {data} = await request(`jaxrs/script`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 创建新的模版.
// GET
export async function templatePageActionListCategory (params) {
    const {data} = await request(`jaxrs/templatepage/list/category`)
    return data.data
}

    
// 删除指定的模版.
// id: String: 标识
// PUT
export async function templatePageActionListWithCategory (params) {
    const {data} = await request(`jaxrs/templatepage/list/category`, params)
    return data.data
}

    
// 获取单个模版.
// id: String: 标识
// GET
export async function templatePageActionGet (params) {
    const {data} = await request(`jaxrs/templatepage/${params.id}`)
    return data.data
}

    
// 获取所有可见的模版,按category进行分类
// GET
export async function templatePageActionList (params) {
    const {data} = await request(`jaxrs/templatepage/list`)
    return data.data
}

    
// 统计分类数量.
// DELETE
export async function templatePageActionDelete (params) {
    const {data} = await request(`jaxrs/templatepage/${params.id}`, params)
    return data.data
}

    
// 列示指定分类下的模版.
// POST
export async function templatePageActionCreate (params) {
    const {data} = await request(`jaxrs/templatepage`, params)
    return data.data
}

    
// 创建新的部件.
// GET
export async function widgetActionListWithPortal (params) {
    const {data} = await request(`jaxrs/widget/list/portal/${params.portalId}`)
    return data.data
}

    
// 删除指定的部件
// id: String: 标识
// PUT
export async function widgetActionEdit (params) {
    const {data} = await request(`jaxrs/widget/${params.id}`, params)
    return data.data
}

    
// 更新指定的部件.
// id: String: 标识
// GET
export async function widgetActionGet (params) {
    const {data} = await request(`jaxrs/widget/${params.id}`)
    return data.data
}

    
// 获取部件.
// id: String: 标识
// DELETE
export async function widgetActionDelete (params) {
    const {data} = await request(`jaxrs/widget/${params.id}`, params)
    return data.data
}

    
// 列示指定Portal下的部件.
// portalId: String: Portal标识
// POST
export async function widgetActionCreate (params) {
    const {data} = await request(`jaxrs/widget`, params)
    return data.data
}

    