
// 删除应用,将同时删除所有相关内容.
// id: String: 应用标识
// onlyRemoveNotCompleted: boolean: 是否仅删除在流转中的Work
// POST
export async function applicationActionPost (params) {
    const {data} = await request(`jaxrs/application`, params)
    return data.data
}

    
// 更新应用.
// id: String: 应用标识
// GET
export async function applicationActionListWithApplicationCategory (params) {
    const {data} = await request(`jaxrs/application/list/applicationcategory/${params.applicationCategory}`)
    return data.data
}

    
// 获取单个应用信息.
// id: String: 应用标识
// GET
export async function applicationActionListSummaryWithApplicationCategory (params) {
    const {data} = await request(`jaxrs/application/list/summary/applicationcategory/${params.applicationCategory}`)
    return data.data
}

    
// 列示所有应用
// PUT
export async function applicationActionSetIcon (params) {
    const {data} = await request(`jaxrs/application/${params.id}/icon`, params)
    return data.data
}

    
// 列示所有应用，同时附带流程简要信息和表单简要信息.返回值按名称进行排序
// PUT
export async function applicationActionEdit (params) {
    const {data} = await request(`jaxrs/application/${params.id}`, params)
    return data.data
}

    
// 根据应用分类获取应用的简要信息,不包含流程表单,应用分类不为null.
// applicationCategory: String: 应用分类
// POST
export async function applicationActionUpdatePermission (params) {
    const {data} = await request(`jaxrs/application/${params.id}/permission`, params)
    return data.data
}

    
// 根据应用分类获取应用,应用分类不为null.
// applicationCategory: String: 应用分类
// GET
export async function applicationActionListSummary (params) {
    const {data} = await request(`jaxrs/application/list/summary`)
    return data.data
}

    
// 创建应用.
// GET
export async function applicationActionGet (params) {
    const {data} = await request(`jaxrs/application/${params.id}`)
    return data.data
}

    
// 更新应用图标.
// id: String: 应用标识
// GET
export async function applicationActionList (params) {
    const {data} = await request(`jaxrs/application/list`)
    return data.data
}

    
// 设置应用权限.
// id: String: 标识
// DELETE
export async function applicationActionDelete (params) {
    const {data} = await request(`jaxrs/application/${params.id}/${params.onlyRemoveNotCompleted}`, params)
    return data.data
}

    
// 获取应用分类信息并统计同一分类的数量.
// GET
export async function applicationCategoryActionList (params) {
    const {data} = await request(`jaxrs/applicationcategory/list`)
    return data.data
}

    
// 删除指定的数据字典以及数据字典数据.
// id: String: 标识
// POST
export async function applicationDictActionPost (params) {
    const {data} = await request(`jaxrs/applicationdict`, params)
    return data.data
}

    
// 获取单个数据字典以及数据字典数据.
// id: String: 标识
// GET
export async function applicationDictActionListWithApplication (params) {
    const {data} = await request(`jaxrs/applicationdict/list/application/${params.applicationId}`)
    return data.data
}

    
// 分页列示数据字典对象.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function applicationDictActionListPaging (params) {
    const {data} = await request(`jaxrs/applicationdict/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取Application的数据字典列表.
// applicationId: String: 应用标识
// GET
export async function applicationDictActionGet (params) {
    const {data} = await request(`jaxrs/applicationdict/${params.id}`)
    return data.data
}

    
// 创建数据字典以及数据.
// PUT
export async function applicationDictActionPut (params) {
    const {data} = await request(`jaxrs/applicationdict/${params.id}`, params)
    return data.data
}

    
// 更新数据字典以及数据.
// id: String: 标识
// DELETE
export async function applicationDictActionDelete (params) {
    const {data} = await request(`jaxrs/applicationdict/${params.id}`, params)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`jaxrs/cache`, params)
    return data.data
}

    
// 根据关键字搜索设计对象.
// id: String: 标识
// GET
export async function designerActionGetRoute (params) {
    const {data} = await request(`jaxrs/designer/route/${params.id}`)
    return data.data
}

    
// 根据关键字搜索设计对象.
// POST
export async function designerActionSearch (params) {
    const {data} = await request(`jaxrs/designer/search`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`jaxrs/echo`)
    return data.data
}

    
// ApplicationDict对象中的孤立对象,包括item对象
// GET
export async function elementToolActionApplicationDictOrphan (params) {
    const {data} = await request(`jaxrs/elementtool/applicationdict/orphan`)
    return data.data
}

    
// Form对象中的孤立对象,包括Form和FormField
// GET
export async function elementToolActionFormOrphan (params) {
    const {data} = await request(`jaxrs/elementtool/form/orphan`)
    return data.data
}

    
// Process对象中的孤立对象,包括Process的子元素
// GET
export async function elementToolActionProcessOrphan (params) {
    const {data} = await request(`jaxrs/elementtool/process/orphan`)
    return data.data
}

    
// Script对象中的孤立对象.
// GET
export async function elementToolActionScriptOrphan (params) {
    const {data} = await request(`jaxrs/elementtool/script/orphan`)
    return data.data
}

    
// 获取文件内容.
// id: String: 标识
// POST
export async function fileActionUpload (params) {
    const {data} = await request(`jaxrs/file/${params.id}/upload`, params)
    return data.data
}

    
// 复制资源文件到新的应用.
// flag: String: 标识
// applicationFlag: String: 应用标识
// GET
export async function fileActionDownload (params) {
    const {data} = await request(`jaxrs/file/${params.id}/download`)
    return data.data
}

    
// 创建文件.
// GET
export async function fileActionListWithApplication (params) {
    const {data} = await request(`jaxrs/file/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 删除文件.
// flag: String: 标识
// GET
export async function fileActionListNext (params) {
    const {data} = await request(`jaxrs/file/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 获取文件内容.以stream方式下载.
// id: String: 标识
// GET
export async function fileActionListPrev (params) {
    const {data} = await request(`jaxrs/file/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 获取文件内容.
// flag: String: 标识
// GET
export async function fileActionGet (params) {
    const {data} = await request(`jaxrs/file/${params.flag}`)
    return data.data
}

    
// 列示文件对象,下一页.
// id: String: 标识
// count: Integer: 数量
// PUT
export async function fileActionUpdate (params) {
    const {data} = await request(`jaxrs/file/${params.id}`, params)
    return data.data
}

    
// 列示文件对象,上一页.
// id: String: 标识
// count: Integer: 数量
// DELETE
export async function fileActionDelete (params) {
    const {data} = await request(`jaxrs/file/${params.flag}`, params)
    return data.data
}

    
// 根据应用列示文件.
// applicationFlag: String: 应用标识
// GET
export async function fileActionCopy (params) {
    const {data} = await request(`jaxrs/file/${params.flag}/application/${params.applicationFlag}`)
    return data.data
}

    
// 更新文件.
// id: String: 标识
// POST
export async function fileActionCreate (params) {
    const {data} = await request(`jaxrs/file`, params)
    return data.data
}

    
// 上传文件内容.
// id: String: 标识
// GET
export async function fileActionContent (params) {
    const {data} = await request(`jaxrs/file/${params.id}/content`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 创建表单.
// GET
export async function formActionListFornFiledWithApplication (params) {
    const {data} = await request(`jaxrs/form/list/formfield/application/${params.applicationId}`)
    return data.data
}

    
// 删除表单.
// id: String: 标识
// GET
export async function formActionListWithApplication (params) {
    const {data} = await request(`jaxrs/form/list/application/${params.applicationId}`)
    return data.data
}

    
// 获取表单内容.
// id: String: 标识
// GET
export async function formActionListFornFiledWithForm (params) {
    const {data} = await request(`jaxrs/form/list/${params.id}/formfield`)
    return data.data
}

    
// 根据指定的应用获取应用下所有表单包含的字段字段信息.
// applicationId: String: 应用标识
// GET
export async function formActionListNext (params) {
    const {data} = await request(`jaxrs/form/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 根据指定的Form获取所有包含的字段信息.
// id: String: 标识
// GET
export async function formActionListPrev (params) {
    const {data} = await request(`jaxrs/form/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示Form对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function formActionGet (params) {
    const {data} = await request(`jaxrs/form/${params.id}`)
    return data.data
}

    
// 列示Form对象,上一页.
// id: String: 标识
// count: Integer: 数量
// PUT
export async function formActionUpdate (params) {
    const {data} = await request(`jaxrs/form/${params.id}`, params)
    return data.data
}

    
// 根据应用列示Form.
// applicationId: String: 应用标识
// DELETE
export async function formActionDelete (params) {
    const {data} = await request(`jaxrs/form/${params.id}`, params)
    return data.data
}

    
// 更新表单.
// id: String: 标识
// POST
export async function formActionCreate (params) {
    const {data} = await request(`jaxrs/form`, params)
    return data.data
}

    
// 获取表单历史版本内容.
// id: String: 标识
// GET
export async function formVersionActionListWithForm (params) {
    const {data} = await request(`jaxrs/formversion/list/form/${params.formId}`)
    return data.data
}

    
// 根据脚本id获取历史版本列表.
// formId: String: form标识
// GET
export async function formVersionActionGet (params) {
    const {data} = await request(`jaxrs/formversion/${params.id}`)
    return data.data
}

    
// 创建用于ID值的UUID
// count: Integer: 数量
// GET
export async function idActionGet (params) {
    const {data} = await request(`jaxrs/id/${params.count}`)
    return data.data
}

    
// 上传对比数据内容.
// PUT
export async function inputActionCover (params) {
    const {data} = await request(`jaxrs/input/cover`, params)
    return data.data
}

    
// 覆盖应用.
// PUT
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`jaxrs/input/prepare/create`, params)
    return data.data
}

    
// 创建应用.
// PUT
export async function inputActionPrepareCover (params) {
    const {data} = await request(`jaxrs/input/prepare/cover`, params)
    return data.data
}

    
// 准备覆盖应用.
// PUT
export async function inputActionCompare (params) {
    const {data} = await request(`jaxrs/input/compare`, params)
    return data.data
}

    
// 准备创建应用.
// PUT
export async function inputActionCreate (params) {
    const {data} = await request(`jaxrs/input/create`, params)
    return data.data
}

    
// 创建表映射.
// GET
export async function mappingActionListWithApplication (params) {
    const {data} = await request(`jaxrs/mapping/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 删除表映射对象.
// flag: String: 标识
// PUT
export async function mappingActionEdit (params) {
    const {data} = await request(`jaxrs/mapping/${params.flag}`, params)
    return data.data
}

    
// 更新表映射.
// flag: String: 标识
// GET
export async function mappingActionListNext (params) {
    const {data} = await request(`jaxrs/mapping/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 执行表映射.
// flag: String: 标识
// GET
export async function mappingActionListPrev (params) {
    const {data} = await request(`jaxrs/mapping/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 获取单个表映射对象.
// flag: String: 标识
// GET
export async function mappingActionGet (params) {
    const {data} = await request(`jaxrs/mapping/${params.flag}`)
    return data.data
}

    
// 列示表映射对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function mappingActionExecute (params) {
    const {data} = await request(`jaxrs/mapping/${params.flag}/execute`)
    return data.data
}

    
// 列示表映射对象,上一页.
// id: String: 标识
// count: Integer: 数量
// DELETE
export async function mappingActionDelete (params) {
    const {data} = await request(`jaxrs/mapping/${params.flag}`, params)
    return data.data
}

    
// 根据应用获取表映射.
// applicationFlag: String: 应用标识
// POST
export async function mappingActionCreate (params) {
    const {data} = await request(`jaxrs/mapping`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`jaxrs/openapi`)
    return data.data
}

    
// 查看所有应用.
// PUT
export async function outputActionSelect (params) {
    const {data} = await request(`jaxrs/output/${params.applicationFlag}/select`, params)
    return data.data
}

    
// 选择应用结构.
// applicationFlag: String: 应用标识
// GET
export async function outputActionList (params) {
    const {data} = await request(`jaxrs/output/list`)
    return data.data
}

    
// 删除流程.
// id: String: 标识
// onlyRemoveNotCompleted: boolean: 仅删除流转中Work
// GET
export async function processActionGetEnabled (params) {
    const {data} = await request(`jaxrs/process/${params.id}/enabled`)
    return data.data
}

    
// 删除流程所有版本.
// id: String: 标识
// onlyRemoveNotCompleted: boolean: 仅删除流转中Work
// POST
export async function processActionUpgrade (params) {
    const {data} = await request(`jaxrs/process/${params.id}/upgrade`, params)
    return data.data
}

    
// 停用当前版本流程.
// id: String: 标识
// POST
export async function processActionPost (params) {
    const {data} = await request(`jaxrs/process`, params)
    return data.data
}

    
// 启用当前版本流程.
// id: String: 标识
// GET
export async function processActionGetProcess (params) {
    const {data} = await request(`jaxrs/process/${params.id}/process`)
    return data.data
}

    
// 执行流程数据映射.
// id: String: 标识
// GET
export async function processActionListWithApplication (params) {
    const {data} = await request(`jaxrs/process/application/${params.applicationId}`)
    return data.data
}

    
// 获取流程内容.含所有节点和路由信息
// id: String: 标识
// POST
export async function processActionGetProcessElementList (params) {
    const {data} = await request(`jaxrs/process/${params.id}/list/element`, params)
    return data.data
}

    
// 获取启用版本流程内容.含所有节点和路由信息
// id: String: 标识
// POST
export async function processActionUpdatePermission (params) {
    const {data} = await request(`jaxrs/process/${params.id}/permission`, params)
    return data.data
}

    
// 仅获取流程内容，不包含节点和路由信息
// id: String: 标识
// DELETE
export async function processActionDeleteEdition (params) {
    const {data} = await request(`jaxrs/process/${params.id}/${params.onlyRemoveNotCompleted}/edition`, params)
    return data.data
}

    
// 查询流程的指定节点或路由信息.
// id: String: 标识
// GET
export async function processActionLeadOut (params) {
    const {data} = await request(`jaxrs/process/${params.id}/lead/out`)
    return data.data
}

    
// 导出流程.
// id: String: 标识
// GET
export async function processActionListEdition (params) {
    const {data} = await request(`jaxrs/process/application/${params.applicationId}/edition/${params.edition}`)
    return data.data
}

    
// 列示未启用的流程版本.
// applicationId: String: 应用标识
// GET
export async function processActionUpgradeAll (params) {
    const {data} = await request(`jaxrs/process/upgrade/all`)
    return data.data
}

    
// 列示流程的所有版本.
// applicationId: String: 应用标识
// edition: String: 流程版本标志
// GET
export async function processActionEnableProcess (params) {
    const {data} = await request(`jaxrs/process/${params.id}/enable`)
    return data.data
}

    
// 列示某个应用的所有流程.
// applicationId: String: 应用标识
// POST
export async function processActionExecuteProjection (params) {
    const {data} = await request(`jaxrs/process/${params.id}/execute/projection`, params)
    return data.data
}

    
// 创建流程.
// GET
export async function processActionListDisableEdition (params) {
    const {data} = await request(`jaxrs/process/application/${params.applicationId}/disable/edition`)
    return data.data
}

    
// 更新流程.
// id: String: 标识
// GET
export async function processActionDisableProcess (params) {
    const {data} = await request(`jaxrs/process/${params.id}/disable`)
    return data.data
}

    
// 设置流程权限.
// id: String: 标识
// GET
export async function processActionGet (params) {
    const {data} = await request(`jaxrs/process/${params.id}`)
    return data.data
}

    
// 升级流程.
// id: String: 标识
// PUT
export async function processActionPut (params) {
    const {data} = await request(`jaxrs/process/${params.id}`, params)
    return data.data
}

    
// 给所有流程打上版本信息.
// DELETE
export async function processActionDelete (params) {
    const {data} = await request(`jaxrs/process/${params.id}/${params.onlyRemoveNotCompleted}`, params)
    return data.data
}

    
// 获取流程历史版本内容.
// id: String: 标识
// GET
export async function processVersionActionListWithForm (params) {
    const {data} = await request(`jaxrs/processversion/list/process/${params.processId}`)
    return data.data
}

    
// 根据脚本id获取历史版本列表.
// processId: String: process标识
// GET
export async function processVersionActionGet (params) {
    const {data} = await request(`jaxrs/processversion/${params.id}`)
    return data.data
}

    
// 删除脚本.
// id: String: 标识
// POST
export async function scriptActionPost (params) {
    const {data} = await request(`jaxrs/script`, params)
    return data.data
}

    
// 获取指定的脚本信息.
// id: String: 标识
// GET
export async function scriptActionListWithApplication (params) {
    const {data} = await request(`jaxrs/script/application/${params.applicationId}`)
    return data.data
}

    
// 根据应用ID和脚本名称获取脚本.
// applicationId: String: 应用标识
// name: String: 名称
// GET
export async function scriptActionGetWithApplicationWithName (params) {
    const {data} = await request(`jaxrs/script/application/${params.applicationId}/name/${params.name}`)
    return data.data
}

    
// 列示Script对象,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function scriptActionManagerList (params) {
    const {data} = await request(`jaxrs/script/list/manager`, params)
    return data.data
}

    
// 分页列示Script对象.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function scriptActionListPaging (params) {
    const {data} = await request(`jaxrs/script/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示Script对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function scriptActionListNext (params) {
    const {data} = await request(`jaxrs/script/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 列示应用所有脚本.
// applicationId: String: 应用标识
// GET
export async function scriptActionListPrev (params) {
    const {data} = await request(`jaxrs/script/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示Script对象（管理员权限）.
// GET
export async function scriptActionGet (params) {
    const {data} = await request(`jaxrs/script/${params.id}`)
    return data.data
}

    
// 创建脚本.
// PUT
export async function scriptActionPut (params) {
    const {data} = await request(`jaxrs/script/${params.id}`, params)
    return data.data
}

    
// 更新脚本.
// id: String: 标识
// DELETE
export async function scriptActionDelete (params) {
    const {data} = await request(`jaxrs/script/${params.id}`, params)
    return data.data
}

    
// 获取脚本历史版本内容.
// id: String: 标识
// GET
export async function scriptVersionActionListWithForm (params) {
    const {data} = await request(`jaxrs/scriptversion/list/script/${params.scriptId}`)
    return data.data
}

    
// 根据脚本id获取历史版本列表.
// scriptId: String: process标识
// GET
export async function scriptVersionActionGet (params) {
    const {data} = await request(`jaxrs/scriptversion/${params.id}`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 创建模版表单或者更新模版表单.
// PUT
export async function templateFormActionListWithCategory (params) {
    const {data} = await request(`jaxrs/templateform/list/category`, params)
    return data.data
}

    
// 删除模版表单.
// id: String: 标识
// GET
export async function templateFormActionListCategory (params) {
    const {data} = await request(`jaxrs/templateform/list/category`)
    return data.data
}

    
// 获取模版表单内容.
// id: String: 标识
// GET
export async function templateFormActionGet (params) {
    const {data} = await request(`jaxrs/templateform/${params.id}`)
    return data.data
}

    
// 列示所有模版表单.
// GET
export async function templateFormActionList (params) {
    const {data} = await request(`jaxrs/templateform/list`)
    return data.data
}

    
// 列示所有分类名称以及分类数量.
// DELETE
export async function templateFormActionDelete (params) {
    const {data} = await request(`jaxrs/templateform/${params.id}`, params)
    return data.data
}

    
// 按分类名称列示模版表单.
// POST
export async function templateFormActionCreate (params) {
    const {data} = await request(`jaxrs/templateform`, params)
    return data.data
}

    
// 指定application合并DataItem数据到WorkCompleted,并删除Item表中的数据.
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionMergeDataWithProcess (params) {
    const {data} = await request(`jaxrs/workcompleted/process/${params.processFlag}/merge/data`)
    return data.data
}

    
// 指定process合并DataItem数据到WorkCompleted,并删除Item表中的数据.
// processFlag: String: 流程标识
// GET
export async function workCompletedActionMergeDataWithApplication (params) {
    const {data} = await request(`jaxrs/workcompleted/application/${params.applicationFlag}/merge/data`)
    return data.data
}

    