package org.linkor.setting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;

/**
 * 配置信息
 */
public class Setting {

    public static int QOS;
//    public final static String BROKER = "tcp://127.0.0.1:521";
    public static String BROKER;
//    public final static String TOPIC = "ModbusTcp/#";
    public static String TOPIC;
    public static String CLIENT_ID =
            LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss")) + Math.random();
    public static String USERNAME;
    public static String PASSWORD;

    public static void init() {
        // read from setting.properties
        //            Properties properties = new Properties();
//            properties.load(Setting.class.getClassLoader().getResourceAsStream("setting.properties"));
        String configFile = findFile("setting.properties");
        if (configFile == null) {
            System.out.println("setting.properties not found");
        }
        Properties properties = readConfig(configFile);
        QOS = Integer.parseInt(properties.getProperty("qos"));
        BROKER = properties.getProperty("broker");
        TOPIC = properties.getProperty("topic");
        USERNAME = properties.getProperty("username");
        PASSWORD = properties.getProperty("password");
    }

    public static String findFile(String fileName) {
        File currentDir = null;
        try {
            currentDir = new File(".").getCanonicalFile();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return findFile(currentDir, fileName);
    }

    private static String findFile(File currentDir, String fileName) {
        if(currentDir == null) {
            return null;
        }

        System.out.println(currentDir.getAbsolutePath() + " " + fileName);

        File[] files = currentDir.listFiles();

        if(files != null) {
            for(File file : files) {
                if(file.getName().equals(fileName)) {
                    return file.getAbsolutePath();
                }
            }
        }

        File parent = currentDir.getParentFile();
        if (parent != null) {
            return findFile(parent, fileName);
        }

        return null;
    }

    public static Properties readConfig(String configFilePath) {

        Properties props = new Properties();

        try {
            FileInputStream fis = new FileInputStream(configFilePath);
            props.load(fis);
            fis.close();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return props;
    }
}
