

// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// userId: String: 用户标识
// users: List<String>: 用户标识
// startDate: String: 开始日期
// endDate: String: 结束日期
// POST : application/json
// 管理员查询申诉数据列表.
export async function appealInfoActionManagerListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/list/manager/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// POST : application/json
// 分页查询当前用户的申诉数据列表.
export async function appealInfoActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// GET : application/json
// 管理员处理异常数据为正常.
export async function appealInfoActionManagerSetNormal (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}/manager/status`, params.data)
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// GET : application/json
// 检查是否能够申诉.
export async function appealInfoActionStartCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}/start/check`, params.data)
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// ins
// job: String: 流程返回的 job
// POST : application/json
// 启动流程后修改状态.
export async function appealInfoActionStartProcess (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}/start/process`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// GET : application/json
// 还原数据状态，清除流程关联.
export async function appealInfoActionResetStatus (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}/reset/status`, params.data)
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// ins
// result: Integer: 审批结果：1-审批通过，-1-审批不通过
// reason: String: 申诉详细，申诉流程结束后写入.
// jobId: String: 流程的jobId，申诉流程结束后写入
// POST : application/json
// 流程结束后回填数据.
export async function appealInfoActionEndProcess (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}/end/process`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 申诉数据ID   
// GET : application/json
// 申诉数据获取.
export async function appealInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// unitName: String: 组织名称
// unitOu: String: 组织编号
// adminName: String: 管理员姓名
// admin: String: 管理员标识
// adminLevel: String: 管理级别:UNIT|TOPUNIT
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// POST : application/json
// 新建或者更新考勤管理员信息
export async function attendanceAdminActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有的考勤管理员信息
export async function attendanceAdminActionListAllAttendanceAdmin (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤管理员配置信息ID   
// GET : application/json
// 根据ID获取指定的考勤管理员信息
export async function attendanceAdminActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤管理员配置信息ID   
// DELETE : application/json
// 根据ID删除考勤管理员信息
export async function attendanceAdminActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// ids: List<String>: 需要复核的ID列表
// opinion1: String: 审批意见
// identity: String: 申诉人的身份，考勤人员身份：如果考勤人员属于多个组织，可以选择一个身份进行申诉信息绑定.
// id: String: 数据库主键,自动生成.
// detailId: String: 申诉的打卡记录ID.
// empName: String: 申诉员工标识:distinguishedName
// topUnitName: String: 员工所属顶层组织distinguishedName
// unitName: String: 员工所属组织名称distinguishedName
// recordDate: Date: 记录日期
// yearString: String: 申诉年份
// monthString: String: 申诉月份
// appealDateString: String: 申诉日期字符串
// recordDateString: String: 记录日期字符串
// startTime: String: 申诉开始时间
// endTime: String: 申诉结束时间
// appealReason: String: 申诉原因简述（60个汉字）
// selfHolidayType: String: 请假类型
// address: String: 地址
// reason: String: 申诉详细事由
// appealDescription: String: 申诉详细说明
// status: Integer: 审批状态:0-待处理，1-审批通过，-1-审批不能过，2-需要下一次审批
// currentProcessor: String: 当前审核人
// archiveTime: String: 归档时间字符串
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 根据ID列表对考勤申诉信息进行审核操作, 参数：ids(申诉ID列表)，opinion(审核意见)， status(审核状态:1-通过;2-需要进行复核;-1-不通过)
export async function attendanceAppealInfoActionAudit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/audit`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 考勤申诉信息ID   
// GET : application/json
// 根据ID对考勤申诉信息进行归档
export async function attendanceAppealInfoActionArchive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/archive/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量   
// PUT : application/json
// 根据根据过滤条件对考勤申诉信息进行下一页查询(带权限)
export async function attendanceAppealInfoActionListNextWithFilterWithManager (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/manager/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量   
// PUT : application/json
// 根据根据过滤条件对考勤申诉信息进行下一页查询
export async function attendanceAppealInfoActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/filter/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量   
// PUT : application/json
// 根据根据过滤条件对考勤申诉信息进行上一页查询
export async function attendanceAppealInfoActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/filter/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// id: String: 考勤申诉id
// status: Integer: 1-审批通过，-1-审批不能过
// PUT : application/json
// 根据考勤申诉ID，更新申诉审核流程的审批信息以及最终审核状态
export async function attendanceAppealInfoActionSyncWithWork (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/workflow/sync`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 考勤打卡记录ID   
// ins
// identity: String: 申诉人的身份，考勤人员身份：如果考勤人员属于多个组织，可以选择一个身份进行申诉信息绑定.
// workId: String: 考勤流程的workId.
// startTime: String: 申诉开始时间
// endTime: String: 申诉结束时间
// appealReason: String: 申诉原因简述（60个汉字）
// selfHolidayType: String: 请假类型
// address: String: 地址
// reason: String: 申诉详细事由, 500字
// appealDescription: String: 申诉详细说明, 500字
// PUT : application/json
// 根据ID对考勤结果申诉信息提起申诉流程
export async function attendanceAppealInfoActionCreateWithWorkFlow (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/workflow/appeal/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 考勤申诉信息ID   
// GET : application/json
// 根据ID获取考勤结果申诉信息
export async function attendanceAppealInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤申诉信息ID   
// DELETE : application/json
// 根据ID删除考勤结果申诉信息
export async function attendanceAppealInfoActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// ids: List<String>: 需要复核的ID列表
// opinion2: String: 复核意见
// identity: String: 申诉人的身份，考勤人员身份：如果考勤人员属于多个组织，可以选择一个身份进行申诉信息绑定.
// id: String: 数据库主键,自动生成.
// detailId: String: 申诉的打卡记录ID.
// empName: String: 申诉员工标识:distinguishedName
// topUnitName: String: 员工所属顶层组织distinguishedName
// unitName: String: 员工所属组织名称distinguishedName
// recordDate: Date: 记录日期
// yearString: String: 申诉年份
// monthString: String: 申诉月份
// appealDateString: String: 申诉日期字符串
// recordDateString: String: 记录日期字符串
// startTime: String: 申诉开始时间
// endTime: String: 申诉结束时间
// appealReason: String: 申诉原因简述（60个汉字）
// selfHolidayType: String: 请假类型
// address: String: 地址
// reason: String: 申诉详细事由
// appealDescription: String: 申诉详细说明
// status: Integer: 审批状态:0-待处理，1-审批通过，-1-审批不能过，2-需要下一次审批
// currentProcessor: String: 当前审核人
// archiveTime: String: 归档时间字符串
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 根据ID列表对考勤申诉信息进行复核操作, 参数：ids(申诉ID列表)，opinion2(审核意见)， status(审核状态:1-通过;-1-不通过)
export async function attendanceAppealInfoActionCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/check `, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 考勤申诉信息ID   
// ins
// identity: String: 申诉人的身份，考勤人员身份：如果考勤人员属于多个组织，可以选择一个身份进行申诉信息绑定.
// workId: String: 自定义流程workId
// id: String: 数据库主键,自动生成.
// detailId: String: 申诉的打卡记录ID.
// empName: String: 申诉员工标识:distinguishedName
// topUnitName: String: 员工所属顶层组织distinguishedName
// unitName: String: 员工所属组织名称distinguishedName
// recordDate: Date: 记录日期
// yearString: String: 申诉年份
// monthString: String: 申诉月份
// appealDateString: String: 申诉日期字符串
// recordDateString: String: 记录日期字符串
// startTime: String: 申诉开始时间
// endTime: String: 申诉结束时间
// appealReason: String: 申诉原因简述（60个汉字）
// selfHolidayType: String: 请假类型
// address: String: 地址
// reason: String: 申诉详细事由
// appealDescription: String: 申诉详细说明
// status: Integer: 审批状态:0-待处理，1-审批通过，-1-审批不能过，2-需要下一次审批
// currentProcessor: String: 当前审核人
// archiveTime: String: 归档时间字符串
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 根据ID对考勤结果申诉信息提起申诉
export async function attendanceAppealInfoActionCreate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/appeal/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// file_id: String: 导入文件信息ID   
// GET : application/json
// 获取数据库中指定导入文件名称的数据列表
export async function attendanceDetailActionListAttendanceDetailByBatchName (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/list/${params.pathParameters.file_id}`, params.data)
    return data.data
}

   
// ins
// q_empName: String: 参与查询的员工标识，人员DistinguishedName
// q_topUnitName: String: 参与查询的顶层组织（公司）标识，组织DistinguishedName
// q_unitName: String: 参与查询的组织（部门）标识，组织DistinguishedName
// q_year: String: 查询数据的年份, yyyy
// q_month: String: 查询数据的月份, mm
// cycleYear: String: 查询数据的统计周期年份，一般与数据日期的年份一致
// cycleMonth: String: 查询数据的统计周期月份，一般与数据日期的月份一致
// q_date: String: 查询数据的具体日期，yyyy-mm-dd
// PUT : application/json
// 获取用户指定年月的打卡数据列表
export async function attendanceDetailActionListUserAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/user`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// q_empName: String: 参与查询的员工标识，人员DistinguishedName
// q_topUnitName: String: 参与查询的顶层组织（公司）标识，组织DistinguishedName
// q_unitName: String: 参与查询的组织（部门）标识，组织DistinguishedName
// q_year: String: 查询数据的年份, yyyy
// q_month: String: 查询数据的月份, mm
// cycleYear: String: 查询数据的统计周期年份，一般与数据日期的年份一致
// cycleMonth: String: 查询数据的统计周期月份，一般与数据日期的月份一致
// q_date: String: 查询数据的具体日期，yyyy-mm-dd
// PUT : application/json
// 获取组织指定年月的打卡数据列表
export async function attendanceDetailActionListUnitAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/unit`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// q_empName: String: 参与查询的员工标识，人员DistinguishedName
// q_topUnitName: String: 参与查询的顶层组织（公司）标识，组织DistinguishedName
// q_unitName: String: 参与查询的组织（部门）标识，组织DistinguishedName
// q_year: String: 查询数据的年份, yyyy
// q_month: String: 查询数据的月份, mm
// cycleYear: String: 查询数据的统计周期年份，一般与数据日期的年份一致
// cycleMonth: String: 查询数据的统计周期月份，一般与数据日期的月份一致
// q_date: String: 查询数据的具体日期，yyyy-mm-dd
// PUT : application/json
// 获取顶层组织指定年月的打卡数据列表
export async function attendanceDetailActionListTopUnitAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/topUnit`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// startDate: String: 开始日期
// endDate: String: 结束日期   
// GET : application/json
// 分析打卡数据
export async function attendanceDetailActionAnalyseAttendanceDetails (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/${params.pathParameters.startDate}/${params.pathParameters.endDate}`, params.data)
    return data.data
}

   
// ins
// startDate: String: 开始日期.
// endDate: String: 结束日期.
// personNames: List<String>: 用户distinguishedName.
// forceFlag: Boolean: 是否分析已分析过的打卡记录.
// POST : application/json
// 分析打卡数据（指定人员）
export async function attendanceDetailActionAnalyseAttendanceDetailsForce (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// GET : application/json
// 将指定的打卡记录归档
export async function attendanceDetailActionArchiveAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/archive/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// deadline: String: 截止时间点，如果不填写，则以当前时间作为截止时间
// signType: String: 未打卡类型：all#onDuty#offDuty#morningOffDuty#afternoonOnDuty, 可以多选#分隔
// PUT : application/json
// 列示在截止时间仍未打卡的员工列表
export async function attendanceDetailActionListNeedSignPersons (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/list/persons/nonesign`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// cycleYear: String: 统计周期年份
// cycleMonth: String: 统计周期月份   
// GET : application/json
// 根据周期的年份月份，以及需要考勤人员的名单，检查人员在周期内每天的考核数据是否存在，如果不存在，则进行补齐
export async function attendanceDetailActionCheckDetailWithPersonByCycle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/checkDetailWithPersonByCycle/${params.pathParameters.cycleYear}/${params.pathParameters.cycleMonth}`, params.data)
    return data.data
}

   
// ins
// q_empName: String: 用于查询的人员：DistinguishedName.
// q_year: String: 查询的年份.
// q_month: String: 查询的月份.
// PUT : application/json
// 获取指定年月的打卡数据列表
export async function attendanceDetailActionListAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// GET : application/json
// 分析打卡数据
export async function attendanceDetailActionAnalyseAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/id/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量   
// ins
// q_empName: String: 参与查询的员工标识，人员DistinguishedName
// q_topUnitName: String: 参与查询的顶层组织（公司）标识，组织DistinguishedName
// q_unitName: String: 参与查询的组织（部门）标识，组织DistinguishedName
// q_year: String: 查询数据的年份, yyyy
// q_month: String: 查询数据的月份, mm
// cycleYear: String: 查询数据的统计周期年份，一般与数据日期的年份一致
// cycleMonth: String: 查询数据的统计周期月份，一般与数据日期的月份一致
// q_date: String: 查询数据的具体日期，yyyy-mm-dd
// PUT : application/json
// 列示符合过滤条件的打卡记录归档
export async function attendanceDetailActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量   
// ins
// q_empName: String: 参与查询的员工标识，人员DistinguishedName
// q_topUnitName: String: 参与查询的顶层组织（公司）标识，组织DistinguishedName
// q_unitName: String: 参与查询的组织（部门）标识，组织DistinguishedName
// q_year: String: 查询数据的年份, yyyy
// q_month: String: 查询数据的月份, mm
// cycleYear: String: 查询数据的统计周期年份，一般与数据日期的年份一致
// cycleMonth: String: 查询数据的统计周期月份，一般与数据日期的月份一致
// q_date: String: 查询数据的具体日期，yyyy-mm-dd
// PUT : application/json
// 列示符合过滤条件的打卡记录归档
export async function attendanceDetailActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// empName: String: 员工标识，<font color='red'>必填</font>，员工的distinguishedName.
// recordDateString: String: 打卡日期，格式yyyy-mm-dd，可以为空.
// onDutyTime: String: 上午上班打卡时间，格式hh24:mi:ss，可以为空，为空就是未打卡.
// morningOffdutyTime: String: 上班下午打卡签退时间，打卡策略2和3时使用，格式hh24:mi:ss，可以为空，为空就是未打卡.
// afternoonOnDutyTime: String: 下午上班打卡签到时间，打卡策略2和3时使用，格式hh24:mi:ss，可以为空，为空就是未打卡.
// offDutyTime: String: 下午下班打卡时间，hh24:mi:ss，可以为空，为空就是未打卡.
// POST : application/json
// 部分更新打卡记录，接入完成后直接分析
export async function attendanceDetailActionReciveSingle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/reciveSingle`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// empName: String: 员工标识，<font color='red'>必填</font>，员工的distinguishedName.
// empNo: String: 员工号, 可以为空，默认为员工标识相同值.
// recordDateString: String: 打卡日期，格式yyyy-mm-dd，可以为空.
// onDutyTime: String: 上午上班打卡时间，格式hh24:mi:ss，可以为空，为空就是未打卡.
// morningOffdutyTime: String: 上班下午打卡签退时间，打卡策略2和3时使用，格式hh24:mi:ss，可以为空，为空就是未打卡.
// afternoonOnDutyTime: String: 下午上班打卡签到时间，打卡策略2和3时使用，格式hh24:mi:ss，可以为空，为空就是未打卡.
// offDutyTime: String: 下午下班打卡时间，hh24:mi:ss，可以为空，为空就是未打卡.
// POST : application/json
// 接入完整的打卡信息记录，接入完成后直接分析
export async function attendanceDetailActionRecive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/recive`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// q_empName: String: 用于查询的人员：DistinguishedName.
// q_year: String: 查询的年份.
// q_month: String: 查询的月份.
// PUT : application/json
// 重新分析指定年月的打卡数据
export async function attendanceDetailActionReAnalyseDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/redo`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// GET : application/json
// 根据ID获取考勤打卡信息
export async function attendanceDetailActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// DELETE : application/json
// 根据ID删除打卡信息记录
export async function attendanceDetailActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// file_id: String: 导入文件信息ID   
// GET : application/json
// 获取指定导入文件的操作状态
export async function attendanceDetailFileImportActionGetStatus (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/${params.pathParameters.file_id}`, params.data)
    return data.data
}


// pathParameters
// file_id: String: 导入文件信息ID   
// GET : application/json
// 获取指定导入文件的操作状态，包括检查数据列表
export async function attendanceDetailFileImportActionGetStatusDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/${params.pathParameters.file_id}/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 获取系统的导入文件操作状态
export async function attendanceDetailFileImportActionGetStatusAll (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/all`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 需要显示的页码
// count: Integer: 每页需要显示的条目数量   
// ins
// empNo: String: 员工号，根据员工号查询记录
// empName: String: 员工姓名，根据员工姓名查询记录.
// startDate: String: 开始日期：yyyy-mm-dd.
// endDate: String: 结束日期：yyyy-mm-dd,如果开始日期填写，结束日期不填写就是只查询开始日期那一天
// signDescription: String: 打卡说明:上班打卡，下班打卡.
// PUT : application/json
// 移动打卡信息记录明细查询
export async function attendanceDetailMobileActionListDataForMobile (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/filter/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 预打卡，根据当前人以及对应的排班设置，给出打卡的预判断
export async function attendanceDetailMobileActionMobilePreview (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/mobilepreview`, params.data)
    return data.data
}

   
// ins
// id: String: Id, 可以为空，如果ID重复，则为更新原有数据.
// empName: String: 员工标识, 可以为空但不能错误：DistinguishedName，如果为空则取当前登录人员.
// checkin_type: String: 打卡类型。字符串，目前有：上午上班打卡，上午下班打卡，下午上班打卡，下午下班打卡，外出打卡，午间打卡
// checkin_time: long: 打卡时间，可以为空，为空则取服务器当前时间。Unix时间戳
// description: String: 其他说明备注, 可以为空.
// recordAddress: String: 打卡地点描述, 可以为空.
// longitude: String: 经度, 可以为空.
// latitude: String: 纬度, 可以为空.
// optMachineType: String: 操作设备类别：手机品牌|PAD|PC|其他, 可以为空.
// optSystemName: String: 操作设备类别：Mac|Windows|IOS|Android|其他, 可以为空.
// workAddress: String: 工作地点描述, 可以为空.
// isExternal: Boolean: 是否范围外打卡
// POST : application/json
// 移动打卡信息接入，移动端特点，会多次接入，部分接入，一次接入的信息不完整，接入完成后不直接进行分析
export async function attendanceDetailMobileActionReciveForMobile (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/recive`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询登录者当天的所有移动打卡信息记录
export async function attendanceDetailMobileActionListMyRecords (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/my`, params.data)
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// GET : application/json
// 根据ID获取移动打卡信息记录
export async function attendanceDetailMobileActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 移动考勤打卡信息ID   
// DELETE : application/json
// 根据ID删除移动打卡信息
export async function attendanceDetailMobileActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// topUnitName: String: 顶层组织名称distinguishedName
// topUnitOu: String: 顶层组织编号distinguishedName
// unitName: String: 组织名称distinguishedName
// unitOu: String: 组织编号
// employeeName: String: 员工姓名distinguishedName
// employeeNumber: String: 员工号
// empInTopUnitTime: String: 员工入职时间
// configType: String: 配置类型:REQUIRED（需要考勤）|NOTREQUIRED（不需要考勤）
// POST : application/json
// 新建或者更新考勤人员配置信息
export async function attendanceEmployeeConfigActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有考勤人员配置信息
export async function attendanceEmployeeConfigActionListAllAttendanceEmployeeConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤人员配置信息ID   
// GET : application/json
// 根据ID获取考勤人员配置信息
export async function attendanceEmployeeConfigActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤人员配置信息ID   
// DELETE : application/json
// 根据ID删除考勤人员配置信息
export async function attendanceEmployeeConfigActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有已经上传成功的文件列表
export async function attendanceImportFileInfoActionListAllAttendanceImportFileInfo (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 导入文件信息ID   
// GET : application/json
// 根据ID获取已经上传成功的文件信息
export async function attendanceImportFileInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 导入文件信息ID   
// DELETE : application/json
// 根据ID删除已经上传成功的文件以及文件信息
export async function attendanceImportFileInfoActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// topUnitName: String: 顶层组织名称distinguishedName
// unitName: String: 组织名称distinguishedName
// unitOu: String: 组织编号distinguishedName
// onDutyTime: String: 上午上班时间
// middayRestStartTime: String: 午休开始时间|上午下班时间
// middayRestEndTime: String: 午休结束时间|下午上班时间
// offDutyTime: String: 下午下班时间
// signProxy: Integer: 打卡策略：1-两次打卡（上午上班，下午下班） 2-三次打卡（上午上班，下午下班加中午一次共三次） 3-四次打卡（上午下午都打上班下班卡）
// lateStartTime: String: 上午上班迟到起算时间
// lateStartTimeAfternoon: String: 下午上班迟到起算时间
// absenceStartTime: String: 缺勤起算时间：第一次打卡在什么时间算是当天缺勤
// leaveEarlyStartTime: String: 下午早退起算时间
// leaveEarlyStartTimeMorning: String: 上午早退起算时间
// POST : application/json
// 新建或者更新考勤时间配置信息
export async function attendanceScheduleSettingActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有考勤时间配置信息列表
export async function attendanceScheduleSettingActionListAllAttendanceScheduleSetting (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/all`, params.data)
    return data.data
}


// pathParameters
// name: String: 顶层组织名称   
// GET : application/json
// 根据顶层组织名称获取所有考勤时间配置信息列表
export async function attendanceScheduleSettingActionListAttendanceScheduleSettingByTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/topUnit/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// name: String: 组织名称   
// GET : application/json
// 根据组织名称获取所有考勤时间配置信息
export async function attendanceScheduleSettingActionListAttendanceScheduleSettingByUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/unit/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤时间配置信息ID   
// GET : application/json
// 根据ID获取考勤时间配置信息
export async function attendanceScheduleSettingActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤时间配置信息ID   
// DELETE : application/json
// 根据ID删除考勤时间配置信息
export async function attendanceScheduleSettingActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: ID，如果ID已存在，则为更新
// employeeName: String: 员工姓名：员工的标识，<font color='red'>必填</font>，员工的distinguishedName，如：张三@zhangsan@P
// leaveType: String: 请假类型:带薪年休假|带薪病假|带薪福利假|扣薪事假|出差|培训|其他，<font color='red'>必填</font>
// startTime: Date: 开始时间，<font color='red'>必填</font>: yyyy-mm-dd hh24:mi:ss
// endTime: Date: 结束时间，<font color='red'>必填</font>: yyyy-mm-dd hh24:mi:ss
// leaveDayNumber: Double: 请假天数，最小粒度，0.5天，<font color='red'>必填</font>
// description: String: 请假说明
// batchFlag: String: 录入批次标识：可以填写流程workId，jobId, CMS的文档ID，或者自定义信息，数据保存时会先根据batchFlag做删除，然后再保存新的数据
// POST : application/json
// 新建或者更新员工休假申请信息
export async function attendanceSelfHolidayActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有员工休假申请信息信息
export async function attendanceSelfHolidayActionListAllAttendanceSelfHoliday (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示的条目数量   
// PUT : application/json
// 列示满足过滤条件员工休假申请信息信息，下一页
export async function attendanceSelfHolidayActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/filter/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示的条目数量   
// PUT : application/json
// 列示满足过滤条件员工休假申请信息信息，上一页
export async function attendanceSelfHolidayActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/filter/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 员工请假信息ID   
// DELETE : application/json
// 根据ID删除员工休假申请信息信息
export async function attendanceSelfHolidayActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: ID，如果ID已存在，则为更新
// employeeName: String: 员工姓名：员工的标识，<font color='red'>必填</font>，员工的distinguishedName，如：张三@zhangsan@P
// leaveType: String: 请假类型:带薪年休假|带薪病假|带薪福利假|扣薪事假|出差|培训|其他，<font color='red'>必填</font>
// startTime: Date: 开始时间，<font color='red'>必填</font>: yyyy-mm-dd hh24:mi:ss
// endTime: Date: 结束时间，<font color='red'>必填</font>: yyyy-mm-dd hh24:mi:ss
// leaveDayNumber: Double: 请假天数，最小粒度，0.5天，<font color='red'>必填</font>
// description: String: 请假说明
// batchFlag: String: 录入批次标识：可以填写流程workId，jobId, CMS的文档ID，或者自定义信息，数据保存时会先根据batchFlag做删除，然后再保存新的数据
// POST : application/json
// 新建或者更新员工休假申请信息
export async function attendanceSelfHolidaySimpleActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/selfholidaysimple`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// docId: String: 文档标识   
// DELETE : application/json
// 根据流程文档ID删除员工休假申请数据对象
export async function attendanceSelfHolidaySimpleActionDeleteByWfDocId (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/selfholidaysimple/docId/${params.pathParameters.docId}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有系统配置信息列表
export async function attendanceSettingActionListAllAttendanceSetting (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/list/all`, params.data)
    return data.data
}

   
// GET : application/json
// 是否启用钉钉考勤或企业微信考勤
export async function attendanceSettingActionEnableType (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/enable/type`, params.data)
    return data.data
}


// pathParameters
// code: String: 系统配置信息编码   
// GET : application/json
// 根据Code获取系统配置信息
export async function attendanceSettingActionGetWithCode (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/code/${params.pathParameters.code}`, params.data)
    return data.data
}


// pathParameters
// id: String: 系统配置信息ID   
// GET : application/json
// 根据ID获取系统配置信息
export async function attendanceSettingActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 系统配置信息ID   
// DELETE : application/json
// 根据ID删除系统配置信息
export async function attendanceSettingActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// configCode: String: 配置编码
// configName: String: 配置名称
// configValue: String: 配置内容
// valueType: String: 值类型: select | identity | number | date | text
// selectContent: String: 可选值，和select配合使用，以‘|’号分隔
// isMultiple: Boolean: 是否可以多值
// orderNumber: Integer: 排序号
// description: String: 备注说明
// POST : application/json
// 新建或者更新系统配置信息
export async function attendanceSettingActionSave (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 驱动系统主动进行一次数据统计
export async function attendanceStatisticActionDoStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statistic/do`, params.data)
    return data.data
}

   
// ins
// statisticName: String: 统计名称
// statisticType: String: 统计类型:PERSON_PER_MONTH|UNIT_PER_MONTH|TOPUNIT_PER_MONTH|UNIT_PER_DAY|TOPUNIT_PER_DAY
// statisticKey: String: 统计键值
// statisticYear: String: 统计年月
// statisticMonth: String: 统计月份
// statisticDay: String: 统计日期
// processTime: Date: 处理时间
// processStatus: String: 处理状态
// description: String: 说明备注
// POST : application/json
// 新建或者更新考勤统计需求信息
export async function attendanceStatisticRequireLogActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有考勤统计需求信息
export async function attendanceStatisticRequireLogActionListAllAttendanceStatisticRequireLog (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 统计需求信息ID   
// GET : application/json
// 根据ID获取考勤统计需求信息
export async function attendanceStatisticRequireLogActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 统计需求信息ID   
// DELETE : application/json
// 根据ID删除考勤统计需求信息
export async function attendanceStatisticRequireLogActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的个人月份统计数据,上一页
export async function attendanceStatisticShowActionListStmForPersonPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/personMonth/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的组织每日统计数据,下一页
export async function attendanceStatisticShowActionListStdForUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitDay/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询顶层组织指定月份的统计数据
export async function attendanceStatisticShowActionShowStForUnitInTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/topUnit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询指定组织所有员工指定月份的统计数据
export async function attendanceStatisticShowActionShowStForPersonInUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/persons/unit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询组织指定月份的统计数据
export async function attendanceStatisticShowActionShowStmForUnitSubnested (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/subnested/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// date: String: 统计日期   
// GET : application/json
// 查询组织指定日期的统计数据
export async function attendanceStatisticShowActionShowStdForUnitInTopUnitWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/topUnit/${params.pathParameters.name}/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的个人月份统计数据,下一页
export async function attendanceStatisticShowActionListStmForPersonNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/personMonth/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的组织月份统计数据,下一页
export async function attendanceStatisticShowActionListStmForUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitMonth/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的顶层组织月份统计数据,下一页
export async function attendanceStatisticShowActionListStmForTopUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitMonth/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的组织每日统计数据,上一页
export async function attendanceStatisticShowActionListStdForUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitDay/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询指定组织所有员工指定月份的统计数据，包括下级组织
export async function attendanceStatisticShowActionShowStForPersonInUnitSubNested (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/persons/unit/subnested/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// date: String: 统计日期   
// GET : application/json
// 查询组织指定日期的统计数据
export async function attendanceStatisticShowActionShowStdForUnitWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/${params.pathParameters.name}/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的顶层组织月份统计数据,上一页
export async function attendanceStatisticShowActionListStmForTopUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitMonth/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的顶层组织每日统计数据,下一页
export async function attendanceStatisticShowActionListStdForTopUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitDay/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的顶层组织每日统计数据,上一页
export async function attendanceStatisticShowActionListStdForTopUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitDay/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量   
// PUT : application/json
// 列示根据过滤条件的组织月份统计数据,上一页
export async function attendanceStatisticShowActionListStmForUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitMonth/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询组织指定月份每日的统计数据
export async function attendanceStatisticShowActionShowStdForUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询员工指定月份的统计数据
export async function attendanceStatisticShowActionShowStmForPerson (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/person/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询组织指定月份的统计数据
export async function attendanceStatisticShowActionShowStmForUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询组织指定月份的统计数据
export async function attendanceStatisticShowActionSumUnitStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/sum/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询顶层组织指定月份的统计数据
export async function attendanceStatisticShowActionShowStmForTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/topUnit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份   
// GET : application/json
// 查询顶层组织指定月份每日的统计数据
export async function attendanceStatisticShowActionShowStdForTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/topUnit/day/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}

   
// ins
// topUnitName: String: 顶层组织名称
// unitName: String: 组织名称
// cycleYear: String: 统计周期年份
// cycleMonth: String: 统计周期月份
// cycleStartDateString: String: 月周期开始日期
// cycleEndDateString: String: 月周期结束日期
// cycleStartDate: Date: 月周期开始日期
// cycleEndDate: Date: 月周期结束日期
// description: String: 说明备注
// POST : application/json
// 新建或者更新考勤统计周期信息
export async function attendanceStatisticalCycleActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有考勤统计周期信息
export async function attendanceStatisticalCycleActionListAllAttendanceStatisticalCycle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/list/all`, params.data)
    return data.data
}


// pathParameters
// year: String: 统计年份
// month: String: 统计月份   
// GET : application/json
// 根据登录的用户查询合适的考勤统计周期信息
export async function attendanceStatisticalCycleActionCycleDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/cycleDetail/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// id: String: 统计周期信息ID   
// GET : application/json
// 根据ID获取考勤统计周期信息
export async function attendanceStatisticalCycleActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 统计周期信息ID   
// DELETE : application/json
// 根据ID删除考勤统计周期信息
export async function attendanceStatisticalCycleActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// configName: String: 配置项名称
// configYear: String: 配置年份
// configMonth: String: 配置月份
// configDate: String: 配置日期
// configType: String: 配置类型：Holiday|Workday
// description: String: 配置说明
// POST : application/json
// 新建或者更新节假日配置信息
export async function attendanceWorkDayConfigActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有节假日配置列表信息
export async function attendanceWorkDayConfigActionListAllAttendanceWorkDayConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/list/all`, params.data)
    return data.data
}

   
// ins
// q_Name: String: 名称
// q_Year: String: 年
// q_Month: String: 月
// PUT : application/json
// 根据条件获取节假日配置列表
export async function attendanceWorkDayConfigActionListWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/filter`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 节假日配置信息ID   
// GET : application/json
// 根据ID获取节假日配置信息
export async function attendanceWorkDayConfigActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 节假日配置信息ID   
// DELETE : application/json
// 根据ID删除节假日配置信息
export async function attendanceWorkDayConfigActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// placeName: String: 场所名称
// placeAlias: String: 场所别名
// creator: String: 创建人
// longitude: String: 经度
// latitude: String: 纬度
// errorRange: Integer: 误差范围
// description: String: 说明备注
// POST : application/json
// 新建或者更新工作区域信息
export async function attendanceWorkPlaceActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有工作区域信息列表
export async function attendanceWorkPlaceActionListAllAttendanceWorkPlace (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/list/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作区域配置信息ID   
// GET : application/json
// 根据ID获取指定工作区域信息
export async function attendanceWorkPlaceActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 工作区域配置信息ID   
// DELETE : application/json
// 根据ID删除指定工作区域信息
export async function attendanceWorkPlaceActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// appealEnable: Boolean: 是否开启补卡申诉功能
// appealMaxTimes: Integer: 每个月最多申诉次数，0不限制
// processId: String: 自定义流程id
// processName: String: 自定义流程名称
// onDutyFastCheckInEnable: Boolean: 上班极速打卡，app端有效
// offDutyFastCheckInEnable: Boolean: 下班极速打卡，app端有效
// checkInAlertEnable: Boolean: 打卡提醒，上班前，下班后会收到提醒，不要忘记打卡.
// exceptionAlertEnable: Boolean: 异常打卡提醒，次日将收到异常打卡提醒.
// exceptionAlertTime: String: 异常打卡提醒时间：HH:mm
// exceptionAlertDate: String: 异常打卡定时执行日期：yyyy-MM-dd .
// POST : application/json
// 保存配置信息.
export async function configActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 个人配置信息.
export async function configActionGetPersonConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config/person`, params.data)
    return data.data
}

   
// ins
// person: String: 人员DN
// onDutyFastCheckInEnable: Boolean: 上班极速打卡，app端有效
// onDutyFastCheckInBegin: Integer: 上班极速打卡开始，上班打卡前几分钟，默认上班时间前1小时，app端有效
// onDutyFastCheckInEnd: Integer: 上班极速打卡结束，上班打卡后几分钟，默认到上班时间，app端有效
// offDutyFastCheckInEnable: Boolean: 下班极速打卡，app端有效
// offDutyFastCheckInBegin: Integer: 下班极速打卡开始，下班后几分钟，默认下班时间，app端有效
// offDutyFastCheckInEnd: Integer: 下班极速打卡结束，下班后几分钟，默认到下班后1小时，app端有效
// POST : application/json
// 保存个人配置信息.
export async function configActionPostPersonConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config/person`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 配置信息.
export async function configActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config`, params.data)
    return data.data
}


// pathParameters
// detailId: String: detail 统计 id   
// GET : application/json
// 根据统计id查询相关的打卡记录列表.
export async function detailActionRecordList (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/${params.pathParameters.detailId}/list/record`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// userId: String: 用户标识
// startDate: String: 开始日期
// endDate: String: 结束日期
// POST : application/json
// 分页查询考勤信息列表.
export async function detailActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filter: String: 人员或组织的DN，组织会递归下面所有的人员，如xxx@xxx@P、xxx@xxx@U
// start: String: 开始日期：yyyy-MM-dd
// end: String: 结束日期：yyyy-MM-dd   
// GET : application/json
// 统计导出.
export async function detailActionStatisticExport (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/export/filter/${params.pathParameters.filter}/start/${params.pathParameters.start}/end/${params.pathParameters.end}`, params.data)
    return data.data
}


// pathParameters
// person: String: 人员
// date: String: 日期：yyyy-MM-dd   
// GET : application/json
// 重新生成考勤信息，人员: 人员DN，日期: yyyy-MM-dd.
export async function detailActionRebuild (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/rebuild/person/${params.pathParameters.person}/date/${params.pathParameters.date}/`, params.data)
    return data.data
}

   
// POST : application/json
// 统计查询.
export async function detailActionStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/filter`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条数据ID
// count: Integer: 每页显示的条目数量   
// ins
// year: String: 年份
// month: String: 月份
// day: String: 日期
// person: String: 人员
// unit: String: 部门
// topUnit: String: 顶级部门，会及联查询下级部门
// checkType: String: 打卡类型:OffDuty|OnDuty
// timeResult: String: 打卡结果:Normal|Early|Late|SeriousLate|Absenteeism|NotSigned
// PUT : application/json
// 查询钉钉打卡结果
export async function dingdingAttendanceActionListNextDingdingAttendance (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/attendance/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询钉钉同步记录信息
export async function dingdingAttendanceActionListDingdingSyncRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/sync/list`, params.data)
    return data.data
}

   
// DELETE : application/json
// 删除所有打卡数据
export async function dingdingAttendanceActionDeleteAllData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/all`, params.data)
    return data.data
}


// pathParameters
// dateFrom: String: 开始时间: yyyy-MM-dd
// dateTo: String: 结束时间: yyyy-MM-dd   
// GET : application/json
// 同步钉钉考勤结果
export async function dingdingAttendanceActionSyncData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/sync/from/${params.pathParameters.dateFrom}/to/${params.pathParameters.dateTo}/start`, params.data)
    return data.data
}


// pathParameters
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 钉钉考勤全部个人数据统计
export async function dingdingAttendanceActionStatisticPerson (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/statistic/person/year/${params.pathParameters.year}/month/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// year: String: 年份: yyyy
// month: String: 月份: MM
// day: String: 日期: dd   
// GET : application/json
// 钉钉考勤全部组织数据统计
export async function dingdingAttendanceActionStatisticUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/statistic/unit/year/${params.pathParameters.year}/month/${params.pathParameters.month}/day/${params.pathParameters.day}`, params.data)
    return data.data
}


// pathParameters
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 根据部门查询人员月份统计
export async function dingdingAttendanceStatisticActionPersonMonthWithUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/person/unit/${params.pathParameters.unit}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// person: String: 人员
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 人员月份统计查询
export async function dingdingAttendanceStatisticActionPersonMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/person/${params.pathParameters.person}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 部门月份统计查询
export async function dingdingAttendanceStatisticActionUnitMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/unit/${params.pathParameters.unit}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/echo`, params.data)
    return data.data
}

 
// formParameters
// file: File:   
// POST : multipart/form-data
// 上传需要导入的数据文件XLS
export async function fileImportExportActionUpload (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/upload`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计公司名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出公司出勤率统计记录,设定是否使用stream输出
export async function fileImportExportActionTopunitStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/topunit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// startdate: String: 开始时间
// enddate: String: 结束时间
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 按时间区间导出请假数据,设定是否使用stream输出
export async function fileImportExportActionSelfHolidayExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/selfholiday/${params.pathParameters.startdate}/${params.pathParameters.enddate}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计部门名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出部门出勤率统计记录,设定是否使用stream输出
export async function fileImportExportActionUnitStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/unit/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出个人出勤率统计记录,设定是否使用stream输出
export async function fileImportExportActionPersonStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/person/${params.pathParameters.name}/${params.pathParameters.year}/${params.pathParameters.month}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// cycleYear: String: 统计周期年份,为空时输入0
// cycleMonth: String: 统计周期月份,为空时输入0
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出原始打卡记录
export async function fileImportExportActionDetailsSourceExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/source/${params.pathParameters.cycleYear}/${params.pathParameters.cycleMonth}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// year: String: 年份
// month: String: 月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 按指定月份导出非正常打卡数据,设定是否使用stream输出
export async function fileImportExportActionAbnormalDetailsExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/abnormaldetails/year/${params.pathParameters.year}/month/${params.pathParameters.month}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// q_topUnitName: String: 公司,为空时输入0
// q_unitName: String: 部门,为空时输入0
// q_empName: String: 员工,为空时输入0
// cycleYear: String: 统计周期年份,为空时输入0
// cycleMonth: String: 统计周期月份,为空时输入0
// q_date: String: 统计具体日期,为空时输入0
// isAbsent: String: 是否缺勤,为空时输入0
// isLackOfTime: String: 是否工时不足,为空时输入0
// isLate: String: 是否迟到,为空时输入0
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出符合过滤条件的打卡记录明细
export async function fileImportExportActionDetailsExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/filter/${params.pathParameters.q_topUnitName}/${params.pathParameters.q_unitName}/${params.pathParameters.q_empName}/${params.pathParameters.cycleYear}/${params.pathParameters.cycleMonth}/${params.pathParameters.q_date}/${params.pathParameters.isAbsent}/${params.pathParameters.isLackOfTime}/${params.pathParameters.isLate}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 根据文件ID下载附件,设定是否使用stream输出
export async function fileImportExportActionFileDownloadStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/download/${params.pathParameters.id}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// groupId: String: 考勤组ID
// date: String: 日期: yyyy-MM-dd   
// GET : application/json
// 当前考勤组重新生成某一天的考勤数据.
export async function groupActionRebuildDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/rebuild/detail/group/${params.pathParameters.groupId}/date/${params.pathParameters.date}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤组ID   
// GET : application/json
// 刷新考勤组.
export async function groupActionRefreshParticipate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.pathParameters.id}/refresh/participate`, params.data)
    return data.data
}

   
// ins
// groupName: String: 考勤组名称
// checkType: String: 打卡类型 
// shiftId: String: 节假日调班的工作班次id.
// operator: String: 最后操作人
// participateList: List<String>: 考勤打卡人员、组织.
// unParticipateList: List<String>: 无需考勤打卡的人员.
// trueParticipantList: List<String>: 真实的考勤打卡的人员列表，participateList和unParticipateList组合计算的结果.
// workDateList: String: 考勤工作日设置.打卡类型为 自由打卡 的时候需要配置，如 1,2,3,4,5 。 0-6代表周日到周六.
// workDateProperties: AttendanceV2GroupWorkDayProperties: 考勤工作日设置. 打卡类型为 固定班制 的时候需要配置，可以为每个打卡日配置班次
// allowFieldWork: Boolean: 是否允许外勤打卡.
// requiredFieldWorkRemarks: Boolean: 外勤打卡备注是否必填.
// fieldWorkMarkError: Boolean: 外勤打卡是否作为异常数据处理.
// workPlaceIdList: List<String>: 工作场所列表.
// requiredCheckInDateList: List<String>: 必须打卡的日期，包含日期 ｜ 班次id ｜ 是否循环，如 2023-01-01|shiftId|week.
// noNeedCheckInDateList: List<String>: 无需打卡的日期，包含日期 ｜ 是否循环 如 2023-01-01|week .
// POST : application/json
// 创建或更新考勤组信息.
export async function groupActionCreateOrUpdate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// name: String: 考勤组名称
// POST : application/json
// 分页查询考勤组列表.
export async function groupActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 考勤组ID   
// GET : application/json
// 获取考勤组对象.
export async function groupActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 考勤组ID   
// GET : application/json
// 删除考勤组.
export async function groupActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.pathParameters.id}/delete`, params.data)
    return data.data
}


// pathParameters
// flag: String: 导入文件返回的结果标记   
// GET : application/json
// 获取导入人员结果.
export async function leaveActionGetResult (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/import/result/flag/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取导入请假数据的模版.
export async function leaveActionTemplate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/template`, params.data)
    return data.data
}

   
// ins
// person: String: 用户标识
// leaveType: String: 请假类型:带薪年休假|带薪病假|带薪福利假|扣薪事假|出差|培训|其他
// startTime: Date: 开始时间：yyyy-MM-dd HH:mm:ss
// endTime: Date: 结束时间：yyyy-MM-dd HH:mm:ss
// leaveDayNumber: Double: 请假天数
// description: String: 请假说明
// jobId: String: 流程的jobId，申诉流程结束后写入.
// POST : application/json
// 保存请假数据信息.
export async function leaveActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// person: String: 人员DN
// POST : application/json
// 分页查询请假数据列表.
export async function leaveActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 请假数据Id   
// GET : application/json
// 删除请假数据信息.
export async function leaveActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/delete/${params.pathParameters.id}`, params.data)
    return data.data
}

 
// formParameters
// file: File: Excel文件  
// POST : multipart/form-data
// 上传Excel导入请假数据.
export async function leaveActionInput (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/import`, params.data)
    return data.data
}

   
// GET : application/json
// 打卡前获取打卡需要信息的请求.
export async function mobileActionPreCheckIn (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/mobile/check/pre`, params.data)
    return data.data
}

   
// ins
// recordId: String: 打卡对象id
// checkInType: String: 打卡类型，OnDuty OffDuty
// workPlaceId: String: 打卡工作场所id，范围内打卡需传入
// fieldWork: Boolean: 是否外勤打卡.
// signDescription: String: 外勤打卡说明
// sourceDevice: String: 来源设备：Mac|Windows|IOS|Android|其他
// description: String: 其他说明备注
// longitude: String: 当前位置经度
// latitude: String: 当前位置纬度
// recordAddress: String: 当前位置地点描述
// sourceType: String: 打卡数据来源： USER_CHECK（用户打卡） FAST_CHECK（极速打卡） 
// POST : application/json
// 打卡.
export async function mobileActionCheckIn (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/mobile/check`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// dateList: List<String>: 查询是否休息日的日期列表，yyyy-MM-dd
// POST : application/json
// 是否是休息日.
export async function myActionCheckIsMyRestDay (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/rest/date/check`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// startDate: String: 开始日期
// endDate: String: 结束日期
// POST : application/json
// 根据日期查询我的考勤数据.
export async function myActionListDetailWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/detail/list`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 考勤版本查询.
export async function myActionVersionCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/version`, params.data)
    return data.data
}

   
// POST : application/json
// 根据日期查询我的考勤统计.
export async function myActionStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/statistic`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// id: String: 最后一条数据ID
// count: Integer: 每页显示的条目数量   
// ins
// year: String: 年份
// month: String: 月份
// day: String: 日期
// person: String: 人员
// unit: String: 部门
// topUnit: String: 顶级部门，会及联查询下级部门
// checkType: String: 打卡类型:上班打卡，下班打卡，外出打卡
// exceptionType: String: 打卡结果:时间异常，地点异常，未打卡，wifi异常，非常用设备
// PUT : application/json
// 查询企业微信打卡结果
export async function qywxAttendanceActionListDingdingAttendance (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/attendance/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询企业微信同步记录信息
export async function qywxAttendanceActionListDingdingSyncRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/sync/list`, params.data)
    return data.data
}

   
// DELETE : application/json
// 删除所有打卡数据
export async function qywxAttendanceActionDeleteAllData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/all`, params.data)
    return data.data
}


// pathParameters
// dateFrom: String: 开始时间: yyyy-MM-dd
// dateTo: String: 结束时间: yyyy-MM-dd   
// GET : application/json
// 同步企业微信考勤结果
export async function qywxAttendanceActionSyncData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/sync/from/${params.pathParameters.dateFrom}/to/${params.pathParameters.dateTo}/start`, params.data)
    return data.data
}


// pathParameters
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 根据部门查询人员月份统计
export async function qywxAttendanceStatisticActionPersonMonthWithUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/person/unit/${params.pathParameters.unit}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// person: String: 人员
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 人员月份统计查询
export async function qywxAttendanceStatisticActionPersonMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/person/${params.pathParameters.person}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}


// pathParameters
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM   
// GET : application/json
// 部门月份统计查询
export async function qywxAttendanceStatisticActionUnitMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/unit/${params.pathParameters.unit}/${params.pathParameters.year}/${params.pathParameters.month}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取导入打卡记录数据的模版.
export async function recordActionTemplate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/template`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// userId: String: 打卡的用户标识
// startDate: String: 打卡记录开始日期: YYYY-MM-dd
// endDate: String: 打卡记录结束日期: YYYY-MM-dd
// POST : application/json
// 分页查询班次列表.
export async function recordActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// people: String: 人员 DN
// date: String: 日期 yyyy-MM-dd   
// GET : application/json
// 根据人员和日期删除打卡记录.
export async function recordActionDeleteByDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/delete/people/${params.pathParameters.people}/date/${params.pathParameters.date}`, params.data)
    return data.data
}

   
// ins
// person: String: 用户唯一标识
// date: String: 日期：yyyy-MM-dd
// onDutyTime1: String: 第一次上班打卡时间：HH:mm
// offDutyTime1: String: 第一次下班打卡时间：HH:mm
// onDutyTime2: String: 第二次上班打卡时间：HH:mm
// offDutyTime2: String: 第二次下班打卡时间：HH:mm
// onDutyTime3: String: 第三次上班打卡时间：HH:mm
// offDutyTime3: String: 第三次下班打卡时间：HH:mm
// POST : application/json
// 导入某一天的打卡记录.
export async function recordActionInputDailyRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/import/daily`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 打卡记录ID   
// GET : application/json
// 获取打卡记录对象.
export async function recordActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/${params.pathParameters.id}`, params.data)
    return data.data
}

 
// formParameters
// file: File: Excel文件  
// POST : multipart/form-data
// 上传Excel导入打卡记录数据.
export async function recordActionInput (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/import`, params.data)
    return data.data
}

   
// ins
// shiftName: String: 班次名称
// operator: String: 最后操作人
// properties: AttendanceV2ShiftCheckTimeProperties: 班次上下班打卡时间.
// workTime: Integer: 工作时长分钟数.
// needLimitWorkTime: Boolean: 工作时长不足是否记为早退.
// seriousTardinessLateMinutes: Integer: 严重迟到分钟数.
// absenteeismLateMinutes: Integer: 旷工迟到分钟数.
// lateAndEarlyOnTime: String: 上班最多可晚时间
// lateAndEarlyOffTime: String: 下班最多可早走时间
// POST : application/json
// 修改班次信息.
export async function shiftActionShiftUpdate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/update`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// name: String: 班次名称
// POST : application/json
// 分页查询班次列表.
export async function shiftActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/list/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// shiftName: String: 班次名称
// operator: String: 最后操作人
// properties: AttendanceV2ShiftCheckTimeProperties: 班次上下班打卡时间.
// workTime: Integer: 工作时长分钟数.
// needLimitWorkTime: Boolean: 工作时长不足是否记为早退.
// seriousTardinessLateMinutes: Integer: 严重迟到分钟数.
// absenteeismLateMinutes: Integer: 旷工迟到分钟数.
// lateAndEarlyOnTime: String: 上班最多可晚时间
// lateAndEarlyOffTime: String: 下班最多可早走时间
// POST : application/json
// 创建班次信息.
export async function shiftActionShiftCreate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/create`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 班次ID   
// GET : application/json
// 获取班次.
export async function shiftActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 班次ID   
// GET : application/json
// 删除班次.
export async function shiftActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/delete/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// ins
// placeName: String: 场所名称
// placeAlias: String: 场所别名
// creator: String: 创建人
// longitude: String: 经度
// latitude: String: 纬度
// errorRange: Integer: 误差范围
// description: String: 说明备注
// POST : application/json
// 新建或者更新工作地点信息
export async function workPlaceV2ActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 全部的工作地点列表.
export async function workPlaceV2ActionListAll (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/list/all`, params.data)
    return data.data
}

   
// ins
// idList: List<String>: 工作地点id
// POST : application/json
// 根据id列表
export async function workPlaceV2ActionListWithWorkPlaceObject (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/list/ids`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 班次ID   
// DELETE : application/json
// 删除工作地点.
export async function workPlaceV2ActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/${params.pathParameters.id}`, params.data)
    return data.data
}
