

// pathParameters
// subjectId: String: 主贴ID 
// formParameters
// file: File: 
// site: String: 位置  
// POST : multipart/form-data
// 上传附件.
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/upload/subject/${params.pathParameters.subjectId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 根据ID下载指定附件
export async function attachmentActionDownloadWithSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/download/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 根据Work下载附件,设定是否使用stream输出
export async function attachmentActionDownloadWithSubjectStream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/download/${params.pathParameters.id}/stream/${params.pathParameters.stream}`, params.data)
    return data.data
}


// pathParameters
// subjectId: String: 主贴ID
// callback: String: 回调函数名 
// formParameters
// file: File: 
// site: String: 位置  
// POST : multipart/form-data
// 上传附件(带回调).
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/upload/subject/${params.pathParameters.subjectId}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// subjectId: String: 贴子ID   
// GET : application/json
// 根据Subject获取Attachment列表.
export async function attachmentActionListWithSubjectId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/list/subject/${params.pathParameters.subjectId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件ID   
// GET : application/json
// 根据附件Id获取单个附件信息.
export async function attachmentActionGetWithId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// DELETE : application/json
// 删除指定subject下指定的附件.
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有论坛设置信息列表.
export async function bBSConfigSettingActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/all`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// configName: String: 系统配置名称
// configCode: String: 系统配置编码
// configValue: String: 配置值
// valueType: String: 值类型: select | identity | number | date | text
// selectContent: String: 可选值，和select配合使用，以‘|’号分隔
// isMultiple: Boolean: 是否可以多值
// orderNumber: Integer: 排序号
// description: String: 备注说明
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 根据编码获取论坛设置对象.
export async function bBSConfigSettingActionGetByCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/code`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 配置信息ID   
// GET : application/json
// 根据ID获取论坛设置对象.
export async function bBSConfigSettingActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// configName: String: 系统配置名称
// configCode: String: 系统配置编码
// configValue: String: 配置值
// valueType: String: 值类型: select | identity | number | date | text
// selectContent: String: 可选值，和select配合使用，以‘|’号分隔
// isMultiple: Boolean: 是否可以多值
// orderNumber: Integer: 排序号
// description: String: 备注说明
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 更新论坛设置对象, 配置信息不允许新建和删除操作.
export async function bBSConfigSettingActionUpdate (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取BBS系统名称配置的论坛设置对象.
export async function bBSConfigSettingAnonymousActionGetBBSName (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/setting/bbsName`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取登录者可以访问到的所有ForumInfo的信息列表.
export async function forumInfoActionViewAllWithMyPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/forum/view/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 表单ID   
// GET : application/json
// 根据指定ID获取论坛信息.
export async function forumInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/forum/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// forumManagerName: String: 论坛管理员.
// forumVisibleResult: String: 论坛可见范围.
// forumName: String: 论坛名称
// forumManagerList: List<String>: 论坛管理员列表
// forumNotice: String: 论坛公告
// forumVisible: String: 论坛可见：所有人（默认）|根据权限
// visiblePermissionList: List<String>: 版块可见范围
// subjectPublishAble: String: 版块发贴权限：所有人（默认）|根据权限
// publishPermissionList: List<String>: 可发布范围
// replyPublishAble: String: 版块回复权限：所有人（默认）|根据权限
// replyPermissionList: List<String>: 可回复范围
// indexListStyle: String: 首页列表样式：经典|简单矩形|图片矩形
// forumIndexStyle: String: 论坛主页面样式：经典|新闻|照片
// subjectType: String: 论坛版块默认的主题分类名称,以|分隔,如讨论|新闻
// typeCategory: String: 论坛版块支持的主题类别名称,以|分隔,默认:信息|问题|投票
// indexRecommendable: Boolean: 允许推荐到首页：true|false
// subjectNeedAudit: Boolean: 主题需要审核：true|false
// replyNeedAudit: Boolean: 回复需要审核：true|false
// sectionCreateAble: Boolean: 允许创建版块：true|false
// sectionTotal: Long: 版块数量
// subjectTotal: Long: 主题数量
// replyTotal: Long: 回复数量
// subjectTotalToday: Long: 今日主题数量
// replyTotalToday: Long: 今日回复数量
// creatorName: String: 创建人姓名
// forumColor: String: 主题顔色
// forumStatus: String: 论坛状态：启用|停用
// orderNumber: Integer: 排序号
// replyMessageNotify: Boolean: 回复消息通知：true|false
// replyMessageNotifyType: String: 回复消息通知类别：一共3位，第1位是否通知论坛分区管理员，第2位是否通知版主，第3位是否通知发贴人，0-不通知|1-通知
// subjectMessageNotify: Boolean: 新主题发布消息通知：true|false
// subjectMessageNotifyType: String: 新主题发布消息通知类别：一共2位，第1位是否通知论坛分区管理员，第2位是否通知版主，0-不通知|1-通知
// POST : application/json
// 创建新的论坛信息或者更新论坛信息.
export async function forumInfoManagerUserActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有论坛信息列表.
export async function forumInfoManagerUserActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 表单ID   
// DELETE : application/json
// 根据ID删除指定的论坛信息，如果论坛里有版块或者贴子，则不允许删除.
export async function forumInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// url: String: 地址
// size: Integer: 像素大小
// POST : application/json
// 将URL指向的图片转换成base64String.
export async function imageBase64ActionConvert (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/image/encode/base64`, JSON.stringify(params.data))
    return data.data
}

   
// POST : application/json
// 用户进入系统，获取并且更新用户权限角色信息.
export async function loginActionLogin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/login`, params.data)
    return data.data
}

   
// POST : application/json
// 退出系统.
export async function logoutActionLogin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/logout`, params.data)
    return data.data
}

   
// GET : application/json
// 获取登录者可以访问到的所有ForumInfo的信息列表.
export async function mobileIndexActionViewAllWithMyPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/mobile/view/all`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 版块ID   
// GET : application/json
// 查询用户对指定主题的所有操作权限.
export async function permissionInfoActionSubjectPublishable (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/subjectPublishable/${params.pathParameters.sectionId}`, params.data)
    return data.data
}

   
// GET : application/json
// 查询当前用户的操作权限.
export async function permissionInfoActionGetUserPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission`, params.data)
    return data.data
}


// pathParameters
// subjectId: String: 主贴ID   
// GET : application/json
// 查询用户是否可以对指定主题进行回复.
export async function permissionInfoActionReplyPublishable (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/replyPublishable/${params.pathParameters.subjectId}`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 版块ID   
// GET : application/json
// 查询用户在指定板块中的所有操作权限.
export async function permissionInfoActionGetSectionOperationPermissoin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/section/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// subjectId: String: 主贴ID   
// GET : application/json
// 查询用户对指定主题的所有操作权限.
export async function permissionInfoActionGetSubjectOperationPermissoin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/subject/${params.pathParameters.subjectId}`, params.data)
    return data.data
}


// pathParameters
// roleCode: String: 角色编码   
// GET : application/json
// 获取指定的角色Code绑定的所有PermissionInfo的信息列表.
export async function permissionInfoAdminActionListPermissionByRoleCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/role/${params.pathParameters.roleCode}`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 版块ID   
// GET : application/json
// 获取指定的版块绑定的所有PermissionInfo的信息列表.
export async function permissionInfoAdminActionListPermissionBySection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/section/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// forumId: String: 论坛ID   
// GET : application/json
// 获取指定的论坛绑定的所有PermissionInfo的信息列表.
export async function permissionInfoAdminActionListPermissionByForumId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/forum/${params.pathParameters.forumId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 版块ID 
// formParameters
// file: File:   
// POST : multipart/form-data
// 更新版块图标.
export async function pictureActionSectionIconUpdate (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/picture/section/${params.pathParameters.id}/icon`, params.data)
    return data.data
}


// pathParameters
// size: Integer: 尺寸大小 
// formParameters
// file: File:   
// POST : multipart/form-data
// 将图片转为base64编码，并且进行尺寸转换.
export async function pictureActionPictureEncode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/picture/encode/base64/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 页码
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 主题Id
// showSubReply: Boolean: 是否平级显示所有的的回复, 如果为false则只显示第一层
// PUT : application/json
// 列示根据过滤条件的ReplyInfo, 下一页.
export async function replyInfoActionListWithSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/filter/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 回复信息ID   
// GET : application/json
// 根据回复内容ID 查询 针对该回帖的回复内容的列表.
export async function replyInfoActionListSubRepliesWithReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/list/sub/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 回复信息ID   
// GET : application/json
// 根据指定ID获取回贴信息.
export async function replyInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 前一页最后一条记录ID
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 主题Id
// PUT : application/json
// 列示我发表的回贴,下一页.
export async function replyInfoManagerUserActionListMyReplyForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/my/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 回复信息ID   
// DELETE : application/json
// 根据ID删除指定的回贴信息.
export async function replyInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// sectionId: String: 版块ID
// sectionName: String: 版块名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// subjectId: String: 主题ID
// title: String: 回贴标题：如果没有则与主题相同
// parentId: String: 上级回帖ID
// picId: String: 图片信息ID
// content: String: 内容
// creatorName: String: 创建人姓名
// nickName: String: 创建人昵称
// replyAuditStatus: String: 回复审核状态：无审核|待审核|审核通过
// auditorName: String: 审核人姓名
// orderNumber: Integer: 排序号
// machineName: String: 设备类别：手机|平板电脑|个人电脑等
// systemType: String: 系统名称
// hostIp: String: IP地址
// PUT : application/json
// 采纳回复信息.
export async function replyInfoManagerUserActionAccept (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/accept`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// sectionId: String: 版块ID
// sectionName: String: 版块名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// subjectId: String: 主题ID
// title: String: 回贴标题：如果没有则与主题相同
// parentId: String: 上级回帖ID
// picId: String: 图片信息ID
// content: String: 内容
// creatorName: String: 创建人姓名
// nickName: String: 创建人昵称
// replyAuditStatus: String: 回复审核状态：无审核|待审核|审核通过
// auditorName: String: 审核人姓名
// orderNumber: Integer: 排序号
// machineName: String: 设备类别：手机|平板电脑|个人电脑等
// systemType: String: 系统名称
// hostIp: String: IP地址
// POST : application/json
// 创建新的回贴信息或者更新回贴信息.
export async function replyInfoManagerUserActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// sectionId: String: 版块ID
// sectionName: String: 版块名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// roleName: String: 角色名称
// roleCode: String: 角色代码
// roleType: String: 角色类别：论坛角色|版块角色
// description: String: 角色说明
// creatorName: String: 操作者姓名
// orderNumber: Integer: 排序号
// POST : application/json
// 创建新的角色信息或者更新角色信息.
export async function roleInfoActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有角色信息列表.
export async function roleInfoActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/all`, params.data)
    return data.data
}

   
// PUT : application/json
// 根据论坛ID查询论坛的角色列表.
export async function roleInfoActionListByForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/forum/${params.pathParameters.forumId}`, params.data)
    return data.data
}

   
// PUT : application/json
// 根据组织名称查询角色列表.
export async function roleInfoActionListSelectedRoleByUnit (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/unit/selected`, params.data)
    return data.data
}

   
// PUT : application/json
// 根据用户姓名查询角色列表.
export async function roleInfoActionListSelectedRoleByUser (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/user/selected`, params.data)
    return data.data
}

   
// PUT : application/json
// 根据角色编码查询绑定的对象列表.
export async function roleInfoActionListBindObjectByRoleCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/rolecode/selected`, params.data)
    return data.data
}

   
// ins
// unitName: String: 组织名称
// userName: String: 人员名称
// forumId: String: 论坛Id
// sectionId: String: 区段Id
// bindRoleCode: String: 绑定角色
// bindObject: BindObject: 绑定对象
// bindRoleCodes: List<String>: 绑定角色列表
// bindObjectArray: List<BindObject>: 绑定对象列表
// PUT : application/json
// 把一个或者多个角色CODE绑定到一个对象（对象名称#对象类型）上.
export async function roleInfoActionBindRoleToUser (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/bind/object`, JSON.stringify(params.data))
    return data.data
}

   
// PUT : application/json
// 把一个或者多个对象（对象名称#对象类型）绑定到一个角色CODE上.
export async function roleInfoActionBindUserToRole (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/bind/role`, params.data)
    return data.data
}

   
// PUT : application/json
// 根据版块ID查询版块的角色列表.
export async function roleInfoActionListBySection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/section/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 角色ID   
// GET : application/json
// 根据论坛角色ID查询论角色信息.
export async function roleInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 角色ID   
// DELETE : application/json
// 根据ID删除指定的角色信息.
export async function roleInfoActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// forumId: String: 论坛信息ID   
// GET : application/json
// 根据论坛ID获取所有版块的信息列表.
export async function sectionInfoActionViewWithForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/viewforum/${params.pathParameters.forumId}`, params.data)
    return data.data
}

   
// GET : application/json
// 从应用市场同步所有的应用名称，存入论坛板块应用市场字段subjectTypeList.
export async function sectionInfoActionSyn (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/syn`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 主版块信息ID   
// GET : application/json
// 根据主版块ID查询所有的子版块信息列表.
export async function sectionInfoActionListSubSectionByMainSectionId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/viewsub/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 版块信息ID   
// GET : application/json
// 根据指定ID获取版块信息.
export async function sectionInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// sectionVisibleResult: String: 版块访问权限列表，用于接收参数.
// replyPublishResult: String: 版块访问权限列表，用于接收参数.
// subjectPublishResult: String: 版块访问权限列表，用于接收参数.
// sectionName: String: 版块名称
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// sectionLevel: String: 版块级别：主版块|子版块
// sectionDescription: String: 版块简介
// icon: String: 图标icon Base64编码后的文本.
// sectionNotice: String: 版块公告
// sectionVisible: String: 版块可见：所有人（默认）|根据权限
// visiblePermissionList: List<String>: 版块可见范围
// subjectPublishAble: String: 版块发贴权限：所有人（默认）|根据权限
// publishPermissionList: List<String>: 版块可发表范围
// replyPublishAble: String: 版块回复权限：所有人（默认）|根据权限
// replyPermissionList: List<String>: 版块可回复范围
// moderatorNames: List<String>: 版主姓名：可多值，默认为创建者
// subjectTypeList: List<String>: 论坛版块-应用类型（从应用市场同步）
// sectionType: String: 版块类别：图片新闻，普通新闻，公告，经典（默认）
// subjectType: String: 论坛版块默认的主题分类名称,以|分隔,如讨论|新闻, 如果未填写, 则以分区配置为主
// typeCategory: String: 论坛版块支持的主题类别名称,以|分隔,信息|问题|投票, 如果未填写,则以分区配置为主
// indexRecommendable: Boolean: 允许推荐到首页：true|false
// subjectNeedAudit: Boolean: 主题需要审核：true|false
// replyNeedAudit: Boolean: 回复需要审核：true|false
// subSectionCreateAble: Boolean: 允许创建子版块：true|false
// subjectTotal: Long: 主题数量
// replyTotal: Long: 回复数量
// subjectTotalToday: Long: 今日主题数量
// replyTotalToday: Long: 今日回复数量
// creatorName: String: 创建人姓名
// sectionStatus: String: 版块状态：启用|停用
// orderNumber: Integer: 排序号
// replyMessageNotify: Boolean: 回复消息通知：true|false
// replyMessageNotifyType: String: 回复消息通知类别：一共3位，第1位是否通知论坛分区管理员，第2位是否通知版主，第3位是否通知发贴人，0-不通知|1-通知
// subjectMessageNotify: Boolean: 新主题发布消息通知：true|false
// subjectMessageNotifyType: String: 新主题发布消息通知类别：一共2位，第1位是否通知论坛分区管理员，第2位是否通知版主，0-不通知|1-通知
// sectionGrade: Boolean: 版块是否支持评分：true|false
// POST : application/json
// 创建新的版块信息或者更新版块信息.
export async function sectionInfoManagerUserActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 版块信息ID   
// DELETE : application/json
// 根据ID删除指定的版块信息，如果版块里有贴子，则全部删除.
export async function sectionInfoManagerUserActionDeleteForce (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/force/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有版块的信息列表.
export async function sectionInfoManagerUserActionListAllSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/all`, params.data)
    return data.data
}


// pathParameters
// forumId: String: 论坛信息ID   
// GET : application/json
// 根据论坛ID获取所有主版块的信息列表(管理).
export async function sectionInfoManagerUserActionListWithForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/forum/${params.pathParameters.forumId}`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 主版块信息ID   
// GET : application/json
// 根据主版块ID查询所有的子版块信息列表(管理).
export async function sectionInfoManagerUserActionListAllSubSectionByMainSectionId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/sub/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 版块信息ID   
// DELETE : application/json
// 根据ID删除指定的版块信息，如果版块里有贴子，则不允许删除.
export async function sectionInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 查询当前用户是否被禁言，返回被禁言信息.
export async function shutupActionGetShutup (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/get/shutup`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// ins
// person: String: 禁言用户
// POST : application/json
// 分页查询.
export async function shutupActionListPaging (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 解除禁言
export async function shutupActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键.
// person: String: 被禁言用户
// unmuteDate: String: 解封时间
// reason: String: 禁言原因
// POST : application/json
// 保存.
export async function shutupActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/save`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 根据主题ID获取BBSSubjectAttachment列表.
export async function subjectAttachmentActionListBySubjectId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/list/subject/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 图片文件ID
// size: String: 最大高宽值   
// GET : application/json
// 将图片附件转为base64编码.
export async function subjectAttachmentActionImageToBase64 (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.pathParameters.id}/binary/base64/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件信息ID   
// GET : application/json
// 根据指定ID获取附件信息.
export async function subjectAttachmentActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件信息ID   
// DELETE : application/json
// 根据ID删除BBSSubjectAttachment数据对象.
export async function subjectAttachmentActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// sectionId: String: 版块信息ID   
// GET : application/json
// 获取所有可以取到的置顶贴列表.
export async function subjectInfoActionListTopSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/top/${params.pathParameters.sectionId}`, params.data)
    return data.data
}


// pathParameters
// sectionName: String: 版块名称
// subjectType: String: 主题类别   
// GET : application/json
// 统计根据过滤条件(版块名称，标题类别)的SubjectInfo的评分
export async function subjectInfoActionStatSubjectGrade (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/statgrade/sectionName/${params.pathParameters.sectionName}/subjectType/${params.pathParameters.subjectType}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 根据指定ID查看主贴具体信息，需要记录查询次数和热度的.
export async function subjectInfoActionViewSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/view/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 贴子ID.
// voteOptionId: String: 投标选项ID.
// forumId: String: 贴子所属论坛ID.
// mainSectionId: String: 贴子所属主版块ID.
// sectionId: String: 贴子所属版块ID.
// searchContent: String: 标题模糊搜索关键词
// creatorName: String: 创建者名称.
// needPicture: Boolean: 是否只查询有大图的贴子.
// withTopSubject: Boolean: 是否包含置顶贴.
// startTime: Date: 创建日期开始.
// endTime: Date: 创建日期结束.
// PUT : application/json
// 列示根据过滤条件的SubjectInfo,下一页.
export async function subjectInfoActionListSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/filter/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 贴子ID.
// voteOptionId: String: 投标选项ID.
// forumId: String: 贴子所属论坛ID.
// mainSectionId: String: 贴子所属主版块ID.
// sectionId: String: 贴子所属版块ID.
// searchContent: String: 标题模糊搜索关键词
// creatorName: String: 创建者名称.
// needPicture: Boolean: 是否只查询有大图的贴子.
// withTopSubject: Boolean: 是否包含置顶贴.
// PUT : application/json
// 列示根据过滤条件的SubjectInfo,为首页准备的服务.
export async function subjectInfoActionListSubjectForBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/index/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// PUT : application/json
// 列示根据过滤条件的SubjectInfo,下一页.
export async function subjectInfoActionSearchSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/search/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 展示页码
// count: Integer: 每页显示条目数量   
// PUT : application/json
// 列示根据过滤条件的推荐主题列表.
export async function subjectInfoActionListRecommendedSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/recommended/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// PUT : application/json
// 列示根据过滤条件的精华主题列表.
export async function subjectInfoActionListCreamedSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/creamed/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 查询的最大条目数量   
// GET : application/json
// 获取所有推荐到BBS首页的主题列表.
export async function subjectInfoActionListRecommendedSubjectForBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/recommended/index/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 贴子ID.
// voteOptionId: String: 投标选项ID.
// forumId: String: 贴子所属论坛ID.
// mainSectionId: String: 贴子所属主版块ID.
// sectionId: String: 贴子所属版块ID.
// sectionName: String: 贴子所属版块名称.必填
// subjectType: String: 标题类别.必填
// searchContent: String: 标题模糊搜索关键词
// creatorName: String: 创建者名称.
// needPicture: Boolean: 是否只查询有大图的贴子.
// withTopSubject: Boolean: 是否包含置顶贴.
// startTime: Date: 创建日期开始.
// endTime: Date: 创建日期结束.
// POST : application/json
// 列示根据过滤条件(版块名称，标题类别)的SubjectInfo,下一页.
export async function subjectInfoActionListSubjectWithSubjectTypeForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/filter/listsubjectinfo/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消完成主题: 属性isCompleted = false.
export async function subjectInfoManagerUserActionUnComplete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/uncomplete/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消问题贴采纳回复
export async function subjectInfoManagerUserActionUnAcceptReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/unacceptreply/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消原创主题.
export async function subjectInfoManagerUserActionNonOriginal (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonOriginal/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID
// replyId: String: 回帖信息ID   
// GET : application/json
// 问题贴采纳回复
export async function subjectInfoManagerUserActionAcceptReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/acceptreply/${params.pathParameters.id}/${params.pathParameters.replyId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 版块置顶
export async function subjectInfoManagerUserActionTopToSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToSection/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消版块置顶
export async function subjectInfoManagerUserActionNonTopToSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToSection/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 主版块置顶
export async function subjectInfoManagerUserActionTopToMainSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToMainSection/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 论坛置顶
export async function subjectInfoManagerUserActionTopToForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToForum/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// subjectIds: List<String>: 需要变更版块的贴子Id列表
// sectionId: String: 目标版块ID
// PUT : application/json
// 将指定ID的主贴转移到其他的版块中.
export async function subjectInfoManagerUserActionChangeSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/change/section`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消论坛置顶.
export async function subjectInfoManagerUserActionNonTopToForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToForum/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 全局置顶.
export async function subjectInfoManagerUserActionTopToBBS (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToBBS/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消全局置顶.
export async function subjectInfoManagerUserActionNonTopToBBS (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToBBS/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// optionGroups: List<WiVoteOptionGroup>: 投票选项组集合
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// sectionId: String: 版块ID
// sectionName: String: 版块名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// picId: String: 首页图片ID
// title: String: 主题名称：标题
// type: String: 主题类别：讨论，新闻等等,根据版块设置
// typeCategory: String: 主题的类别,不同的类别有不同的操作:信息|问题|投票
// summary: String: 主题摘要
// latestReplyTime: Date: 最新回复时间
// latestReplyUser: String: 最新回复用户
// latestReplyId: String: 最新回复ID
// replyTotal: Long: 回复数量
// viewTotal: Long: 查看数量
// hot: Long: 主题热度
// stopReply: Boolean: 禁止回贴
// recommendToBBSIndex: Boolean: 推荐到系统首页
// recommendToForumIndex: Boolean: 推荐到论坛首页
// forumIndexSetterName: String: 论坛推荐人姓名
// forumIndexSetterTime: Date: 论坛推荐时间
// topToSection: Boolean: 版块置顶
// topToMainSection: Boolean: 主版块置顶
// topToForum: Boolean: 论坛置顶
// topToBBS: Boolean: 全局置顶
// isTopSubject: Boolean: 是否为置顶主题
// isCreamSubject: Boolean: 精华主题
// isCompleted: Boolean: 是否已解决:为问题贴准备
// acceptReplyId: String: 采纳的回复ID:为问题贴准备,问题贴可以采纳一个回复
// screamSetterName: String: 精华设置人姓名
// screamSetterTime: Date: 精华设置时间
// isOriginalSubject: Boolean: 原创主题
// originalSetterName: String: 原创设置人姓名
// originalSetterTime: Date: 原创设置时间
// isRecommendSubject: Boolean: 版主推荐主题
// recommendorName: String: 推荐人姓名
// recommendTime: Date: 推荐时间
// creatorName: String: 创建人姓名
// nickName: String: 创建人昵称
// lastUpdateUser: String: 最后修改人员
// subjectAuditStatus: String: 主题审核状态：无审核|待审核|审核通过
// auditorName: String: 审核人姓名
// subjectStatus: String: 主题状态：启用|关闭|锁定    锁定后是不允许任何人修改和回复的
// voteLimitTime: Date: 投票截止时间
// voteResultVisible: Boolean: 投票结果是否可见
// votePersonVisible: Boolean: 投票人信息是否可见
// anonymousSubject: Boolean: 是否匿名发布
// orderNumber: Integer: 排序号
// attachmentList: List<String>: 附件列表
// editorList: List<String>: 编辑者列表
// machineName: String: 设备类别：手机|平板电脑|个人电脑等
// systemType: String: 系统名称
// hostIp: String: IP地址
// grade: Integer: 评分
// PUT : application/json
// 提交投票信息.
export async function subjectInfoManagerUserActionVoteSubmit (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/vote/submit`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 设置为原创主题.
export async function subjectInfoManagerUserActionSetOriginal (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setOriginal/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 设置为精华主题.
export async function subjectInfoManagerUserActionSetCream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setCream/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消精华主题.
export async function subjectInfoManagerUserActionNonCream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonCream/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// PUT : application/json
// 列示投票记录.
export async function subjectInfoManagerUserActionListVoteRecordForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/voterecord/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 推荐到BBS首页.
export async function subjectInfoManagerUserActionSetRecommendToBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setRecommendToBBSIndex/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消主版块置顶
export async function subjectInfoManagerUserActionNonTopToMainSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToMainSection/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量   
// ins
// subjectId: String: 贴子ID.
// voteOptionId: String: 投标选项ID.
// forumId: String: 贴子所属论坛ID.
// mainSectionId: String: 贴子所属主版块ID.
// sectionId: String: 贴子所属版块ID.
// searchContent: String: 标题模糊搜索关键词
// creatorName: String: 创建者名称.
// needPicture: Boolean: 是否只查询有大图的贴子.
// withTopSubject: Boolean: 是否包含置顶贴.
// PUT : application/json
// 列示我发布的主题.
export async function subjectInfoManagerUserActionListMySubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/my/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 取消推荐到BBS首页.
export async function subjectInfoManagerUserActionNonRecommendToBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonRecommendToBBSIndex/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 锁定主题: 状态修改为'已锁定', 属性stopReply = true
export async function subjectInfoManagerUserActionLock (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/lock/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 根据指定ID获取主题具体信息.
export async function subjectInfoManagerUserActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// DELETE : application/json
// 根据ID删除指定的主题信息.
export async function subjectInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// optionGroups: List<WiVoteOptionGroup>: 投票选项组集合
// forumId: String: 论坛ID
// forumName: String: 论坛名称
// sectionId: String: 版块ID
// sectionName: String: 版块名称
// mainSectionId: String: 主版块ID
// mainSectionName: String: 主版块名称
// picId: String: 首页图片ID
// title: String: 主题名称：标题
// type: String: 主题类别：讨论，新闻等等,根据版块设置
// typeCategory: String: 主题的类别,不同的类别有不同的操作:信息|问题|投票
// summary: String: 主题摘要
// latestReplyTime: Date: 最新回复时间
// latestReplyUser: String: 最新回复用户
// latestReplyId: String: 最新回复ID
// replyTotal: Long: 回复数量
// viewTotal: Long: 查看数量
// hot: Long: 主题热度
// stopReply: Boolean: 禁止回贴
// recommendToBBSIndex: Boolean: 推荐到系统首页
// recommendToForumIndex: Boolean: 推荐到论坛首页
// forumIndexSetterName: String: 论坛推荐人姓名
// forumIndexSetterTime: Date: 论坛推荐时间
// topToSection: Boolean: 版块置顶
// topToMainSection: Boolean: 主版块置顶
// topToForum: Boolean: 论坛置顶
// topToBBS: Boolean: 全局置顶
// isTopSubject: Boolean: 是否为置顶主题
// isCreamSubject: Boolean: 精华主题
// isCompleted: Boolean: 是否已解决:为问题贴准备
// acceptReplyId: String: 采纳的回复ID:为问题贴准备,问题贴可以采纳一个回复
// screamSetterName: String: 精华设置人姓名
// screamSetterTime: Date: 精华设置时间
// isOriginalSubject: Boolean: 原创主题
// originalSetterName: String: 原创设置人姓名
// originalSetterTime: Date: 原创设置时间
// isRecommendSubject: Boolean: 版主推荐主题
// recommendorName: String: 推荐人姓名
// recommendTime: Date: 推荐时间
// creatorName: String: 创建人姓名
// nickName: String: 创建人昵称
// lastUpdateUser: String: 最后修改人员
// subjectAuditStatus: String: 主题审核状态：无审核|待审核|审核通过
// auditorName: String: 审核人姓名
// subjectStatus: String: 主题状态：启用|关闭|锁定    锁定后是不允许任何人修改和回复的
// voteLimitTime: Date: 投票截止时间
// voteResultVisible: Boolean: 投票结果是否可见
// votePersonVisible: Boolean: 投票人信息是否可见
// anonymousSubject: Boolean: 是否匿名发布
// orderNumber: Integer: 排序号
// attachmentList: List<String>: 附件列表
// editorList: List<String>: 编辑者列表
// machineName: String: 设备类别：手机|平板电脑|个人电脑等
// systemType: String: 系统名称
// hostIp: String: IP地址
// grade: Integer: 评分
// POST : application/json
// 创建新的主题信息或者更新主题信息.
export async function subjectInfoManagerUserActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 锁定主题: 状态修改为'启用', 属性stopReply = false.
export async function subjectInfoManagerUserActionUnlock (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/unlock/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 主贴信息ID   
// GET : application/json
// 完成主题: 属性isCompleted = true
export async function subjectInfoManagerUserActionComplete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/complete/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// PUT : application/json
// 列示根据过滤条件的论坛用户信息.
export async function userInfoActionFilterUserInfo (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/userinfo`, params.data)
    return data.data
}


// pathParameters
// person: String: 用户   
// GET : application/json
// 批量更新指定用户帖子和回复的昵称.
export async function userInfoActionUpdateNickName (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/userinfo/update/nick/name/${params.pathParameters.person}`, params.data)
    return data.data
}
