
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有Component对象.
export async function componentActionListAll (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component/list/all`, params.data)
    return data.data
}

   
// DELETE : application/json
// 删除所有Component,还原默认布局.
export async function componentActionDeleteAll (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component/delete/all`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取Component对象.
export async function componentActionGet (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除Component对象.
export async function componentActionDelete (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// name: String: 名称,不可重名.
// title: String: 标题.
// visible: Boolean: 是否是可见的应用.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// path: String: 应用路径.
// iconPath: String: 图标位置.
// allowList: List<String>: 可访问人员.
// denyList: List<String>: 拒绝访问人员.
// POST : application/json
// 创建Component对象.
export async function componentActionCreate (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// name: String: 名称,不可重名.
// title: String: 标题.
// visible: Boolean: 是否是可见的应用.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// path: String: 应用路径.
// iconPath: String: 图标位置.
// allowList: List<String>: 可访问人员.
// denyList: List<String>: 拒绝访问人员.
// PUT : application/json
// 更新Component对象.
export async function componentActionEdit (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/component/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有模块信息,并分类可见与不可见.
export async function statusActionList (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/status/list`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_component_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
