

// pathParameters
// folderId: String: 目录 
// formParameters
// fileMd5: String: 附件md5值
// fileName: String: 附件名称  
// POST : multipart/form-data
// 创建Attachment的内容
export async function attachment2ActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/upload/folder/${params.pathParameters.folderId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取附件内容,输出头信息
export async function attachment2ActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// scale: Integer: 缩放比例   
// GET : application/json
// 获取图片缩放后的base64内容(png格式).scale(0-200)百分比缩放比例.
export async function attachment2ActionGetImageScaleBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/image/scale/${params.pathParameters.scale}/binary/base64`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度   
// GET : application/json
// 下载图片设定宽高后的(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
export async function attachment2ActionDownloadImageWidthHeight (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/download/image/width/${params.pathParameters.width}/height/${params.pathParameters.height}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度   
// GET : application/json
// 获取图片设定宽高后的base64内容(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
export async function attachment2ActionGetImageWidthHeightBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/image/width/${params.pathParameters.width}/height/${params.pathParameters.height}/binary/base64`, params.data)
    return data.data
}


// pathParameters
// name: String: 目录标识   
// GET : application/json
// 根据文件名称查找当前用户的附件.
export async function attachment2ActionListWithFilter (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/filter/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取附件内容.不输出头信息
export async function attachment2ActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// fileType: String: 文件分类：图片(image)|文档(office)|音乐(music)|视频(movie)|其它(other)
// POST : application/json
// 按附件类型分页显示.
export async function attachment2ActionListFileTypePaging (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/type/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识
// type: String: 输出文件类型：html|pdf   
// GET : application/json
// 预览文件,输出html或pdf文件头信息，支持word、ppt、excel、pdf类型文件
export async function attachment2ActionOfficePreview (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/office/preview/type/${params.pathParameters.type}`, params.data)
    return data.data
}

  
// queryParameters
// person: String: 查询用户 
// GET : application/json
// 获取当前用户或指定用户（管理员权限）使用容量.
export async function attachment2ActionGetUseCapacity (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/user/capacity?person=${params.queryParameters.person }`, params.data)
    return data.data
}


// pathParameters
// folderId: String: 目录标识   
// GET : application/json
// 获取当前人员在指定文件夹下的文件.
export async function attachment2ActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/folder/${params.pathParameters.folderId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// POST : application/json
// 获取附件内容,输出头信息,,使用POST方法访问.
export async function attachment2ActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// POST : application/json
// 获取附件内容.不输出头信息,使用POST方法访问.
export async function attachment2ActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// owner: String: 文件所有人   
// GET : application/json
// 获取指定人员共享给我编辑的文件.
export async function attachment2ActionListWithEditor (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/editor/${params.pathParameters.owner}`, params.data)
    return data.data
}


// pathParameters
// owner: String: 文件所有人   
// GET : application/json
// 获取指定人员共享给我的文件.
export async function attachment2ActionListWithShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/share/${params.pathParameters.owner}`, params.data)
    return data.data
}


// pathParameters
// fileMd5: String: 附件md5值   
// GET : application/json
// 根据文件的md5值查找附件.
export async function attachment2ActionCheckFileExist (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/exist/file/${params.pathParameters.fileMd5}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取文件Base64编码后的内容.
export async function attachment2ActionGetBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}/binary/base64`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员的顶层文件.
export async function attachment2ActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/top`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取指定人员共享给我的文件.
export async function attachment2ActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// ins
// name: String: 文件名称.
// folder: String: 文件所属目录.
// description: String: 文件描述.
// PUT : application/json
// 更新Attachment
export async function attachment2ActionUpdate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// DELETE : application/json
// 删除附件.
export async function attachment2ActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// folderId: String: 目录 
// formParameters
// file: File: 上传文件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 创建Attachment的内容
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/upload/folder/${params.pathParameters.folderId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取附件内容,输出头信息
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// scale: Integer: 缩放比例   
// GET : application/json
// 获取图片缩放后的base64内容(png格式).scale(0-200)百分比缩放比例.
export async function attachmentActionGetImageScaleBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/image/scale/${params.pathParameters.scale}/binary/base64`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度   
// GET : application/json
// 获取图片设定宽高后的base64内容(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
export async function attachmentActionGetImageWidthHeightBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/image/width/${params.pathParameters.width}/height/${params.pathParameters.height}/binary/base64`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识
// callback: String: 回调函数名 
// formParameters
// file: File: 上传文件  
// POST : multipart/form-data
// 更新Attachment的内容并返回回调.,使用callback方式,为了与前台兼容使用POST方法
export async function attachmentActionUpdateContentCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/update/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识 
// formParameters
// file: File: 上传文件  
// PUT : multipart/form-data
// 更新Attachment的内容
export async function attachmentActionUpdateContent (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/update`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取附件内容.不输出头信息
export async function attachmentActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// folderId: String: 目录标识   
// GET : application/json
// 获取当前人员在指定文件夹下的文件.
export async function attachmentActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/folder/${params.pathParameters.folderId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// POST : application/json
// 获取附件内容,输出头信息,,使用POST方法访问.
export async function attachmentActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// POST : application/json
// 获取附件内容.不输出头信息,使用POST方法访问.
export async function attachmentActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// owner: String: 文件所有人   
// GET : application/json
// 获取指定人员共享给我编辑的文件.
export async function attachmentActionListWithEditor (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/editor/${params.pathParameters.owner}`, params.data)
    return data.data
}


// pathParameters
// owner: String: 文件所有人   
// GET : application/json
// 获取指定人员共享给我的文件.
export async function attachmentActionListWithShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/share/${params.pathParameters.owner}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取文件Base64编码后的内容.
export async function attachmentActionGetBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}/binary/base64`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员的顶层文件.
export async function attachmentActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/top`, params.data)
    return data.data
}


// pathParameters
// folderId: String: 目录
// callback: String: 回调函数名 
// formParameters
// file: File: 上传文件
// fileName: String: 附件名称  
// POST : multipart/form-data
// 创建Attachment的内容并返回回调.
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/upload/folder/${params.pathParameters.folderId}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取指定人员共享给我的文件.
export async function attachmentActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// ins
// name: String: 文件名称.
// shareList: List<String>: 共享人员
// editorList: List<String>: 可编辑人员
// folder: String: 文件所属分类.
// PUT : application/json
// 更新Attachment
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 附件标识   
// DELETE : application/json
// 删除附件.
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件夹标识   
// GET : application/json
// 获取个人在指定分类下的文件.
export async function complexActionGetWithFolderSubDirect (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/complex/folder/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取指定个人的顶层文件.
export async function complexActionGetTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/complex/top`, params.data)
    return data.data
}

   
// ins
// fileTypeIncludes: List<String>: 只允许上传的文件后缀
// fileTypeExcludes: List<String>: 不允许上传的文件后缀
// person: String: 所属用户.
// name: String: 分类名称.
// capacity: Integer: 容量(单位M)，0表示无限大.
// recycleDays: Integer: 回收站数据保留天数
// POST : application/json
// 保存云文件系统配置.
export async function configActionSaveSystemConfig (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 判断当前用户是否是云文件管理员。
export async function configActionIsFileManager (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config/is/file/manager`, params.data)
    return data.data
}

   
// GET : application/json
// 获取云文件系统配置。
export async function configActionGetSystemConfig (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config/system/config`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/echo`, params.data)
    return data.data
}

   
// GET : application/json
// 获取他人共享给我编辑的文件.
export async function editorActionList (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/editor/list`, params.data)
    return data.data
}


// pathParameters
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放 
// formParameters
// file: File: 上传文件  
// PUT : multipart/form-data
// 上传文件,并进行压缩,如果文件大小小于指定宽度或者宽度<0,则不进行压缩.
export async function fileActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}/scale/${params.pathParameters.scale}`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// GET : application/json
// 下载文件,输出contentType头.
export async function fileActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// referenceType: ReferenceType: 参考类型   
// GET : application/json
// 列示当前用户指定referenceType下的所有File,上一页.
export async function fileActionListPrevWithReferenceType (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/referencetype/${params.pathParameters.referenceType}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量
// referenceType: ReferenceType: 参考类型   
// GET : application/json
// 列示当前用户指定referenceType下的所有File,下一页.
export async function fileActionListNextWithReferenceType (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/next/${params.pathParameters.count}/referencetype/${params.pathParameters.referenceType}`, params.data)
    return data.data
}


// pathParameters
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放   
// POST : application/octet-stream
// 上传文件,并进行压缩,如果文件大小小于指定宽度或者宽度<0,则不进行压缩.为了兼容前台增加的POST方法.
export async function fileActionUploadPostOctetStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}/scale/${params.pathParameters.scale}`, params.data)
    return data.data
}


// pathParameters
// referenceType: String: 参考类型
// reference: String: 参考   
// GET : application/json
// 根据指定的referenceType和reference列示所有的File.
export async function fileActionListWithReferenceTypeWithReference (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户下的所有File,上一页.
export async function fileActionListPrev (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// referenceType: String: 文件类型
// fileName: String: 文件名称,带扩展名的文件名.
// fileUrl: String: *附件来源url地址.
// reference: String: *关联id.
// scale: Integer: 缩放,如果指定宽度<=0,则不进行压缩
// POST : application/json
// 根据url上传附件
export async function fileActionUploadWithUrl (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/with/url`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示当前用户下的所有File,下一页.
export async function fileActionListNext (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// GET : application/json
// 查找未使用的cmsDocument文件.
export async function fileActionManageListUnusedReferenceTypeCmsDocument (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/unused/referencetype/cmsdocument/manage`, params.data)
    return data.data
}

   
// DELETE : application/json
// 清理未使用的cmsDocument文件.
export async function fileActionManageCleanUnusedReferenceTypeCmsDocument (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/clean/unused/referencetype/cmsdocument/manage`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// GET : application/json
// 下载文件,以附件方式,不输出contentType头.
export async function fileActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// POST : application/json
// 下载文件,输出contentType头,使用POST方法访问.
export async function fileActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// POST : application/json
// 下载文件,以附件方式,不输出contentType头,使用POST方法访问.
export async function fileActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放
// callback: String: 回调函数名 
// formParameters
// file: File: 上传文件  
// POST : multipart/form-data
// 创建Attachment的内容并返回回调.
export async function fileActionUploadCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}/scale/${params.pathParameters.scale}/callback/${params.pathParameters.callback}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示有File,上一页.
export async function fileActionListPrevAll (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/prev/${params.pathParameters.count}/all`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前用户的ReferenceType.
export async function fileActionListReference (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/referencetype`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示所有File,下一页.
export async function fileActionListNextAll (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.pathParameters.id}/next/${params.pathParameters.count}/all`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取指定File.
export async function fileActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// referenceType: String: 参考类型
// reference: String: 参考   
// DELETE : application/json
// 根据referenceType和reference删除File.
export async function fileActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}`, params.data)
    return data.data
}


// pathParameters
// attachmentId: String: Attachment标识
// referenceType: String: 参考类型
// reference: String: 参考
// scale: Integer: 缩放   
// GET : application/json
// 将Attachment的附件复制到File中,关联到referenceType和reference.
export async function fileActionCopy (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/copy/attachment/${params.pathParameters.attachmentId}/referencetype/${params.pathParameters.referenceType}/reference/${params.pathParameters.reference}/scale/${params.pathParameters.scale}`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// GET : application/json
// 下载文件,输出contentType头.
export async function fileAnonymousActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// GET : application/json
// 下载文件,以附件方式,不输出contentType头.
export async function fileAnonymousActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// POST : application/json
// 下载文件,输出contentType头,使用POST方法访问.
export async function fileAnonymousActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// id: String: 文件标识   
// POST : application/json
// 下载文件,以附件方式,不输出contentType头,使用POST方法访问.
export async function fileAnonymousActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.pathParameters.id}/download/stream`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// id: String: 附件标识   
// GET : application/json
// 获取文件夹所有附件并打包为zip,输出头信息
export async function folder2ActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.pathParameters.id}/download`, params.data)
    return data.data
}

  
// queryParameters
// attIds: List: 附件ID列表
// folderIds: List: 目录ID列表 
// GET : application/json
// 打包所有指定的附件或目录下的附件,输出头信息
export async function folder2ActionBatchDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/batch/download?attIds=${params.queryParameters.attIds }&folderIds=${params.queryParameters.folderIds }`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取当前人员指定文件夹下的直属文件夹。
export async function folder2ActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/list/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员顶层文件夹。
export async function folder2ActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/list/top`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取文件夹对象。只能由Folder的所有者进行操作,并返回文件夹的下文件的数量和总字节。
export async function folder2ActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// person: String: 所属用户.
// name: String: 分类名称.
// superior: String: 上级目录ID。
// status: String: 文件状态：正常|已删除
// lastUpdateTime: Date: 最后更新时间
// PUT : application/json
// 更新文件夹,不能重名
export async function folder2ActionPut (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除分类,同时删除所有下属的文件和文件夹.
export async function folder2ActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// person: String: 所属用户.
// name: String: 分类名称.
// superior: String: 上级目录ID。
// status: String: 文件状态：正常|已删除
// lastUpdateTime: Date: 最后更新时间
// POST : application/json
// 创建文件夹.
export async function folder2ActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取当前人员指定文件夹下的直属文件夹。
export async function folderActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/list/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取当前人员顶层文件夹。
export async function folderActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/list/top`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取文件夹对象。只能由Folder的所有者进行操作,并返回文件夹的下文件的数量和总字节。
export async function folderActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// person: String: 所属用户.
// name: String: 分类名称.
// superior: String: 上级分类ID,为空代表顶级分类。
// PUT : application/json
// 更新文件夹,不能重名
export async function folderActionPut (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除分类,同时删除所有下属的文件和文件夹.
export async function folderActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// person: String: 所属用户.
// name: String: 分类名称.
// superior: String: 上级分类ID,为空代表顶级分类。
// POST : application/json
// 创建文件夹.
export async function folderActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取回收站的文件对象。
export async function recycleActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取回收站所有文件.
export async function recycleActionList (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/list`, params.data)
    return data.data
}

   
// DELETE : application/json
// 清空回收站的文件.
export async function recycleActionEmpty (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/empty`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除回收站的文件.
export async function recycleActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.pathParameters.id}/delete`, params.data)
    return data.data
}


// pathParameters
// id: String: 共享文件ID   
// POST : application/json
// 从回收站恢复数据
export async function recycleActionResume (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.pathParameters.id}/resume`, params.data)
    return data.data
}


// pathParameters
// shareId: String: 共享文件ID
// fileId: String: 转存附件ID  
// queryParameters
// password: String: 共享密码 
// GET : application/json
// 获取附件内容,输出头信息.
export async function shareActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/download/share/${params.pathParameters.shareId}/file/${params.pathParameters.fileId}?password=${params.queryParameters.password }`, params.data)
    return data.data
}


// pathParameters
// shareId: String: 共享文件ID
// folderId: String: 目录ID   
// GET : application/json
// 获取共享文件指定文件夹下的直属文件夹.
export async function shareActionListFolderWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/folder/share/${params.pathParameters.shareId}/folder/${params.pathParameters.folderId}/`, params.data)
    return data.data
}


// pathParameters
// id: String: 共享文件ID   
// GET : application/json
// 屏蔽共享给我的文件
export async function shareActionShield (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/shield/${params.pathParameters.id}`, params.data)
    return data.data
}

  
// queryParameters
// shareType: String: 分享类型:密码分享(password)|指定分享(member)
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder) 
// GET : application/json
// 获取我共享的文件QueryParam.
export async function shareActionListMyShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/my?shareType=${params.queryParameters.shareType }&fileType=${params.queryParameters.fileType }`, params.data)
    return data.data
}


// pathParameters
// shareId: String: 共享文件ID
// folderId: String: 目录ID   
// GET : application/json
// 获取共享文件指定文件夹下的附件.
export async function shareActionListAttWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/att/share/${params.pathParameters.shareId}/folder/${params.pathParameters.folderId}/`, params.data)
    return data.data
}


// pathParameters
// shareId: String: 共享文件ID
// fileId: String: 转存文件ID
// folderId: String: 转存目录ID 
// formParameters
// password: String: 共享密码  
// POST : application/json
// 保存到网盘
export async function shareActionSaveToFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/share/${params.pathParameters.shareId}/file/${params.pathParameters.fileId}/folder/${params.pathParameters.folderId}`, params.data)
    return data.data
}


// pathParameters
// shareType: String: 分享类型:密码分享(password)|指定分享(member)|全部({0})
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder)|全部({0})   
// GET : application/json
// 获取我共享的文件2.
export async function shareActionListMyShare2 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/my2/${params.pathParameters.shareType}/${params.pathParameters.fileType}`, params.data)
    return data.data
}

  
// queryParameters
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder) 
// GET : application/json
// 获取他人共享给我的文件.
export async function shareActionListShareToMe (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/to/me?fileType=${params.queryParameters.fileType }`, params.data)
    return data.data
}

   
// GET : application/json
// 获取他人共享给我的文件V1.
export async function shareActionListShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// password: String: 共享密码   
// GET : application/json
// 根据密码获取分享的文件对象。
export async function shareActionGetWithPassword (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.pathParameters.id}/password/${params.pathParameters.password}`, params.data)
    return data.data
}


// pathParameters
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder)|全部({0})   
// GET : application/json
// 获取他人共享给我的文件2.
export async function shareActionListShareToMe2 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/to/me2/${params.pathParameters.fileType}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识  
// queryParameters
// password: String: 共享密码 
// GET : application/json
// 获取分享的文件对象。
export async function shareActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.pathParameters.id}?password=${params.queryParameters.password }`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除分享的文件.
export async function shareActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// person: String: 所属用户.
// name: String: 分享的文件或目录名称.
// fileId: String: 文件或目录id.
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder).
// extension: String: 扩展名,必须要有扩展名的文件才允许上传.
// length: Long: 文件大小.
// shareType: String: 分享类型:密码分享(password)|指定分享个人或组织(member).
// password: String: 分享密码.
// validTime: Date: 有效时间
// lastUpdateTime: Date: 最后更新时间
// shareUserList: List<String>: 共享人员
// shareOrgList: List<String>: 共享组织
// shareGroupList: List<String>: 共享群组
// shieldUserList: List<String>: 屏蔽人员
// POST : application/json
// 分享文件.
export async function shareActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
