
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 当前页码
// count: Integer: 每页数量   
// PUT : application/json
// 列示根据过滤条件的HotPictureInfo,下一页
export async function hotPictureInfoActionListForPage (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/filter/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// GET : application/json
// 检查所有的热点新闻还在不在
export async function hotPictureInfoActionExistsCheck (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/exists/check`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// POST : application/json
// 修改已经存在的热点图片的标题信息
export async function hotPictureInfoActionChangeTitle (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/changeTitle`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// application: String: 应用名称：CMS|BBS等等.
// infoId: String: 信息id   
// GET : application/json
// 根据应用类型以及信息ID查询热图信息
export async function hotPictureInfoActionListByApplicationAndInfoId (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.application}/${params.pathParameters.infoId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 热图信息id   
// GET : application/json
// 查询指定的图片的base64编码
export async function hotPictureInfoActionGet (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// application: String: 应用标识
// infoId: String: 信息标识   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// DELETE : application/json
// 根据应用类型以及信息ID删除热图信息
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.application}/${params.pathParameters.infoId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 信息标识   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// DELETE : application/json
// 根据ID删除指定的热图信息
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// application: String: 应用标识
// infoId: String: 信息标识   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// DELETE : application/json
// 根据应用类型以及信息ID删除热图信息
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.application}/${params.pathParameters.infoId}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 信息标识   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// DELETE : application/json
// 根据ID删除指定的热图信息
export async function hotPictureInfoActionDelete (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// application: String: 应用名称
// infoId: String: 信息对象ID
// title: String: 信息标题
// summary: String: 主题摘要
// picId: String: 信息图片URL
// creator: String: 创建者
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// POST : application/json
// 创建新的热图信息或者更新热图信息
export async function hotPictureInfoActionSave (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/user/hotpic`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: BBS主贴ID   
// DELETE : application/json
// 根据BBS主贴ID删除热点信息
export async function hotPictureInfoCipherActionDeleteBBS (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cipher/hotpic/bbs/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 当前页码
// count: Integer: 每页数量   
// ins
// application: String: 应用名称：CMS|BBS等等.
// infoId: String: 信息ID.
// title: String: 信息标题，模糊查询.
// PUT : application/json
// 列示根据过滤条件的HotPictureInfo,下一页
export async function hotPictureInfoCipherActionListForPage (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cipher/hotpic/filter/list/page/${params.pathParameters.page}/count/${params.pathParameters.count}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: CMS文档ID   
// DELETE : application/json
// 根据CMS文档ID删除热点信息
export async function hotPictureInfoCipherActionDeleteCms (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cipher/hotpic/cms/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 热图信息id   
// GET : application/json
// 根据ID获取单个热图信息
export async function hotPictureInfoCipherActionGet (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/cipher/hotpic/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_hotpic_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
