
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}


// pathParameters
// pushType: String: 推送通道类型：jpush|huawei   
// GET : application/json
// 获取当前用户所有绑定设备
export async function deviceActionListAllByPushType (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/list/${params.pathParameters.pushType}`, params.data)
    return data.data
}


// pathParameters
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios   
// DELETE : application/json
// 设备解除绑定
export async function deviceActionRemoveBind (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/unbind/${params.pathParameters.deviceName}/${params.pathParameters.deviceType}`, params.data)
    return data.data
}


// pathParameters
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios
// pushType: String: 推送通道类型：jpush|huawei   
// GET : application/json
// 检查设备是否已经绑定
export async function deviceActionCheckBind (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/check/${params.pathParameters.deviceName}/${params.pathParameters.deviceType}/${params.pathParameters.pushType}`, params.data)
    return data.data
}


// pathParameters
// deviceName: String: 设备号
// deviceType: String: 设备类型：android|ios
// pushType: String: 推送通道类型：jpush|huawei   
// GET : application/json
// 设备解除绑定，新版增加pushType字段
export async function deviceActionRemoveBindNew (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/unbind/new/${params.pathParameters.deviceName}/${params.pathParameters.deviceType}/${params.pathParameters.pushType}`, params.data)
    return data.data
}

   
// GET : application/json
// 查询推送通道类型，jpush|huawei
export async function deviceActionConfigPushType (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/config/push/type`, params.data)
    return data.data
}

   
// ins
// deviceName: String: 设备号deviceName
// deviceType: String: 设备类型deviceType：ios|android
// pushType: String: 推送通道类型：jpush|huawei
// POST : application/json
// 绑定设备
export async function deviceActionBind (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/device/bind`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// ins
// person: String: 人员
// message: String: 消息内容
// POST : application/json
// 发送消息
export async function messageActionSendMessage (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/message/send`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// person: String: 人员
// message: String: 消息内容
// POST : application/json
// 测试发送消息
export async function messageActionSendMessageTest (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/message/test/send`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_jpush_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}
