
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// flag: String: 导入文件返回的结果标记   
// GET : application/json
// 获取导出结果.
export async function exportActionGetResult (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/result/flag/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取政务钉钉人员.
export async function exportActionZhengwuDingdingPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/zhengwudingding/person`, params.data)
    return data.data
}


// pathParameters
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出   
// GET : application/json
// 导出人员组织信息
export async function exportActionExportAllPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/export/all`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 删除群组mockdeletetoget.
export async function groupActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据拼音或者首字母进行模糊查询mockputtopost
export async function groupActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/pinyin/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据名称进行模糊查询mockputtopost.
export async function groupActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 获取拼音首字母开始的群组mockputtopost.
export async function groupActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/pinyininitial/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// personFlag: String: 个人标识   
// GET : application/json
// 查找人员直接作为成员所在的群组.
export async function groupActionListSupDirectWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/person/${params.pathParameters.personFlag}/sup/direct`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// id: String: 数据库主键,自动生成.
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// POST : application/json
// 删除群组成员mockputtopost.
export async function groupActionDeleteMemberMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/delete/member/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// personFlag: String: 个人标识   
// GET : application/json
// 查找人员所在的群组,包括嵌套的下级群组.
export async function groupActionListSupNestedWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/person/${params.pathParameters.personFlag}/sup/nested`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// identityList: List<String>: 群组存放身份成员,identity ID.
// POST : application/json
// 添加群组成员mockputtopost.
export async function groupActionAddMemberMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/add/member/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// description: String: 描述.
// name: String: 群组名称.可重名
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// unitList: List<String>: 群组存放组织成员,存放unit ID.
// identityList: List<String>: 群组存放身份成员,identity ID.
// PUT : application/json
// 更新群组.
export async function groupActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// description: String: 描述.
// name: String: 群组名称.可重名
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// unitList: List<String>: 群组存放组织成员,存放unit ID.
// identityList: List<String>: 群组存放身份成员,identity ID.
// POST : application/json
// 更新群组mockputtopost.
export async function groupActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识
// count: Integer: 数量   
// GET : application/json
// 列示群组,上一页.
export async function groupActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// roleFlag: String: 角色标识   
// GET : application/json
// 查找指定角色所包含的群组.
export async function groupActionListWithRole (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/role/${params.pathParameters.roleFlag}`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据拼音或者首字母进行模糊查询
export async function groupActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/pinyin`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// identityList: List<String>: 群组存放身份成员,identity ID.
// PUT : application/json
// 添加群组成员.
export async function groupActionAddMember (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/add/member`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 查找群组所在的群组,包括嵌套的下级群组.
export async function groupActionListSubNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/sub/nested`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 查找群组直接作为成员所在的群组.
export async function groupActionListSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/sub/direct`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 查找群组的嵌套上级群组
export async function groupActionListSupNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/sup/nested`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// ins
// id: String: 数据库主键,自动生成.
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 删除群组成员.
export async function groupActionDeleteMember (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}/delete/member`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据名称进行模糊查询.
export async function groupActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 查找群组的直接上级群组.
export async function groupActionListSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/sup/direct`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 获取拼音首字母开始的群组.
export async function groupActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/pinyininitial`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 群组标识
// count: Integer: 数量   
// GET : application/json
// 列示群组,下一页.
export async function groupActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// GET : application/json
// 获取群组.
export async function groupActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 群组标识   
// DELETE : application/json
// 删除群组.
export async function groupActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 群组名称.可重名
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 群组的个人成员.存放个人 ID.
// groupList: List<String>: 群组的群组成员.存放群组 ID.
// unitList: List<String>: 群组存放组织成员,存放unit ID.
// identityList: List<String>: 群组存放身份成员,identity ID.
// POST : application/json
// 创建群组.
export async function groupActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 身份标识   
// GET : application/json
// 删除身份,同时删除职务mockdeletetoget.
export async function identityActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// POST : application/json
// 根据拼音或者首字母搜索mockputtopost.
export async function identityActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/pinyin/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// POST : application/json
// 进行模糊查询mockputtopost.
export async function identityActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// POST : application/json
// 获取拼音首字母开始的身份mockputtopost.
export async function identityActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/pinyininitial/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织
// unitDutyName: String: 组织职务名称   
// GET : application/json
// 根据给定的组织和组织职务名称,列示其所有的身份.
export async function identityActionListWithUnitWithUnitDutyName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.pathParameters.flag}/unitduty/name/${params.pathParameters.unitDutyName}`, params.data)
    return data.data
}


// pathParameters
// unitDutyName: String: 组织职务名称   
// GET : application/json
// 根据给定的组织职务名称,列示其所有的身份.
export async function identityActionListWithUnitDutyName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/unitduty/name/${params.pathParameters.unitDutyName}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 身份标识   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// person: String: 身份所属个人,存放个人 ID,不为空.
// unit: String: 属性所属组织,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// major: Boolean: 主身份标识
// PUT : application/json
// 更新身份.
export async function identityActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 身份标识   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// person: String: 身份所属个人,存放个人 ID,不为空.
// unit: String: 属性所属组织,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// major: Boolean: 主身份标识
// POST : application/json
// 更新身份mockputtopost.
export async function identityActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 身份标识
// count: Integer: 数量   
// GET : application/json
// 列示身份,上一页.
export async function identityActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// PUT : application/json
// 根据拼音或者首字母搜索.
export async function identityActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/pinyin`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// PUT : application/json
// 进行模糊查询.
export async function identityActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// unitDutyList: List<String>: 搜索职务范围,为空则不限定
// groupList: List<String>: 搜索群组范围(仅限群组的身份成员),为空则不限定
// PUT : application/json
// 获取拼音首字母开始的身份.
export async function identityActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/pinyininitial`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// unitFlag: String: 组织标识   
// GET : application/json
// 根据给定的组织,列示其所有的身份.
export async function identityActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/unit/${params.pathParameters.unitFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 身份标识
// count: Integer: 数量   
// GET : application/json
// 列示身份,下一页.
export async function identityActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// personFlag: String: 个人标识   
// GET : application/json
// 根据给定的人员,列示其所有的身份.
export async function identityActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/person/${params.pathParameters.personFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 身份标识   
// GET : application/json
// 获取身份.
export async function identityActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 身份标识   
// DELETE : application/json
// 删除身份,同时删除职务.
export async function identityActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// person: String: 身份所属个人,存放个人 ID,不为空.
// unit: String: 属性所属组织,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// major: Boolean: 主身份标识
// POST : application/json
// 创建身份.
export async function identityActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 身份标识
// followFlag: String: 后续身份标识   
// GET : application/json
// 更新身份.
export async function identityActionOrder (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.pathParameters.flag}/order/before/${params.pathParameters.followFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 导入文件返回的结果标记   
// GET : application/json
// 获取导入人员结果.
export async function inputPersonActionGetResult (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/result/flag/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取导入人员模版.
export async function inputPersonActionTemplate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/template`, params.data)
    return data.data
}

   
// GET : application/json
// 清空人员组织数据.
export async function inputPersonActionWipeAll (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/wipe`, params.data)
    return data.data
}

 
// formParameters
// file: File: Excel文件  
// POST : multipart/form-data
// 上传Excel导入人员.
export async function inputPersonActionInput (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson`, params.data)
    return data.data
}


// pathParameters
// stream: Boolean: 是否采用流格式直接作为附件下载   
// GET : application/json
// 获取用户登录记录的Excel.
export async function loginRecordActionLoginRecord (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/loginrecord/${params.pathParameters.stream}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// ins
// excludeUnit: List<String>: 不允许被查询单位.
// excludePerson: List<String>: 不允许被查询个人.
// limitQueryOuter: List<String>: 限制查看外部门.
// limitQueryAll: List<String>: 限制查看所有人
// explain: String: 描述.
// status: String: 状态.草稿,发布
// extend1: String: extend1扩展字段.
// extend2: String: extend2扩展字段.
// extend3: String: extend3扩展字段.
// POST : application/json
// 更新通讯录配置mockputtopost.
export async function permissionSettingActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 通讯录配置标识   
// GET : application/json
// 删除通讯录设置配置mockdeletetoget.
export async function permissionSettingActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// GET : application/json
// 获取通讯录配置.
export async function permissionSettingActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// ins
// excludeUnit: List<String>: 不允许被查询单位.
// excludePerson: List<String>: 不允许被查询个人.
// limitQueryOuter: List<String>: 限制查看外部门.
// limitQueryAll: List<String>: 限制查看所有人
// explain: String: 描述.
// status: String: 状态.草稿,发布
// extend1: String: extend1扩展字段.
// extend2: String: extend2扩展字段.
// extend3: String: extend3扩展字段.
// PUT : application/json
// 更新通讯录配置.
export async function permissionSettingActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有通讯录设置配置
export async function permissionSettingActionList (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/list`, params.data)
    return data.data
}


// pathParameters
// flag: String: 通讯录配置标识   
// DELETE : application/json
// 删除通讯录设置配置.
export async function permissionSettingActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// excludeUnit: List<String>: 不允许被查询单位.
// excludePerson: List<String>: 不允许被查询个人.
// limitQueryOuter: List<String>: 限制查看外部门.
// limitQueryAll: List<String>: 限制查看所有人
// explain: String: 描述.
// status: String: 状态.草稿,发布
// extend1: String: extend1扩展字段.
// extend2: String: extend2扩展字段.
// extend3: String: extend3扩展字段.
// POST : application/json
// 创建通讯录权限设置.
export async function permissionSettingActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人标识   
// ins
// value: String: 字符串值.
// PUT : application/json
// 更新指定个人的密码.
export async function personActionSetPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/set/password`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 删除个人mockdeletetoget.
export async function personActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据拼音或者首字母进行模糊查询mockputtopost.
export async function personActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/pinyin/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人标识   
// ins
// value: String: 字符串值.
// POST : application/json
// 更新指定个人的密码mockputtopost.
export async function personActionSetPasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/set/password/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人标识 
// formParameters
// file: File: 头像文件  
// POST : multipart/form-data
// 设置个人的头像mockputtopost.
export async function personActionSetIconMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/icon/mockputtopost`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据名称进行模糊查询mockputtopost.
export async function personActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 删除个人关联信息（身份、角色等），但保留人员（企业离退休人员需要能登录平台但不能做业务处理）.
export async function personActionReserveDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/reserve/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// groupFlag: String: 群组标识   
// GET : application/json
// 根根据给定的群组,列示嵌套的个人成员.
export async function personActionListSubNestedWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/group/${params.pathParameters.groupFlag}/sub/nested`, params.data)
    return data.data
}


// pathParameters
// groupFlag: String: 群组标识   
// GET : application/json
// 根据给定的群组,列示直接个人成员.
export async function personActionListSubDirectWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/group/${params.pathParameters.groupFlag}/sub/direct`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 获取拼音首字母开始的个人mockputtopost.
export async function personActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/pinyininitial/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// ins
// genderType: GenderType: 性别.男:m,女:f,未知:d
// iconMdpi: String: icon Base64编码后的文本（中等尺寸图像）.
// iconLdpi: String: icon Base64编码后的文本（小尺寸图像）.
// signature: String: 个性签名.
// description: String: 描述.
// name: String: 名称,可重名.
// nickName: String: 昵称.
// employee: String: 工号,不可重复.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@P结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 个人管理者.默认为创建者。
// superior: String: 汇报对象.
// changePasswordTime: Date: 用户密码最后修改时间.
// ipAddress: String: 允许登录的IP.
// mail: String: 邮件地址.
// weixin: String: 微信号.
// qq: String: QQ号.
// mobile: String: 必填,手机号.
// hiddenMobile: Boolean: 是否隐藏手机号.
// officePhone: String: 办公电话.
// boardDate: Date: 入职时间.
// birthday: Date: 生日.
// age: Integer: 年龄
// dingdingId: String: 钉钉人员ID.
// dingdingHash: String: 钉钉人员哈希特征.
// weLinkId: String: WeLikn人员ID.
// weLinkHash: String: WeLink人员哈希特征.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公人员ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公人员哈希特征.
// mpwxopenId: String: 微信公众号人员openid.
// open1Id: String: oauth登录id1.
// open2Id: String: oauth登录id2.
// open3Id: String: oauth登录id3.
// open4Id: String: oauth登录id4.
// open5Id: String: oauth登录id5.
// failureTime: Date: 登录失败记录时间.
// failureCount: Integer: 登录失败次数
// language: String: 国际化语言,如：zh-CN,zh,en,zh_TW等.
// PUT : application/json
// 更新个人.
export async function personActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// ins
// genderType: GenderType: 性别.男:m,女:f,未知:d
// iconMdpi: String: icon Base64编码后的文本（中等尺寸图像）.
// iconLdpi: String: icon Base64编码后的文本（小尺寸图像）.
// signature: String: 个性签名.
// description: String: 描述.
// name: String: 名称,可重名.
// nickName: String: 昵称.
// employee: String: 工号,不可重复.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@P结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 个人管理者.默认为创建者。
// superior: String: 汇报对象.
// changePasswordTime: Date: 用户密码最后修改时间.
// ipAddress: String: 允许登录的IP.
// mail: String: 邮件地址.
// weixin: String: 微信号.
// qq: String: QQ号.
// mobile: String: 必填,手机号.
// hiddenMobile: Boolean: 是否隐藏手机号.
// officePhone: String: 办公电话.
// boardDate: Date: 入职时间.
// birthday: Date: 生日.
// age: Integer: 年龄
// dingdingId: String: 钉钉人员ID.
// dingdingHash: String: 钉钉人员哈希特征.
// weLinkId: String: WeLikn人员ID.
// weLinkHash: String: WeLink人员哈希特征.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公人员ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公人员哈希特征.
// mpwxopenId: String: 微信公众号人员openid.
// open1Id: String: oauth登录id1.
// open2Id: String: oauth登录id2.
// open3Id: String: oauth登录id3.
// open4Id: String: oauth登录id4.
// open5Id: String: oauth登录id5.
// failureTime: Date: 登录失败记录时间.
// failureCount: Integer: 登录失败次数
// language: String: 国际化语言,如：zh-CN,zh,en,zh_TW等.
// POST : application/json
// 更新个人mockputtopost.
export async function personActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// DELETE : application/json
// 删除个人关联信息（身份、角色等），但保留人员（企业离退休人员需要能登录平台但不能做业务处理）.
export async function personActionReserveDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/reserve`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识
// count: Integer: 数量   
// GET : application/json
// 列示个人,上一页.
export async function personActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// roleFlag: String: 角色标识   
// GET : application/json
// 根根据给定的角色,列示个人成员.
export async function personActionListWithRole (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/role/${params.pathParameters.roleFlag}`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据拼音或者首字母进行模糊查询.
export async function personActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/pinyin`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 用户解锁，用于管理员解锁登录多次失败被锁定的用户.
export async function personActionUnlockPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/unlock/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人标识   
// GET : application/json
// 重置个人的密码.
export async function personActionResetPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/reset/password`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据名称进行模糊查询.
export async function personActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 获取拼音首字母开始的个人.
export async function personActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/pinyininitial`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// password: String: 校验密码   
// GET : application/json
// 校验password密码等级.
export async function personActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/check/password/${params.pathParameters.password}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人标识   
// GET : application/json
// 获取个人头像.
export async function personActionGetIconWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/icon`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人标识 
// formParameters
// file: File: 头像文件  
// PUT : multipart/form-data
// 设置个人的头像.
export async function personActionSetIcon (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/icon`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识
// date: String: 过期时间   
// ins
// passwordExpiredTime: Date: 到期日期.
// GET : application/json
// 设置用户密码到期时间，用于管理员设置用户的密码到期时间.
export async function personActionSetPasswordExpiredTime (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}/set/password/expired/time/${params.pathParameters.date}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识
// count: Integer: 数量   
// GET : application/json
// 列示个人,下一页.
export async function personActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 获取个人,附带身份,身份所在的组织,个人所在群组,个人拥有角色.
export async function personActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// DELETE : application/json
// 删除个人.
export async function personActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// genderType: GenderType: 性别.男:m,女:f,未知:d
// iconMdpi: String: icon Base64编码后的文本（中等尺寸图像）.
// iconLdpi: String: icon Base64编码后的文本（小尺寸图像）.
// signature: String: 个性签名.
// description: String: 描述.
// name: String: 名称,可重名.
// nickName: String: 昵称.
// employee: String: 工号,不可重复.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@P结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 个人管理者.默认为创建者。
// superior: String: 汇报对象.
// ipAddress: String: 允许登录的IP.
// mail: String: 邮件地址.
// weixin: String: 微信号.
// qq: String: QQ号.
// mobile: String: 必填,手机号.
// hiddenMobile: Boolean: 是否隐藏手机号.
// officePhone: String: 办公电话.
// boardDate: Date: 入职时间.
// birthday: Date: 生日.
// age: Integer: 年龄
// dingdingId: String: 钉钉人员ID.
// dingdingHash: String: 钉钉人员哈希特征.
// weLinkId: String: WeLikn人员ID.
// weLinkHash: String: WeLink人员哈希特征.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公人员ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公人员哈希特征.
// mpwxopenId: String: 微信公众号人员openid.
// open1Id: String: oauth登录id1.
// open2Id: String: oauth登录id2.
// open3Id: String: oauth登录id3.
// open4Id: String: oauth登录id4.
// open5Id: String: oauth登录id5.
// failureTime: Date: 登录失败记录时间.
// failureCount: Integer: 登录失败次数
// language: String: 国际化语言,如：zh-CN,zh,en,zh_TW等.
// topUnitList: List<String>: 所属顶层组织.
// POST : application/json
// 创建个人.
export async function personActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人属性标识   
// GET : application/json
// 删除个人属性mockdeletetoget.
export async function personAttributeActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人属性标识
// count: Integer: 数量   
// GET : application/json
// 列示个人属性,上一页.
export async function personAttributeActionStandardListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人属性标识   
// ins
// description: String: 描述.
// name: String: 名称,同一个组织中不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@PA结尾.
// person: String: 个人属性所属个人,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// PUT : application/json
// 更新个人属性.
export async function personAttributeActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人属性标识   
// ins
// description: String: 描述.
// name: String: 名称,同一个组织中不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@PA结尾.
// person: String: 个人属性所属个人,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// POST : application/json
// 更新个人属性mockputtopost.
export async function personAttributeActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 个人属性标识
// count: Integer: 数量   
// GET : application/json
// 列示个人属性,下一页.
export async function personAttributeActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// personFlag: String: 个人标识   
// GET : application/json
// 列示个人的个人属性.
export async function personAttributeActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/person/${params.pathParameters.personFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人属性标识   
// GET : application/json
// 获取个人属性.附带个人
export async function personAttributeActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 个人属性标识   
// DELETE : application/json
// 删除个人属性.
export async function personAttributeActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 名称,同一个组织中不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@PA结尾.
// person: String: 个人属性所属个人,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// POST : application/json
// 创建个人属性.
export async function personAttributeActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 页码
// size: Integer: 每页几条   
// ins
// key: String: 匹配关键字
// groupType: String: 分组名称
// PUT : application/json
// 按分组查询当前登录人的名片.分页
export async function personCardActionListPagingWithGroupType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpagingwithgroup/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 页码
// size: Integer: 每页几条   
// ins
// key: String: 匹配关键字:姓名，手机号，电话，姓名拼音，分组，状态
// POST : application/json
// 获取当前登录人的名片分页mockputtopost.
export async function personCardActionListPagingMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpaging/page/${params.pathParameters.page}/size/${params.pathParameters.size}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// GET : application/json
// 删除个人名片mockdeletetoget.
export async function personCardActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 页码
// size: Integer: 每页几条   
// ins
// key: String: 匹配关键字
// groupType: String: 分组名称
// POST : application/json
// 按分组查询当前登录人的名片分页mockputtopost.
export async function personCardActionListPagingWithGroupTypeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpagingwithgroup/page/${params.pathParameters.page}/size/${params.pathParameters.size}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// cardId: String: 名片id   
// GET : application/json
// 组织人员生成二维码
export async function personCardActionPersoncode (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/createCode/${params.pathParameters.cardId}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 页码
// size: Integer: 每页几条   
// ins
// key: String: 匹配关键字:姓名，手机号，电话，姓名拼音，分组，状态
// PUT : application/json
// 获取当前登录人的名片.分页
export async function personCardActionListPaging (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpaging/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取当前登录人的所有名片
export async function personCardActionMylist (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/mylist`, params.data)
    return data.data
}

   
// GET : application/json
// 列出当前用户的所有分组
export async function personCardActionListGroupTypes (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listgrouptypes`, params.data)
    return data.data
}


// pathParameters
// idList: String: 名片id组   
// GET : application/json
// 导出组织通讯录vcf
export async function personCardActionListVCf (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listVCf/${params.pathParameters.idList}`, params.data)
    return data.data
}


// pathParameters
// idList: String: 名片id组   
// GET : application/json
// 导出个人通讯录vcf
export async function personCardActionListPersonalVCf (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listPersonalVCf/${params.pathParameters.idList}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// GET : application/json
// 获取个人名片.
export async function personCardActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// ins
// name: String: 名称,可重名.
// genderType: GenderType: 性别.男:m,女:f,未知:d
// groupType: String: 所属分组.
// mobile: String: 必填,手机号.
// officePhone: String: 办公电话.
// address: String: 地址.
// description: String: 备注.
// extend1: String: extend1扩展字段.
// extend2: String: extend2扩展字段.
// extend3: String: extend3扩展字段.
// status: String: 状态.草稿,发布
// PUT : application/json
// 更新个人名片.
export async function personCardActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 名片标识   
// DELETE : application/json
// 删除个人名片.
export async function personCardActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// name: String: 名称,可重名.
// genderType: GenderType: 性别.男:m,女:f,未知:d
// groupType: String: 所属分组.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// mobile: String: 必填,手机号.
// officePhone: String: 办公电话.
// address: String: 地址.
// description: String: 备注.
// extend1: String: extend1扩展字段.
// extend2: String: extend2扩展字段.
// extend3: String: extend3扩展字段.
// status: String: 状态.草稿,发布
// POST : application/json
// 创建名片.
export async function personCardActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// cardId: String: 名片id   
// GET : application/json
// 个人通讯录生成二维码
export async function personCardActionCode (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/createQR/${params.pathParameters.cardId}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 角色标识   
// GET : application/json
// 删除角色对象mockdeletetoget.
export async function roleActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据拼音或者首字母进行模糊查询mockputtopost.
export async function roleActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/pinyin/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 根据名称进行模糊查询mockputtopost.
export async function roleActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// POST : application/json
// 获取拼音首字母开始的Person mockputtopost.
export async function roleActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/pinyininitial/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 角色标识   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 角色个人成员,多值,存储 Person ID.
// groupList: List<String>: 角色群组成员,多值,存储 Group ID.
// PUT : application/json
// 更新角色.
export async function roleActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 角色标识   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 角色个人成员,多值,存储 Person ID.
// groupList: List<String>: 角色群组成员,多值,存储 Group ID.
// POST : application/json
// 更新角色mockputtopost.
export async function roleActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 角色标识
// count: Integer: 数量   
// GET : application/json
// 列示角色对象,上一页.
export async function roleActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// groupFlag: String: 群组标识   
// GET : application/json
// 根据给定的Group ID,获取其拥有的角色对象.
export async function roleActionListWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/group/${params.pathParameters.groupFlag}`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据拼音或者首字母进行模糊查询.
export async function roleActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/pinyin`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 根据名称进行模糊查询.
export async function roleActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// groupList: List<String>: 搜索群组范围,为空则不限定
// roleList: List<String>: 搜索角色范围,为空则不限定
// PUT : application/json
// 获取拼音首字母开始的Person.
export async function roleActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/pinyininitial`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 角色标识
// count: Integer: 数量   
// GET : application/json
// 列示角色对象,下一页.
export async function roleActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// personFlag: String: 个人标识   
// GET : application/json
// 根据给定的人员的的角色.
export async function roleActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/person/${params.pathParameters.personFlag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 角色标识   
// GET : application/json
// 获取角色.
export async function roleActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 角色标识   
// DELETE : application/json
// 删除角色对象.
export async function roleActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 名称,可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// personList: List<String>: 角色个人成员,多值,存储 Person ID.
// groupList: List<String>: 角色群组成员,多值,存储 Group ID.
// POST : application/json
// 创建角色.
export async function roleActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有的组织属性.
export async function unitActionListType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/type`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识
// type: String: 组织的type属性值,匹配多值中的某一个   
// GET : application/json
// 查找递归上级组织中符合type值的对象.
export async function unitActionListSupNestedWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/sup/nested/type/${params.pathParameters.type}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 删除组织mockdeletetoget.
export async function unitActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// POST : application/json
// 根据拼音或者首字母进行模糊查询mockputtopost.
export async function unitActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/pinyin/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// POST : application/json
// 根据名称进行模糊查询mockputtopost.
export async function unitActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// POST : application/json
// 获取拼音首字母开始的组织mockputtopost.
export async function unitActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/pinyininitial/mockputtopost`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织的type属性值,匹配多值中的某一个,不能为空
// PUT : application/json
// 通过type属性值搜索组织.
export async function unitActionListWithUnitWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/unit/type`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织的type属性值,匹配多值中的某一个,不能为空
// POST : application/json
// 通过type属性值搜索组织mockputtopost.
export async function unitActionListWithUnitWithTypeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/unit/type/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// identityFlag: String: 组织标识
// level: Integer: 组织等级   
// GET : application/json
// 根据身份获取递归上级组织中等级为指定登记的组织.
export async function unitActionGetWithIdentityWithLevel (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/identity/${params.pathParameters.identityFlag}/level/${params.pathParameters.level}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识
// type: String: 组织的type属性值,匹配多值中的某一个   
// GET : application/json
// 查找直接下级组织中符合type值的对象.
export async function unitActionListSubDirectWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/sub/direct/type/${params.pathParameters.type}`, params.data)
    return data.data
}


// pathParameters
// identityFlag: String: 组织标识
// type: String: 组织类型   
// GET : application/json
// 根据身份获取递归上级组织中type为指定type的组织.
export async function unitActionGetWithIdentityWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/identity/${params.pathParameters.identityFlag}/type/${params.pathParameters.type}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// ins
// name: String: 名称,可以重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.以@U结尾.
// typeList: List<String>: 组织类型.
// description: String: 描述.
// shortName: String: 组织简称。
// levelOrderNumber: String: 层级排序号,使用/进行分割.将逐级unit中的orderNumber的Integer值扩充到在Organization配置中指定位数的文本值,前填充0
// superior: String: 上级组织.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 组织的管理人员.
// dingdingId: String: 钉钉部门ID.
// dingdingHash: String: 钉钉部门哈希特征.
// weLinkId: String: WeLink部门ID.
// weLinkHash: String: WeLink部门哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公组织ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公组织哈希特征.
// PUT : application/json
// 更新组织.
export async function unitActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// ins
// name: String: 名称,可以重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.以@U结尾.
// typeList: List<String>: 组织类型.
// description: String: 描述.
// shortName: String: 组织简称。
// levelOrderNumber: String: 层级排序号,使用/进行分割.将逐级unit中的orderNumber的Integer值扩充到在Organization配置中指定位数的文本值,前填充0
// superior: String: 上级组织.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 组织的管理人员.
// dingdingId: String: 钉钉部门ID.
// dingdingHash: String: 钉钉部门哈希特征.
// weLinkId: String: WeLink部门ID.
// weLinkHash: String: WeLink部门哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公组织ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公组织哈希特征.
// POST : application/json
// 更新组织mockputtopost.
export async function unitActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织标识
// count: Integer: 数量   
// GET : application/json
// 列示组织对象,上一页.
export async function unitActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// PUT : application/json
// 根据拼音或者首字母进行模糊查询.
export async function unitActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/pinyin`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 递归下级组织.
export async function unitActionListSubNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/sub/nested`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 直接下级组织.
export async function unitActionListSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/sub/direct`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 递归上级组织.
export async function unitActionListSupNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/sup/nested`, params.data)
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// PUT : application/json
// 根据名称进行模糊查询.
export async function unitActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 搜索关键字
// unitList: List<String>: 搜索组织范围,为空则不限定
// type: String: 组织类型
// PUT : application/json
// 获取拼音首字母开始的组织.
export async function unitActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/pinyininitial`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 指定人员.
// POST : application/json
// 列示指定人员在组织管理者中的组织.
export async function unitActionListWithController (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/controller`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// type: String: 组织的type属性值,匹配多值中的某一个   
// GET : application/json
// 通过type属性值搜索顶层组织.
export async function unitActionListTopWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/top/type/${params.pathParameters.type}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示顶层组织.
export async function unitActionListTop (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/top`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 直接上级组织.
export async function unitActionGetSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}/sup/direct`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识
// count: Integer: 数量   
// GET : application/json
// 列示组织,下一页.
export async function unitActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// GET : application/json
// 获取组织.
export async function unitActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// unitList: List<String>: 组织标识
// POST : application/json
// 批量获取组织.
export async function unitActionList (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织标识   
// DELETE : application/json
// 删除组织.
export async function unitActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// name: String: 名称,可以重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名.以@U结尾.
// typeList: List<String>: 组织类型.
// description: String: 描述.
// shortName: String: 组织简称。
// levelOrderNumber: String: 层级排序号,使用/进行分割.将逐级unit中的orderNumber的Integer值扩充到在Organization配置中指定位数的文本值,前填充0
// superior: String: 上级组织.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// controllerList: List<String>: 组织的管理人员.
// dingdingId: String: 钉钉部门ID.
// dingdingHash: String: 钉钉部门哈希特征.
// weLinkId: String: WeLink部门ID.
// weLinkHash: String: WeLink部门哈希特征.
// qiyeweixinId: String: 企业微信人员ID.
// zhengwuDingdingId: String: 政务钉钉人员ID.
// andFxId: String: 移动办公组织ID.
// zhengwuDingdingHash: String: 政务钉钉人员哈希特征.
// qiyeweixinHash: String: 企业微信人员哈希特征.
// andFxHash: String: 移动办公组织哈希特征.
// POST : application/json
// 创建组织.
export async function unitActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// GET : application/json
// 删除组织属性mockdeletetoget.
export async function unitAttributeActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// ins
// description: String: 描述.
// name: String: 名称,不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UA结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// PUT : application/json
// 更新组织属性.
export async function unitAttributeActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// ins
// description: String: 描述.
// name: String: 名称,不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UA结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// POST : application/json
// 更新组织属性mockputtopost.
export async function unitAttributeActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织属性标识
// count: Integer: 数量   
// GET : application/json
// 列示组织属性,上一页.
export async function unitAttributeActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// GET : application/json
// 根据给定的组织,列示其所有的组织属性对象.
export async function unitAttributeActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/unit/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织属性标识
// count: Integer: 数量   
// GET : application/json
// 列示组织属性,下一页.
export async function unitAttributeActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// GET : application/json
// 获取组织属性对象.
export async function unitAttributeActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织属性标识   
// DELETE : application/json
// 删除组织属性.
export async function unitAttributeActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 名称,不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UA结尾.
// unit: String: 组织属性所属组织,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// attributeList: List<String>: 属性值,多值.
// POST : application/json
// 创建组织属性.
export async function unitAttributeActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织职务标识   
// GET : application/json
// 删除组织职务mockdeletetoget.
export async function unitDutyActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.pathParameters.flag}/mockdeletetoget`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织职务标识   
// ins
// description: String: 描述.
// name: String: 名称,同一组织下不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UD结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// identityList: List<String>: 组织职务身份成员,多值.
// PUT : application/json
// 更新组织职务.
export async function unitDutyActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织职务标识   
// ins
// description: String: 描述.
// name: String: 名称,同一组织下不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UD结尾.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// identityList: List<String>: 组织职务身份成员,多值.
// POST : application/json
// 更新组织职务mockputtopost.
export async function unitDutyActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.pathParameters.flag}/mockputtopost`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 组织职务标识
// count: Integer: 数量   
// GET : application/json
// 列示组织职务,上一页.
export async function unitDutyActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/${params.pathParameters.flag}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// unitFlag: String: 组织标识   
// GET : application/json
// 根据给定的组织,获取组织职务.
export async function unitDutyActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/unit/${params.pathParameters.unitFlag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取去重的组织职务名称.
export async function unitDutyActionDistinctName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/distinct/name`, params.data)
    return data.data
}


// pathParameters
// key: String: 关键字,拼音或首字母   
// GET : application/json
// 模糊匹配组织职务的名称,匹配名称,拼音和首字母.
export async function unitDutyActionDistinctNameLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/distinct/name/like/${params.pathParameters.key}`, params.data)
    return data.data
}


// pathParameters
// identityFlag: String: 身份标识   
// GET : application/json
// 根据给定的身份,获取所拥有的组织职务.
export async function unitDutyActionListWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/identity/${params.pathParameters.identityFlag}`, params.data)
    return data.data
}


// pathParameters
// name: String: 组织名称   
// GET : application/json
// 给定组织职务名称,列示组织职务.
export async function unitDutyActionListWithName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/name/${params.pathParameters.name}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织职务标识
// count: Integer: 数量   
// GET : application/json
// 列示组织职务.下一页
export async function unitDutyActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/${params.pathParameters.flag}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织职务标识   
// GET : application/json
// 获取组织职务.
export async function unitDutyActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 组织职务标识   
// DELETE : application/json
// 删除组织职务.
export async function unitDutyActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// description: String: 描述.
// name: String: 名称,同一组织下不可重名.
// unique: String: 唯一标识,不可重复,为空则使用自动填充值
// distinguishedName: String: 识别名,自动填充,@UD结尾.
// unit: String: 组织职务所属组织,不可为空.
// orderNumber: Integer: 排序号,升序排列,为空在最后
// identityList: List<String>: 组织职务身份成员,多值.
// POST : application/json
// 创建组织职务.
export async function unitDutyActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty`, JSON.stringify(params.data))
    return data.data
}
