
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/echo`, params.data)
    return data.data
}

   
// ins
// application: String: 应用
// edition: String: 流程版本
// process: String: 流程
// work: String: 工作
// identityList: List<String>: 身份
// POST : application/json
// 查找指定人员的委托办理.
export async function empowerActionListWithIdentityObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/empower/list/identity/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// fromPerson: String: 人员.
// fromIdentity: String: 身份.
// toPerson: String: 委托人员.
// toIdentity: String: 委托身份.
// application: String: 应用.
// applicationName: String: 应用名称.
// applicationAlias: String: 应用别名.
// process: String: 流程ID.
// processName: String: 流程名称.
// processAlias: String: 流程别名.
// job: String: 任务标识.
// work: String: work标识.
// empowerTime: Date: 委托时间.
// title: String: 标题.
// activity: String: 当前活动ID
// activityName: String: 活动名称
// activityAlias: String: 活动别名
// POST : application/json
// 创建委托日志.
export async function empowerLogActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/empowerlog`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 查询群组的直接下级群组.
export async function groupActionListWithGroupSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sub/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 查询群组的直接下级群组对象.
export async function groupActionListWithGroupSubDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sub/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 查询群组的嵌套下级群组.
export async function groupActionListWithGroupSubNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sub/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组的直接上级群组对象.
export async function groupActionListWithGroupSupDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sup/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组的嵌套上级群组对象.
export async function groupActionListWithGroupSupNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sup/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 查询群组的嵌套下级群组对象.
export async function groupActionListWithGroupSubNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sub/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组的直接上级群组.
export async function groupActionListWithGroupSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sup/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组的嵌套上级群组.
export async function groupActionListWithGroupSupNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/sup/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// recursiveGroupFlag: Boolean: 是否递归查询上级群组，默认true
// referenceFlag: Boolean: 是否包含查找身份归属组织成员的所属群组，默认false
// recursiveOrgFlag: Boolean: 是否递归身份归属组织的上级组织所属群组，前提referenceFlag为true，默认false
// POST : application/json
// 批量查询人员身份所在的群组对象.
export async function groupActionListWithIdentityObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/identity/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// recursiveGroupFlag: Boolean: 是否递归查询上级群组，默认true
// referenceFlag: Boolean: 是否包含查找人员身份成员、人员归属组织成员的所属群组，默认false
// recursiveOrgFlag: Boolean: 是否递归人员归属组织的上级组织所属群组，前提referenceFlag为true，默认false
// POST : application/json
// 批量查询人员所在的群组对象.
export async function groupActionListWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// group: String: 群组
// roleList: List<String>: 角色
// POST : application/json
// 判断群组是否拥有指定角色中的一个或者多个
export async function groupActionHasRole (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/has/role`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组对象
export async function groupActionListObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组的嵌套下级群组信息-树形模式.
export async function groupActionListWithGroupTree (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/group/tree`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 个人
// recursiveGroupFlag: Boolean: 是否递归查询上级群组，默认true
// referenceFlag: Boolean: 是否包含查找身份归属组织成员的所属群组，默认false
// recursiveOrgFlag: Boolean: 是否递归身份归属组织的上级组织所属群组，前提referenceFlag为true，默认false
// POST : application/json
// 批量查询人员身份所在的群组.
export async function groupActionListWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/identity`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// recursiveGroupFlag: Boolean: 是否递归查询上级群组，默认true
// referenceFlag: Boolean: 是否包含查找人员身份成员、人员归属组织成员的所属群组，默认false
// recursiveOrgFlag: Boolean: 是否递归人员归属组织的上级组织所属群组，前提referenceFlag为true，默认false
// POST : application/json
// 批量查询人员所在的群组.
export async function groupActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组
export async function groupActionList (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/group/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询个人对应的身份对象.
export async function identityActionListWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接成员对应的个人
export async function identityActionListWithUnitSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/sub/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人
export async function identityActionListWithUnitSubNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/sub/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接成员对应的个人对象
export async function identityActionListWithUnitSubDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/sub/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人对象
export async function identityActionListWithUnitSubNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/sub/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组对应的身份对象,个人如果在组织中没有指定,那么取主身份,组织不递归.
export async function identityActionListWithGroupObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/group/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// personList: List<String>: 个人
// POST : application/json
// 批量查询指定组织和指定个人对应的身份对象
export async function identityActionListWithUnitPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人的主身份.
export async function identityActionListMajorWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/major/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人的主身份对象.
export async function identityActionListMajorWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/major/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// referenceFlag: Boolean: 是否关联查询身份所属对象信息：组织、角色、群组
// recursiveFlag: Boolean: 是否递归查询上级组织或群组，默认false
// POST : application/json
// 批量查询身份对象
export async function identityActionListObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// personList: List<String>: 个人
// POST : application/json
// 批量查询指定组织和指定个人对应的身份
export async function identityActionListWithUnitPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/unit/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组对应的身份,个人如果在组织中没有指定,那么取主身份,组织不递归.
export async function identityActionListWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/group`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询个人对应的身份.
export async function identityActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份
export async function identityActionList (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/identity/list`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// ins
// fetchIdentity: Boolean: 是否获取身份.
// fetchUnit: Boolean: 是否获取组织.
// fetchUnitDuty: Boolean: 是否获取组织职务.
// fetchGroup: Boolean: 是否获取群组.
// fetchRole: Boolean: 是否获取角色.
// fetchPersonAttribute: Boolean: 是否获取个人属性.
// POST : application/json
// 查询人员信息,返回身份,组织,组织职务,群组,角色,个人属性.
export async function personActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/detail/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份对应的个人对象
export async function personActionListWithIdentityObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/identity/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接成员对应的个人
export async function personActionListWithUnitSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人
export async function personActionListWithUnitSubNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接成员对应的个人对象
export async function personActionListWithUnitSubDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人对象
export async function personActionListWithUnitSubNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 关键字
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人,按关键字进行搜索.
export async function personActionListWithUnitSubNestedLike (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/nested/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// count: Integer: 数量
// POST : application/json
// 查询最近登录人员对象
export async function personActionListLoginRecentObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/login/recent/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 个人属性名称
// attribute: String: 个人属性值
// POST : application/json
// 批量查找拥有指定个人属性的个人
export async function personActionListWithPersonAttribute (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/personattribute`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 关键字
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的直接成员对应的个人对象,按关键字进行搜索.
export async function personActionListWithUnitSubDirectLikeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/direct/like/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组包含的个人,包含嵌套的个人对象.
export async function personActionListWithGroupObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/group/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// date: Date: 截至登录日期
// POST : application/json
// 查询截至日期之后登录的人员对象
export async function personActionListLoginAfterObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/login/after/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的直接下级
export async function personActionListWithPersonSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sub/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的直接上级
export async function personActionListWithPersonSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sup/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的递归逐级上级对象
export async function personActionListWithPersonSupNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sup/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的直接下级对象
export async function personActionListWithPersonSubDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sub/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 个人属性名称
// attribute: String: 个人属性值
// POST : application/json
// 批量查找拥有指定个人属性的个人对象
export async function personActionListWithPersonAttributeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/personattribute/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的递归逐级上级
export async function personActionListWithPersonSupNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sup/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 关键字
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的直接成员对应的个人,按关键字进行搜索.
export async function personActionListWithUnitSubDirectLike (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/direct/like`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的递归下级对象
export async function personActionListWithPersonSubNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sub/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的直接上级
export async function personActionListWithPersonSupDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sup/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// key: String: 关键字
// unitList: List<String>: 组织
// POST : application/json
// 批量组织的嵌套成员对应的个人对象,按关键字进行搜索.
export async function personActionListWithUnitSubNestedLikeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/unit/sub/nested/like/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查找个人的递归下级
export async function personActionListWithPersonSubNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/person/sub/nested`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询所有个人.
export async function personActionListAll (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/all`, params.data)
    return data.data
}

   
// ins
// person: String: 个人
// roleList: List<String>: 角色
// POST : application/json
// 判断个人是否拥有指定角色中的一个或者多个
export async function personActionHasRole (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/has/role`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询个人对象
export async function personActionListObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份对应的个人,以匹配对的格式返回.
export async function personActionListPairIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/pair/identity`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 数量   
// ins
// name: String: 名称
// employee: String: 工号
// unique: String: 唯一标识
// mobile: String: 手机号.
// POST : application/json
// 分页查询用户信息.
export async function personActionListFilterPaging (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/filter/${params.pathParameters.page}/size/${params.pathParameters.size}`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// date: Date: 截至登录日期
// POST : application/json
// 查询截至日期之后登录的人员
export async function personActionListLoginAfter (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/login/after`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// count: Integer: 数量
// POST : application/json
// 查询最近登录人员
export async function personActionListLoginRecent (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/login/recent`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询所有个人对象.
export async function personActionListAllObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/all/object`, params.data)
    return data.data
}

   
// ins
// roleList: List<String>: 角色
// POST : application/json
// 批量查询角色对应的个人对象
export async function personActionListWithRoleObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/role/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// roleList: List<String>: 角色
// POST : application/json
// 批量查询角色对应的个人
export async function personActionListWithRole (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/role`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// groupList: List<String>: 群组
// POST : application/json
// 批量查询群组包含的个人,包含嵌套的个人.
export async function personActionListWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/group`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份对应的个人
export async function personActionListWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list/identity`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 获取个人手机号码.
export async function personActionGetMobile (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/mobile/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 获取个人昵称.
export async function personActionGetNickName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/nick/name/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 人员标识   
// GET : application/json
// 获取个人,附带身份,身份所在的组织,个人所在群组,个人拥有角色.
export async function personActionGet (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// personList: List<String>: 个人
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询个人
export async function personActionList (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/person/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 根据个人查询个人属性对象.
export async function personAttributeActionListWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/personattribute/list/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 属性名称
// person: String: 个人
// POST : application/json
// 查询个人属性的值.
export async function personAttributeActionListAttributeWithPersonWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/personattribute/list/attribute/person/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// attributeList: List<String>: 属性值
// name: String: 属性名称
// person: String: 个人
// POST : application/json
// 覆盖个人属性值.
export async function personAttributeActionSetWithPersonWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/personattribute/set/person/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// attributeList: List<String>: 属性值
// name: String: 属性名称
// person: String: 个人
// POST : application/json
// 添加个人属性值.
export async function personAttributeActionAppendWithPersonWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/personattribute/append/person/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量根据个人查询个人属性名称
export async function personAttributeActionListNameWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/personattribute/list/name/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询人员所在的群组对象.
export async function roleActionListWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/role/list/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// roleList: List<String>: 角色
// POST : application/json
// 批量查询群组对象
export async function roleActionListObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/role/list/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询人员所在的群组.
export async function roleActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/role/list/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// roleList: List<String>: 角色
// POST : application/json
// 批量查询角色
export async function roleActionList (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/role/list`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份所在的组织.
export async function unitActionListWithIdentityObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/identity/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人所在的组织.
export async function unitActionListWithPersonObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/person/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接下级组织.
export async function unitActionListWithUnitSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sub/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的嵌套下级组织.
export async function unitActionListWithUnitSubNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sub/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// countSubDirectUnit: Boolean: 是否要统计直接子部门数量
// countSubDirectIdentity: Boolean: 是否要统计直接部门身份数量
// POST : application/json
// 批量查询组织的直接下级组织.
export async function unitActionListWithUnitSubDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sub/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的嵌套下级组织.
export async function unitActionListWithUnitSubNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sub/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人所在的组织,并递归查找其上级组织.
export async function unitActionListWithPersonSupNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/person/sup/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人所在的组织,并递归查找其上级组织.
export async function unitActionListWithPersonSupNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/person/sup/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的嵌套上级组织.
export async function unitActionListWithUnitSupNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sup/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identity: String: 身份
// type: String: 组织类型
// POST : application/json
// 查询身份所在的组织,并往上递归,找到有指定组织属性的组织.
export async function unitActionGetWithIdentityWithTypeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/identity/type/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织属性名称
// attribute: String: 组织属性值
// POST : application/json
// 根据组织属性批量查询组织.
export async function unitActionListWithUnitAttribute (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unitattribute`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接上级组织.
export async function unitActionListWithUnitSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sup/direct`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织层级名称
// POST : application/json
// 批量查询指定组织层级名称的组织对象.
export async function unitActionListWithLevelNameObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/level/name/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// typeList: List<String>: 组织类型
// POST : application/json
// 批量查询指定组织类型的组织对象.
export async function unitActionListWithTypesObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/types/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// levelList: List<Integer>: 组织层级
// POST : application/json
// 批量查询指定组织层级的组织对象.
export async function unitActionListWithLevelObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/level/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的直接上级组织.
export async function unitActionListWithUnitSupDirectObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sup/direct/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的嵌套上级组织.
export async function unitActionListWithUnitSupNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/sup/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织属性名称
// attribute: String: 组织属性值
// POST : application/json
// 根据组织属性批量查询组织.
export async function unitActionListWithUnitAttributeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unitattribute/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identity: String: 身份
// level: Integer: 组织级别
// POST : application/json
// 查询身份所在的组织,并往上递归,找到指定等级的组织.
export async function unitActionGetWithIdentityWithLevelObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/identity/level/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份所在的组织,并递归查找其上级组织对象.
export async function unitActionListWithIdentitySupNestedObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/identity/sup/nested/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份所在的组织,并递归查找其上级组织.
export async function unitActionListWithIdentitySupNested (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/identity/sup/nested`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织职务名称
// identity: String: 组织职务身份
// POST : application/json
// 根据组织职务批量查询组织.
export async function unitActionListWithUnitDutyObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unitduty/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identity: String: 身份
// level: Integer: 组织级别
// POST : application/json
// 查询身份所在的组织,并往上递归,找到指定等级的组织.
export async function unitActionGetWithIdentityWithLevel (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/identity/level`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identity: String: 身份
// type: String: 组织类型
// POST : application/json
// 查询身份所在的组织,并往上递归,找到有指定组织属性的组织.
export async function unitActionGetWithIdentityWithType (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/identity/type`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询所有组织.
export async function unitActionListAll (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/all`, params.data)
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询组织对象.
export async function unitActionListObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/object`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查询所有组织对象.
export async function unitActionListAllObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/all/object`, params.data)
    return data.data
}

   
// ins
// person: String: *用户
// unit: String: *组织
// recursive: Boolean: *是否递归查找组织(true|false)
// POST : application/json
// 校验用户是否在指定组织中注册身份.
export async function unitActionCheckHasPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/check/unit/has/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织职务名称
// identity: String: 组织职务身份
// POST : application/json
// 根据组织职务批量查询组织.
export async function unitActionListWithUnitDuty (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unitduty`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// type: String: 组织类型   
// GET : application/json
// 查询指定组织类型的组织对象.
export async function unitActionListWithTypeObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/type/${params.pathParameters.type}/object`, params.data)
    return data.data
}

   
// ins
// typeList: List<String>: 组织类型
// POST : application/json
// 批量查询指定组织类型的组织.
export async function unitActionListWithTypes (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/types`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// levelList: List<Integer>: 组织层级
// POST : application/json
// 批量查询指定组织层级的组织.
export async function unitActionListWithLevel (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/level`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的嵌套下级组织信息-树形模式.
export async function unitActionListWithUnitTree (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/unit/tree`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identity: String: *身份
// unit: String: *组织
// recursive: Boolean: *是否递归查找组织(true|false)
// POST : application/json
// 校验身份是否是指定组织的成员.
export async function unitActionCheckHasIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/check/unit/has/identity`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份所在的组织.
export async function unitActionListWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/identity`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// personList: List<String>: 个人
// POST : application/json
// 批量查询个人所在的组织.
export async function unitActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list/person`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// useNameFind: Boolean: 是否需要根据名称查找，默认false
// POST : application/json
// 批量查询组织.
export async function unitActionList (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unit/list`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// attributeList: List<String>: 属性值
// name: String: 属性名称
// unit: String: 组织
// POST : application/json
// 根据组织和组织属性名称添加值.
export async function unitAttributeActionAppendWithUnitWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitattribute/append/unit/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// attributeList: List<String>: 属性值
// name: String: 属性名称
// unit: String: 组织
// POST : application/json
// 根据组织和组织属性名称设置值.
export async function unitAttributeActionSetWithUnitWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitattribute/set/unit/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织属性名称
// unit: String: 组织
// POST : application/json
// 根据组织和组织属性名称获取值.
export async function unitAttributeActionListAttributeWithUnitWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitattribute/list/attribute/unit/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的组织属性名称.
export async function unitAttributeActionListNameWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitattribute/list/name/unit`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 查询组织的组织属性对象.
export async function unitAttributeActionListWithUnitObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitattribute/list/unit/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// identityList: List<String>: 身份
// POST : application/json
// 批量查询身份的组织职务名称.
export async function unitDutyActionListNameWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/name/identity`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 职务名称
// unit: String: 组织
// POST : application/json
// 根据组织和职务名称获取职务信息.
export async function unitDutyActionGetWithUnitWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/find/by/unit/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织职务名称
// unit: String: 组织
// nameList: List<String>: 组织职务名称(多值)
// unitList: List<String>: 组织(多值)
// recursiveUnit: Boolean: 是否递归下级组织（默认false）
// POST : application/json
// 根据组织和组织职务名称获取身份.
export async function unitDutyActionListIdentityWithUnitWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/identity/unit/name`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// name: String: 组织职务名称
// unit: String: 组织
// nameList: List<String>: 组织职务名称(多值)
// unitList: List<String>: 组织(多值)
// recursiveUnit: Boolean: 是否递归下级组织（默认false）
// POST : application/json
// 根据组织和组织职务名称获取身份对象.
export async function unitDutyActionListIdentityWithUnitWithNameObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/identity/unit/name/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 批量查询组织的组织职务名称.
export async function unitDutyActionListNameWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/name/unit`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// unitList: List<String>: 组织
// POST : application/json
// 查询组织的组织职务对象.
export async function unitDutyActionListWithUnitObject (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/unit/object`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// nameList: List<String>: 组织职务名称.
// POST : application/json
// 根据组织职务名称获取组织职务标识.
export async function unitDutyActionListWithName (params) {
    const {data} = await request(`/x_organization_assemble_express/jaxrs/unitduty/list/name`, JSON.stringify(params.data))
    return data.data
}
