
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// designerTypes: List<String>: 设计类型：script|form|page|widget|process
// moduleAppList: List<ModuleApp>: 模块的应用列表.
// POST : application/json
// 根据关键字搜索设计对象.
export async function designerActionSearch (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/designer/search`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// data: JsonElement: 字典数据(json格式).
// id: String: 数据库主键,自动生成.
// application: String: 应用.
// name: String: 字典名称.
// alias: String: 别名.
// description: String: 说明.
// POST : application/json
// 创建数据字典以及数据.
export async function dictActionPost (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// portalId: String: 门户应用标识   
// GET : application/json
// 获取应用的数据字典列表.
export async function dictActionListWithApplication (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict/list/portal/${params.pathParameters.portalId}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示数据字典对象.
export async function dictActionListPaging (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取单个数据字典以及数据字典数据.
export async function dictActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// data: JsonElement: 字典数据(json格式).
// id: String: 数据库主键,自动生成.
// application: String: 应用.
// name: String: 字典名称.
// alias: String: 别名.
// description: String: 说明.
// PUT : application/json
// 更新数据字典以及数据.
export async function dictActionPut (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的数据字典以及数据字典数据.
export async function dictActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/dict/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识 
// formParameters
// file: File: 文件内容
// fileName: String: 附件名称  
// POST : multipart/form-data
// 上传文件内容.
export async function fileActionUpload (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/${params.pathParameters.id}/upload`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取文件内容.
export async function fileActionDownload (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/${params.pathParameters.id}/download`, params.data)
    return data.data
}


// pathParameters
// applicationFlag: String: 应用标识   
// GET : application/json
// 根据应用列示文件.
export async function fileActionListWithApplication (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/list/application/${params.pathParameters.applicationFlag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示文件对象,下一页.
export async function fileActionListNext (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示文件对象,上一页.
export async function fileActionListPrev (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取文件内容.
export async function fileActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 文件名称.
// alias: String: 文件别名.
// description: String: 描述.
// portal: String: 文件所属门户.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// fileName: String: 文件名称.
// length: Long: 文件大小.
// PUT : application/json
// 更新文件.
export async function fileActionUpdate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除文件.
export async function fileActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 文件名称.
// alias: String: 文件别名.
// description: String: 描述.
// portal: String: 文件所属门户.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// fileName: String: 文件名称.
// length: Long: 文件大小.
// POST : application/json
// 创建文件.
export async function fileActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/file`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 创建数量   
// GET : application/json
// 创建用于ID值的UUID
export async function idActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/id/${params.pathParameters.count}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 覆盖应用.
export async function inputActionCover (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/input/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备创建应用.
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/input/prepare/create`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备覆盖应用.
export async function inputActionPrepareCover (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/input/prepare/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 上传对比数据内容.
export async function inputActionCompare (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/input/compare`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 创建应用.
export async function inputActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/input/create`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// portalFlag: String: 应用标识   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// properties: PortalProperties: 属性对象存储字段.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 选择门户结构.
export async function outputActionSelect (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/output/${params.pathParameters.portalFlag}/select`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 输出文件标识   
// GET : application/json
// 以文件方式导出应用.
export async function outputActionSelectOutput (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/output/${params.pathParameters.flag}/select/file`, params.data)
    return data.data
}

   
// GET : application/json
// 查看所有应用.
export async function outputActionList (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/output/list`, params.data)
    return data.data
}


// pathParameters
// portalId: String: Portal标识   
// GET : application/json
// 列示指定Portal下的Page.
export async function pageActionListWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/page/list/portal/${params.pathParameters.portalId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// relatedWidgetList: List<String>: 关联Widget.
// mobileRelatedWidgetList: List<String>: 移动端关联Widget.
// relatedScriptMap: Map<String,String>: 关联脚本.
// mobileRelatedScriptMap: Map<String,String>: 移动端关联脚本.
// cornerMarkScript: String: 角标关联脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// name: String: 名称.
// alias: String: 别名.
// category: String: 分类
// description: String: 描述.
// portal: String: 所属的Portal.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// properties: PageProperties: 属性对象存储字段.
// PUT : application/json
// 更新指定的Page.
export async function pageActionEdit (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/page/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Page.
export async function pageActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/page/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的Page
export async function pageActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/page/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// relatedWidgetList: List<String>: 关联Widget.
// mobileRelatedWidgetList: List<String>: 移动端关联Widget.
// relatedScriptMap: Map<String,String>: 关联脚本.
// mobileRelatedScriptMap: Map<String,String>: 移动端关联脚本.
// cornerMarkScript: String: 角标关联脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// category: String: 分类
// description: String: 描述.
// portal: String: 所属的Portal.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// properties: PageProperties: 属性对象存储字段.
// POST : application/json
// 创建新的Page.
export async function pageActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/page`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// portalCategory: String: 门户分类   
// GET : application/json
// 列示当前用户在指定分类下可以管理的Portal的简要信息包含page.
export async function portalActionListSummaryWithPortalCategory (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/list/summary/portalcategory/${params.pathParameters.portalCategory}`, params.data)
    return data.data
}


// pathParameters
// portalCategory: String: 门户分类   
// GET : application/json
// 列示当前用户在指定分类下可以管理的Portal.
export async function portalActionListWithPortalCategory (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/list/portalcategory/${params.pathParameters.portalCategory}`, params.data)
    return data.data
}

   
// ins
// name: String: 名称(模糊查询)
// portalCategory: String: 分类名称
// orderBy: String: 排序字段：lastUpdateTime|createTime|name(默认)
// descOrder: Boolean: 是否倒叙排序，默认false
// POST : application/json
// 列示当前用户可以管理的Portal的简要信息.
export async function portalActionListSummaryV2 (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/list/summary/v2`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 列示当前用户可以管理的Portal的简要信息包含page.
export async function portalActionListSummary (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/list/summary`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// controllerList: List<String>: 应用管理者。
// POST : application/json
// 设置门户应用权限.
export async function portalActionUpdatePermission (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识 
// formParameters
// file: File: 图标文件  
// PUT : multipart/form-data
// 更新Portal图标.
export async function portalActionSetIcon (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/${params.pathParameters.id}/icon`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// PUT : application/json
// 更新指定的Portal,需要对此portal的管理权限
export async function portalActionEdit (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取单个Portal配置信息,检查是否有editable权限.
export async function portalActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示当前用户可以管理的Portal.
export async function portalActionList (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的Portal,需要指定权限.
export async function portalActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// availableIdentityList: List<String>: 可访问的身份.
// availableUnitList: List<String>: 可访问的组织.
// availableGroupList: List<String>: 可访问的群组.
// portalCategory: String: 应用分类.
// icon: String: icon Base64编码后的文本.
// firstPage: String: 默认首页.
// controllerList: List<String>: 应用管理者。
// creatorPerson: String: 应用的创建者。
// lastUpdateTime: Date: 应用的最后修改时间。
// lastUpdatePerson: String: 应用的最后修改者
// pcClient: Boolean: 是否在pc终端显示.
// mobileClient: Boolean: 是否在移动设备显示.
// cornerMarkScript: String: 角标关联门户脚本.
// cornerMarkScriptText: String: 角标脚本文本.
// POST : application/json
// 创建新的Portal.需要对Portal模块的管理权限
export async function portalActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portal`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 查看用户可管理的portalcategory.
export async function portalCategoryActionListWith (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/portalcategory/list`, params.data)
    return data.data
}


// pathParameters
// portalId: String: Portal标识   
// GET : application/json
// 列示指定Portal下的Script.
export async function scriptActionListWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/list/portal/${params.pathParameters.portalId}`, params.data)
    return data.data
}


// pathParameters
// page: Integer: 分页
// size: Integer: 每页数量   
// POST : application/json
// 分页列示Script对象.
export async function scriptActionListPaging (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/list/paging/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// appIdList: List<String>: 应用ID列表.
// POST : application/json
// 列示Script对象（管理员权限）.
export async function scriptActionManagerList (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/list/manager`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// validated: Boolean: 代码格式是否正确.
// portal: String: 脚本所属应用.
// text: String: 脚本内容.
// dependScriptList: List<String>: 依赖的函数列表.
// creatorPerson: String: 流程创建者.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// PUT : application/json
// 更新指定的Portal.
export async function scriptActionEdit (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Script.
export async function scriptActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的Portal
export async function scriptActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// validated: Boolean: 代码格式是否正确.
// portal: String: 脚本所属应用.
// text: String: 脚本内容.
// dependScriptList: List<String>: 依赖的函数列表.
// creatorPerson: String: 流程创建者.
// lastUpdatePerson: String: 最后的编辑者.
// lastUpdateTime: Date: 最后的编辑时间.
// POST : application/json
// 创建新的Script.
export async function scriptActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/script`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}

   
// GET : application/json
// 统计分类数量.
export async function templatePageActionListCategory (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage/list/category`, params.data)
    return data.data
}

   
// PUT : application/json
// 列示指定分类下的模版.
export async function templatePageActionListWithCategory (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage/list/category`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取单个模版.
export async function templatePageActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取所有可见的模版,按category进行分类
export async function templatePageActionList (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage/list`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的模版.
export async function templatePageActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 表单别名.
// description: String: 描述.
// category: String: 模版分类.
// availableIdentityList: List<String>: 允许使用此模版的身份.
// availableUnitList: List<String>: 允许使用此模版的部门.
// icon: String: icon Base64编码后的文本.
// preview: String: 缩略图.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// controllerList: List<String>: 管理者.
// creatorPerson: String: 创建者.
// lastUpdateTime: Date: 最后修改时间.
// lastUpdatePerson: String: 最后修改者.
// POST : application/json
// 创建新的模版.
export async function templatePageActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/templatepage`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// portalId: String: Portal标识   
// GET : application/json
// 列示指定Portal下的部件.
export async function widgetActionListWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/widget/list/portal/${params.pathParameters.portalId}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// category: String: 分类
// description: String: 描述.
// portal: String: 所属的Portal.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// PUT : application/json
// 更新指定的部件.
export async function widgetActionEdit (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/widget/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取部件.
export async function widgetActionGet (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/widget/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除指定的部件
export async function widgetActionDelete (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/widget/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// category: String: 分类
// description: String: 描述.
// portal: String: 所属的Portal.
// data: String: 文本内容.
// mobileData: String: 移动端文本内容.
// hasMobile: Boolean: 是否有移动端内容.
// POST : application/json
// 创建新的部件.
export async function widgetActionCreate (params) {
    const {data} = await request(`/x_portal_assemble_designer/jaxrs/widget`, JSON.stringify(params.data))
    return data.data
}
