
   
// GET : application/json
// 显示缓存状态.
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache/detail`, params.data)
    return data.data
}

   
// GET : application/json
// 接收刷新Config配置文件指令.
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache/config/flush`, params.data)
    return data.data
}

   
// ins
// nodeName: String: 节点名.
// className: String: 类名.
// keys: List<Object>: 关键字.
// POST : application/json
// 接收缓存刷新指令.
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// keyword: String: 搜索关键字.
// caseSensitive: Boolean: 是否区分大小写.
// matchWholeWord: Boolean: 是否全字匹配.
// matchRegExp: Boolean: 是否正则表达式匹配.
// designerTypes: List<String>: 设计类型：script|form|page|widget|process
// moduleAppList: List<ModuleApp>: 模块的应用列表.
// POST : application/json
// 根据关键字搜索设计对象.
export async function designerActionSearch (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/designer/search`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取应答.
export async function echoActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/echo`, params.data)
    return data.data
}


// pathParameters
// className: String: 运行类   
// GET : application/json
// 接受x_program_center发送过来的运行定时任务指令.
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/fireschedule/classname/${params.pathParameters.className}`, params.data)
    return data.data
}


// pathParameters
// count: Integer: 数量   
// GET : application/json
// 创建用于ID值的UUID
export async function idActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/id/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// POST : application/json
// 设置数据导入模型权限.
export async function importModelActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 查询标识   
// GET : application/json
// 根据query列示数据导入对象.
export async function importModelActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/list/query/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取数据导入模型内容.
export async function importModelActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// layout: String: 显示布局.
// data: String: 访问方案.
// code: String: 前台运行脚本.
// enableValid: Boolean: 是否启用校验.
// type: String: 类型.
// processStatus: String: 流程状态.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// count: Integer: 最大导入数量.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// PUT : application/json
// 更新数据导入模型.
export async function importModelActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除数据导入模型.
export async function importModelActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// layout: String: 显示布局.
// data: String: 访问方案.
// code: String: 前台运行脚本.
// enableValid: Boolean: 是否启用校验.
// type: String: 类型.
// processStatus: String: 流程状态.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// count: Integer: 最大导入数量.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// POST : application/json
// 创建数据导入模型.
export async function importModelActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 覆盖应用.
export async function inputActionCover (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备覆盖应用.
export async function inputActionPrepareCover (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/prepare/cover`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 准备创建应用.
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/prepare/create`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 上传对比数据内容.
export async function inputActionCompare (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/compare`, JSON.stringify(params.data))
    return data.data
}

   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 创建应用.
export async function inputActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/create`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 获取模型.
export async function neuralActionGetModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}

   
// ins
// neuralNetworkType: String: 神经网络类型:mlp.
// dataType: String: 数据类型:cms,processPlatform
// name: String: 名称
// description: String: 说明
// alias: String: 别名.
// inValueScriptText: String: 输入值脚本,脚本中的操作对象是inValues,对象类型Set
// outValueScriptText: String: 输出值脚本,脚本中的操作对象是outValues,对象类型Set
// attachmentScriptText: String: 附件过滤脚本,脚本中的操作对象是attachments,对象类型List,内容是附件名称,可以删除不要进行分词的附件名.
// processList: List<String>: 包含流程.
// applicationList: List<String>: 包含应用.
// analyzeType: String: 分析类型,default,full,customized
// maxResult: Integer: 最大输出值
// inValueCount: Integer: 输入数量
// outValueCount: Integer: 输出数量
// propertyMap: LinkedHashMap<String,String>: 神经网络参数.
// POST : application/json
// 创建模型.
export async function neuralActionCreateModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 列示所有模型.
export async function neuralActionListModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/list/model`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// ins
// neuralNetworkType: String: 神经网络类型:mlp.
// dataType: String: 数据类型:cms,processPlatform
// name: String: 名称
// description: String: 说明
// alias: String: 别名.
// inValueScriptText: String: 输入值脚本,脚本中的操作对象是inValues,对象类型Set
// outValueScriptText: String: 输出值脚本,脚本中的操作对象是outValues,对象类型Set
// attachmentScriptText: String: 附件过滤脚本,脚本中的操作对象是attachments,对象类型List,内容是附件名称,可以删除不要进行分词的附件名.
// processList: List<String>: 包含流程.
// applicationList: List<String>: 包含应用.
// analyzeType: String: 分析类型,default,full,customized
// maxResult: Integer: 最大输出值
// inValueCount: Integer: 输入数量
// outValueCount: Integer: 输出数量
// propertyMap: LinkedHashMap<String,String>: 神经网络参数.
// PUT : application/json
// 更新模型.
export async function neuralActionUpdateModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.pathParameters.modelFlag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// DELETE : application/json
// 删除项目.
export async function neuralActionDeleteModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 重置状态.
export async function neuralActionResetStatus (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.pathParameters.modelFlag}/reset/status`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 学习.
export async function neuralActionLearn (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/learn/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 停止学习.
export async function neuralActionStopLearning (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/stop/learn/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 停止创建条目.
export async function neuralActionStopGenerating (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/stop/generating/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}


// pathParameters
// modelFlag: String: 模型标识   
// GET : application/json
// 创建条目.
export async function neuralActionGenerate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/generate/model/${params.pathParameters.modelFlag}`, params.data)
    return data.data
}

   
// GET : application/json
// 获取openapi描述文件.
export async function openApiActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/openapi`, params.data)
    return data.data
}


// pathParameters
// queryFlag: String: 查询标识   
// ins
// viewList: List<WrapView>: 视图
// statList: List<WrapStat>: 统计
// tableList: List<WrapTable>: 数据表
// statementList: List<WrapStatement>: 查询配置
// importModelList: List<WrapImportModel>: 数据导入模型
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// creatorPerson: String: 查询的创建者
// lastUpdateTime: Date: 查询的最后修改时间
// lastUpdatePerson: String: 查询的最后修改者
// queryCategory: String: 分类
// data: String: 自定义字段.
// distributeFactor: Integer: 分布式存储标识位.
// createTime: Date: 创建时间,自动生成,索引创建在约束中.
// updateTime: Date: 修改时间,自动生成,索引创建在约束中.
// sequence: String: 列表序号,由创建时间以及ID组成.在保存时自动生成,索引创建在约束中.
// PUT : application/json
// 选择查询.
export async function outputActionSelect (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/${params.pathParameters.queryFlag}/select`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 输出文件标识   
// GET : application/json
// 以文件方式导出应用.
export async function outputActionSelectOutput (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/${params.pathParameters.flag}/select/file`, params.data)
    return data.data
}

   
// GET : application/json
// 查看所有应用.
export async function outputActionList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/list`, params.data)
    return data.data
}


// pathParameters
// flag: String: 应用标识 
// formParameters
// file: File: 头像文件  
// PUT : multipart/form-data
// 更新查询图标.
export async function queryActionSetIcon (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.pathParameters.flag}/icon`, params.data)
    return data.data
}


// pathParameters
// queryCategory: String: 查询分类   
// GET : application/json
// 列示指定分类的查询.
export async function queryActionListWithQueryCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/querycategory/${params.pathParameters.queryCategory}`, params.data)
    return data.data
}


// pathParameters
// entity: String: 实体类名称(系统表要全称如com.x.query.core.entity.Query，自建表只要名称)
// entityCategory: String: 实体类类型(自建表：dynamic|系统表：official)   
// GET : application/json
// 根据标识获取语句操作对象的属性信息.
export async function queryActionGetEntityProperties (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/entity/${params.pathParameters.entity}/category/${params.pathParameters.entityCategory}/properties`, params.data)
    return data.data
}


// pathParameters
// queryCategory: String: 查询分类   
// GET : application/json
// 根据查询分类获取查询的简要信息,同时附带视图简要信息和统计简要信息应用分类不为null.
export async function queryActionListSummaryWithApplicationCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/summary/querycategory/${params.pathParameters.queryCategory}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示查询年分类,并统计数量.
export async function queryActionListQueryCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/querycategory/list`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// queryCategory: String: 分类
// data: String: 自定义字段.
// PUT : application/json
// 更新查询.
export async function queryActionEdit (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// controllerList: List<String>: 查询管理者
// POST : application/json
// 设置数据中心权限.
export async function queryActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}

   
// GET : application/json
// 获取所有查询内容.
export async function queryActionListAll (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/all`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有查询，同时附带视图简要信息和统计简要信息.
export async function queryActionListSummary (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/summary`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 获取查询内容.
export async function queryActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除查询.
export async function queryActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 应用别名,如果有必须唯一.
// description: String: 描述.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// icon: String: icon Base64编码后的文本.
// iconHue: String: icon的主色调
// controllerList: List<String>: 查询管理者
// queryCategory: String: 分类
// data: String: 自定义字段.
// POST : application/json
// 创建查询.
export async function queryActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// POST : application/json
// 设置统计权限.
export async function statActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Stat对象,下一页.
export async function statActionListNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 查询标识   
// GET : application/json
// 根据query列示stat对象.
export async function statActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/query/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// person: String: 当前用户
// unitList: List<String>: 组织
// groupList: List<String>: 群组
// roleList: List<String>: 角色
// unitAllList: List<String>: 所有群组
// identityList: List<String>: 身份
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// PUT : application/json
// 模拟执行stat
export async function statActionSimulate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.pathParameters.id}/simulate`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示Stat对象,上一页.
export async function statActionListPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取Stat内容.
export async function statActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// view: String: 绑定的视图.
// data: String: 访问方案.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// PUT : application/json
// 更新Stat.
export async function statActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除Stat.
export async function statActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// view: String: 绑定的视图.
// data: String: 访问方案.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// POST : application/json
// 创建Stat.
export async function statActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// executePersonList: List<String>: 可执行的用户.
// executeUnitList: List<String>: 可以访问的组织.
// executeGroupList: List<String>: 可以访问的群组.
// anonymousAccessible: Boolean: 是否允许匿名访问（boolean类型）
// POST : application/json
// 设置查询语句权限.
export async function statementActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 查询标识   
// ins
// viewEnable: Boolean: 是否允许作为视图嵌入到表单.
// POST : application/json
// 根据query列示statement对象.
export async function statementActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/list/query/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识
// mode: String: 执行模式：data|count|all
// page: Integer: 页码
// size: Integer: 每页数量   
// POST : application/json
// 执行语句V2,可以同时执行查询结果及查询总数.
export async function statementActionExecuteV2 (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.flag}/execute/mode/${params.pathParameters.mode}/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有statement对象.
export async function statementActionManageList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/list/manage`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 根据标识获取语句.
export async function statementActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// name: String: 语句名称.
// alias: String: 别名.
// format: String: 格式,jpql或者script.
// description: String: 描述.
// query: String: 所属查询.
// fv: Float: 功能版本号.
// executePersonList: List<String>: 可执行的用户.
// executeUnitList: List<String>: 可以访问的组织.
// executeGroupList: List<String>: 可以访问的群组.
// data: String: jpql语句.
// scriptText: String: 类型为script的执行脚本.
// countData: String: jpql语句，用于查询总数.
// countScriptText: String: 类型为script的执行脚本，用于查询总数.
// sql: String: sql语句.
// sqlScriptText: String: sqlScript的执行脚本.
// sqlCount: String: sql总数统计语句.
// sqlCountScriptText: String: sql总数统计语句脚本.
// view: String: 展现视图.
// table: String: 执行的表
// entityClassName: String: custom,official时使用的类名.
// entityCategory: String: 表类型,official,dynamic,custom
// testParameters: String: 测试参数（json格式文本）.
// anonymousAccessible: Boolean: 是否允许匿名访问（boolean类型）
// display: Boolean: 是否前端可见.
// viewEnable: Boolean: 是否允许作为视图嵌入到表单.
// orderNumber: Integer: 排序号,为空在最后
// countMethod: String: 数量总计方法,ignore:忽略,auto:自动,assign:指定.
// PUT : application/json
// 更新语句.
export async function statementActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识
// page: Integer: 页码
// size: Integer: 每页数量   
// POST : application/json
// V8版本新版本查询语句,取消mode参数,增加自动count,增加自动内置参数判断,替换V2版本.
export async function statementActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.flag}/execute/page/${params.pathParameters.page}/size/${params.pathParameters.size}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除语句.
export async function statementActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// name: String: 语句名称.
// alias: String: 别名.
// format: String: 格式,jpql或者script.
// description: String: 描述.
// query: String: 所属查询.
// fv: Float: 功能版本号.
// executePersonList: List<String>: 可执行的用户.
// executeUnitList: List<String>: 可以访问的组织.
// executeGroupList: List<String>: 可以访问的群组.
// data: String: jpql语句.
// scriptText: String: 类型为script的执行脚本.
// countData: String: jpql语句，用于查询总数.
// countScriptText: String: 类型为script的执行脚本，用于查询总数.
// sql: String: sql语句.
// sqlScriptText: String: sqlScript的执行脚本.
// sqlCount: String: sql总数统计语句.
// sqlCountScriptText: String: sql总数统计语句脚本.
// view: String: 展现视图.
// table: String: 执行的表
// entityClassName: String: custom,official时使用的类名.
// entityCategory: String: 表类型,official,dynamic,custom
// testParameters: String: 测试参数（json格式文本）.
// anonymousAccessible: Boolean: 是否允许匿名访问（boolean类型）
// display: Boolean: 是否前端可见.
// viewEnable: Boolean: 是否允许作为视图嵌入到表单.
// orderNumber: Integer: 排序号,为空在最后
// countMethod: String: 数量总计方法,ignore:忽略,auto:自动,assign:指定.
// POST : application/json
// 创建语句.
export async function statementActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// filePath: String: 查找路径(根路径:(0))   
// GET : application/json
// 获取静态资源信息.
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/sysresource/filePath/${params.pathParameters.filePath}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// readPersonList: List<String>: 可以访问数据的用户.
// readUnitList: List<String>: 可以访问数据的组织.
// readGroupList: List<String>: 可以访问数据的群组.
// editPersonList: List<String>: 可以修改数据的用户.
// editUnitList: List<String>: 可以修改数据的组织.
// editGroupList: List<String>: 可以修改数据的群组.
// POST : application/json
// 设置表权限.
export async function tableActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 查询标识   
// GET : application/json
// 根据query列示table对象.
export async function tableActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/query/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// query: String: 应用标识   
// GET : application/json
// 编译指定应用所有表,执行后需要立即重新启动，支持集群环境.
export async function tableActionBuildDispatch (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.query}/build/dispatch`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// where: String: where语句   
// GET : application/json
// 通过where 统计数量
export async function tableActionRowCountWhere (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/count/where/${params.pathParameters.where}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// GET : application/json
// 获取表中某一行数据
export async function tableActionRowGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// where: String: where语句   
// GET : application/json
// 通过where 获取表中的数据,格式为jpql语法,o.name='zhangsan'
export async function tableActionListRowSelectWhere (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.pathParameters.tableFlag}/row/select/where/${params.pathParameters.where}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// POST : application/json
// 指定表中插入数据.
export async function tableActionRowInsert (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 标识表状态为草稿.
export async function tableActionStatusDraft (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}/status/draft`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// DELETE : application/json
// 更新指定表中指定行数据.
export async function tableActionRowDeleteAll (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/delete/all`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表中的行对象,下一页.
export async function tableActionListRowNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示表中的行对象,上一页.
export async function tableActionListRowPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 标识表状态为编译.
export async function tableActionStatusBuild (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}/status/build`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// PUT : application/json
// 更新指定表中指定行数据.
export async function tableActionRowUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// id: String: 行标识   
// DELETE : application/json
// 更新指定表中指定行数据.
export async function tableActionRowDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// query: String: 应用标识   
// GET : application/json
// 编译指定应用所有表,执行后需要立即重新启动，仅对当前服务器.
export async function tableActionBuildQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/query/${params.pathParameters.query}/build`, params.data)
    return data.data
}

   
// GET : application/json
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/reload/dynamic`, params.data)
    return data.data
}

   
// GET : application/json
// 列示所有table对象.
export async function tableActionManageList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/manage`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识   
// POST : application/json
// 指定表中批量保存或更新数据.
export async function tableActionRowSave (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.tableFlag}/row/save`, params.data)
    return data.data
}


// pathParameters
// tableFlag: String: 表标识
// count: Integer: 数量(最大2000)   
// GET : application/json
// 导出行对象。
export async function tableActionExportRow (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/export/${params.pathParameters.tableFlag}/count/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// GET : application/json
// 根据标识获取表.
export async function tableActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// query: String: 所属查询.
// description: String: 描述.
// readPersonList: List<String>: 可以访问数据的用户.
// readUnitList: List<String>: 可以访问数据的组织.
// readGroupList: List<String>: 可以访问数据的群组.
// editPersonList: List<String>: 可以修改数据的用户.
// editUnitList: List<String>: 可以修改数据的组织.
// editGroupList: List<String>: 可以修改数据的群组.
// draftData: String: 草稿表结构方案.
// buildSuccess: Boolean: 是否编译成功.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// PUT : application/json
// 更新表.
export async function tableActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识   
// ins
// type: String: 类型
// data: String: jpql语句.
// countData: String: 同时返回数量的jpql语句.
// maxResults: Integer: 返回最大结果集.
// firstResult: Integer: 返回结果开始于.
// POST : application/json
// 执行语句.
export async function tableActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}/execute`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// flag: String: 标识   
// DELETE : application/json
// 删除表,同时会级联删除语句.
export async function tableActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.pathParameters.flag}`, params.data)
    return data.data
}

   
// ins
// query: String: 所属查询.
// name: String: 表名,最大64个字符.
// alias: String: 别名.
// description: String: 描述.
// readPersonList: List<String>: 可以访问数据的用户.
// readUnitList: List<String>: 可以访问数据的组织.
// readGroupList: List<String>: 可以访问数据的群组.
// editPersonList: List<String>: 可以修改数据的用户.
// editUnitList: List<String>: 可以修改数据的组织.
// editGroupList: List<String>: 可以修改数据的群组.
// draftData: String: 草稿表结构方案.
// buildSuccess: Boolean: 是否编译成功.
// display: Boolean: 是否前端可见.
// orderNumber: Integer: 排序号,为空在最后
// POST : application/json
// 创建表.
export async function tableActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// POST : application/json
// 设置视图权限.
export async function viewActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}/permission`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示View对象,下一页.
export async function viewActionListNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/${params.pathParameters.id}/next/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// flag: String: 查询标识   
// GET : application/json
// 根据query列示view对象.
export async function viewActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/query/${params.pathParameters.flag}`, params.data)
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// bundleList: List<String>: 限定结果集
// key: String: 秘钥串，结果集不为空时必须传.
// PUT : application/json
// 模拟执行view
export async function viewActionSimulate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}/simulate`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识
// count: Integer: 数量   
// GET : application/json
// 列示View对象,上一页.
export async function viewActionListPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/${params.pathParameters.id}/prev/${params.pathParameters.count}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// GET : application/json
// 获取View内容.
export async function viewActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}`, params.data)
    return data.data
}


// pathParameters
// id: String: 标识   
// ins
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// enableCache: Boolean: 是否对结果进行缓存.
// layout: String: 显示布局.
// data: String: 访问方案.
// afterGridScriptText: String: gird生成后运行脚本.
// afterGroupGridScriptText: String: gropuGird生成后运行脚本.
// afterCalculateGridScriptText: String: calculateGrid生成后运行脚本.
// code: String: 前台运行脚本.
// display: Boolean: 是否前端可见.
// type: String: 类型.
// cacheAccess: Boolean: 是否缓存访问内容.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// count: Integer: 最大返回数量.
// pageSize: Integer: 分页单页数量.
// toolbar: String: 工具条.
// orderNumber: Integer: 排序号,为空在最后
// PUT : application/json
// 更新View.
export async function viewActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 视图标识   
// ins
// filterList: List<FilterEntry>: 过滤
// parameter: Map<String,String>: 参数
// count: Integer: 数量
// PUT : application/json
// 模拟执行view,输出所有bundle值
export async function viewActionBundle (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}/bundle`, JSON.stringify(params.data))
    return data.data
}


// pathParameters
// id: String: 标识   
// DELETE : application/json
// 删除View.
export async function viewActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.pathParameters.id}`, params.data)
    return data.data
}

   
// ins
// id: String: 数据库主键,自动生成.
// name: String: 名称.
// alias: String: 别名.
// description: String: 描述.
// query: String: 所属查询.
// enableCache: Boolean: 是否对结果进行缓存.
// layout: String: 显示布局.
// data: String: 访问方案.
// afterGridScriptText: String: gird生成后运行脚本.
// afterGroupGridScriptText: String: gropuGird生成后运行脚本.
// afterCalculateGridScriptText: String: calculateGrid生成后运行脚本.
// code: String: 前台运行脚本.
// display: Boolean: 是否前端可见.
// type: String: 类型.
// cacheAccess: Boolean: 是否缓存访问内容.
// availableIdentityList: List<String>: 允许使用的用户.
// availableUnitList: List<String>: 允许使用的组织.
// availableGroupList: List<String>: 允许使用的群组.
// count: Integer: 最大返回数量.
// pageSize: Integer: 分页单页数量.
// toolbar: String: 工具条.
// orderNumber: Integer: 排序号,为空在最后
// POST : application/json
// 创建View.
export async function viewActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view`, JSON.stringify(params.data))
    return data.data
}
