from django.http import HttpResponseForbidden
from django.shortcuts import render, redirect, get_object_or_404
from note.models import Note, User
from django.contrib.auth.hashers import make_password
from django.contrib.auth import login, authenticate, logout
from django.contrib.auth.models import Permission
from django.contrib.auth.decorators import permission_required


# Create your views here.

def show_notes(request):
    if request.method == "GET":
        notes_dict = Note.objects.all()
        if request.user.is_anonymous:
            return render(request, 'login.html')
        return render(request, 'note/index.html', {'notes_dict': notes_dict})
    return HttpResponseForbidden('没有相关请求')
    

def user_login(request):
    if request.method == 'POST':
        username = request.POST.get('user')
        password = request.POST.get('password')

        user = authenticate(request=request, username=username, password=password)
        
        if user is None:
            try:
                user = User.objects.get(username=username)
                # user 为 None 的情况下，有可能是密码错误
                if user is not None:
                    return redirect('/')
            except User.DoesNotExist:
                # 注册
                user = User.objects.create_user(username=username, password=password, algorithm='argon2')

                add_note_permission = Permission.objects.get(codename='add_note')
                change_note_permission = Permission.objects.get(codename='change_note')
                user.user_permissions.add(add_note_permission, change_note_permission)

        # 这里可以直接给 request，这个样子获取的 user 是从 request 中取出的
        login(request, user)
        return redirect('/note/')
    return HttpResponseForbidden('没有相关请求')


@permission_required('note.change_note', login_url='/note/login/')
def change_note(request):
    if request.method == 'POST':
        id = request.POST.get('note_id')
        note = Note.objects.get(id=id)
        note.note = request.POST.get('change_note')
        note.save()
        return redirect('/note/')
    return HttpResponseForbidden('没有相关请求')


@permission_required('note.add_note', login_url='/note/login/')
def add_note(request):
    if request.method == 'POST':
        note = Note()
        note.user = request.user
        note.note = request.POST.get('note')
        note.save()
        return redirect('/note/')
    return HttpResponseForbidden('没有相关请求')


@permission_required('note.delete_note', login_url='/note/login/')
def del_note(request):
    if request.method == 'POST':
        id = request.POST.get('note_id')
        note = Note.objects.get(id=id)
        note.delete()
        return redirect('/note/')
    return HttpResponseForbidden('没有相关请求')


def logout_view(request):
    logout(request)
    return redirect('/note/')


def index(request):
    return render(request, 'base.html')
