import openpyxl
import json

file_name = 'example1'
# Open the Excel file
workbook = openpyxl.load_workbook(f'{file_name}.xlsx')

# Select the first worksheet
sheet = workbook.active

# Create an empty 2D array
json_data = []

# Iterate through each row
for row in sheet.iter_rows():
    row_data = []
    # Iterate through each cell in the row
    for cell in row:
        cell_value = cell.value
        is_header = cell.font.bold if cell.font.bold is not None else False
        cell_data = {
            "value": cell_value,
            "isHeader": is_header,
            "rowSpan": 1,
            "colSpan": 1,
        }

        is_merged = sheet.merged_cells.ranges
        for merged_range in is_merged:
            if cell.coordinate in merged_range:
                print('单元格处于合并状态', cell.coordinate)
                print('合并范围', merged_range, merged_range.min_row, merged_range.max_row, merged_range.min_col, merged_range.max_col)
                
                if cell_data['value'] is None:
                    cell_data.pop('value')

                if ((count := merged_range.max_row - merged_range.min_row + 1) > 1 and 
                     cell_data.get('value', None) is not None):
                    cell_data['rowSpan'] = count
                if ((count := merged_range.max_col - merged_range.min_col + 1) > 1 and
                      cell_data.get('value', None) is not None):
                    cell_data['colSpan'] = count
                break

        row_data.append(cell_data)
    json_data.append(row_data)

# Convert the 2D array to JSON format
json_output = json.dumps(json_data, ensure_ascii=False, indent=4)
with open(f'{file_name}.json', 'w', encoding='utf-8') as f:
    f.write(json_output)
    f.close()

# Close the Excel file
workbook.close()
