import { defineStore } from "pinia";
import { ref } from "vue";

export const useSlideStateStore = defineStore("slideState", () => {
  const slideState = ref<boolean>(localStorage.getItem("sidebarStatus") == "1");

  function getSlideState(): boolean {
    return slideState.value;
  }

  function setSlideState(state: any) {
    slideState.value = state == "1" ? true : false;
  }

  return {
    slideState,
    getSlideState,
    setSlideState,
  };
});
