import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { scrapydApi } from './apiPaths'

// 获取项目列表
export function getProjectList(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listProjects,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取项目版本列表
export function getProjectVersions(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listVersions,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫列表
export function getSpiderList(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listSpiders,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取任务列表
export function getJobList(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listJobsMerge,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 取消任务
export function cancelJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scrapydApi.cancel,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 取消所有任务
export function cancelAllJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scrapydApi.cancelAllJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除项目版本
export function deleteProjectVersion(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scrapydApi.deleteVersion,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除项目
export function deleteProject(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scrapydApi.deleteProject,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 调度任务
export function scheduleJob(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.schedule,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 运行爬虫
export function schedule(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.schedule,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取服务状态
export function getDaemonStatus(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.daemonStatus,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 添加项目版本
export function addProjectVersion(data: FormData): Promise<ApiResponse> {
  return request({
    url: scrapydApi.addVersion,
    method: POST,
    data,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  }) as unknown as Promise<ApiResponse>
}

// 获取项目下的爬虫列表
export function listSpiders(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listSpiders,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫列表简化版（用于表单选择等）
export function getSpiders(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listSpiders,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取项目列表简化版（用于表单选择等）
export function listProjects(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.listProjects,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}
