import { defineStore } from 'pinia'

interface AppState {
  sidebar: {
    opened: boolean
    withoutAnimation: boolean
  },
  device: 'desktop' | 'mobile'
}

export const useAppStore = defineStore('app', {
  state: (): AppState => ({
    sidebar: {
      opened: localStorage.getItem('sidebarStatus') 
        ? !!+localStorage.getItem('sidebarStatus')! // 将获取到的值转换为布尔值 其中 + 为先转为数字 !! 为转成 bool 值
        : true,
      withoutAnimation: false
    },
    device: 'desktop',
  }),
  
  actions: {
    toggleSidebar() {
      this.sidebar.opened = !this.sidebar.opened
      this.sidebar.withoutAnimation = false
      if (this.sidebar.opened) {
        localStorage.setItem('sidebarStatus', '1')
      } else {
        localStorage.setItem('sidebarStatus', '0')
      }
    },
    
    closeSideBar(options: { withoutAnimation: boolean }) {
      this.sidebar.opened = false
      this.sidebar.withoutAnimation = options.withoutAnimation
      localStorage.setItem('sidebarStatus', '0')
    },
    
    toggleDevice(device: 'desktop' | 'mobile') {
      this.device = device
    }
  }
})
