import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams ,UserQueryParams } from '@/utils/request'
import { systemApi, scrapydServerApi, spiderApi } from './apiPaths'

// 获取系统信息
export function getSystemInfo(): Promise<ApiResponse> {
  return request({
    url: systemApi.systemInfo,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 获取系统数据
export function getSystemData(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: systemApi.systemData,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取系统配置
export function getSystemConfig(): Promise<ApiResponse> {
  return request({
    url: systemApi.systemConfig,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 更新系统配置
export function updateSystemConfig(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: systemApi.systemConfig,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取登录历史
export function getLoginHistory(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: systemApi.loginHistoryList,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}

export const getScrapydServerList = (): Promise<ApiResponse> => {
  return request({
    url: scrapydServerApi.getScrapydServerPage,
    method: POST,
  }) as unknown as Promise<ApiResponse>
}

// 爬虫列表
export function getSpiderList(data: UserQueryParams) {
  return request({
    url: spiderApi.spiderList,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}