import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams ,UserQueryParams } from '@/utils/request'
import { systemApi, scrapydServerApi, spiderApi,spiderTaskApi} from './apiPaths'

// 爬虫任务执行记录
export function getSpiderTaskRecord(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.taskRecord,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 爬虫任务列表
export function getSpiderTaskList(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.taskList,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 新增/更新爬虫任务
export function addSpiderTask(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.addTask,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除爬虫任务
export function deleteSpiderTask(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.deleteTask,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 暂停爬虫任务
export function pauseSpiderTask(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.pauseJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 继续爬虫任务
export function resumeSpiderTask(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.resumeJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫任务数据
export function getTaskData(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.jobDetail,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}