import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { dataApi } from './apiPaths'

// 获取爬虫静态数据列表
export function getStatsDataList(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: dataApi.dataStatistics,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫任务列表
export function getSpiderTaskList(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: dataApi.taskStatistics,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫任务列表
export function getPerformanceList(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: dataApi.performanceStatistics,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}