import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { authApi } from './apiPaths'

// 用户登录
export function login(data: { username: string, password: string }): Promise<ApiResponse> {
  return request({
    url: authApi.login,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取用户信息
export function getInfo() {
  return new Promise(resolve => {
    resolve({
      data: {
        roles: ['admin'],
        introduction: 'Admin',
        avatar: 'user-avatar.gif',
        name: 'Admin'
      }
    })
  })
}

// 用户登出
export function logout(): Promise<ApiResponse> {
  return request({
    url: authApi.logout,
    method: POST
  }) as unknown as Promise<ApiResponse>
}
