import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { statsApi } from './apiPaths'

// 获取爬虫统计数据列表
export function getStatsList(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: statsApi.statsList,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}

// 获取爬虫统计数据明细
export function getStatsDetail(params: QueryParams): Promise<ApiResponse> {
  return request({
    url: statsApi.statsDetail,
    method: POST,
    params
  }) as unknown as Promise<ApiResponse>
}

// 删除爬虫统计数据
export function removeStats(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: statsApi.removeStats,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 清空爬虫统计数据
export function clearAllStats(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: statsApi.clearAllStats,  // TODO 这个接口在后端还没有实现
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}
