import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { scrapydApi } from './apiPaths'

// 获取日志列表
export function getLogs(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.logs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取项目日志
export function getProjectLogs(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.projectLogs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse> 
}

// 获取爬虫日志
export function getSpiderLogs(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.spiderLogs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取任务日志
export function getJobLog(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scrapydApi.jobLog,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}
